DESCRIPTION = "MTK MiTA daemon"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

S = "${WORKDIR}"

inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/telephonyware/3.0/mita"

DEPENDS += " mipc curl mosquitto libccci"

RDEPENDS_${PN} += " python3 ntp ntpdate mipc curl mosquitto libccci"


inherit systemd
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = " mita.service "

# SRC_URI += "file://mita.service"

FILES_${PN} += "${bindir}/mita"
FILES_${PN} += "${bindir}/mita_core/* \
                ${systemd_unitdir}/system/mita.service \
"


EXTRA_OEMAKE = 'PLATFORM="TELEMATICS"'
EXTRA_OEMAKE += 'MITA_VERSION="${@time.strftime('MiTA\(Yocto\)_V01.%y%U.0%w',time.gmtime())}"'
EXTRA_OEMAKE += 'CONFIG_MITA_MDM_SUPPORT="y"'
EXTRA_OEMAKE += 'CONFIG_MITA_SERVER_AGENT_SUPPORT="y"'

MITA_CFLAGS_ADD = " -I${STAGING_DIR_HOST}/usr/include/mipc/api \
                    -I${STAGING_DIR_HOST}/usr/include/mipc/common \
                    -I${STAGING_DIR_HOST}/usr/include/mipc/msg \
                    -I${STAGING_DIR_HOST}/usr/include \
                    -I${STAGING_DIR_HOST}/usr/include/curl \
                    -I${STAGING_DIR_HOST}/usr/include/libccci \
                    -I${STAGING_DIR_HOST}/${libdir} \
                    -D_LINUX -DTELEMATICS -fPIC -DSERVER_AGENT_ENABLE \
"

CFLAGS_append = "${MITA_CFLAGS_ADD}"
CXXFLAGS_append = "${MITA_CFLAGS_ADD}"
LDFLAGS_append = " -L${STAGING_DIR_HOST}/${libdir} -lmipc_msg -lpthread -ldl -lrt"
EXTRA_OEMAKE += 'LIBS="-lmipc_msg -lpthread -ldl -lmosquitto -lcurl -luuid -lmdm_server"'


do_install() {
    install -d ${D}${bindir}
    install -d ${D}${systemd_unitdir}/system/
    install -d ${D}${bindir}/mita_core
    install -m 0755 mita ${D}${bindir}/mita_core
    install -m 0644 ${S}/*.so* ${D}${bindir}/mita_core
    install -m 0644 ${S}/py/* ${D}${bindir}/mita_core
    install -m 0644 ${S}/files/mita.service ${D}${systemd_unitdir}/system
    ln -sr ${D}${bindir}/mita_core/mita ${D}${bindir}/mita
}
