#Basic Configuration
DESCRIPTION = "Library for RILD"
SECTION = "base"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS = "platform-libs platform-libs-common gstreamer1.0 glib-2.0 libapn libpal"

WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/telephonyware/3.0/libvendor-ril"

BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

inherit deploy workonsrc systemd

PLATFORM_CHIP = "MT6735"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'CROSS=${TARGET_PREFIX}'\
                'ROOT=${STAGING_DIR_HOST}'\
                'PREFIX=${BACH_PREFIX}'\
                'PACKAGE_ARCH=${PACKAGE_ARCH}'\
                'PLATFORM_CHIP=${PLATFORM_CHIP}'\
                'BB_INCLUDE_ADD=${BB_INCLUDE_ADD}'\
                'BB_LDFLAGS_ADD=${BB_LDFLAGS_ADD}'\
                'BB_TELEFWK_OPTION=true'\
                'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}' \
                'MTK_HAS_HAL2MNL_EXT_SERVER=true'"

SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "tele-fwk.service"

FILES_${PN} = "${base_bindir}\
               ${base_sbindir} \
               /etc/dbus-1/system.d/"

FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

FILES_${PN} += "${systemd_unitdir}/system/tele-fwk.service"
FILES_${PN} += "${datadir}/init/init_telefwk"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"

do_compile () {
	if [ "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" ]; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mfpu=neon-vfpv4 -mhard-float -Wl,--hash-style=gnu"
	elif [ "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4" ]; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mfpu=neon-vfpv4 -mhard-float -Wl,--hash-style=gnu"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu"
	fi
}

do_install () {
    oe_runmake install ROOT=${D}

    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${datadir}/init
        install -m 0755 ${S}/tele_fwk/init_telefwk ${D}${datadir}/init/init_telefwk
        install -d ${D}${includedir}/vendor-ril
        cp -af ${S}/include/telephony/ril.h ${D}${includedir}/vendor-ril
        cp -af ${S}/include/telephony ${D}${includedir}/vendor-ril
        install -d ${D}/etc/dbus-1/system.d
        install -m 0644 ${S}/mtk-rilproxy/telephony/sdk/data_sdk.conf ${D}/etc/dbus-1/system.d
        install -d ${D}${systemd_unitdir}/system/
        install -m 0644 ${S}/tele_fwk/tele-fwk.service ${D}${systemd_unitdir}/system
    fi
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
