inherit externalsrc package systemd

DESCRIPTION = "lynq_system.service"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "libpal gstreamer1.0 glib-2.0 dtmf libapn liblynq-log dbus"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/common_src/framework/lynq-system-service/src"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_system.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_system.service"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	echo "Installing image PN ${PN}"
	echo "Installing image systemd_unitdir ${systemd_unitdir}"
	echo "Installing image D ${D}"
	echo "Installing image B ${B}"
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq_system.service ${D}${systemd_unitdir}/system
	fi
	install -d ${D}/etc/dbus-1/system.d
	install -m 0644 ${S}/driver_sdk.conf ${D}/etc/dbus-1/system.d
	install -m 0644 ${S}/broadcast_sdk.conf ${D}/etc/dbus-1/system.d
	install -m 0644 ${S}/test_sdk.conf ${D}/etc/dbus-1/system.d
	install -m 0755 ${S}/lynq-system-service ${D}${bindir}/
	install -d ${D}${includedir}
}
