DESCRIPTION = "This module is a demo for MIPC."
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://${MTK_LICENSE_DIR}/MediaTekProprietary;md5=c5d17c6905715d0948a3d6087602d12d"

inherit workonsrc
WORKONSRC = "${MIPC_DIR}"

DEPENDS += "libtrm"

INSANE_SKIP_${PN} = "ldflags"
FILES_SOLIBSDEV = ""

FILES_${PN}-dev = "${includedir}/*"
FILES_${PN} = "${libdir}/libmipc_msg.so"

do_compile_prepend() {
	tar zxvf ${S}mipc.release.tar.gz

	sed -i -e 's/CC = gcc/#CC = gcc/g' ${S}/Makefile
	sed -i -e 's/CXX = g++/#CXX = g++/g' ${S}/Makefile
	sed -i -e 's/AR = ar/#AR = ar/g' ${S}/Makefile
	sed -i -e 's/CC = gcc/#CC = gcc/g' ${S}/Makefile.build
	sed -i -e 's/CXX = g++/#CXX = g++/g' ${S}/Makefile.build
	sed -i -e 's/AR = ar/#AR = ar/g' ${S}/Makefile.build
}

CFLAGS_append = " -DENABLE_TRM"
CXXFLAGS_append = " -DENABLE_TRM"
LDFLAGS_append = " -ldl"

do_install() {
    install -d ${D}${libdir}
    install -m 0755 ${S}/out/libmipc_msg.so ${D}${libdir}

    install -d ${D}${includedir}/mipc/common/
    install -d ${D}${includedir}/mipc/msg/
    install -d ${D}${includedir}/mipc/external/
    install -m 0644 ${S}/include/common/*.h ${D}${includedir}/mipc/common/
    install -m 0644 ${S}/include/msg/*.h ${D}${includedir}/mipc/msg/
    install -m 0644 ${S}/include/external/*.h ${D}${includedir}/mipc/external/
}
