DESCRIPTION = "MTK netagent"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"

inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/telephonyware/3.0/netagent/src"

DEPENDS += " libubox mipc ubus uci platform-libs"

INSANE_SKIP_${PN} += "dev-deps ldflags"
FILES_${PN} += "${libdir}/libnetagent.so"
FILES_${PN}-dev = "${includedir}/*"
FILES_SOLIBSDEV = ""

export EXTRA_CFLAGS += "-Wl,--hash-style=gnu"

LDFLAGS += "-Wl,--hash-style=gnu"

NETAGENT_CFLAGS_ADD = " -I${STAGING_DIR_HOST}/usr/include/mipc/api \
                        -I${STAGING_DIR_HOST}/usr/include/mipc/common \
                        -I${STAGING_DIR_HOST}/usr/include/mipc/msg \
                        -I${STAGING_DIR_HOST}/usr/include \
                        -I${WORKDIR}/${PN}-${PV}/include \
                        -D_LINUX \
                        -lpthread \
"



CFLAGS_append = "${NETAGENT_CFLAGS_ADD} -D __ANDROID__"
CXXFLAGS_append = "${NETAGENT_CFLAGS_ADD} -D __ANDROID__"


do_compile () {
    oe_runmake all
}


do_install() {
	install -d ${D}/usr/bin/

	install -d ${D}/${libdir}/
	install -d ${D}/usr/include/netagent
	install -d ${D}/usr/include/netagent/sysutils
	install -d ${D}/usr/include/netagent/ioutils
	install -d ${D}/usr/include/netagent/netutils

	install -m 0755 ${S}libnetagent/*.h  ${D}/usr/include/netagent/
	install -m 0755 ${S}libnetagent/nautils/include/sysutils/*.h ${D}/usr/include/netagent/sysutils/
	install -m 0755 ${S}libnetagent/nautils/include/ioutils/netagent_io.h  ${D}/usr/include/netagent/ioutils/
	install -m 0755 ${S}libnetagent/nautils/include/netutils/ifc.h  ${D}/usr/include/netagent/netutils/
	install -m 0755 ${S}libnetagent.so ${D}/${libdir}/
	install -m 0755 ${S}mtk_ia ${D}/usr/bin/
	install -m 0755 ${S}mtk_act_data_call ${D}/usr/bin/
	install -m 0755 ${S}mtk_deact_data_call ${D}/usr/bin/
}
