inherit externalsrc package systemd

DESCRIPTION = "lynq sdk ready"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "platform-libs liblynq-sim liblynq-uci liblynq-misc"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/common_src/framework/lynq-sdk-ready/src"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_sdk_ready.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_sdk_ready.service"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}lynq-sdk-ready ${D}${bindir}/
	install -d ${D}${systemd_unitdir}/system/
	install -m 0644 ${B}/lynq_sdk_ready.service ${D}${systemd_unitdir}/system
}
