inherit externalsrc package

DESCRIPTION = "apn database"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS = "platform-libs sqlite3 libxml2"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST}"
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/telephonyware/3.0/libvendor-ril/"
inherit deploy workonsrc

EXTRA_OEMAKE = "'CROSS=${TARGET_PREFIX}'\
                'PROJECT=${PROJ}'\
                'ROOT=${STAGING_DIR_HOST}'\
                'BB_APN_OPTION=true'\
                'LDFLAGS=${BB_LDFLAGS_ADD}'"

FILES_${PN} = "${base_libdir}/*.so \
               ${base_bindir}\
               ${base_sbindir}\
               /system/etc/tele"

FILES_${PN}-dev = "${includedir}/"

FILES_${PN}-staticdev = "${base_libdir}/*.a"

FILES_${PN}-doc = "/doc"

do_compile () {
    if [ "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" ]; then
        oe_runmake all BB_CFLAGS_ADD="--sysroot=${STAGING_DIR_HOST} -mhard-float" LDFLAGS="${LDFLAGS}" ROOT=${STAGING_DIR_HOST} OFLAGS="${BB_INCLUDE_ADD}" SYS_CFLAGS="${BB_INCLUDE_ADD}"
    else
        oe_runmake all BB_CFLAGS_ADD="--sysroot=${STAGING_DIR_HOST} -mhard-float" CXX="${CXX} ${CXXFLAGS}" LDFLAGS="${LDFLAGS}" ROOT=${STAGING_DIR_HOST} OFLAGS="${BB_INCLUDE_ADD}" SYS_CFLAGS="${BB_INCLUDE_ADD}"
    fi
}

do_install() {
    install -d ${D}${includedir}
    install ${WORKONSRC}/apn/inc/apn_interface.h ${D}${includedir}
    oe_runmake install ROOT=${D} PACKAGE_ARCH=${PACKAGE_ARCH}
    install -d ${D}/system/etc/tele/
    install -m 0644 ${S}/apn/resource/apns-conf.xml ${D}/system/etc/tele/
    install -m 0644 ${S}/apn/resource/apns-full-conf.xml ${D}/system/etc/tele/
    install -m 0644 ${S}/apn/resource/apns-conf-pct*.xml ${D}/system/etc/tele/
}
