inherit externalsrc package

DESCRIPTION = "wpa_supplicant test"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "platform-libs glib-2.0 openssl libnl"
DEPENDS += "${@bb.utils.contains("CONNMAN_SUPPORT", "yes", "dbus", "", d)}"

inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/packages/thirdpart/lynq-wg870"

LDFLAGS = "${@bb.utils.contains("CONNMAN_SUPPORT", "yes", "-L${STAGING_LIBDIR} -ldbus-1", "", d)}"

TARGET_CC_ARCH += "${LDFLAGS}"

CFLAGS = "-I${STAGING_INCDIR}/libnl3"
CFLAGS += "${@bb.utils.contains("CONNMAN_SUPPORT", "yes", "-I${STAGING_INCDIR}/dbus-${PV}", "", d)}"
CFLAGS += "${@bb.utils.contains("CONNMAN_SUPPORT", "yes", "-I${STAGING_LIBDIR}/dbus-${PV}/include/", "", d)}"


#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

FILES_${PN} += "/data/wifi/wg870/*"
FILES_${PN} += "${bindir}/wl"
FILES_${PN} += "${libdir}/libwpa_client.so"


FILES_${PN}-dev = "${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} = "ldflags"
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
INHIBIT_PACKAGE_STRIP = "1"

do_compile () {
	export CONFIG_BUILD_WPA_CLIENT_SO=y
	export CONFIG_DRIVER_NL80211_IFX=y
	export CONFIG_WEP=y

	if [ "${CONNMAN_SUPPORT}" = "yes" ]; then
		sed -i "s/^#CONFIG_CTRL_IFACE_DBUS_NEW=y/CONFIG_CTRL_IFACE_DBUS_NEW=y/" ${S}wpa_supplicant/.config
	else
		sed -i "s/^CONFIG_CTRL_IFACE_DBUS_NEW=y/#CONFIG_CTRL_IFACE_DBUS_NEW=y/" ${S}wpa_supplicant/.config
	fi

	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}hostapd/hostapd ${D}${bindir}/
	install -m 0755 ${S}hostapd/hostapd_cli ${D}${bindir}/
	install -m 0755 ${S}wpa_supplicant/wpa_supplicant ${D}${bindir}/
	install -m 0755 ${S}wpa_supplicant/wpa_cli ${D}${bindir}/
	install -m 0755 ${S}wl ${D}/${bindir}

	install -d ${D}/data/wifi/wg870
	install -m 0644 ${S}conf/wpa_supplicant.conf ${D}/data/wifi/wg870/
	install -m 0644 ${S}conf/wpa_supplicant_ap.conf ${D}/data/wifi/wg870/
	install -m 0644 ${S}conf/p2p_supplicant.conf ${D}/data/wifi/wg870/
	
	if [ "${CONNMAN_SUPPORT}" = "yes" ]; then
		install -d ${D}/etc/dbus-1/system.d/
		install -m 0644 ${S}wpa_supplicant/dbus/dbus-wpa_supplicant.conf ${D}/etc/dbus-1/system.d/
	fi

	install -d ${D}${includedir}/
	install -m 0644 ${S}src/common/wpa_ctrl.h ${D}${includedir}/
	install -d ${D}${libdir}/
	install -m 0644 ${S}wpa_supplicant/libwpa_client.so ${D}${libdir}/
}

