#Basic Configuration
DESCRIPTION = "LIBPAL"
SECTION = "base"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS +="platform-libs build-init"

PLATFORM_CHIP = "MT6735"
BACH_PREFIX = "${STAGING_INCDIR}/install"
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/telephonyware/3.0/libpal"

BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

inherit deploy workonsrc

#Parameters passed to do_compile()
EXTRA_OEMAKE = "'CROSS=${TARGET_PREFIX}'\
                'PROJECT=${PROJ}'\
				'PREFIX=${BACH_PREFIX}'\
				'PACKAGE_ARCH=${PACKAGE_ARCH}'\
                'PLATFORM_CHIP=${PLATFORM_CHIP}'\
                'BB_INCLUDE_ADD=${BB_INCLUDE_ADD}'\
                'BB_LDFLAGS_ADD=${BB_LDFLAGS_ADD}'"

FILES_${PN} = "${base_libdir}/*.so\
               ${base_bindir} \
               /mnt\
               /tmp\
               /etc\
               /test"

FILES_${PN}-dev = "${includedir}"

FILES_${PN}-staticdev = "${base_libdir}/*.a"

FILES_${PN}-dbg = "/usr/src/debug \
				   ${base_libdir}/.debug \
				   ${base_bindir}"

#Skip strip check in QA test.
INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"

do_compile () {
    unset LDFLAGS
    oe_runmake all ROOT=${STAGING_DIR_HOST}
}

do_install () {
    oe_runmake install ROOT=${D}
	
	if [ -d "${D}/include" ]; then
		install -d ${D}${includedir}
		cp -af ${D}/include/* ${D}${includedir}
		rm -rf ${D}/include
	fi
	
        
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}

