/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef YOCTO_COMMON_DATA_H
#define YOCTO_COMMON_DATA_H

#include <memory>
#include <vendor-ril/telephony/ril.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <sys/prctl.h>
#include <cstdint>
#include <pthread.h>

#include "powerManager.h"
#include "rfdesense/RfDesenseTxTest.h"
#include "framework/lynq_interface.h"
#include "util/AtLine.h"

#define DEBUG 0
#define FUNCTION_CALLED(time,msg) printf("%s: %s %s called\n",(time), __func__ ,(msg));
#define FUNCTION_RETURN(time,msg) printf("%s: %s %s returns\n",(time), __func__ ,(msg));

#define EM_MODE_SUPPORT 1
#ifdef ATCI_PARSE
#define ATCI_ENABLE_RESPONSE 1
#endif
//#define ENABLE_BLOCK_FEATURE
#define BLOCK_MARK          0x10000000
#define RSP_DISP_TOKEN_MARK 0x01000000
#define ATCI_TOKEN_MARK     0x02000000
#define RIL_TOKEN_MARK      0x04000000
#define INIT_TOKEN_MARK     0x08000000
#define OTHER_TOKEN_MARK    0x20000000;
#define TOKEN_MODE 0x01000000
#define INIT 1
#define UDP  2
#define ATCI 3
#define RSPD 4
#define OTHER 5

#define PROP_DEFAULT_DATA_SIM "persist.vendor.radio.data.sim"
#define PROP_DEFAULT_DATA_SIM_STATUS "vendor.radio.data.enable"
#define ATCI_SIM "persist.vendor.service.atci.sim"
//#define PROP_DATA_ALLOW_STATUS "vendor.ril.data.allow.status"

#define UNSET -1

typedef struct {
    int requestNumber;
    void (*dispatchFunction) (android::Parcel &p, struct RequestInfo *pRI);
    int(*responseFunction) (android::Parcel &p, void *response, size_t responselen);
} CommandInfo;

typedef struct RequestInfo {
    int32_t token;      //this is not RIL_Token
    /*mobiletek add*/
    void *UserToken;
    /*mobiletek end*/
    CommandInfo *pCI;
    struct RequestInfo *p_next;
    char cancelled;
    char local;         // responses to local commands do not go back to command process
    RIL_SOCKET_ID socket_id;
} RequestInfo;

typedef struct {
    char *name;           /* User printable name of the function. */
    int (*func)(int argc, char *argv[], RIL_SOCKET_ID socket_id, RequestInfo *pRI);       /* Function to call to do the job. */
    char *doc;            /* Documentation for this function.  */
    int request;
} COMMAND;


void updateCardStatusV6(RIL_CardStatus_v6 *card_status,int slot);
char* getAid(int slot);

void update_reg_voice_service_state(int request, char* code, int slot, int32_t token);
void update_reg_voice_radio_tech(int request, int code, int slot, int32_t token);
void update_reg_data_service_state(int request, char* code, int slot, int32_t token);
void update_reg_data_radio_tech(int request, int code, int slot, int32_t token);
void update_preferred_network_type(int type, int slot);
void update_call_state(void *response, size_t responselen, int slot);

int is_call_state_idle(int slot);
int get_preferred_network_type(int slot);
int get_reg_data_radio_tech(int slot);
int get_reg_voice_radio_tech(int slot);
void update_voice_radio_tech(int code, int slot);
int get_voice_radio_tech(int slot);
void update_radio_capa(RIL_RadioCapability* cap, int slot);
RIL_RadioCapability get_radio_capa(int slot);
std::int32_t GenerateToken(int mode, int request);

void updateRadioStatus(int newValue,RIL_SOCKET_ID soc_id);
bool isRadioOn(RIL_SOCKET_ID soc_id);
bool isRadioAvailable(RIL_SOCKET_ID soc_id);

bool isDataConnectEnable(int slot);
void updataDataConnectState(int slot, bool state);
const char *radioStateToString(RIL_RadioState);
const char * rilSocketIdToString(RIL_SOCKET_ID socket_id);

#if EM_MODE_SUPPORT
typedef void (* netwokInfoNotify)(int type, char *data);
typedef void (*atCmdResponse)(char *response,int responselen);
extern RfDesenseTxTest* m_RfDesense;

void registerRadioOn(RfDesenseTxTest* rf);
void unregisterRadioOn();
void registerRadioOffOrNotAvailable(RfDesenseTxTest* rf);
void unregisterRadioOffOrNotAvailable();
void registerOnUnsolOemHookRaw(RfDesenseTxTest* rf);
void unregisterOnUnsolOemHookRaw();
void register_response_oem_hook_raw(RfDesenseTxTest* rf);
void unregister_response_oem_hook_raw();

bool isFinalResponseErrorEx(char* str);

void set_default_sim_all(int slot_id);
int get_default_sim_all();
void set_default_sim_voice(int slot_id);
int get_default_sim_voice();
void set_default_sim_data(int slot);
int get_default_sim_data_for_switch();
bool isNeedConnect();
void resetConnect();
int get_default_sim_data();
void set_default_sim_sms(int slot_id);
int get_default_sim_sms();
void set_default_sim_all_except_data(int slot_id);
int get_default_sim_all_except_data();
RequestInfo* creatRILInfoAndInit(int request, int mode, RIL_SOCKET_ID soc_id);
int get_atci_sim();
bool mtkItTest(const char* data);

void updateSystemTime(const void *data, int datalen);
void notifyDataSignal();
#endif
#ifdef ECALL_SUPPORT
void ConvertMsd(const char *msdChar, unsigned char *msd);
#endif /*ECALL_SUPPORT*/
namespace android {
    void initRequestInfo(RequestInfo *pRI, int  request, int mode, RIL_SOCKET_ID soc_id);
    const char * requestToString(int request);
    const int RspDispFunction(int request,char* arg, RIL_SOCKET_ID socket_id);
    void requestSMSACKNOWLEDGE(RIL_SOCKET_ID soc_id);
    void requestAnswer(RIL_SOCKET_ID soc_id);
    void writeStringToParcel(Parcel &p, const char *s);
    void RIL_startEventLoop(void);
    void startATCILoop(void);
    void startGdbusLoop(void);
    void startPMLoop(void);
    void registerForATcmdResponse(atCmdResponse cb);
    void unregisterNetwork();
    void registerForNetworkInfo(netwokInfoNotify cb);
    void unregisterATcmd();
    int emResultNotify(const char *str);
    void ATCIRequest(int request, char* reqString, void* t,int argc, char**argv);
    void startWakupLoop(void);
}

#endif
