#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "set network selection mode automatically or manually"
if [ ! -n "$1" ]
then
        echo -E "Error:"
        echo -E "please input parameter, you can input 'SetNetworkSelectionMode -h' for more details"
        exit 1
fi

if [ "$1" == "-h" ]
then
	echo -E "set network selection mode automatically or manually."
	echo -E "Usage: SetNetworkSelectionMode selectionmode [MCCMNC]"
	echo -E "selectionmode: Auto | Manual"
	echo -E "MCCMNC: used when using manual selection mode, and MCC is Mobile Country Code, MNC is Mobile Network Code(eg "46000")"
	echo -E "Where MCC is Mobile Country Code, MNC is Mobile Network Code(eg "46000")"
	exit 0
fi

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
if [ "$1" == "Auto" ]
then
	echo "RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC" >&9
elif [ "$1" == "Manual" ]
then
	if [ ! -n "$2" ]
	then
		echo -E "error:"
		echo -E "please input parameter MCCMNC when using manual selection mode."
		echo -E "input 'SetNetworkSelectionMode -h' for more details "
	exit 1
	else
		echo "RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL $2" >&9
	fi
fi

#close socket R/W
exec 9>&-
exec 9<&-
exit 0