/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <utils/String8.h>
#include <cutils/properties.h>
#include <vendor-ril/telephony/ril.h>
#include <bitset>
#include <vector>

#include "Radio_capability_switch_util.h"
#include "utils.h"
#include "log_extra.h"
#include "Phone_utils.h"
#include "common.h"
#include "Proxycontroller.h"
#include "RatConfiguration.h"
#include "MtkRadioAccessFamily.h"
#include "network.h"

const int Radio_capability_switch_util::SIM_OP_INFO_UNKNOWN = 0;
const int Radio_capability_switch_util::SIM_OP_INFO_OVERSEA = 1;
const int Radio_capability_switch_util::SIM_OP_INFO_OP01 = 2;
const int Radio_capability_switch_util::SIM_OP_INFO_OP02 = 3;
const int Radio_capability_switch_util::SIM_OP_INFO_OP09 = 4;
const int Radio_capability_switch_util::SIM_OP_INFO_OP18 = 4;

const int Radio_capability_switch_util::SIM_TYPE_SIM = 0;
const int Radio_capability_switch_util::SIM_TYPE_USIM = 1;
const int Radio_capability_switch_util::SIM_TYPE_OTHER = 2;

const int Radio_capability_switch_util::OP01_6M_PRIORITY_OP01_USIM = 0;
const int Radio_capability_switch_util::OP01_6M_PRIORITY_OP01_SIM = 1;
const int Radio_capability_switch_util::OP01_6M_PRIORITY_OTHER = 2;

// sync to ril_oem.h for dsda
const int Radio_capability_switch_util::SIM_SWITCH_MODE_SINGLE_TALK_MDSYS       = 1;
const int Radio_capability_switch_util::SIM_SWITCH_MODE_SINGLE_TALK_MDSYS_LITE  = 2;
const int Radio_capability_switch_util::SIM_SWITCH_MODE_DUAL_TALK               = 3;
const int Radio_capability_switch_util::SIM_SWITCH_MODE_DUAL_TALK_SWAP          = 4;
const int Radio_capability_switch_util::ENHANCEMENT_T_PLUS_T = 0;
const int Radio_capability_switch_util::ENHANCEMENT_T_PLUS_W = 1;
const int Radio_capability_switch_util::ENHANCEMENT_T_PLUS_C = 2;
const int Radio_capability_switch_util::ENHANCEMENT_W_PLUS_C = 3;
const int Radio_capability_switch_util::ENHANCEMENT_W_PLUS_W = 4;
const int Radio_capability_switch_util::ENHANCEMENT_W_PLUS_NA = 5;

#define LOG_TAG "DEMO_RADIO_CAPABILITY_SWITCH_UTIL"

const std::string Radio_capability_switch_util::PROPERTY_ICCID = "vendor.ril.iccid.sim";
const std::string Radio_capability_switch_util::PROPERTY_CAPABILITY_SWITCH = "persist.vendor.radio.simswitch";
// OP01 SIMs
const std::string Radio_capability_switch_util::PLMN_TABLE_OP01[] = {
    "46000", "46002", "46007", "46008", "45412", "45413",
    // Lab test IMSI
    "00101", "00211", "00321", "00431", "00541", "00651",
    "00761", "00871", "00902", "01012", "01122", "01232",
    "46004", "46602", "50270"
};

// OP02 SIMs
const std::string Radio_capability_switch_util::PLMN_TABLE_OP02[]= {
    "46001", "46006", "46009", "45407"
};

// OP09 SIMs
const std::string Radio_capability_switch_util::PLMN_TABLE_OP09[]= {
    "46005", "45502", "46003", "46011"
};

// OP18 SIMs
const std::string Radio_capability_switch_util::PLMN_TABLE_OP18[] = {
    "405840", "405854", "405855", "405856",
    "405857", "405858", "405855", "405856",
    "405857", "405858", "405859", "405860",
    "405861", "405862", "405863", "405864",
    "405865", "405866", "405867", "405868",
    "405869", "405870", "405871", "405872",
    "405873", "405874"
};

// OP02 case
const std::string Radio_capability_switch_util::NO_SIM_VALUE = "N/A";
const std::string Radio_capability_switch_util::CN_MCC = "460";
const std::string Radio_capability_switch_util::PROPERTY_SIM_ICCID[] = {
    "vendor.ril.iccid.sim1",
    "vendor.ril.iccid.sim2",
    "vendor.ril.iccid.sim3",
    "vendor.ril.iccid.sim4"
};

const int Radio_capability_switch_util::IMSI_NOT_READY_OR_SIM_LOCKED = 2;
const int Radio_capability_switch_util::ICCID_ERROR = 3;

// sim icc status
// 0: imsi not ready
// 1: imsi ready
const std::string Radio_capability_switch_util::IMSI_NOT_READY = "0";
const std::string Radio_capability_switch_util::IMSI_READY = "1";
const std::string Radio_capability_switch_util::PROPERTY_SIM_IMSI_STATUS[] = {
    "vendor.ril.imsi.status.sim1",
    "vendor.ril.imsi.status.sim2",
    "vendor.ril.imsi.status.sim3",
    "vendor.ril.imsi.status.sim4"
};

const std::string Radio_capability_switch_util::PROPERTY_RIL_FULL_UICC_TYPE[] = {
    "vendor.gsm.ril.fulluicctype",
    "vendor.gsm.ril.fulluicctype.2",
    "vendor.gsm.ril.fulluicctype.3",
    "vendor.gsm.ril.fulluicctype.4",
};

const std::string Radio_capability_switch_util::PROPERTY_RIL_CT3G[] = {
    "vendor.gsm.ril.ct3g",
    "vendor.gsm.ril.ct3g.2",
    "vendor.gsm.ril.ct3g.3",
    "vendor.gsm.ril.ct3g.4",
};

#define PROPERTY_ICCID_PREIFX "vendor.ril.iccid.sim"

std::string Radio_capability_switch_util::get_sim_app_type(int slot) {
    char buf[PROPERTY_VALUE_MAX] = {0};
    utils::mtk_property_get(PROPERTY_RIL_FULL_UICC_TYPE[slot].c_str(), buf, "");
    std::string str(buf);
    logd(android::String8::format("get slot(%d) type %s", slot, str.c_str()));
    return str;
}

Radio_capability_switch_util::Radio_capability_switch_util() {
    // TODO Auto-generated constructor stub
}

Radio_capability_switch_util::~Radio_capability_switch_util() {
    // TODO Auto-generated destructor stub
}

int Radio_capability_switch_util::get_main_capability_phone_id() {
    int phoneId = 0;
    phoneId = utils::mtk_property_get_int32(PROPERTY_CAPABILITY_SWITCH.c_str(), 1) - 1;
    logd(android::String8::format("getMainCapabilityPhoneId %d",phoneId));
    return phoneId;
}

bool Radio_capability_switch_util::is_sim_inserted(int slot) {
    char iccid[PROPERTY_VALUE_MAX] = {0};
    android::String8 prop(PROPERTY_ICCID_PREIFX);

    prop.append(android::String8::format("%d", (slot + 1)));
    utils::mtk_property_get(prop.string(), iccid, "");

    LOG_D(LOG_TAG, "(slot%d)iccid: %s", slot, iccid);
    if ((strlen(iccid) > 0) && (strcmp(iccid, "N/A") != 0)){
        return true;
    }
    return false;
}

int Radio_capability_switch_util::get_max_raf_supported(){
    int maxRaf = RAF_UNKNOWN;

    // RAF_GPRS is a marker of main capability
    for (int i = 0; i < SIM_COUNT; i++) {
        int rat = get_radio_capa(i).rat;
        LOG_D(LOG_TAG, "(slot%d)rat: %d", i, rat);
        if ((rat & RAF_GPRS) == RAF_GPRS) {
            maxRaf = rat;
        }
    }
    RLOGD("get_max_raf_supported:  maxRaf= %d" , maxRaf);

    // If the phone capability cannot be updated promptly, the max capability should mark with
    // GPRS, to avoid using an unknown RAF to trigger sim switch
    if (maxRaf == RAF_UNKNOWN) {
        maxRaf |= RAF_GPRS;
    }

    return maxRaf;
}

//RIL_RadioAccessFamily
int Radio_capability_switch_util::get_min_rat_supported(){
    int minRaf = RAF_UNKNOWN;

    // RAF_GPRS is a marker of main capability
    for (int i = 0; i < SIM_COUNT; i++) {
        int rat = get_radio_capa(i).rat;
        LOG_D(LOG_TAG, "(slot%d)rat: %d", i, rat);
        if ((rat & RAF_GPRS) == 0) {
            minRaf = rat;
        }
    }
    RLOGD("get_max_raf_supported:  minRaf= %d" , minRaf);
    return minRaf;
}

void Radio_capability_switch_util::sendRadioCapabilityRequest(int slotid) {
    RequestInfo *info = creatRILInfoAndInit(RIL_REQUEST_SET_RADIO_CAPABILITY, OTHER, (RIL_SOCKET_ID)slotid);
    char* version  = strdup((std::to_string(RIL_RADIO_CAPABILITY_VERSION)).c_str());
    char* argv[7] = {"RIL_REQUEST_SET_RADIO_CAPABILITY", "0", "1", "2", "0","modem_sys1_ps0","0"};
    argv[1] = version;
    setRadioCapability(7, argv,(RIL_SOCKET_ID)slotid, info);
    free(version);
}

void Radio_capability_switch_util::set_default_data_slot(int slot) {
    int id = get_main_capability_phone_id();
    if(id == slot) {
        android::emResultNotify("default data slot is right, no need switch\n");
        LOG_D(LOG_TAG, "the default data slot capability is right, don't need to set");
        return;
    }

    int len = Phone_utils::get_phone_count();
    std::vector<RIL_RadioAccessFamily> rafs = {RAF_UNKNOWN, RAF_UNKNOWN};
    if(slot == 0 ){
        rafs[1] = (RIL_RadioAccessFamily)get_min_rat_supported();
    } else if(slot == 1) {
        rafs[0] = (RIL_RadioAccessFamily)get_min_rat_supported();
    } else {
        LOG_D(LOG_TAG, "slot is %d, range 0 or 1", slot);
        return ;
    }
    rafs[slot] = (RIL_RadioAccessFamily)get_max_raf_supported();
    Proxy_controller::getInstance()->set_Radio_Capability(rafs);
}

/**
 * Check if need to skip switch capability.
 *
 * @param majorPhoneId new major phone ID
 * @return true : don't switch and stay current capability setting
 * @       false  :  keep do setCapability
 */
bool Radio_capability_switch_util::isSkipCapabilitySwitch(int majorPhoneId, int phoneNum) {
    std::vector<int> simOpInfo(phoneNum);
    std::vector<int> simType(phoneNum);
    int insertedState = 0;
    int insertedSimCount = 0;
    int tSimCount = 0;
    int wSimCount = 0;
    int cSimCount = 0;
    std::vector<std::string> currIccId(phoneNum, "");
    char optr[PROPERTY_VALUE_MAX] = {0};
    utils::mtk_property_get("persist.vendor.operator.optr", optr, "OM");
    std::string opSpec(optr);
    std::string opOM("OM");

    if (isPS2SupportLTE()) {
        if (phoneNum > 2) {
            if (majorPhoneId < 2 && get_main_capability_phone_id() < 2
                    && !RatConfiguration::isC2kSupported()
                    && !RatConfiguration::isTdscdmaSupported()) {
                return true;
            }
            return false;
        }
        // check sim cards number
        for (int i = 0; i < phoneNum; i++) {
            char iccid[PROPERTY_VALUE_MAX] = {0};
            utils::mtk_property_get(std::string(PROPERTY_ICCID).append(std::to_string(i+1)).c_str(), iccid, "");
            currIccId[i] = iccid;
            if (currIccId[i].empty()) {
                LOG_D(LOG_TAG, "iccid not found, do capability switch");
                return false;
            }
            if (!(NO_SIM_VALUE == currIccId[i])) {
                ++insertedSimCount;
                insertedState = insertedState | (1 << i);
            }
        }

        // no sim card
        if (insertedSimCount == 0) {
            LOG_D(LOG_TAG, "no sim card, skip capability switch");
            return true;
        }

        // check sim info
        if (getSimInfo(simOpInfo, simType, insertedState) == false) {
            LOG_D(LOG_TAG, "cannot get sim operator info, do capability switch");
            return false;
        }

        for (int i = 0; i < phoneNum; i++) {
            if (SIM_OP_INFO_OP01 == simOpInfo[i]) {
                tSimCount++;
            } else if (isCdmaCard(i, simOpInfo[i])) {
                cSimCount++;
            } else if (SIM_OP_INFO_UNKNOWN!= simOpInfo[i]){
                wSimCount++;
            }
        }

        LOG_D(LOG_TAG, "isSkipCapabilitySwitch : Inserted SIM count: %d, insertedStatus: %d, tSimCount: %d, wSimCount: %d, cSimCount: %d",
                insertedSimCount, insertedState, tSimCount, wSimCount ,cSimCount );

        if (opOM == opSpec ) {
            // t + t --> don't need to capability switch
            if (isSupportSimSwitchEnhancement(ENHANCEMENT_T_PLUS_T)
                    && (insertedSimCount == 2) && (tSimCount == 2)) {
                return true;
            }

            // t + w --> if support real T+W, always on t card
            if (isSupportSimSwitchEnhancement(ENHANCEMENT_T_PLUS_W)
                    && (insertedSimCount == 2) && (tSimCount == 1) && (wSimCount == 1)) {
                if (isTPlusWSupport() && (simOpInfo[majorPhoneId] != SIM_OP_INFO_OP01)) {
                    return true;
                }
            }

            // t + c --> always on c card
            if (isSupportSimSwitchEnhancement(ENHANCEMENT_T_PLUS_C)
                    && (insertedSimCount == 2) && (tSimCount == 1) && (cSimCount == 1)) {
                if (!isCdmaCard(majorPhoneId, simOpInfo[majorPhoneId])) {
                    return true;
                }
            }

            // w + c--> always on c card
            if (isSupportSimSwitchEnhancement(ENHANCEMENT_W_PLUS_C)
                    && (insertedSimCount == 2) && (wSimCount == 1) && (cSimCount == 1)) {
                if (!isCdmaCard(majorPhoneId, simOpInfo[majorPhoneId])) {
                    return true;
                }
            }

        }

        // w + w --> don't need to capability switch
        if (isSupportSimSwitchEnhancement(ENHANCEMENT_W_PLUS_W)
                && (insertedSimCount == 2) && (wSimCount == 2)) {
            return true;
        }

        // w + empty --> don't need to capability switch
        if (isSupportSimSwitchEnhancement(ENHANCEMENT_W_PLUS_NA)
                && (insertedSimCount == 1) && (wSimCount == 1)) {
            return true;
        }
    }

    return false;
}

bool Radio_capability_switch_util::getSimInfo(std::vector<int> simOpInfo, std::vector<int>  simType, int insertedStatus) {
    std::vector<std::string> strMnc(simOpInfo.size(), "");
    std::vector<std::string> strSimType(simOpInfo.size(),"");
    std::string propStr;

    for (int i = 0; i < simOpInfo.size(); i++) {
        if (i == 0) {
            propStr = "vendor.gsm.ril.uicctype";
        } else {
            propStr = std::string("vendor.gsm.ril.uicctype.").append(std::to_string(i + 1));
        }
        char uicctype[PROPERTY_VALUE_MAX] = { 0 };
        utils::mtk_property_get(propStr.c_str(),uicctype, "");
        strSimType[i] = uicctype;
        if (strSimType[i] == "SIM") {
            simType[i] = Radio_capability_switch_util::SIM_TYPE_SIM;
        } else if (strSimType[i] == "USIM") {
            simType[i] = Radio_capability_switch_util::SIM_TYPE_USIM;
        } else {
            simType[i] = Radio_capability_switch_util::SIM_TYPE_OTHER;
        }
        LOG_D(LOG_TAG, "SimType[%d]= %s, simType[%d]= %d",i, strSimType[i].c_str(), i, simType[i]);

        if (strMnc[i].empty()) {
            LOG_D(LOG_TAG, "strMnc[%d] is null, get mnc by ril.uim.subscriberid",i);
            propStr = std::string("vendor.ril.uim.subscriberid.").append(std::to_string(i+1));
            char uim[PROPERTY_VALUE_MAX] = { 0 };
            utils::mtk_property_get(propStr.c_str(), uim, "");
            strMnc[i] = uim;
        }
        if (strMnc[i].empty()) {
            LOG_D(LOG_TAG, "strMnc[%d] is null, get mnc by vendor.gsm.ril.uicc.mccmnc", i);
            if (i == 0) {
                propStr = "vendor.gsm.ril.uicc.mccmnc";
            } else {
                propStr = std::string("vendor.gsm.ril.uicc.mccmnc.").append(std::to_string(i));
            }
            char mccmnc[PROPERTY_VALUE_MAX] = { 0 };
            utils::mtk_property_get(propStr.c_str(), mccmnc, "");
            strMnc[i] = mccmnc;
        }

        if (strMnc[i].empty()) {
            LOG_D(LOG_TAG, "strMnc[%d] is null", i);
            strMnc[i] = "";
        }

        if (strMnc[i].length() >= 6) {
            strMnc[i] = strMnc[i].substr(0, 6);
        } else if (strMnc[i].length() >= 5) {
            strMnc[i] = strMnc[i].substr(0, 5);
        }
        LOG_D(LOG_TAG, "insertedStatus: %d, imsi status:", insertedStatus, getSimImsiStatus(i));
        if ((insertedStatus >= 0) && (((1 << i) & insertedStatus) > 0)) {
            if (strMnc[i].empty() || strMnc[i] == "error") {
                LOG_D(LOG_TAG, "SIM is inserted but no imsi");
                return false;
            }
            if (strMnc[i] == "sim_lock") {
                LOG_D(LOG_TAG, "SIM is lock, wait pin unlock");
                return false;
            }
            if (strMnc[i] == "N/A" || strMnc[i] == "sim_absent") {
                LOG_D(LOG_TAG, "strMnc have invalid value, return false");
                return false;
            }
        }
        for (std::string mccmnc : PLMN_TABLE_OP01) {
            if (strMnc[i].find(mccmnc) == 0) {
                simOpInfo[i] = SIM_OP_INFO_OP01;
                break;
            }
        }
        if (simOpInfo[i] == SIM_OP_INFO_UNKNOWN) {
            for (std::string mccmnc : PLMN_TABLE_OP02) {
                if (strMnc[i].find(mccmnc) == 0) {
                    simOpInfo[i] = SIM_OP_INFO_OP02;
                    break;
                }
            }
        }
        if (simOpInfo[i] == SIM_OP_INFO_UNKNOWN) {
            for (std::string mccmnc : PLMN_TABLE_OP09) {
                if (strMnc[i].find(mccmnc) == 0) {
                    simOpInfo[i] = SIM_OP_INFO_OP09;
                    break;
                }
            }
        }
        char optr[PROPERTY_VALUE_MAX] = { 0 };
        utils::mtk_property_get("persist.vendor.operator.optr", optr,"");
        if ("OP18" == std::string(optr)) {
            if (simOpInfo[i] == SIM_OP_INFO_UNKNOWN) {
                for (std::string mccmnc : PLMN_TABLE_OP18) {
                    if (strMnc[i].find(mccmnc) == 0) {
                        simOpInfo[i] = SIM_OP_INFO_OP18;
                        break;
                    }
                }
            }
        }
        if (simOpInfo[i] == SIM_OP_INFO_UNKNOWN) {
            if (!(strMnc[i].empty()) && !(strMnc[i] == "N/A")) {
                simOpInfo[i] = SIM_OP_INFO_OVERSEA;
            }
        }
        LOG_D(LOG_TAG, "strMnc[%d]= %s, simOpInfo[%d]=%d", i, strMnc[i].c_str(), i,simOpInfo[i]);
    }
    for(auto info : simOpInfo) {
        LOG_D(LOG_TAG, "getSimInfo(simOpInfo): %d", info);
    }
    for(auto type: simType) {
        LOG_D(LOG_TAG, "getSimInfo(simType): %d", type);
    }
    return true;
}

std::string Radio_capability_switch_util::getSimImsiStatus(int slot) {
    char sim_status[PROPERTY_VALUE_MAX] = { 0 };
    utils::mtk_property_get(PROPERTY_SIM_IMSI_STATUS[slot].c_str(), sim_status,
            IMSI_NOT_READY.c_str());
    return std::string(sim_status);
}

bool Radio_capability_switch_util::isPS2SupportLTE() {
    char ps2_rat[PROPERTY_VALUE_MAX] = { 0 };
    utils::mtk_property_get("persist.vendor.radio.mtk_ps2_rat", ps2_rat, "");
    std::string rat(ps2_rat);
    if (rat.find('L') != std::string::npos) {
        LOG_D(LOG_TAG, "isPS2SupportLTE = true");
        return true;
    }
    LOG_D(LOG_TAG, "isPS2SupportLTE = false");
    return false;
}

bool Radio_capability_switch_util::isTPlusWSupport() {
    char tpluswsupport[PROPERTY_VALUE_MAX] = { 0 };
    utils::mtk_property_get("vendor.ril.simswitch.tpluswsupport", tpluswsupport,
            "");
    if ("1" == std::string(tpluswsupport)) {
        LOG_D(LOG_TAG, "return true for T+W support");
        return true;
    }
    return false;
}

bool Radio_capability_switch_util::isVolteEnabled(int phoneId) {
    bool imsUseEnabled = utils::mtk_property_get_bool("persist.mtk.volte.enable", false);
    if (imsUseEnabled == true) {
        // check 4G is enabled or not
        if (is_sim_inserted(phoneId)) {
            int nwMode = get_preferred_network_type(phoneId);
            int rafFromNwMode = MtkRadioAccessFamily::getRafFromNetworkType(
                    nwMode);
            int rafLteGroup = MtkRadioAccessFamily::RAF_LTE
                    | MtkRadioAccessFamily::RAF_LTE_CA;
            if ((rafFromNwMode & rafLteGroup) == 0) {
                imsUseEnabled = false;
            }
            LOG_D(LOG_TAG, "isVolteEnabled, imsUseEnabled = %d, nwMode = %d, rafFromNwMode = %d, rafLteGroup = %d",
                    imsUseEnabled,nwMode, rafFromNwMode, rafLteGroup);
        } else {
            LOG_D(LOG_TAG,"isVolteEnabled, subId[] is null");
        }
    }
    LOG_D(LOG_TAG,"isVolteEnabled = %d", imsUseEnabled);
    return imsUseEnabled;
}

bool Radio_capability_switch_util::isHVolteEnabled() {
    char mtk_ct_volte[PROPERTY_VALUE_MAX] = {0};
    utils::mtk_property_get("persist.vendor.mtk_ct_volte_support", mtk_ct_volte, "");
    if ( "2" == std::string(mtk_ct_volte) || "3" == std::string(mtk_ct_volte)) {
        return true;
    }
    return false;
}

bool Radio_capability_switch_util::isCdmaCard(int phoneId, int opInfo) {
    bool isCdmaSim = false;
    if (phoneId < 0
            || phoneId >= SIM_COUNT) {
        LOG_D(LOG_TAG, "isCdmaCard invalid phoneId: %d", phoneId);
        return isCdmaSim;
    }

    char uicc_type[PROPERTY_VALUE_MAX] = {0};
    utils::mtk_property_get(PROPERTY_RIL_FULL_UICC_TYPE[phoneId].c_str(), uicc_type, "");
    std::string cardType(uicc_type);
    isCdmaSim =
            (cardType.find("CSIM") != std::string::npos || cardType.find("RUIM") != std::string::npos);

    if (!isCdmaSim && ("SIM" == cardType)) {
        char ct3g[PROPERTY_VALUE_MAX] = {0};
        utils::mtk_property_get(PROPERTY_RIL_CT3G[phoneId].c_str(), ct3g, "");
        std::string uimDualMode(ct3g);
        if ("1" == uimDualMode) {
            isCdmaSim = true;
        }
    }

    if (opInfo == SIM_OP_INFO_OP09) {
        isCdmaSim = true;
    }

    if (isCdmaSim == true && isVolteEnabled(phoneId) == true
            && isHVolteEnabled() == false) {
        // if volte is enabled and h-volte is disbale, SRLTE is unused for CT card, treat as CU sim
        isCdmaSim = false;
        LOG_D(LOG_TAG,"isCdmaCard, volte is enabled, SRLTE is unused for CT card");
    }

    return isCdmaSim;
}

/**
 * Check if support SIM switch enhancement
 *
 * @return true : support SIM switch enhancement.
 * @       false  :  don't support SIM switch enhancement
 */
bool Radio_capability_switch_util::isSupportSimSwitchEnhancement(int simType) {
    bool ret = false;
    switch (simType) {
    // CMCC + CMCC
    case ENHANCEMENT_T_PLUS_T:
        ret = true;
        break;

        // CMCC + CU
    case ENHANCEMENT_T_PLUS_W:
        ret = true;
        break;

        // CMCC + CT
    case ENHANCEMENT_T_PLUS_C:
        ret = false;
        break;

        // CT + CU
    case ENHANCEMENT_W_PLUS_C:
        ret = false;
        break;

        // CU + CU
    case ENHANCEMENT_W_PLUS_W:
        ret = true;
        break;

        // CU + Empty
    case ENHANCEMENT_W_PLUS_NA:
        ret = true;
        break;

    default:
        break;
    }
    return ret;
}

void Radio_capability_switch_util::logd(android::String8 s) {
    LOG_D(LOG_TAG, "%s", s.string());
}
