// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef RFDESENSETXTEST_H_
#define RFDESENSETXTEST_H_

#include <string>
#include <vector>
#include <memory>
#include <mutex>
#include <thread>
#include <condition_variable>
#include <vendor-ril/telephony/ril.h>
#include <utils/Looper.h>
#include <utils/Thread.h>
#include <utils/RefBase.h>

using namespace std;
using ::android::Looper;
using ::android::Thread;
using ::android::MessageHandler;
using ::android::Message;
using ::android::sp;
using ::android::RefBase;

#include "rfdesense/RfDesenseRatInfo.h"
#include "Radio_capability_switch_util.h"

class RfDesenseTxTest: public android::RefBase {
public:
    RfDesenseTxTest();
    virtual ~RfDesenseTxTest();
    static RfDesenseTxTest* getInstance();
    int emRfDesenseStart(int len,int *item,int multilen,char *value[]);
    void emRadioStateOn();
    void emRadioStateOfforNotAvailable();
    void emOemHookRaw(int value, int slot_id);
    void emRfDesenseAtCmdHandle(char*response, int responselen);
    static const int STATE_NONE;
    static const int STATE_STARTED;
    static const int STATE_STOPPED;

    static const int MSG_START_TX;
    static const int MSG_CONTINUE_TX;
    static const int MSG_NEXT_RAT;
    static const int MSG_READ_POWER;
    static const int MSG_EWMPOLICY_TDSCDMA;
    static const int MSG_EWMPOLICY_WCDMA;
    static const int MSG_ECSRA;
    static const int MSG_SWITCH_RAT_DONE;
    static const int MSG_NR_READ_POWER;

    static const std::string KEY_GSM_ATCMD;
    static const std::string KEY_TDSCDMA_ATCMD;
    static const std::string KEY_WCDMA_ATCMD;
    static const std::string KEY_LTE_FDD_ATCMD;
    static const std::string KEY_LTE_TDD_ATCMD;
    static const std::string KEY_CDMA_1X_ATCMD;
    static const std::string KEY_CDMA_EVDO_ATCMD;
    static const std::string KEY_TEST_DURATION;
    static const std::string KEY_TEST_COUNT;
    static const std::string KEY_CHECK_LIMIT;
    static const std::string KEY_READBACK_INTREVAL;

    static const std::string DEFAULT_GSM_ATCMD;
    static const std::string DEFAULT_TDSCDMA_ATCMD;
    static const std::string DEFAULT_WCDMA_ATCMD;
    static const std::string DEFAULT_LTE_FDD_ATCMD;
    static const std::string DEFAULT_LTE_TDD_ATCMD;
    static const std::string DEFAULT_NR_ATCMD;
    static const std::string DEFAULT_CDMA_EVDO_ATCMD;
    static const std::string DEFAULT_CDMA_1X_ATCMD;
    static const std::string DEFAULT_CDMA_EVDO_ATCMD_93before;
    static const std::vector<std::string> mRatName;
    static std::vector<std::string> mRatCmdStart;
    static std::vector<std::string> mRatCmdStop;
    static std::vector<std::string> mRatCmdSwitch;
    static std::vector<std::string> mRatCmdPowerRead;
    static std::vector<std::string> mRatBand;
    static std::vector<std::string> mRatPowerSet;
    static std::vector<bool> mRatCheck;
    static std::vector<bool> mSendState;
    static long mTestDuration;
    static long mTestCount;
    static long mTestDurationSended;
    static long mTestCountSended;
    static long mCheckLimit;
    static long mReadbackInterval;
    std::vector<std::shared_ptr<RfDesenseRatInfo>> mRatList;
    std::shared_ptr<RfDesenseRatInfo> mCurrectRatInfo;

    const int MSG_QUERY = 0;
    const int MSG_SET = 1;
    int mCurrentFlag = 0;
    std::vector<std::string> mCurrentSettingsValues;

    static int INDEX_GSM;
    static int INDEX_TDSCDMA;
    static int INDEX_WCDMA;
    static int INDEX_LTE_FDD;
    static int INDEX_LTE_TDD;
    static int INDEX_NR;
    static int INDEX_CDMA_EVDO;
    static int INDEX_CDMA_1X;

    static constexpr int INDEX_GSM_SUB_BAND = 0;
    static constexpr int INDEX_GSM_SUB_CHANNEL = 1;
    static constexpr int INDEX_GSM_SUB_POWER = 2;
    static constexpr int INDEX_GSM_SUB_AFC = 3;
    static constexpr int INDEX_GSM_SUB_TSC = 4 ;
    static constexpr int INDEX_GSM_SUB_PATTERN = 5;

    static constexpr int INDEX_3G_SUB_BAND = 0;
    static constexpr int INDEX_3G_SUB_CHANNEL = 1;
    static constexpr int INDEX_3G_SUB_POWER = 2;

    static constexpr int INDEX_CDMA_SUB_BAND = 0;
    static constexpr int INDEX_CDMA_SUB_MODULATION = 1;
    static constexpr int INDEX_CDMA_SUB_CHANNEL = 2;
    static constexpr int INDEX_CDMA_SUB_POWER = 3;

    static constexpr int INDEX_FDD_SUB_MODE = 0;
    static constexpr int INDEX_FDD_SUB_BAND = 1;
    static constexpr int INDEX_FDD_SUB_BANDWITH = 2;
    static constexpr int INDEX_FDD_SUB_FREQ = 3;
    static constexpr int INDEX_FDD_SUB_START = 4;
    static constexpr int INDEX_FDD_SUB_LENGTH = 5;
    static constexpr int INDEX_FDD_SUB_MCS = 6;
    static constexpr int INDEX_FDD_SUB_POWER = 7;

    static constexpr int INDEX_TDD_SUB_MODE = 0;
    static constexpr int INDEX_TDD_SUB_BAND = 1;
    static constexpr int INDEX_TDD_SUB_BANDWIDTH = 2;
    static constexpr int INDEX_TDD_SUB_FREQ = 3;
    static constexpr int INDEX_TDD_SUB_CONFIG = 4;
    static constexpr int INDEX_TDD_SUB_SPECIAL = 5;
    static constexpr int INDEX_TDD_SUB_START = 6;
    static constexpr int INDEX_TDD_SUB_LENGTH = 7;
    static constexpr int INDEX_TDD_SUB_MCS = 8;
    static constexpr int INDEX_TDD_SUB_POWER = 9;

    static constexpr int INDEX_NR_SUB_MODE = 0;
    static constexpr int INDEX_NR_SUB_BAND = 1;
    static constexpr int INDEX_NR_SUB_BANDWIDTH = 2;
    static constexpr int INDEX_NR_SUB_FREQ = 3;
    static constexpr int INDEX_NR_SUB_START = 4;
    static constexpr int INDEX_NR_SUB_LENGTH = 5;
    static constexpr int INDEX_NR_SUB_MCS = 6;
    static constexpr int INDEX_NR_SUB_SCS = 7;
    static constexpr int INDEX_NR_SUB_POWER = 8;
    static constexpr int INDEX_NR_SUB_CONFIG = 9;

    class RequestHandleThread: public Thread {
    public:
        RequestHandleThread(RfDesenseTxTest* tx);
        virtual ~RequestHandleThread();
        sp<Looper> getLooper();

    protected:
        RfDesenseTxTest* mTx;
        virtual bool threadLoop();
    private:
        sp<Looper> m_looper;
    };

    class RfRequestMessage: public RefBase {
    public:
        RfRequestMessage(RfDesenseTxTest* tx);
        virtual ~RfRequestMessage();
        void sendMessage(int delayms);
    public:
        int mMsgType;
        string response;
        int responselen;
        int slot;
        RIL_Errno e;
    private:
        RfDesenseTxTest* mTx;
    };

    class RfRequestHandler: public MessageHandler {
    public:
        RfRequestHandler(RfDesenseTxTest* tx): mTx(tx){}
        virtual ~RfRequestHandler();

    public:
        void sendMessage(sp<RfRequestMessage> msg, int delayms);
        void handleMessage(const Message& message);
        sp<RfRequestMessage> mMsg;
        // dummy message that makes handler happy
        Message m_dummyMsg;
    private:
        RfDesenseTxTest* mTx;
    };

public:
    void emRfDesenseAtCmdHandle(sp<RfRequestMessage> msg);
    sp<RequestHandleThread> mRequestHandleThread;
    sp<RfRequestHandler> mRfRequestHandler;
    // send message to request handler
    sp<RfRequestHandler> sendMessage(sp<RfRequestMessage> msg, int delayms);
    void handle_request(string response,int responselen,int slot, RIL_Errno e);

private:
    std::shared_ptr<RfDesenseRatInfo> getCurrectRatInfo();
    void update_rat();
    void tx_stop();
    void turnOffRf();
    void turnOnRf();
    void emRfDesenseThread(int id);
    void rf_send_at_cmd(std::string cmd, int flag);
    void save(int index);
    void txTestStop(int what);
    static RfDesenseTxTest* m_instance;
    static std::mutex mMutex;
    static bool trm_flag;
    std::condition_variable m_condVar;
    bool m_rawUrc = false;
    void initRatList();
    void handle_gsm_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_tdscdma_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_wcdma_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_lte_fdd_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_lte_tdd_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_nr_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_cdma_evdo_para(const std::string& name, int last_pos,const std::string& sub_name);
    void handle_cdma_1X_para(const std::string& name, int last_pos,const std::string& sub_name);
    bool handle_show_default(const std::string& standard);
    bool handle_para(int len, int classid, int propertyid, int operatorid,const std::string& standard, int* item);
    bool handle_start(const std::string& standard);
    void parse_read_power(std::string response);
    char* msg_type_to_str(int msgType);

    static int mState;
    static std::string str_msg;
    static int phone_id;
    bool mIsModemEnabled = true;
    bool mIsModemNotEnabled = true;
private:
    void init();
    void deInit();
};

#endif /* RFDESENSETXTEST_H_ */
