#!/bin/bash
#Copyright (c) [Year], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <command> <fileid> <path> <p1> <p2> <p3> <data> <pin2> <aidPtr>"
    echo "int command;    /* one of the commands listed for TS 27.007 +CRSM*/"
    echo "int fileid;     /* EF id */"
    echo "char *path;     /* "pathid" from TS 27.007 +CRSM command.Path is in hex asciii format eg "7f205f70" Path must always be provided.*/"
    echo "int p1;"
    echo "int p2;"
    echo "int p3;"
    echo "char *data;     /* May be NULL*/"
    echo "char *pin2;     /* May be NULL*/"
    echo "char *aidPtr;   /* AID value, See ETSI 102.221 8.1 and 101.220 4, NULL if no value. */"
    echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}
is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}


if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" != 9 ]
then
    fail_tip
    exit 0
fi

for var in "$1" "$2" "$4" "$5" "$6"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

echo -E " Request SIM I/O operation: $1 $2 $3 $4 $5 $6 $7 $8 $9"

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SIM_IO $1 $2 $3 $4 $5 $6 $7 $8 $9" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
