#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <retry> <MessageRef: Last Server Return Result> <ReceiverNum> <MessageStr>"
    echo "unsigned char  retry; /* 0 == not retry, nonzero == retry */"
    echo "int            messageRef;  /* Valid field if retry is set to nonzero.Contains messageRef from RIL_SMS_Response corresponding to failed MO SMS. */"
    echo "ReceiverNum  receive number"
    echo "MessageStr  send content"
    echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}

is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}


if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" != 4 ]
then
    fail_tip
    exit 0
fi

for var in "$1" "$2"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

retry=$1
MessageRef=$2
ReceiverNum=$3
MessageStr=$4

echo "Send a SMS message over IMS"
echo -E "Send message ${MessageStr} to Receiver Number ${ReceiverNum} with MessageRef ${MessageRef} Retry Number is ${retry}."

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_IMS_SEND_SMS_CDMA $retry $MessageRef $ReceiverNum \"$MessageStr\"" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
