/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <string>
#include <vector>

#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_C2KMODEMSETTING"
const int TIME_REG = 0;

const static int MSG_SET_DISABLE_1X_TIME = 1;
const static int MSG_SET_ENABLE_1X_TIME = 2;
const static int MSG_QUERY_STATUS_1X_TIME = 3;

int c2kmodemsetting_id = -1;
//int c2kmodemsetting_option_cnt = -1;
int c2kmodemsetting_option[8] = { 0 };

int mCurrentC2KEmmodemSettingFlag = -1;
static void sendATCommand(const char *cmd, int msg) {
    mCurrentC2KEmmodemSettingFlag = msg;
    emSendATCommand(cmd,Radio_capability_switch_util::get_main_capability_phone_id());
    return;
}

static void set1XTime(int command, int msg) {
    std::vector<std::string> cmdOri(3);
    cmdOri[0] = "AT+ECREGTYPE=0," + std::to_string((command == 1 ? 1 : 0));
    cmdOri[1] = "";
    cmdOri[2] = "DESTRILD:C2K";
    std::vector<std::string> cmds = getCdmaCmdArr(cmdOri);
    std::string cmd;
    for (auto s : cmds) {
        cmd += s;
    }
    RLOGD("set1XTime AT command: %s", cmd);
    sendATCommand(cmd.c_str(), msg);
}

static void emC2kModemSetingsAtCmdHandle(char*response, int responselen) {
    switch (mCurrentC2KEmmodemSettingFlag) {
    case MSG_SET_DISABLE_1X_TIME: {
        if ((responselen > 0) && (response != NULL)) {
            RLOGD("Disable_Time_REG successful");
            emResultNotifyWithDone("Disable_Time_REG successful");
        } else {
            RLOGD("Disable_Time_REG failed.");
            emResultNotifyWithDone("Disable_Time_REG failed.");
        }
        break;
    }
    case MSG_SET_ENABLE_1X_TIME: {
        if ((responselen > 0) && (response != NULL)) {
            RLOGD("Enable_Time_REG successful.");
            emResultNotifyWithDone("Enable_Time_REG successful.");
        } else {
            RLOGD("Enable_Time_REG failed.");
            emResultNotifyWithDone("Enable_Time_REG failed.");
        }
        break;
    }
    case MSG_QUERY_STATUS_1X_TIME:
        break;
    default:
        break;
    }
}

static void * emC2kModemSettingThread(void* arg) {
    RLOGD("c2k Modem Setting: %d ", c2kmodemsetting_option[0]);
    switch (c2kmodemsetting_id) {
    case TIME_REG: {
        set1XTime(c2kmodemsetting_option[0],
                (c2kmodemsetting_option[0] ?
                        MSG_SET_ENABLE_1X_TIME : MSG_SET_DISABLE_1X_TIME));
        break;
    }
    default:
        break;
    }
    pthread_exit(0);
}

int emC2kModemSettingStart(int argc, int multicnt, int *item) {
    RLOGD("emC2kModemSettingStart called");
    int idmapping[1] = { TIME_REG };
    c2kmodemsetting_id = idmapping[item[0]];
    c2kmodemsetting_option[0] = item[1];
    android::registerForATcmdResponse(emC2kModemSetingsAtCmdHandle);
    pthread_t emC2kModemSetting_thread;
    pthread_create(&emC2kModemSetting_thread, NULL, emC2kModemSettingThread,
            NULL);
    return 0;
}
#endif /*EM_MODE_SUPPORT*/

