 /*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "CdmaSmsCbProgramData.h"

CdmaSmsCbProgramData::CdmaSmsCbProgramData(int operation, int category,
    int language, int maxMessages, int alertOption, std::string categoryName) {
  mOperation = operation;
  mCategory = category;
  mLanguage = language;
  mMaxMessages = maxMessages;
  mAlertOption = alertOption;
  mCategoryName = categoryName;
}

CdmaSmsCbProgramData::~CdmaSmsCbProgramData() {
  // TODO Auto-generated destructor stub
}

/**
 * Returns the service category operation, e.g. {@link #OPERATION_ADD_CATEGORY}.
 * @return one of the {@code OPERATION_*} values
 */
int CdmaSmsCbProgramData::getOperation() {
  return mOperation;
}

/**
 * Returns the CDMA service category to modify.
 * @return a 16-bit CDMA service category value
 */
int CdmaSmsCbProgramData::getCategory() {
  return mCategory;
}

/**
 * Returns the CDMA language code for this service category.
 * @return one of the language values defined in BearerData.LANGUAGE_*
 */
int CdmaSmsCbProgramData::getLanguage() {
  return mLanguage;
}

/**
 * Returns the maximum number of messages to store for this service category.
 * @return the maximum number of messages to store for this service category
 */
int CdmaSmsCbProgramData::getMaxMessages() {
  return mMaxMessages;
}

/**
 * Returns the service category alert option, e.g. {@link #ALERT_OPTION_DEFAULT_ALERT}.
 * @return one of the {@code ALERT_OPTION_*} values
 */
int CdmaSmsCbProgramData::getAlertOption() {
  return mAlertOption;
}

/**
 * Returns the service category name, in the language specified by {@link #getLanguage()}.
 * @return an optional service category name
 */
std::string CdmaSmsCbProgramData::getCategoryName() {
  return mCategoryName;
}

std::string CdmaSmsCbProgramData::toString() {
  return "CdmaSmsCbProgramData{operation=" + std::to_string(mOperation)
      + ", category=" + std::to_string(mCategory) + ", language="
      + std::to_string(mLanguage) + ", max messages="
      + std::to_string(mMaxMessages) + ", alert option="
      + std::to_string(mAlertOption) + ", category name=" + mCategoryName + "}";
}

/**
 * Describe the kinds of special objects contained in the marshalled representation.
 * @return a bitmask indicating this Parcelable contains no special objects
 */
int CdmaSmsCbProgramData::describeContents() {
  return 0;
}
