//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "rfdesense/RfDesenseTxTest.h"

#include <memory>
#include <list>
#include <regex>
#include <cmath>
#include <string>
#include <cstdarg>
#include <cstring>

#include <vendor-ril/telephony/ril.h>

#include  "common.h"
#include "em.h"
#include "rfdesense/RfDesenseTxTestCdma.h"
#include "rfdesense/RfDesenseTxTestGsm.h"
#include "rfdesense/RfDesenseTxTestLte.h"
#include "rfdesense/RfDesenseTxTestTd.h"
#include "rfdesense/RfDesenseTxTestNr.h"
#include "util/log_extra.h"
#include "util/utils.h"

#undef LOG_TAG
#define LOG_TAG "EM_RfDesenseTxTest"

RfDesenseTxTest* RfDesenseTxTest::m_instance = NULL;
std::mutex RfDesenseTxTest::mMutex;

const int RfDesenseTxTest::STATE_NONE = 0;
const int RfDesenseTxTest::STATE_STARTED = 1;
const int RfDesenseTxTest::STATE_STOPPED = 2;

const int RfDesenseTxTest::MSG_START_TX = 1;
const int RfDesenseTxTest::MSG_CONTINUE_TX = 2;
const int RfDesenseTxTest::MSG_NEXT_RAT = 4;
const int RfDesenseTxTest::MSG_READ_POWER = 10;
const int RfDesenseTxTest::MSG_EWMPOLICY_TDSCDMA = 12;
const int RfDesenseTxTest::MSG_EWMPOLICY_WCDMA = 13;
const int RfDesenseTxTest::MSG_ECSRA = 14;
const int RfDesenseTxTest::MSG_SWITCH_RAT_DONE = 15;
const int RfDesenseTxTest::MSG_NR_READ_POWER = 20;

int RfDesenseTxTest::INDEX_GSM = -1;
int RfDesenseTxTest::INDEX_TDSCDMA = -1;
int RfDesenseTxTest::INDEX_WCDMA = -1;
int RfDesenseTxTest::INDEX_LTE_FDD = -1;
int RfDesenseTxTest::INDEX_LTE_TDD = -1;
int RfDesenseTxTest::INDEX_NR = -1;
int RfDesenseTxTest::INDEX_CDMA_EVDO = -1;
int RfDesenseTxTest::INDEX_CDMA_1X = -1;

int RfDesenseTxTest::mState = STATE_NONE;

long RfDesenseTxTest::mTestDuration = 10;
long RfDesenseTxTest::mTestCount = 1;
long RfDesenseTxTest::mTestDurationSended = 0;
long RfDesenseTxTest::mTestCountSended = 0;
long RfDesenseTxTest::mCheckLimit = 2;
long RfDesenseTxTest::mReadbackInterval = 5;

const static std::string CMD_SAME_EGMC = "+EGMC:";

const std::string RfDesenseTxTest::KEY_GSM_ATCMD = "gsm_at_cmd";
const std::string RfDesenseTxTest::KEY_TDSCDMA_ATCMD = "tdscdma_at_cmd";
const std::string RfDesenseTxTest::KEY_WCDMA_ATCMD = "wcdma_at_cmd";
const std::string RfDesenseTxTest::KEY_LTE_FDD_ATCMD = "lte_fdd_at_cmd";
const std::string RfDesenseTxTest::KEY_LTE_TDD_ATCMD = "lte_tdd_at_cmd";
const std::string RfDesenseTxTest::KEY_CDMA_1X_ATCMD = "cdma_at_cmd";
const std::string RfDesenseTxTest::KEY_CDMA_EVDO_ATCMD = "cdma_evdo_at_cmd";
const std::string RfDesenseTxTest::KEY_TEST_DURATION = "test_duration";
const std::string RfDesenseTxTest::KEY_TEST_COUNT = "test_count";
const std::string RfDesenseTxTest::KEY_CHECK_LIMIT = "check_limit";
const std::string RfDesenseTxTest::KEY_READBACK_INTREVAL = "readback_interval";

const std::string RfDesenseTxTest::DEFAULT_GSM_ATCMD = "AT+ERFTX=2,1,190,4100,128,0,5,0";
const std::string RfDesenseTxTest::DEFAULT_TDSCDMA_ATCMD = "AT+ERFTX=0,0,1,10087,24";
const std::string RfDesenseTxTest::DEFAULT_WCDMA_ATCMD = "AT+ERFTX=0,0,1,9750,23";
const std::string RfDesenseTxTest::DEFAULT_LTE_FDD_ATCMD = "AT+ERFTX=6,0,1,3,3,17475,1,0,0,0,1,0,23";
const std::string RfDesenseTxTest::DEFAULT_LTE_TDD_ATCMD = "AT+ERFTX=6,0,1,38,3,25950,0,0,0,0,1,0,23";
const std::string RfDesenseTxTest::DEFAULT_NR_ATCMD = "AT+EGMC=1,\"NrForcedTx\",2,1,1950000,23";
const std::string RfDesenseTxTest::DEFAULT_CDMA_EVDO_ATCMD = "AT+ERFTX=13,4,384,0,83";
const std::string RfDesenseTxTest::DEFAULT_CDMA_1X_ATCMD = "AT+ECRFTX=1,384,0,83,0";

const std::string RfDesenseTxTest::DEFAULT_CDMA_EVDO_ATCMD_93before =
            "AT+ERFTX=1,384,0,83,1";

const std::vector<std::string> RfDesenseTxTest::mRatName = {
            "GSM"
#ifndef TARGET_PLATFORM_MT2735
            , "TDSCDMA"
#endif
            , "WCDMA"
            , "LTE(FDD)", "LTE(TDD)"
#ifdef TARGET_PLATFORM_MT2735
            , "NR"
#endif
#ifdef C2K_SUPPORT
            ,"CDMA(EVDO)", "CDMA(1X)"
#endif
            };
std::vector<std::string> RfDesenseTxTest::mRatCmdStart = {
            DEFAULT_GSM_ATCMD
#ifndef TARGET_PLATFORM_MT2735
            , DEFAULT_TDSCDMA_ATCMD
#endif
            , DEFAULT_WCDMA_ATCMD
            , DEFAULT_LTE_FDD_ATCMD, DEFAULT_LTE_TDD_ATCMD
#ifdef TARGET_PLATFORM_MT2735
            , DEFAULT_NR_ATCMD
#endif
#ifdef C2K_SUPPORT
            , DEFAULT_CDMA_EVDO_ATCMD, DEFAULT_CDMA_1X_ATCMD
#endif
            };

std::vector<std::string> RfDesenseTxTest::mRatCmdStop = {
            "AT+ERFTX=2,0"
#ifndef TARGET_PLATFORM_MT2735
            , "AT+ERFTX=0,1"
#endif
            , "AT+ERFTX=0,1"
            , "AT+ERFTX=6,0,0", "AT+ERFTX=6,0,0"
#ifdef TARGET_PLATFORM_MT2735
            , "AT+EGMC=1,\"NrForcedTx\",0"
#endif
#ifdef C2K_SUPPORT
            ,"AT+ERFTX=13,5", "AT+ECRFTX=0"
#endif
            };

 std::vector<std::string> RfDesenseTxTest::mRatCmdSwitch = {
            "AT+ERAT=0"
#ifndef TARGET_PLATFORM_MT2735
            , "AT+ERAT=1"
#endif
            , "AT+ERAT=1"
            , "AT+ERAT=6,4", "AT+ERAT=6,4"
#ifdef TARGET_PLATFORM_MT2735
            , "AT+ERAT=22,128"
#endif
#ifdef C2K_SUPPORT
            , "AT+ERAT=7,64", "AT+ERAT=7,32"
#endif
            };

std::vector<std::string> RfDesenseTxTest::mRatCmdPowerRead = {
            ""
#ifndef TARGET_PLATFORM_MT2735
            , "AT+ERFTX=0,3"
#endif
            , "AT+ERFTX=0,3"
            , "AT+ERFTX=6,1", "AT+ERFTX=6,1"
#ifdef TARGET_PLATFORM_MT2735
            , "AT+EGMC=0,\"NrFetchTxPwr\""
#endif
#ifdef C2K_SUPPORT
            , "AT+ERFTX=13,3", "AT+ERFTX=13,3"
#endif
            };

std::vector<std::string> RfDesenseTxTest::mRatBand = {
            "19"
#ifndef TARGET_PLATFORM_MT2735
            , "1"
#endif
            , "1"
            , "3", "38"
#ifdef TARGET_PLATFORM_MT2735
            , "1"
#endif
#ifdef C2K_SUPPORT
            , "0", "0"
#endif
            };

std::vector<std::string> RfDesenseTxTest::mRatPowerSet = {
            "19"
#ifndef TARGET_PLATFORM_MT2735
            , "10"
#endif
            , "24"
            , "23", "23"
#ifdef TARGET_PLATFORM_MT2735
            , "23"
#endif
#ifdef C2K_SUPPORT
            , "23", "23"
#endif
            };

std::vector<bool> RfDesenseTxTest::mRatCheck = {false, false, false, false, false, false, false, false};
std::vector<bool> RfDesenseTxTest::mSendState = {false, false, false, false, false, false, false, false};
std::string RfDesenseTxTest::str_msg = "";
bool RfDesenseTxTest::trm_flag = false;
int RfDesenseTxTest::phone_id = 0;

void RfDesenseTxTest::rf_send_at_cmd(std::string cmd, int flag){
    mCurrentFlag = flag;
    emSendATCommand(cmd.c_str(),phone_id);
}

//create thread to send command
void RfDesenseTxTest::emRfDesenseThread(int id) {
    mState = STATE_STARTED;
    int operatorid = id;
    LOG_D(LOG_TAG, "emRfDesenseThread: operatorid(%d)", operatorid);
    switch (operatorid) {
        case 0:{
            if (trm_flag) {
                LOG_D(LOG_TAG, "wait modem reset done");
                std::this_thread::sleep_for(std::chrono::milliseconds(1000*5));
                trm_flag = false;
            }
            if(isRadioOn((RIL_SOCKET_ID)phone_id)) {
                LOG_D(LOG_TAG, "radio already on");
                mIsModemEnabled = false;
                emRadioStateOn();
            } else {
                while(!isRadioOn((RIL_SOCKET_ID)phone_id)) {
                    LOG_D(LOG_TAG, "radio isn't on");
                    std::this_thread::sleep_for(std::chrono::milliseconds(200));
                    turnOnRf();
                }
                //turnOnRf();
                LOG_D(LOG_TAG, "radio on again");
                registerRadioOn(m_instance);
                mIsModemEnabled = false;
            }
            break;
        }
    }
}

void RfDesenseTxTest::emRadioStateOn(){
    if (mIsModemEnabled == true) {
        LOG_D(LOG_TAG, "mIsModemEnabled is true, just return");
        return;
    }
    mIsModemEnabled = true;
    LOG_D(LOG_TAG, "turn on rf succeed");
    if (mState == STATE_STARTED) {
        mCurrectRatInfo = getCurrectRatInfo();
        if (mCurrectRatInfo
                && !mCurrectRatInfo->getRatCmdSwitch().empty()) {
            LOG_D(LOG_TAG, "switch rat(%s)",mCurrectRatInfo->getRatCmdSwitch().c_str());
            //unregisterRadioOn();
            rf_send_at_cmd(mCurrectRatInfo->getRatCmdSwitch(), MSG_SWITCH_RAT_DONE);
        } else {
            LOG_D(LOG_TAG, "mCurrectRatInfo == null");
        }
    }
}

void RfDesenseTxTest::emRadioStateOfforNotAvailable() {
    //unregisterRadioOffOrNotAvailable();
    if (mIsModemNotEnabled == true) {
        LOG_D(LOG_TAG, "mIsModemNotEnabled is true, just return");
        return;
    }
    mIsModemNotEnabled = true;
    LOG_D(LOG_TAG, "turn off rf succeed...");
    if (mCurrectRatInfo) {
        mCurrectRatInfo->setRatSendState(true);
        rf_send_at_cmd(mCurrectRatInfo->getRatCmdStart(), MSG_START_TX);
        LOG_D(LOG_TAG, "send:Ratname=%s, RatCmd=%s",mCurrectRatInfo->getRatName().c_str() ,mCurrectRatInfo->getRatCmdStart().c_str());
    } else {
        LOG_D(LOG_TAG, "mCurrectRatInfo == null");
    }
}

void RfDesenseTxTest::emOemHookRaw(int value, int slot_id){
    if(slot_id != phone_id) {
        LOG_W(LOG_TAG, "slot_id = %d, main_slot: %d", slot_id, phone_id);
        //return;
    }
    LOG_D(LOG_TAG, "Readback tx power = %d", value);
    std::string result = "";
    std::string rat = "";
    std::lock_guard<std::mutex> guard(mMutex);
    m_rawUrc = true;
    m_condVar.notify_one();
    float getPower = value / 8.0f;
    if (std::abs(std::stoi(mCurrectRatInfo->getRatPowerSet()) -
            getPower) > mCheckLimit) {
        result = "failed\n";
    } else {
        result = "succeed\n";
    }

    std::string s = std::string("Start TX:\n")
            + std::string("Rat(band)          ") + std::string("Power_Set   ")
            + std::string("Power_Get    ") + std::string("Result\n");
    rat = utils::format("%-20s %-15s %-10s",
            (mCurrectRatInfo->getRatName()+ "(b" + mCurrectRatInfo->getRatband() + ")").c_str(),
            mCurrectRatInfo->getRatPowerSet().c_str(),
            std::to_string(getPower).c_str()
    );
    std::string ret;
    if (!result.compare("failed\n")) {
        ret = utils::format("%10s", result.c_str());
    } else {
        ret = utils::format("%10s", result.c_str());
    }
    str_msg += s + rat + ret;

}

void RfDesenseTxTest::tx_stop() {
    LOG_D(LOG_TAG,"tx_stop");
    std::unique_lock<std::mutex> mlock(mMutex);
    m_condVar.wait(mlock,[this]{return m_rawUrc;});
    txTestStop(MSG_NEXT_RAT);
}

void RfDesenseTxTest::init() {
    mRequestHandleThread = new RequestHandleThread(this);
    mRequestHandleThread->run();
}

RfDesenseTxTest::RfDesenseTxTest() {
    initRatList();
}

RfDesenseTxTest::~RfDesenseTxTest() {
    LOG_D(LOG_TAG, "RfDesenseTxTest destroyed");
}

void RfDesenseTxTest::txTestStop(int what) {
    if (mCurrectRatInfo) {
        rf_send_at_cmd(mCurrectRatInfo->getRatCmdStop(), what);
        LOG_D(LOG_TAG, "stop: %s %s", mCurrectRatInfo->getRatName().c_str(), mCurrectRatInfo->getRatCmdStop().c_str());
    } else {
        LOG_D(LOG_TAG, "mCurrectRatInfo is null");
        mState = STATE_STOPPED;
        for (int i = 0; i < mRatList.size(); i++) {
            mRatList[i]->setRatSendState(false);
            mRatList[i]->setRatCheckState(false);
        }
    }
}

void RfDesenseTxTest::deInit() {

}

RfDesenseTxTest* RfDesenseTxTest::getInstance() {
    if(!m_instance) {
        mMutex.lock();
        if(!m_instance) {
            m_instance = new RfDesenseTxTest();
            m_instance->init();
        }
        mMutex.unlock();
    }
    return m_instance;
}

// Method implements of RequestHandleThread
RfDesenseTxTest::RequestHandleThread::RequestHandleThread(RfDesenseTxTest* tx) : m_looper(NULL) {
    mTx = tx;
    LOG_D(LOG_TAG, "RequestHandleThread created");
}

RfDesenseTxTest::RequestHandleThread::~RequestHandleThread() {
    mTx = NULL;
    LOG_D(LOG_TAG, "RequestHandleThread destroyed");
}

bool RfDesenseTxTest::RequestHandleThread::threadLoop() {
    LOG_D(LOG_TAG, "RequestHandleThread threadLoop");
    // start message loop
    m_looper = Looper::prepare(0);
    int result;
    do {
        result = m_looper->pollAll(-1);
        LOG_D(LOG_TAG, "RequestHandleThread threadLoop, pull message result = %d", result);
    } while (result == Looper::POLL_WAKE || result == Looper::POLL_CALLBACK);
    return true;
}

sp<Looper> RfDesenseTxTest::RequestHandleThread::getLooper() {
    return m_looper;
}

RfDesenseTxTest::RfRequestMessage::RfRequestMessage(RfDesenseTxTest* tx) : mTx(tx),mMsgType(0),
        response(""),responselen(0), slot(0), e(RIL_E_SUCCESS) {
}

RfDesenseTxTest::RfRequestMessage::~RfRequestMessage() {
    LOG_D(LOG_TAG, "RequestHandleThread destroyed");
}

void RfDesenseTxTest::RfRequestMessage::sendMessage(int delayms) {
    LOG_D(LOG_TAG, "RfDesenseTxTest::RfRequestMessage, sendMessage delayms=%d", delayms);
    if(mTx != NULL) {
        mTx->sendMessage(this, delayms);
    } else {
        LOG_D(LOG_TAG, "RfDesenseTxTest::RfRequestHandler mTx is null");
    }
}

void RfDesenseTxTest::RfRequestHandler::sendMessage(sp<RfRequestMessage> msg, int delayms) {
    LOG_D(LOG_TAG, "RfDesenseTxTest::RfRequestHandler, sendMessage msg what=%d delayms=%d", msg->mMsgType, delayms);
    this->mMsg = msg;
    if(mTx != NULL) {
        mTx->sendMessage(mMsg, delayms);
    } else {
        LOG_D(LOG_TAG, "RfDesenseTxTest::RfRequestHandler mTx is null");
    }
}

RfDesenseTxTest::RfRequestHandler:: ~RfRequestHandler() {
    mTx = NULL;
    LOG_D(LOG_TAG, "RfRequestHandler destroyed");
}

void RfDesenseTxTest::handle_request(string response,int responselen,int slot, RIL_Errno e) {
    sp<RfRequestMessage> msg = new RfRequestMessage(this);
    msg->mMsgType = mCurrentFlag;
    msg->response = response;
    msg->responselen = responselen;
    msg->slot = slot;
    msg->e = e;
    if(mCurrentFlag == MSG_READ_POWER) {
        sendMessage(msg, 2*1000);
    } else {
        sendMessage(msg, 1000);
    }
}

sp<RfDesenseTxTest::RfRequestHandler> RfDesenseTxTest::sendMessage(sp<RfRequestMessage> msg, int delayms) {
    LOG_D(LOG_TAG, "sendMessage msg token=%d delayms=%d", msg->mMsgType, delayms);
    sp<RfRequestHandler> handler = new RfRequestHandler(this);
    handler->mMsg = msg;
    if(mRequestHandleThread.get()) {
        sp<Looper> looper = mRequestHandleThread->getLooper();
        if(looper.get()) {
            if (delayms > 0) {
                looper->sendMessageDelayed(ms2ns(delayms),handler, handler->m_dummyMsg);
            } else {
                looper->sendMessage(handler, handler->m_dummyMsg);
            }
        } else {
            LOG_D(LOG_TAG, "looper fail");
        }
    } else {
        LOG_D(LOG_TAG, "mRequestHandleThread fail");
    }

    return handler;
}

char* RfDesenseTxTest::msg_type_to_str(int msgType) {
    switch (msgType) {
        case MSG_START_TX:
            return "MSG_START_TX";
        case MSG_CONTINUE_TX:
            return "MSG_CONTINUE_TX";
        case MSG_NEXT_RAT:
            return "MSG_NEXT_RAT";
        case MSG_READ_POWER:
            return "MSG_READ_POWER";
        case MSG_EWMPOLICY_TDSCDMA:
            return "MSG_EWMPOLICY_TDSCDMA";
        case MSG_EWMPOLICY_WCDMA:
            return "MSG_EWMPOLICY_WCDMA";
        case MSG_ECSRA:
            return "MSG_ECSRA";
        case MSG_SWITCH_RAT_DONE:
            return "MSG_SWITCH_RAT_DONE";
        case MSG_NR_READ_POWER:
            return "MSG_NR_READ_POWER";
        default:
            return "unknown type";
    }
}

void RfDesenseTxTest::emRfDesenseAtCmdHandle(sp<RfRequestMessage> msg){
    LOG_D(LOG_TAG, "emRfDesenseAtCmdHandle(), %s", msg_type_to_str(msg->mMsgType));
    int responselen = msg->responselen;
    std::string response = msg->response;
    switch (msg->mMsgType) {
    case MSG_SWITCH_RAT_DONE: {
        if (msg->e == RIL_E_SUCCESS) {
            LOG_D(LOG_TAG, "switch rat=%s succeed", mCurrectRatInfo->getRatName().c_str());
#ifndef TARGET_PLATFORM_MT2735
            if (mCurrectRatInfo->getRatName() == mRatName[INDEX_TDSCDMA]) { // tdscdma
                LOG_D(LOG_TAG, "end AT+EWMPOLICY=0");
                rf_send_at_cmd("AT+EWMPOLICY=0", MSG_EWMPOLICY_TDSCDMA);
            } else
#endif
            if (mCurrectRatInfo->getRatName() == mRatName[INDEX_WCDMA]) { // wcdma
                LOG_D(LOG_TAG,  "send AT+EWMPOLICY=0");
                rf_send_at_cmd("AT+EWMPOLICY=0", MSG_EWMPOLICY_WCDMA);
            } else { // other rat
                registerRadioOffOrNotAvailable(m_instance);
                turnOffRf();
            }

        } else {
            LOG_D(LOG_TAG, "switch rat failed");
            emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " switch rat failed\n");
        }
        break;
    }
    case MSG_EWMPOLICY_TDSCDMA: {
        LOG_D(LOG_TAG, "AT+EWMPOLICY=0 send succeed");
        LOG_D(LOG_TAG, "send AT+ECSRA=2,0,1,0,1,0 ...");
        rf_send_at_cmd("AT+ECSRA=2,0,1,0,1,0", MSG_ECSRA);
        break;
    }
    case MSG_EWMPOLICY_WCDMA: {
        LOG_D(LOG_TAG, "AT+EWMPOLICY=0 send succeed");
        LOG_D(LOG_TAG, "send AT+ECSRA=2,1,0,1,1,0 ...");
        rf_send_at_cmd("AT+ECSRA=2,1,0,1,1,0", MSG_ECSRA);
        break;
    }
    case MSG_ECSRA: {
        LOG_D(LOG_TAG, "AT+ECSRA send succeed");
        turnOffRf();
        break;
    }
    case MSG_START_TX:{
        if (msg->e == RIL_E_SUCCESS) {
            LOG_D(LOG_TAG, "start cmd ok");

            if (utils::is93ModemAndAbove() && mCurrectRatInfo && !mCurrectRatInfo->getRatCmdPowerRead().empty()) {
#ifdef TARGET_PLATFORM_MT2735
                // For NR, need send get power after 5s, 10s (2 times)
                if (mCurrectRatInfo->getRatName() == sub_tx_test[INDEX_NR].name) {
                    LOG_D(LOG_TAG, "For NR, wait and start read cmd");
                    sp<RfRequestMessage> nr_msg = new RfRequestMessage(this);
                    nr_msg->mMsgType = MSG_CONTINUE_TX;
                    nr_msg->response = msg->response;
                    nr_msg->responselen = msg->responselen;
                    nr_msg->slot = msg->slot;
                    nr_msg->e = RIL_E_SUCCESS;
                    sendMessage(nr_msg, 1000);

                } else {
#endif
                    LOG_D(LOG_TAG,"start read cmd: %s", mCurrectRatInfo->getRatCmdPowerRead().c_str());
                    rf_send_at_cmd(mCurrectRatInfo->getRatCmdPowerRead(), MSG_READ_POWER);
#ifdef TARGET_PLATFORM_MT2735
                }
#endif
            } else {
                LOG_D(LOG_TAG, "don't read");
                txTestStop(MSG_NEXT_RAT);
            }
        } else {
            LOG_D(LOG_TAG, "start cmd failed");
            emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " start cmd failed\n");
        }
        break;
    }

    case MSG_CONTINUE_TX:{
        mTestDurationSended += mReadbackInterval;
        if (mTestDurationSended >= mTestDuration) {
            LOG_D(LOG_TAG, "read tx power succeed");
            txTestStop(MSG_NEXT_RAT);
            mTestDurationSended = 0;

        } else {
            LOG_D(LOG_TAG, "Wait again for mTestDurationSended=%d < %d", mTestDurationSended, mTestDuration);
            sp<RfRequestMessage> nr_msg = new RfRequestMessage(this);
            nr_msg->mMsgType = MSG_CONTINUE_TX;
            nr_msg->response = msg->response;
            nr_msg->responselen = msg->responselen;
            nr_msg->slot = msg->slot;
            nr_msg->e = msg->e;
            sendMessage(msg, mReadbackInterval*1000);

            if (utils::is93ModemAndAbove() && mCurrectRatInfo && !mCurrectRatInfo->getRatCmdPowerRead().empty()) {
                LOG_D(LOG_TAG,"start read cmd: %s", mCurrectRatInfo->getRatCmdPowerRead().c_str());
                rf_send_at_cmd(mCurrectRatInfo->getRatCmdPowerRead(), MSG_NR_READ_POWER);
            } else {
                LOG_D(LOG_TAG,"start read cmd fail");
            }
        }
        break;
    }

    case MSG_NR_READ_POWER:{
        if ((msg->e == RIL_E_SUCCESS) && (responselen > 0)) {
            RLOGD("Get response %s", msg->response.c_str());
            parse_read_power(response);

        } else {
            LOG_D(LOG_TAG, "read tx power failed");
            emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " read tx power failed\n");
        }

        break;
    }

    case MSG_READ_POWER:{
        mTestDurationSended += mReadbackInterval;
        if (mTestDurationSended >= mTestDuration) {
            if (msg->e == RIL_E_SUCCESS) {
                LOG_D(LOG_TAG, "read tx power succeed");
                if(m_rawUrc){
                    txTestStop(MSG_NEXT_RAT);
                    m_rawUrc = false;
                } else {
                   std::thread thread_stop(&RfDesenseTxTest::tx_stop, m_instance);
                   thread_stop.detach();
                }
            } else {
                LOG_D(LOG_TAG, "read tx power failed");
                emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " read tx power failed\n");
            }
            mTestDurationSended = 0;
        } else {
            if (utils::is93ModemAndAbove() && mCurrectRatInfo && !mCurrectRatInfo->getRatCmdPowerRead().empty()) {
                LOG_D(LOG_TAG,"(sencond)start read cmd: %s", mCurrectRatInfo->getRatCmdPowerRead().c_str());
                rf_send_at_cmd(mCurrectRatInfo->getRatCmdPowerRead(), MSG_READ_POWER);
            } else {
                LOG_D(LOG_TAG,"(sencond)start read cmd fail");
            }
        }
        break;
    }
    case MSG_NEXT_RAT: {
        if (msg->e == RIL_E_SUCCESS) {
            std::string rat = mCurrectRatInfo->getRatName();
            LOG_D(LOG_TAG, "stop(%s) cmd ok", rat.c_str());
            mCurrectRatInfo = getCurrectRatInfo();
            if (mCurrectRatInfo) {
                LOG_D(LOG_TAG, "error, mCurrectRatInfo should null ");
            }
            emResultNotifyWithDone(str_msg + "send all rat done\n");
            str_msg = "";
            mState = STATE_STOPPED;
            for (int i = 0; i < mRatList.size(); i++) {
                mRatList[i]->setRatSendState(false);
                mRatList[i]->setRatCheckState(false);
            }
//            if(rat == mRatName[1] || rat == mRatName[2]) {
//                if(utils::is93ModemAndAbove()){
//                    utils::mtk_property_set("vendor.ril.mux.report.case", "2");
//                    utils::mtk_property_set("vendor.ril.muxreport", "1");
//                }else {
//                    emSendATCommand("AT+CFUN=1,1");
//                }
//                trm_flag = true;
//            } else {
//                turnOnRf();
//            }
            turnOnRf();
            trm_flag = true;
            unregister_response_oem_hook_raw();
            unregisterOnUnsolOemHookRaw();
        } else {
            LOG_D(LOG_TAG, "stop cmd failed");
            emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " stop cmd failed \n");
        }
        break;
    }
    default:
        break;
    }
}

void RfDesenseTxTest::RfRequestHandler::handleMessage(const Message& message) {
    LOG_D(LOG_TAG, "handleMessage msg->mMsgType: %d", mMsg->mMsgType);
    if(mTx != NULL) {
        mTx->emRfDesenseAtCmdHandle(mMsg);
    } else {
        LOG_D(LOG_TAG, "handleMessage mTx is null");
    }
}

void RfDesenseTxTest::parse_read_power(std::string response) {
    std::vector<std::string> out;
    utils::tokenize(response, "\n", out);
    std::string str;
    str.clear();

    for(auto i: out) {
        if(i.find(CMD_SAME_EGMC) != std::string::npos) {
            std::string splitString = i.substr(std::string(CMD_SAME_EGMC).size());
            std::vector<std::string> getDigitalVal;
            utils::tokenize(string(splitString), ",\n", getDigitalVal);
            RLOGD("parseCurrentMode splitString: %s, getDigitalVal.size()=%d",
                    splitString.c_str(), getDigitalVal.size());

            if (getDigitalVal.size() <= 0 || getDigitalVal.size() > 2) {
                LOG_D(LOG_TAG, "read tx power size failed");
                emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " read tx power failed\n");
                return ;
            }

            try {
                float getPower = std::stof(getDigitalVal[1]);
                LOG_D(LOG_TAG, "Readback tx power = %f", getPower);

                std::string result = "";
                std::string rat = "";

                if (std::abs(std::stoi(mCurrectRatInfo->getRatPowerSet()) - getPower) > mCheckLimit) {
                    result = "failed\n";
                } else {
                    result = "succeed\n";
                }

                std::string s = std::string("Start TX:\n")
                        + std::string("Rat(band)          ") + std::string("Power_Set   ")
                        + std::string("Power_Get    ") + std::string("Result\n");
                rat = utils::format("%-20s   %-15s   %-10s",
                        (mCurrectRatInfo->getRatName()+ "(b" + mCurrectRatInfo->getRatband() + ")").c_str(),
                        mCurrectRatInfo->getRatPowerSet().c_str(),
                        std::to_string(getPower).c_str()
                );

                std::string ret;
                if (!result.compare("failed\n")) {
                    ret = utils::format("%10s", result.c_str());
                } else {
                    ret = utils::format("%10s", result.c_str());
                }
                str_msg += s + rat + ret;

                RLOGD("%s", str_msg.c_str());

            } catch (const out_of_range &e) {
                emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " read tx power failed\n");
                RLOGD("out of range: %s", e.what());
                return;
            } catch (const invalid_argument &e) {
                emResultNotifyWithDone(mCurrectRatInfo->getRatName() + " read tx power failed\n");
                RLOGD("invalid argument: %s", e.what());
                return;
            }

        }
    }
}

void RfDesenseTxTest::handle_gsm_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestGsm> gsm =
            RfDesenseTxTestGsm::get_instance();
    if (name == rfdesense_gsm_sub[INDEX_GSM_SUB_BAND].name) {
        flag = gsm->set_band(last_pos);
    } else if (name == rfdesense_gsm_sub[INDEX_GSM_SUB_CHANNEL].name) {
        if (sub_name == set_get[0].name) {
            //get
            gsm->show_channel();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = gsm->set_channel(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_gsm_sub[INDEX_GSM_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            gsm->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = gsm->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_gsm_sub[INDEX_GSM_SUB_AFC].name) {
        if (sub_name == set_get[0].name) {
            //get
            gsm->show_afc();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = gsm->set_afc(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_gsm_sub[INDEX_GSM_SUB_TSC].name) {
        if (sub_name == set_get[0].name) {
            //get
            gsm->show_tsc();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = gsm->set_tsc(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_gsm_sub[INDEX_GSM_SUB_PATTERN].name) {
        flag = gsm->set_pattern(last_pos);
    }

    if (flag) {
        mRatList[INDEX_GSM]->setRatCmdStart(gsm->get_command());
        mRatList[INDEX_GSM]->setRatband(gsm->get_band());
        mRatList[INDEX_GSM]->setRatPowerSet(gsm->get_power());
        save(INDEX_GSM);
    }
}

void RfDesenseTxTest::handle_tdscdma_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    //"TDSCDMA"
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestTd> tdscdma = std::make_shared<
            RfDesenseTxTestTd>(utils::MODEM_TDSCDMA);
    if (name == rfdesense_tdscdma_sub[INDEX_3G_SUB_BAND].name) {
        flag = tdscdma->set_band(last_pos);
    } else if (name == rfdesense_tdscdma_sub[INDEX_3G_SUB_CHANNEL].name) {
        if (sub_name == set_get[0].name) {
            //get
            tdscdma->show_channel();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = tdscdma->set_channel(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_tdscdma_sub[INDEX_3G_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            tdscdma->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = tdscdma->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else {
        LOG_D(LOG_TAG, "logic error");
    }

    if (flag) {
        mRatList[INDEX_TDSCDMA]->setRatCmdStart(tdscdma->get_command());
        mRatList[INDEX_TDSCDMA]->setRatband(tdscdma->get_band());
        mRatList[INDEX_TDSCDMA]->setRatPowerSet(tdscdma->get_power());
        save(INDEX_TDSCDMA);
    }
}

void RfDesenseTxTest::handle_wcdma_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    //"WCDMA"
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestTd> wcdma = std::make_shared<
            RfDesenseTxTestTd>(utils::MODEM_WCDMA);
    if (name == rfdesense_wcdma_sub[INDEX_3G_SUB_BAND].name) {
        flag = wcdma->set_band(last_pos);
    } else if (name == rfdesense_wcdma_sub[INDEX_3G_SUB_CHANNEL].name) {
        if (sub_name == set_get[0].name) {
            //get
            wcdma->show_channel();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = wcdma->set_channel(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_wcdma_sub[INDEX_3G_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            wcdma->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = wcdma->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else {
        LOG_D(LOG_TAG, "logic error");
    }

    if (flag) {
        mRatList[INDEX_WCDMA]->setRatCmdStart(wcdma->get_command());
        mRatList[INDEX_WCDMA]->setRatband(wcdma->get_band());
        mRatList[INDEX_WCDMA]->setRatPowerSet(wcdma->get_power());
        save(INDEX_WCDMA);
    }
}

void RfDesenseTxTest::handle_lte_fdd_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    //LTE(FDD)
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestLte> fdd = std::make_shared<
            RfDesenseTxTestLte>(utils::MODEM_LTE_FDD);
    if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_MODE].name) {
        flag = fdd->set_mode(last_pos);
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_BAND].name) {
        flag = fdd->set_band(last_pos);
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_BANDWITH].name) {
        flag = fdd->set_bandwith(last_pos);
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_FREQ].name) {
        if (sub_name == set_get[0].name) {
            //get
            fdd->show_freq();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = fdd->set_freq(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_START].name) {
        if (sub_name == set_get[0].name) {
            //get
            fdd->show_start();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = fdd->set_start(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_LENGTH].name) {
        if (sub_name == set_get[0].name) {
            //get
            fdd->show_length();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = fdd->set_length(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_MCS].name) {
        flag = fdd->set_mcs(last_pos);
    } else if (name == rfdesense_fdd_sub[INDEX_FDD_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            fdd->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = fdd->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else {
        LOG_D(LOG_TAG, "error");
    }

    if (flag) {
        mRatList[INDEX_LTE_FDD]->setRatCmdStart(fdd->get_command());
        mRatList[INDEX_LTE_FDD]->setRatband(fdd->get_band());
        mRatList[INDEX_LTE_FDD]->setRatPowerSet(fdd->get_power());
        save(INDEX_LTE_FDD);
    }
}

void RfDesenseTxTest::handle_lte_tdd_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    //LTE(TDD)
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestLte> tdd = std::make_shared<
            RfDesenseTxTestLte>(utils::MODEM_LTE_TDD);
    if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_MODE].name) {
        flag = tdd->set_mode(last_pos);
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_BAND].name) {
        flag = tdd->set_band(last_pos);
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_BANDWIDTH].name) {
        flag = tdd->set_bandwith(last_pos);
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_FREQ].name) {
        if (sub_name == set_get[0].name) {
            //get
            tdd->show_freq();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = tdd->set_freq(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_CONFIG].name) {
        flag = tdd->set_tdd_config(last_pos);
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_SPECIAL].name) {
        flag = tdd->set_tdd_special(last_pos);
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_START].name) {
        if (sub_name == set_get[0].name) {
            //get
            tdd->show_start();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = tdd->set_start(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_LENGTH].name) {
        if (sub_name == set_get[0].name) {
            //get
            tdd->show_length();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = tdd->set_length(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_MCS].name) {
        flag = tdd->set_mcs(last_pos);
    } else if (name == rfdesense_tdd_sub[INDEX_TDD_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            tdd->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = tdd->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else {
        LOG_D(LOG_TAG, "error");
    }

    if (flag) {
        mRatList[INDEX_LTE_TDD]->setRatCmdStart(tdd->get_command());
        mRatList[INDEX_LTE_TDD]->setRatband(tdd->get_band());
        mRatList[INDEX_LTE_TDD]->setRatPowerSet(tdd->get_power());
        save(INDEX_LTE_TDD);
    }
}

void RfDesenseTxTest::handle_nr_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    //NR
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestNr> nr =
            RfDesenseTxTestNr::get_instance();

    if (name == rfdesense_nr_sub[INDEX_NR_SUB_MODE].name) {
        flag = nr->set_tx_mode(last_pos);

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_BAND].name) {
        flag = nr->set_band_idx(last_pos);

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_BANDWIDTH].name) {
        flag = nr->set_bandwith_idx(last_pos);

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_FREQ].name) {
        if (sub_name == set_get[0].name) {
            //get
            nr->show_freq();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = nr->set_freq(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
            em_result_notify_error("get/set input error");
        }

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_START].name) {
        if (sub_name == set_get[0].name) {
            //get
            nr->show_start();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = nr->set_vrb_start(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
            em_result_notify_error("get/set input error");
        }

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_LENGTH].name) {
        if (sub_name == set_get[0].name) {
            //get
            nr->show_length();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = nr->set_vrb_length(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
            em_result_notify_error("get/set input error");
        }

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_MCS].name) {
        flag = nr->set_mcs(last_pos);

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_SCS].name) {
        flag = nr->set_scs(last_pos);

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            nr->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = nr->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
            em_result_notify_error("get/set input error");
        }

    } else if (name == rfdesense_nr_sub[INDEX_NR_SUB_CONFIG].name) {
        if (sub_name == set_get[0].name) {
            //get
            nr->show_config();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = nr->set_tdd_slot_config(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
            em_result_notify_error("get/set input error");
        }
    } else {
        LOG_D(LOG_TAG, "No name=%s", name.c_str());
        em_result_notify_error("get/set input error");
    }

    if (flag) {
        mRatList[INDEX_NR]->setRatCmdStart(nr->get_command());
        mRatList[INDEX_NR]->setRatband(nr->get_band());
        mRatList[INDEX_NR]->setRatPowerSet(nr->get_power());
        save(INDEX_NR);
    }
}

void RfDesenseTxTest::handle_cdma_evdo_para(const std::string& name,
        int last_pos, const std::string& sub_name) {
    //CDMA(EVDO)
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestCdma> evdo = std::make_shared<
            RfDesenseTxTestCdma>(utils::MODEM_CDMA_EVDO);
    if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_BAND].name) {
        flag = evdo->set_band(last_pos);
    } else if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_CHANNEL].name) {
        if (sub_name == set_get[0].name) {
            //get
            evdo->show_channel();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = evdo->set_channel(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_MODULATION].name) {
        flag = evdo->set_modulation(last_pos);
    } else if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            evdo->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = evdo->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    }

    if (flag) {
        mRatList[INDEX_CDMA_EVDO]->setRatCmdStart(evdo->get_command());
        mRatList[INDEX_CDMA_EVDO]->setRatband(evdo->get_band());
        mRatList[INDEX_CDMA_EVDO]->setRatPowerSet(evdo->get_power());
        save(INDEX_CDMA_EVDO);
    }
}

void RfDesenseTxTest::handle_cdma_1X_para(const std::string& name, int last_pos,
        const std::string& sub_name) {
    //CDMA(1X)
    bool flag = false;
    std::shared_ptr<RfDesenseTxTestCdma> cdma_1x = std::make_shared<
            RfDesenseTxTestCdma>(utils::MODEM_CDMA_1X);
    if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_BAND].name) {
        flag = cdma_1x->set_band(last_pos);
    } else if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_CHANNEL].name) {
        if (sub_name == set_get[0].name) {
            //get
            cdma_1x->show_channel();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = cdma_1x->set_channel(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    } else if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_MODULATION].name) {
        flag = cdma_1x->set_modulation(last_pos);
    } else if (name == rfdesense_cdma_sub[INDEX_CDMA_SUB_POWER].name) {
        if (sub_name == set_get[0].name) {
            //get
            cdma_1x->show_power();
        } else if (sub_name == set_get[1].name) {
            // set
            if (mCurrentSettingsValues.size() > 0) {
                flag = cdma_1x->set_power(mCurrentSettingsValues[0]);
            } else {
                LOG_D(LOG_TAG, "mCurrentSettingsValues size is 0");
                em_result_notify_error("please input set values, now, only select the set item. value is empty");
            }
        } else {
            LOG_D(LOG_TAG, "error");
        }
    }

    if (flag) {
        mRatList[INDEX_CDMA_1X]->setRatCmdStart(cdma_1x->get_command());
        mRatList[INDEX_CDMA_1X]->setRatband(cdma_1x->get_band());
        mRatList[INDEX_CDMA_1X]->setRatPowerSet(cdma_1x->get_power());
        save(INDEX_CDMA_1X);
    }
}

bool RfDesenseTxTest::handle_show_default(const std::string& standard) {
    //show default
    if (standard == sub_tx_test[INDEX_GSM].name) {
        //"GSM"
        std::shared_ptr<RfDesenseTxTestGsm> gsm =
                RfDesenseTxTestGsm::get_instance();
        gsm->show_default();
#ifndef TARGET_PLATFORM_MT2735
    } else if (standard == sub_tx_test[INDEX_TDSCDMA].name) {
        //"TDSCDMA"
        std::shared_ptr<RfDesenseTxTestTd> tdscdma = std::make_shared<
                RfDesenseTxTestTd>(utils::MODEM_TDSCDMA);
        tdscdma->show_default();
#endif
    } else if (standard == sub_tx_test[INDEX_WCDMA].name) {
        //"WCDMA"
        std::shared_ptr<RfDesenseTxTestTd> wcdma = std::make_shared<
                RfDesenseTxTestTd>(utils::MODEM_WCDMA);
        wcdma->show_default();
    } else if (standard == sub_tx_test[INDEX_LTE_FDD].name) {
        //LTE(FDD)
        std::shared_ptr<RfDesenseTxTestLte> fdd = std::make_shared<
                RfDesenseTxTestLte>(utils::MODEM_LTE_FDD);
        fdd->show_default();
    } else if (standard == sub_tx_test[INDEX_LTE_TDD].name) {
        //LTE(TDD)
        std::shared_ptr<RfDesenseTxTestLte> tdd = std::make_shared<
                RfDesenseTxTestLte>(utils::MODEM_LTE_TDD);
        tdd->show_default();
#ifdef TARGET_PLATFORM_MT2735
    } else if (standard == sub_tx_test[INDEX_NR].name) {
        //NR
        std::shared_ptr<RfDesenseTxTestNr> nr =
                RfDesenseTxTestNr::get_instance();
        nr->show_default();
#endif
#ifdef C2K_SUPPORT
    } else if ((standard == sub_tx_test[INDEX_CDMA_EVDO].name)
            && utils::isC2KSupport()) {
        //CDMA(EVDO)
        std::shared_ptr<RfDesenseTxTestCdma> evdo = std::make_shared<
                RfDesenseTxTestCdma>(utils::MODEM_CDMA_EVDO);
        evdo->show_default();
    } else if ((standard == sub_tx_test[INDEX_CDMA_1X].name)
            && utils::isC2KSupport()) {
        //CDMA(1X)
        std::shared_ptr<RfDesenseTxTestCdma> cdma_1x = std::make_shared<
                RfDesenseTxTestCdma>(utils::MODEM_CDMA_1X);
        cdma_1x->show_default();
#endif
    } else {
        LOG_D(LOG_TAG, "invaild INPUT");
        return false;
    }
    return true;
}

bool RfDesenseTxTest::handle_para(int len, int classid, int propertyid,int operatorid, const std::string& standard, int* item) {
    if (len < 5) {
        LOG_D(LOG_TAG, "logic error");
        return false;
    }
    LOG_D(LOG_TAG, "len: %d, classid: %d, propertyid: %d, operatorid: %d, standard: %s", len, classid,propertyid, operatorid, standard.c_str());
    int name_pos = item[3];
    int last_pos = item[4];
    std::string name =
            desense_test[classid].subarray[propertyid].subarray[operatorid].subarray[name_pos].name;
    std::string sub_name =
            desense_test[classid].subarray[propertyid].subarray[operatorid].subarray[name_pos].subarray[last_pos].name;
    LOG_D(LOG_TAG, "name_pos: %d, last_pos: %d, name: %s, sub_name: %s", name_pos, last_pos,name.c_str(), sub_name.c_str());
    if (standard == sub_tx_test[INDEX_GSM].name) {
        //"GSM"
        handle_gsm_para(name, last_pos, sub_name);
#ifndef TARGET_PLATFORM_MT2735
    } else if (standard == sub_tx_test[INDEX_TDSCDMA].name) {
        //"TDSCDMA"
        handle_tdscdma_para(name, last_pos, sub_name);
#endif
    } else if (standard == sub_tx_test[INDEX_WCDMA].name) {
        //"WCDMA"
        handle_wcdma_para(name, last_pos, sub_name);
    } else if (standard == sub_tx_test[INDEX_LTE_FDD].name) {
        //LTE(FDD)
        handle_lte_fdd_para(name, last_pos, sub_name);
    } else if (standard == sub_tx_test[INDEX_LTE_TDD].name) {
        //LTE(TDD)
        handle_lte_tdd_para(name, last_pos, sub_name);
#ifdef TARGET_PLATFORM_MT2735
    } else if (standard == sub_tx_test[INDEX_NR].name) {
        //NR
        handle_nr_para(name, last_pos, sub_name);
#endif
#ifdef C2K_SUPPORT
    } else if ((standard == sub_tx_test[INDEX_CDMA_EVDO].name)
            && utils::isC2KSupport()) {
        //CDMA(EVDO)
        handle_cdma_evdo_para(name, last_pos, sub_name);
    } else if ((standard == sub_tx_test[INDEX_CDMA_1X].name)
            && utils::isC2KSupport()) {
        //CDMA(1X)
        handle_cdma_1X_para(name, last_pos, sub_name);
#endif
    } else {
        LOG_D(LOG_TAG, "invaild INPUT");
        return false;
    }
    return true;
}

bool RfDesenseTxTest::handle_start(const std::string& standard) {
    //start
    mState = STATE_STARTED;
    if (standard == sub_tx_test[INDEX_GSM].name) {
        //"GSM"
        mRatList[INDEX_GSM]->setRatCheckState(true);
#ifndef TARGET_PLATFORM_MT2735
    } else if (standard == sub_tx_test[INDEX_TDSCDMA].name) {
        //"TDSCDMA"
        mRatList[INDEX_TDSCDMA]->setRatCheckState(true);
#endif
    } else if (standard == sub_tx_test[INDEX_WCDMA].name) {
        //"WCDMA"
        mRatList[INDEX_WCDMA]->setRatCheckState(true);
    } else if (standard == sub_tx_test[INDEX_LTE_FDD].name) {
        //LTE(FDD)
        mRatList[INDEX_LTE_FDD]->setRatCheckState(true);
    } else if (standard == sub_tx_test[INDEX_LTE_TDD].name) {
        //LTE(TDD)
        mRatList[INDEX_LTE_TDD]->setRatCheckState(true);
#ifdef TARGET_PLATFORM_MT2735
    } else if (standard == sub_tx_test[INDEX_NR].name) {
        //NR
        mRatList[INDEX_NR]->setRatCheckState(true);
#endif
#ifdef C2K_SUPPORT
    } else if ((standard == sub_tx_test[INDEX_CDMA_EVDO].name)
            && utils::isC2KSupport()) {
        //CDMA(EVDO)
        mRatList[INDEX_CDMA_EVDO]->setRatCheckState(true);
    } else if ((standard == sub_tx_test[INDEX_CDMA_1X].name)
            && utils::isC2KSupport()) {
        //CDMA(1X)
        mRatList[INDEX_CDMA_1X]->setRatCheckState(true);
#endif
    } else {
        LOG_D(LOG_TAG, "invaild INPUT");
        return false;
    }
    return true;
}

int RfDesenseTxTest::emRfDesenseStart(int len,int *item,int multilen,char *value[]) {
    LOG_D(LOG_TAG,"emRfDesenseStart called");

    // Update manu index
    int idx_count = 0;
    INDEX_GSM = idx_count;
#ifndef TARGET_PLATFORM_MT2735
    INDEX_TDSCDMA = ++idx_count;
#endif
    INDEX_WCDMA = ++idx_count;
    INDEX_LTE_FDD = ++idx_count;
    INDEX_LTE_TDD = ++idx_count;
#ifdef TARGET_PLATFORM_MT2735
    INDEX_NR = ++idx_count;
#endif
#ifdef C2K_SUPPORT
    INDEX_CDMA_EVDO = ++idx_count;
    INDEX_CDMA_1X = ++idx_count;
#endif
    LOG_D(LOG_TAG, "Manu index: GSM=%d, TDSCDMA=%d, WCDMA=%d, LTE_FDD=%d, LTE_TDD=%d, NR=%d, CDMA_EVDO=%d, CDMA_1X=%d",
            INDEX_GSM, INDEX_TDSCDMA, INDEX_WCDMA, INDEX_LTE_FDD, INDEX_LTE_TDD, INDEX_NR, INDEX_CDMA_EVDO, INDEX_CDMA_1X);

    update_rat();
    if (len < 3) {
        LOG_D(LOG_TAG, "please select redesense get or set");
        return -1;
    }
    int classid = item[0];
    int propertyid = item[1];
    int operatorid = item[2];
    LOG_D(LOG_TAG, "classid=%d, propertyid=%d, operatorid=%d", classid, propertyid, operatorid);

    mCurrentSettingsValues.clear();
    for(int i = 0; i < multilen; i++ ) {
        mCurrentSettingsValues.push_back(value[i]);
        LOG_D(LOG_TAG, "value[%d]: %s", i, value[i]);
    }
    LOG_D(LOG_TAG, "mCurrentSettingsValues size: %d" + mCurrentSettingsValues.size());

    em_arry_t *subarry = &(desense_test[classid].subarray[propertyid]);
    std::string standard = subarry->name;
    LOG_D(LOG_TAG,"rfdesense property name: %s, operatorid: %d",subarry->name, operatorid);
    switch (operatorid) {
        case 0: { //start
            str_msg = "";
            if(!handle_start(standard)) return -1;
            //emEnableRadio(false);
            registerOnUnsolOemHookRaw(m_instance);
            register_response_oem_hook_raw(m_instance);
            std::thread thread_start(&RfDesenseTxTest::emRfDesenseThread, m_instance, operatorid);
            thread_start.detach();
            break;
        }
        case 1: {
            if(!handle_para(len, classid, propertyid, operatorid, standard, item)) return -1;
            break;
        }
        case 2: { //show default
            if(!handle_show_default(standard)) return -1;
            break;
        }
        default:
            LOG_D(LOG_TAG, "logic eror ");
            return -1;
    }
    return (0);
}

std::shared_ptr<RfDesenseRatInfo> RfDesenseTxTest::getCurrectRatInfo() {
    int index;
    for (index = 0; index < mRatList.size(); index++) {
         if (mRatList[index]->getRatCheckState()) {
             if (mRatList[index]->getRatSendState()) {
                 continue;
             }
             mCurrectRatInfo = mRatList[index];
             break;
         }
     }
     return mCurrectRatInfo;
}

void RfDesenseTxTest::turnOffRf(){
    LOG_D(LOG_TAG, "turn off rf....");
    mIsModemNotEnabled = false;
    emEnableRadio(false, phone_id);
    if(utils::is_support_dsds()){
        emEnableRadio(false, phone_id == 0? 1:0);
    }
}

void RfDesenseTxTest::turnOnRf() {
    LOG_D(LOG_TAG, "turn on rf....");
    mIsModemEnabled = false;
    emEnableRadio(true, phone_id);
    if(utils::is_support_dsds()){
        emEnableRadio(true, phone_id == 0? 1:0);
    }
}

void RfDesenseTxTest::initRatList() {
    phone_id = Radio_capability_switch_util::get_main_capability_phone_id();
    mState = STATE_NONE;

    if(!utils::is93ModemAndAbove()){
        mRatCmdStart[5] = DEFAULT_CDMA_EVDO_ATCMD_93before;
        mRatCmdStop[5] = "AT+ECRFTX=0";
    }

    if(utils::is90Modem()) {
        mRatCmdSwitch[5] = "AT^PREFMODE=4";
        mRatCmdSwitch[6] = "AT^EIRATMODE=2";
    }

    for (int i = 0; i < mRatName.size(); i++) {
        std::shared_ptr<RfDesenseRatInfo> Info = std::make_shared<RfDesenseRatInfo>();
        Info->setRatName(mRatName[i]);
        Info->setRatCmdStart(mRatCmdStart[i]);
        Info->setRatCmdStop(mRatCmdStop[i]);
        Info->setRatCmdSwitch(mRatCmdSwitch[i]);
        Info->setRatPowerRead(mRatCmdPowerRead[i]);
        Info->setRatband(mRatBand[i]);
        Info->setRatPowerSet(mRatPowerSet[i]);
        Info->setRatCheckState(false);
        Info->setRatSendState(false);
        mRatList.push_back(Info);
    }
}

void RfDesenseTxTest::update_rat() {
    for(int i=0; i < mRatList.size(); i++){
        mRatList[i]->setRatName(mRatName[i]);
        mRatList[i]->setRatCmdStart(mRatCmdStart[i]);
        mRatList[i]->setRatCmdStop(mRatCmdStop[i]);
        mRatList[i]->setRatCmdSwitch(mRatCmdSwitch[i]);
        mRatList[i]->setRatPowerRead(mRatCmdPowerRead[i]);
        mRatList[i]->setRatband(mRatBand[i]);
        mRatList[i]->setRatPowerSet(mRatPowerSet[i]);
        mRatList[i]->setRatCheckState(false);
        mRatList[i]->setRatSendState(false);
    }
}
void RfDesenseTxTest::save(int index) {
    mRatCmdStart[index] = mRatList[index]->getRatCmdStart();
    mRatBand[index] = mRatList[index]->getRatband();
    mRatPowerSet[index] = mRatList[index]->getRatPowerSet();
}
