
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <string.h>
//#include "lynq_call.h"
//#include "lynq_module_common.h"
//#include "lynq_call_common.h"
#include "common.h"
#include "call_rtp.h"
#include "call_rtp_inner.h"
#include "lynq_interface.h"
#include "ecall/eCall.h"
#include "cc.h"

#undef LOG_TAG
#define LOG_TAG "ECALL_RTP"

static lynq_rtp_client_info g_rtp_client_info;
static lynq_rtp_server_info g_rtp_server_info;

static pthread_t g_rtp_thread[RTP_MODE_MAX];
static bool g_rtp_thread_valid[RTP_MODE_MAX]={0};

static pthread_mutex_t mtx = PTHREAD_MUTEX_INITIALIZER;

int lock_rtp_audio_mtx()
{
    return pthread_mutex_lock(&mtx);
}

int unlock_rtp_audio_mtx()
{
    return pthread_mutex_unlock(&mtx);
}


int set_voice_audio_mode(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{    
    android::Parcel p;
    int setValue = 0;

    if(argc < 2) {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_VOICE_AUDIO_MODE,0,2);
        android::LYNQ_RIL_respSocket_sp(p,pRI);
        free(pRI);
        RLOGW("%s fail! argc is %d",__FUNCTION__,argc);
        return -1;
    }

    setValue = atoi(argv[1]);
    RLOGD("%s %d start",__FUNCTION__,setValue);
    if(setValue < AUDIO_MODE_CODEC || setValue > AUDIO_MODE_RTP ) {
        RLOGW("Warning: parameter %d is over-range!",setValue);
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_VOICE_AUDIO_MODE,0,3);
        android::LYNQ_RIL_respSocket_sp(p,pRI);
        free(pRI);
        return -1;
    }

    int s = lock_rtp_audio_mtx();
    if(s != 0) {
        RLOGE("%s lock_rtp_audio_mtx fail",__FUNCTION__);
    }

    int old_EcallAudioPath = isEcallAudioPath();

    setEcallAudioPathOn_New(setValue==AUDIO_MODE_CODEC);     

    if((get_call_status() == CALL_ON) && getSpeechStatus() == NORMAL_SPEECH_ON)        
    {
        if(isEcallAudioPath()!=old_EcallAudioPath)
        {
            RLOGD("%s, change mode in real time",__FUNCTION__);
            if(exe_set_voice_audio_mode((isEcallAudioPath())? AUDIO_MODE_CODEC:AUDIO_MODE_RTP)!=RESULT_OK)
            {
                setEcallAudioPathOn_New(old_EcallAudioPath);                
                s = unlock_rtp_audio_mtx();
                if(s != 0) {
                    RLOGE("%s, unlock_rtp_audio_mtx fail",__FUNCTION__);
                }
                
                android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_VOICE_AUDIO_MODE,0,5);
                android::LYNQ_RIL_respSocket(p,(void *)pRI);  
                free(pRI);
                return RESULT_ERROR; 
            }
        }        
    }    

    s = unlock_rtp_audio_mtx();
    if(s != 0) {
        RLOGE("%s, unlock_rtp_audio_mtx fail",__FUNCTION__);
    }

    android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_VOICE_AUDIO_MODE,0,0);
    android::LYNQ_RIL_respSocket(p,(void *)pRI);  
    free(pRI);
       RLOGD("%s %d finish",__FUNCTION__,setValue);
    return RESULT_OK; 
}

int set_remote_rtp_ip(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    RLOGD("%s start!",__FUNCTION__);
    android::Parcel p;

    if(argc < 2) {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_REMOTE_RTP_IP,0,2);
        android::LYNQ_RIL_respSocket_sp(p,pRI);
        free(pRI);
        RLOGW("Warning: no %s!",__FUNCTION__);
        return -1;
    } 

    if(exe_set_remote_rtp_ip(argv[1],strlen(argv[1])+1)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_REMOTE_RTP_IP,0,0);
        RLOGD(">>>>%s<<<< success value is %s!\n", __FUNCTION__, argv[1]);
    }
    else
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_REMOTE_RTP_IP,0,4);
        RLOGD(">>>>%s <<<< failure value is %s!\n",__FUNCTION__, argv[1]);
    }       

    android::LYNQ_RIL_respSocket(p,(void *)pRI);  
    free(pRI);
    return RESULT_OK; 
}
int set_vlan_info(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    RLOGD("%s start!",__FUNCTION__);
    android::Parcel p;
    const char* vlan_info="";   
        
    if(argc >1) 
    {
        vlan_info=argv[1];      
    } 

    if(exe_set_vlan_info(vlan_info,strlen(vlan_info)+1)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_VLAN_INFO,0,0);
        RLOGD(">>>>%s<<<< success value is %s!\n", __FUNCTION__, vlan_info);
    }
    else
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_VLAN_INFO,0,4);
        RLOGE(">>>>%s <<<< failure value is %s!\n",__FUNCTION__, vlan_info);
    }       

    android::LYNQ_RIL_respSocket(p,(void *)pRI);  
    free(pRI);
    return RESULT_OK; 
}

int set_rtp_port(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    RLOGD("%s start!",__FUNCTION__);
    android::Parcel p;

    if(argc < 3) 
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PORT,0,2);
        android::LYNQ_RIL_respSocket_sp(p,pRI);
        free(pRI);
        RLOGW("Warning: no %s!",__FUNCTION__);
        return -1;
    } 

    if(exe_set_rtp_port((LYNQ_Rtp_Mode)(atoi(argv[1])),atoi(argv[2]))==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PORT,0,0);
        RLOGD(">>>>%s<<<< success value is %s %s!\n", __FUNCTION__, argv[1],argv[2]);
    }
    else
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PORT,0,4);
        RLOGE(">>>>%s <<<< failure value is %s %s!\n",__FUNCTION__, argv[1],argv[2]);
    }

    android::LYNQ_RIL_respSocket(p,(void *)pRI);  
    free(pRI);
 
    return RESULT_OK; 
}
    

int set_rtp_param(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    RLOGD("%s start!",__FUNCTION__);
    android::Parcel p;

    if(argc < 4) {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PARAM,0,2);
        android::LYNQ_RIL_respSocket_sp(p,pRI);
        free(pRI);
        RLOGW("Warning: no %s!",__FUNCTION__);
        return -1;
    } 

    if(exe_set_rtp_param(atoi(argv[1]),atoi(argv[2]),atoi(argv[3]))==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PARAM,0,0);
        RLOGD(">>>>%s<<<< success value is %s %s %s!\n", __FUNCTION__, argv[1],argv[2],argv[3]);
    }
    else
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PARAM,0,4);   
        RLOGE(">>>>%s <<<< failure value is %s %s %s!\n",__FUNCTION__, argv[1],argv[2],argv[3]);
    } 
    
    android::LYNQ_RIL_respSocket(p,(void *)pRI);  
    free(pRI);

    return RESULT_OK; 
}

int set_call_rtp_ssrc(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    RLOGD("%s start!",__FUNCTION__);
    android::Parcel p;

    if(argc < 3) {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_CALL_RTP_SSRC,0,2);
        android::LYNQ_RIL_respSocket_sp(p,pRI);
        free(pRI);
        RLOGW("Warning: no %s!",__FUNCTION__);
        return -1;
    } 

    if(exe_set_call_rtp_ssrc(atoi(argv[1]),strtoul(argv[2],0,0))==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_CALL_RTP_SSRC,0,0);
        RLOGD(">>>>%s<<<< success value is %s %s!\n", __FUNCTION__, argv[1],argv[2]);
    }
    else
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_CALL_RTP_SSRC,0,4);
        RLOGE(">>>>%s <<<< failure value is %s %s!\n",__FUNCTION__, argv[1],argv[2]);
    } 
    
    android::LYNQ_RIL_respSocket(p,(void *)pRI);  
    free(pRI);

    return RESULT_OK; 
}


int get_voice_audio_mode(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;
    int mode = exe_get_voice_audio_mode();
 
    android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_VOICE_AUDIO_MODE,0,0);
   
    p.writeInt32(mode);
    android::LYNQ_RIL_respSocket(p,(void *)pRI);
    free(pRI);
    return RESULT_OK;
}

int get_remote_rtp_ip(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    char rtp_ip[MAX_IP_LENGTH]={0};

    android::Parcel p;
    if(exe_get_remote_rtp_ip(rtp_ip,MAX_IP_LENGTH)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_REMOTE_RTP_IP,0,0);
        p.writeInt32(1);
        android::writeStringToParcel(p,rtp_ip);        
    }
    else 
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_REMOTE_RTP_IP,0,2);
    } 
   
    android::LYNQ_RIL_respSocket(p,(void *)pRI);
    free(pRI);
    return RESULT_OK;
}

int get_vlan_info(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    char vlan_info[MAX_VLAN_INFO_LENGTH]={0};

    android::Parcel p;
    if(exe_get_vlan_info(vlan_info,MAX_VLAN_INFO_LENGTH)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_VLAN_INFO,0,0);
        p.writeInt32(1);
        android::writeStringToParcel(p,vlan_info);        
    }
    else 
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_VLAN_INFO,0,2);
    } 
   
    android::LYNQ_RIL_respSocket(p,(void *)pRI);
    free(pRI);
    return RESULT_OK;
}

int get_rtp_port(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    int rtp_port;
    android::Parcel p;

    
    if(argc < 2) {
           android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_SET_RTP_PORT,0,2);
           android::LYNQ_RIL_respSocket_sp(p,pRI);
           free(pRI);
           RLOGW("Warning: no %s!",__FUNCTION__);
           return RESULT_ERROR;
    } 
    if(exe_get_rtp_port((LYNQ_Rtp_Mode) (atoi(argv[1])),&rtp_port)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_VLAN_INFO,0,0);
        p.writeInt32(rtp_port);        
    }
    else 
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_VLAN_INFO,0,3);
    } 
   
    android::LYNQ_RIL_respSocket(p,(void *)pRI);
    free(pRI);
    return RESULT_OK;
}

int get_rtp_param(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    int clock_rate, channels, latency;
    android::Parcel p;
    
    if(exe_get_rtp_param(&clock_rate, &channels, &latency)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_RTP_PARAM,0,0);
        p.writeInt32(clock_rate);    
        p.writeInt32(channels);    
        p.writeInt32(latency);    
    }
    else 
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_RTP_PARAM,0,2);
    } 
   
    android::LYNQ_RIL_respSocket(p,(void *)pRI);
    free(pRI);
    return RESULT_OK;
}

int get_call_rtp_ssrc(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    android::Parcel p;

    int ssrc_mode;
    unsigned int ssrc;
    
    if(exe_get_call_rtp_ssrc(&ssrc_mode, &ssrc)==RESULT_OK)
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_CALL_RTP_SSRC,0,0);
        p.writeInt32(ssrc_mode);    
        p.writeUint32(ssrc);            
    }
    else 
    {
        android::lynqAssemblyParcelheader(p,socket_id,pRI->uToken,LYNQ_REQUEST_GET_CALL_RTP_SSRC,0,2);
    } 
   
    android::LYNQ_RIL_respSocket(p,(void *)pRI);
    free(pRI);
    return RESULT_OK;
}


void lynq_init_rtp()
{   
    memset(&g_rtp_client_info,0,sizeof(g_rtp_client_info));
    memset(&g_rtp_server_info,0,sizeof(g_rtp_server_info));    
  

    exe_set_rtp_param(8000,1,400);

    for(int i=0;i<RTP_MODE_MAX;i++)
    {
        exe_set_rtp_port((LYNQ_Rtp_Mode)i,6666);
        g_rtp_thread_valid[i] = 0;
    }          

    exe_set_voice_audio_mode(AUDIO_MODE_INIT);
    
    RLOGD("lynq init rtp success!!!");
    return;
}

/*Audio Path setting begin*/
/*sub function*/
void exe_set_rtp_mixer_ctrl(int audio_mode)
{
    char cmd[256];
    RLOGD("set_rtp_mixer_ctrl, audio mode is %d", audio_mode);
    if(audio_mode==AUDIO_MODE_RTP)
    {
        sprintf(cmd, "amixer -D mtk_phonecall cset name=\"Speech_on_ecall\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -D mtk_phonecall cset name=\"M2M_Speech_on\" %d", 1);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"PCM_2_PB_CH1 DL2_CH1\" %d", 1);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"PCM_2_PB_CH2 DL2_CH2\" %d", 1);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"UL2_CH1 PCM_2_CAP_CH1\" %d", 1);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"UL2_CH2 PCM_2_CAP_CH1\" %d", 1);
        system(cmd);    
    }
    else if(audio_mode==AUDIO_MODE_CODEC)
    {        
        sprintf(cmd, "amixer -D mtk_phonecall cset name=\"M2M_Speech_on\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"PCM_2_PB_CH1 DL2_CH1\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"PCM_2_PB_CH2 DL2_CH2\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"UL2_CH1 PCM_2_CAP_CH1\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"UL2_CH2 PCM_2_CAP_CH1\" %d", 0);
        system(cmd);    
        sprintf(cmd, "amixer -D mtk_phonecall cset name=\"Speech_on_ecall\" %d", 1);
        system(cmd);
    }    
    else 
    {
        if(audio_mode==AUDIO_MODE_INIT)
        {
            sprintf(cmd, "amixer -D mtk_phonecall cset name=\"Speech_on\" %d", 0);
            system(cmd);
        }
        sprintf(cmd, "amixer -D mtk_phonecall cset name=\"Speech_on_ecall\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -D mtk_phonecall cset name=\"M2M_Speech_on\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"PCM_2_PB_CH1 DL2_CH1\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"PCM_2_PB_CH2 DL2_CH2\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"UL2_CH1 PCM_2_CAP_CH1\" %d", 0);
        system(cmd);
        sprintf(cmd, "amixer -c0 cset name=\"UL2_CH2 PCM_2_CAP_CH1\" %d", 0);
        system(cmd);    
    }
}

static int record_count=0;
void* exe_start_rtp_cmd(void *arg)
{
    int* rtp_mode= (int*) arg;
    char cmd[384];
    char vlan_para_string[sizeof(RTP_VLAN_INFO_FORMAT)+MAX_VLAN_INFO_LENGTH-2/*sizeof "%s"*/]={0};
    char ssrc_para_string[sizeof(RTP_SSRC_INFO_FORMAT)+MAX_SSRC_INFO_LENGTH-2/*sizeof "%u"*/]={0};
    RLOGD("exe_start_rtp_cmd: rtp_mode is %d",(*rtp_mode));    
    if ((*rtp_mode) == RTP_CLIENT)
    {
         if(g_ril_test==RIL_STUB_TEST_SWTICH_RTP_RECORD)
         {
             system("sleep 30");
         }
         else             
         {
              sprintf(cmd,RTP_FROM_CMD, \
                    g_rtp_client_info.port,g_rtp_client_info.clockrate,g_rtp_client_info.channels, \
                    g_rtp_client_info.latency);            
              RLOGD("start from rtp play: cmd is %s",cmd);    
              system(cmd);
           }
    }
    else if ((*rtp_mode) == RTP_SERVER)
    {
        if(g_ril_test==RIL_STUB_TEST_SWTICH_RTP_RECORD)
        {
            const char* record_fmt="arecord -D hw:0,6 -c 2 -d 10 -r 32000 -f S16_LE --period-size=1280    --buffer-size=5120 /tmp/record_%d.wav";
            sprintf(cmd,record_fmt,record_count);     
            RLOGD("start to rtp play: cmd is %s",cmd);
            record_count++;
            system(cmd);        
        }
        else
        {        
            if(strlen(g_rtp_server_info.vlan_info)>0)
            {
               sprintf(vlan_para_string,RTP_VLAN_INFO_FORMAT,g_rtp_server_info.vlan_info);
            }
    
            if(g_rtp_server_info.ssrc_mode == Rtp_Ssrc_specific)
            {
               sprintf(ssrc_para_string,RTP_SSRC_INFO_FORMAT,g_rtp_server_info.ssrc);
            }
            sprintf(cmd,RTP_TO_CMD,   \
            g_rtp_client_info.channels, g_rtp_client_info.clockrate, ssrc_para_string, g_rtp_server_info.ip,vlan_para_string,g_rtp_server_info.port);       
            
            RLOGD("start to rtp play: cmd is %s",cmd);
            system(cmd);    
        }
        
    }
    return NULL;
}

int exe_start_rtp_thread(int rtp_mode)
{
    int ret;
    pthread_attr_t attr;
    static int start_mode[RTP_MODE_MAX]={0,1};  

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    ret = pthread_create(&(g_rtp_thread[rtp_mode]),&attr,exe_start_rtp_cmd,&(start_mode[rtp_mode]));
    if(ret != 0)
    {
        g_rtp_thread_valid[rtp_mode]=0;
        RLOGE("rtp create %d pthread error, ret is %d",rtp_mode, ret);
        return ret;
    }
    g_rtp_thread_valid[rtp_mode]=1;
    return RESULT_OK;  
}

/*set*/
int exe_set_voice_audio_mode(const LYNQ_Audio_Mode audio_mode)
{
    int ret;
    int i;

    RLOGD("%s %d",__FUNCTION__,audio_mode);
    if(audio_mode==AUDIO_MODE_RTP)
    {  
        exe_set_rtp_mixer_ctrl(audio_mode);
        for(i=0;i<RTP_MODE_MAX;i++)
        {
            if(!g_rtp_thread_valid[i])
            {
                if(exe_start_rtp_thread(i)!= 0)
                {
                    RLOGE("start rtp thread %d fail",i);
                    break;
                }
                else 
                {
                    RLOGD("start rtp thread %d suc",i);        
                }
            }
            else 
            {
                RLOGE("rtp thread %d needn't start",i); 
            }
        }
        if(i!= RTP_MODE_MAX)            
        {
            RLOGD("%s %d fail",__FUNCTION__,audio_mode);
            exe_set_voice_audio_mode(AUDIO_MODE_CODEC);
            return RESULT_ERROR;
        }              
    }
    else if(audio_mode==AUDIO_MODE_CODEC)
    {
        for(i=0;i<RTP_MODE_MAX;i++)
        {
            if(g_rtp_thread_valid[i]) 
            {
                 ret = pthread_cancel(g_rtp_thread[i]);
                 RLOGD("pthread cancel rtp %d ret = %d",i,ret);
                 ret = pthread_join(g_rtp_thread[i],NULL);
                 RLOGD("pthread join rtp %d ret = %d",i,ret);
                 g_rtp_thread_valid[i] = 0;
            }
            else 
            {
                RLOGD("rtp thread %d needn't stop",i);
            }
        }          
        exe_set_rtp_mixer_ctrl(audio_mode);        
    }
    else // audio_mode==AUDIO_MODE_ALL_CLOSE /AUDIO_MODE_INIT
    {        
        for(i=0;i<RTP_MODE_MAX;i++)
        {
            if(g_rtp_thread_valid[i]) 
            {
                 ret = pthread_cancel(g_rtp_thread[i]);
                 RLOGD("pthread cancel rtp %d ret = %d",i,ret);
                 ret = pthread_join(g_rtp_thread[i],NULL);
                 RLOGD("pthread join rtp %d ret = %d",i,ret);
                 g_rtp_thread_valid[i] = 0;
            }
            else 
            {
                RLOGD("rtp thread %d needn't stop",i);
            }
        }    
        exe_set_rtp_mixer_ctrl(audio_mode);           
    }
    RLOGD("%s %d suc",__FUNCTION__,audio_mode);
    return RESULT_OK;    
}
int exe_set_remote_rtp_ip(const char* ip, const int ip_length)
{
    if (NULL == ip)
    {
        RLOGE("ip is NULL!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if ((ip_length < strlen(ip)+1) || (ip_length > MAX_IP_LENGTH))
    {
        RLOGE("incoming ip length error %d", ip_length);
        return LYNQ_E_PARAMETER_ANONALY;
    }    

    bzero(g_rtp_server_info.ip,MAX_IP_LENGTH);
    strcpy(g_rtp_server_info.ip,ip);
    
    RLOGD("exe_set_remote_rtp_ip suc: ip is %s, length is %d", ip,ip_length);
    
    return RESULT_OK;  
}
int exe_set_vlan_info(const char* vlan_info, const int vlan_info_length)
{
    if (NULL == vlan_info)
    {
        RLOGE("vlan_info is NULL!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    
    if ((vlan_info_length < strlen(vlan_info)+1) || (vlan_info_length > MAX_VLAN_INFO_LENGTH))
    {
        RLOGE("incoming vlan_info error, vlan info length %d", vlan_info_length);
        return LYNQ_E_PARAMETER_ANONALY;
    }    

    
    bzero(g_rtp_server_info.vlan_info,MAX_VLAN_INFO_LENGTH);
    strcpy(g_rtp_server_info.vlan_info,vlan_info);
   
    RLOGD("exe_set_vlan_info suc: vlan is %s, length is %d", vlan_info,vlan_info_length);
    
    return RESULT_OK;  
}
int exe_set_rtp_port(const LYNQ_Rtp_Mode rtp_mode, const int port)
{  
    if (port < 0)
    {
        RLOGE("invalid port number %d", port);
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if (rtp_mode == 0)
    {
        g_rtp_client_info.port = port;
    }
    else if (rtp_mode == 1)
    {
        g_rtp_server_info.port = port;
    }
    RLOGD("exe_set_rtp_port suc: LYNQ_Rtp_Mode is %d, port is %d", rtp_mode, port);
    return RESULT_OK;  
}
int exe_set_rtp_param(const int clock_rate,const int channels,const int latency) 
{
    g_rtp_client_info.clockrate = clock_rate;
    g_rtp_client_info.channels = channels;
    g_rtp_client_info.latency = latency;
    RLOGD("exe_set_rtp_param suc: clockrate is %d, channels is %d, latency is %d", clock_rate, channels, latency);
    return RESULT_OK;  
}
int exe_set_call_rtp_ssrc(const int ssrc_mode,const unsigned int ssrc)
{
    if(ssrc_mode < Rtp_Ssrc_random || ssrc_mode > Rtp_Ssrc_specific)
    {
        return LYNQ_E_PARAMETER_ANONALY;
    }
    g_rtp_server_info.ssrc_mode = ssrc_mode;
    g_rtp_server_info.ssrc = ssrc ;
    RLOGD("%s suc: param is %d %u", __func__, ssrc_mode, ssrc);
    return RESULT_OK;
}
/*get*/
LYNQ_Audio_Mode exe_get_voice_audio_mode()
{
    if(isEcallAudioPath())
    {
        return AUDIO_MODE_CODEC;
    }
    else 
    {
        return AUDIO_MODE_RTP;
    }
}
int exe_get_remote_rtp_ip(char* ip, const int ip_length)
{
    if(ip_length < strlen(g_rtp_server_info.ip)+1)
    {
        RLOGE("ip length %d is shorter than saved ip length %d",ip_length,strlen(g_rtp_server_info.ip)+1);
        return LYNQ_E_PARAMETER_ANONALY;
    }
    
    bzero(ip,ip_length);
    strcpy(ip,g_rtp_server_info.ip);
    
    return RESULT_OK;  
}
int exe_get_vlan_info(char* vlan_info, const int vlan_info_length)
{
    if(vlan_info_length < strlen(g_rtp_server_info.vlan_info)+1)
    {
        RLOGE("vlan info length %d is shorter than saved vlan info length %d",vlan_info_length,strlen(g_rtp_server_info.vlan_info)+1);
        return LYNQ_E_PARAMETER_ANONALY;
    }
   
    bzero(vlan_info,vlan_info_length);
    strcpy(vlan_info,g_rtp_server_info.vlan_info);        
   
    return RESULT_OK;  
}
int exe_get_rtp_port(const LYNQ_Rtp_Mode rtp_mode, int* port)
{    
    if (rtp_mode == 0)
    {
        *port = g_rtp_client_info.port;
    }
    else if (rtp_mode == 1)
    {
        *port = g_rtp_server_info.port;
    }
    return RESULT_OK;  
}
int exe_get_rtp_param(int* clock_rate, int* channels, int* latency)//only for client mode
{
    *clock_rate = g_rtp_client_info.clockrate;
    *channels = g_rtp_client_info.channels ;
    *latency = g_rtp_client_info.latency;

    return RESULT_OK;  
}
int exe_get_call_rtp_ssrc(int* ssrc_mode, unsigned int* ssrc)
{   
    *ssrc_mode = g_rtp_server_info.ssrc_mode;
    *ssrc = g_rtp_server_info.ssrc ;   
    
    return RESULT_OK;
}
