/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include "em/em_el1_public_struct.h"
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_EL1"

static int mItemCount = 0;
static int mFlag = 0;// at cmd flag
static int mCurrentFlag = 0; // at cmd handle flag

static const int MSG_NW_INFO = 1;
static const int MSG_NW_INFO_OPEN = 4;
static const int MSG_NW_INFO_CLOSE = 5;

static void sendATCommand(const char *cmd,int msg)
{
    mCurrentFlag = msg;
    emSendATCommand(cmd, get_default_sim_all_except_data());
    return ;
}

static char hex2char(unsigned int hex) {
    if (hex >= '0' && hex <= '9') {
        return hex - '0';
    }
    if (hex >= 'A' && hex <= 'F') {
        return 0xA + hex - 'A';
    }
    if (hex >= 'a' && hex <= 'f') {
        return 0xA + hex - 'a';
    }
    return 0;
}

static void hex2char(char *input, int input_len, char *buf, int buf_size) {
    RLOGD("hex2char, input_len: %d, buf_size: %d", input_len, buf_size);
    memset(buf, 0, buf_size);
    //respose data lack of 8 byte, corresponding to header
    //ref_count(1)+lp_reserved(1)+ msg_len(2) + em_info(4)
    if (input_len < (buf_size-8) * 2) { // should not happen
        buf_size = input_len / 2;
    }
    for (int i = 0; i < buf_size; i++) {
        buf[i+8] = (hex2char(input[i * 2]) << 4) + hex2char(input[i * 2 + 1]);
    }

}

static void el1_at_cmd_handle(char*response, int responselen) {
    switch (mCurrentFlag) {
        case MSG_NW_INFO:
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("el1_at_cmd_handle response %s\n",response);
                //mFlag = FLAG_OFFSET_BIT;
            }
            else {
                RLOGD("send fail ");
            }
            break;
        case MSG_NW_INFO_OPEN:
        case MSG_NW_INFO_CLOSE:
            break;
        default:
            break;
    }
}

static void el1_parse(char *output,char * input){
    em_el1_status_ind_struct buf;
    hex2char(input, strlen(input), (char *)&buf, sizeof(em_el1_status_ind_struct));
    snprintf(output, 8192,
            "[Cell Info]\n"
            "  band: %u,%u,%u,%u\n"
            "  DL_BW: %u,%u,%u,%u\n"
            "  UL_BW: %u,%u,%u,%u\n"
            "  TM: %u,%u,%u,%u\n"
            "  PCI: %d,%d,%d,%d\n"
            "  EARFCN: %u,%u,%u,%u\n"
            "[DL]\n"
            "  dl_rssi: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  dl_rsrp: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  dl_rsrq: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  dl_sinr: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  rsrp: %d,%d,%d,%d\n"
            "  rsrq: %d,%d,%d,%d\n"
            "  sinr: %d,%d,%d,%d\n"
            "  rsSNR: %d,%d,%d,%d\n"
            "  tm: %d,%d,%d,%d\n"
            "  rsrp_l1_rxpath_sum_dBm: %d,%d,%d,%d\n"
            "  rsrq_l1_rxpath_sum_dB: %d,%d,%d,%d\n"
            "  snr_l1_rxpath_sum_dB: %d,%d,%d,%d\n",
        buf.cell_info[0].band, buf.cell_info[1].band,buf.cell_info[2].band,buf.cell_info[3].band,
        buf.cell_info[0].dl_bw, buf.cell_info[1].dl_bw,buf.cell_info[2].dl_bw,buf.cell_info[3].dl_bw,
        buf.cell_info[0].ul_bw, buf.cell_info[1].ul_bw,buf.cell_info[2].ul_bw,buf.cell_info[3].ul_bw,
        buf.cell_info[0].tm, buf.cell_info[1].tm,buf.cell_info[2].tm,buf.cell_info[3].tm,
        buf.cell_info[0].pci, buf.cell_info[1].pci,buf.cell_info[2].pci,buf.cell_info[3].pci,
        buf.cell_info[0].earfcn, buf.cell_info[1].earfcn,buf.cell_info[2].earfcn,buf.cell_info[3].earfcn,
        buf.dl_info[0].dl_rssi[0],buf.dl_info[0].dl_rssi[1],buf.dl_info[1].dl_rssi[0],buf.dl_info[1].dl_rssi[1],
        buf.dl_info[2].dl_rssi[0],buf.dl_info[2].dl_rssi[1],buf.dl_info[3].dl_rssi[0],buf.dl_info[3].dl_rssi[1],
        buf.dl_info[0].dl_rsrp[0],buf.dl_info[0].dl_rsrp[1],buf.dl_info[1].dl_rsrp[0],buf.dl_info[1].dl_rsrp[1],
        buf.dl_info[2].dl_rsrp[0],buf.dl_info[2].dl_rsrp[1],buf.dl_info[3].dl_rsrp[0],buf.dl_info[3].dl_rsrp[1],
        buf.dl_info[0].dl_rsrq[0],buf.dl_info[0].dl_rsrq[1],buf.dl_info[1].dl_rsrq[0],buf.dl_info[1].dl_rsrq[1],
        buf.dl_info[2].dl_rsrq[0],buf.dl_info[2].dl_rsrq[1],buf.dl_info[3].dl_rsrq[0],buf.dl_info[3].dl_rsrq[1],
        buf.dl_info[0].dl_sinr[0],buf.dl_info[0].dl_sinr[1],buf.dl_info[1].dl_sinr[0],buf.dl_info[1].dl_sinr[1],
        buf.dl_info[2].dl_sinr[0],buf.dl_info[2].dl_sinr[1],buf.dl_info[3].dl_sinr[0],buf.dl_info[3].dl_sinr[1],
        buf.dl_info[0].rsrp, buf.dl_info[1].rsrp, buf.dl_info[2].rsrp, buf.dl_info[3].rsrp,
        buf.dl_info[0].rsrq, buf.dl_info[1].rsrq, buf.dl_info[2].rsrq, buf.dl_info[3].rsrq,
        buf.dl_info[0].sinr, buf.dl_info[1].sinr, buf.dl_info[2].sinr, buf.dl_info[3].sinr,
        buf.dl_info[0].rsSNR, buf.dl_info[1].rsSNR, buf.dl_info[2].rsSNR, buf.dl_info[3].rsSNR,
        buf.dl_info[0].tm, buf.dl_info[1].tm, buf.dl_info[2].tm, buf.dl_info[3].tm,
        buf.dl_info[0].rsrp_l1_rxpath_sum_dBm, buf.dl_info[1].rsrp_l1_rxpath_sum_dBm, buf.dl_info[2].rsrp_l1_rxpath_sum_dBm, buf.dl_info[3].rsrp_l1_rxpath_sum_dBm,
        buf.dl_info[0].rsrq_l1_rxpath_sum_dB, buf.dl_info[1].rsrq_l1_rxpath_sum_dB, buf.dl_info[2].rsrq_l1_rxpath_sum_dB, buf.dl_info[3].rsrq_l1_rxpath_sum_dB,
        buf.dl_info[0].snr_l1_rxpath_sum_dB, buf.dl_info[1].snr_l1_rxpath_sum_dB, buf.dl_info[2].snr_l1_rxpath_sum_dB, buf.dl_info[3].snr_l1_rxpath_sum_dB
        );
}

static void  el1_urc_handle(int type, char *data){
    RLOGD("el1_urc_handle type %d data %s\n",type,data);
    if(type == EM_EL1_INFO) {
        char outbuf[8192] = {0};
        el1_parse(outbuf,data);
        android::emResultNotify(outbuf);
        android::emResultNotify(RET_STRING_LTE_SUCCESS);
        android::unregisterNetwork();
        char atcommand[32] = {0};
        sprintf(atcommand,"AT+EINFO=%d,%d,1",mFlag,EM_EL1_INFO);
        sendATCommand(atcommand, MSG_NW_INFO_CLOSE);
    }
}

int em_el1_start(int argc, int multicnt,int *item)
{
    RLOGD("em_el1_start called");
    if(argc < 1)
    {
        RLOGD("em_el1_start: please select page to show info");
        android::emResultNotify(RET_STRING_LTE_FAIL);
        return -1;
    }
    mItemCount = multicnt + 1;
    RLOGD("mItemCount: %d, item[%d]: %d", mItemCount, multicnt, item[multicnt]);
    android::registerForNetworkInfo(el1_urc_handle);
    android::registerForATcmdResponse(el1_at_cmd_handle);
    //sendATCommand("AT+EINFO?",MSG_NW_INFO);
    mFlag = 8;
    char atcommand[32] = {0};
    sprintf(atcommand,"AT+EINFO=%d,%d,0",mFlag,EM_EL1_INFO);
    sendATCommand(atcommand, MSG_NW_INFO_OPEN);
    return (0);
}
#endif

