/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "Content.h"
#include "../../util/utils.h"
#include "../../util/ModemCategory.h"

const bool Content::NEW_VALUE = true; //ChipSupport.getChip() >= ChipSupport.MTK_6735_SUPPORT;
const bool Content::IS_MOLY = ModemCategory::isLteSupport();

/* Item Index */
constexpr int Content::CELL_INDEX;
constexpr int Content::CHANNEL_INDEX;
constexpr int Content::CTRL_INDEX;
constexpr int Content::RACH_INDEX;
constexpr int Content::LAI_INDEX;
constexpr int Content::RADIO_INDEX;
constexpr int Content::MEAS_INDEX;
constexpr int Content::CA_INDEX;
constexpr int Content::CONTROL_INDEX;
constexpr int Content::SI2Q_INDEX;
constexpr int Content::MI_INDEX;
constexpr int Content::BLK_INDEX;
constexpr int Content::TBF_INDEX;
constexpr int Content::GPRS_INDEX;
const int Content::SM_INFO_INDEX = IS_MOLY ? 58 : 63;
constexpr int Content::URR_3G_GENERAL_INDEX;
const int Content::MM_INFO_INDEX = NEW_VALUE ? 53 : 21;
constexpr int Content::GMM_INFO_INDEX;
const int Content::TCM_MMI_INDEX = NEW_VALUE ? 59 : 27;
const int Content::CSCE_SERV_CELL_STATUS_INDEX = NEW_VALUE ? 75 : 47;
const int Content::CSCE_NEIGH_CELL_STATUS_INDEX = NEW_VALUE ? 76 : 48;
const int Content::CSCE_MULTIPLMN_INDEX = NEW_VALUE ? 81 : 52;
const int Content::UMTS_CELL_STATUS_INDEX = NEW_VALUE ? 90 : 53;
const int Content::PERIOD_IC_BLER_REPORT_INDEX = NEW_VALUE ? (IS_MOLY ? 97 : 99) : 62;
const int Content::URR_UMTS_SRNC_INDEX = NEW_VALUE ? 111 : 64;
const int Content::PSDATA_RATE_STATUS_INDEX = NEW_VALUE ? 140 : 65;
const int Content::HSERV_CELL_INDEX = NEW_VALUE ? (IS_MOLY ? 96 : 98) : 61;
const int Content::HANDOVER_SEQUENCE_INDEX = NEW_VALUE ? 130 : 65;
const int Content::UL_ADM_POOL_STATUS_INDEX = NEW_VALUE ? 185 : 67;
const int Content::UL_PSDATA_RATE_STATUS_INDEX = NEW_VALUE ? 186 : 68;
const int Content::UL_HSDSCH_RECONFIG_STATUS_INDEX = NEW_VALUE ? 187 : 69;
const int Content::UL_URLC_EVENT_STATUS_INDEX = NEW_VALUE ? 188 : 70;
const int Content::UL_PERIOD_IC_BLER_REPORT_INDEX = NEW_VALUE ? 189 : 71;

constexpr int Content::CDMA_INDEX_BASE;
constexpr int Content::CDMA_1XRTT_RADIO_INDEX;
constexpr int Content::CDMA_1XRTT_INFO_INDEX;
constexpr int Content::CDMA_1XRTT_SCH_INFO_INDEX;
constexpr int Content::CDMA_1XRTT_STATISTICS_INDEX;
constexpr int Content::CDMA_1XRTT_SERVING_INDEX;
constexpr int Content::CDMA_EVDO_SERVING_INFO_INDEX;
constexpr int Content::CDMA_EVDO_ACTIVE_SET_INDEX;
constexpr int Content::CDMA_EVDO_CANDICATE_SET_INDEX;
constexpr int Content::CDMA_EVDO_NEIGHBOR_SET_INDEX;
constexpr int Content::CDMA_EVDO_FL_INDEX;
constexpr int Content::CDMA_EVDO_RL_INDEX;
constexpr int Content::CDMA_EVDO_STATE_INDEX;
constexpr int Content::CDMA_EVDO_FORCE_TX_ANT;

// add for LGE
const int Content::LLC_EM_INFO_INDEX = 57;
constexpr int Content::UL1_EM_PRX_DRX_MEASURE_INFO_INDEX;
const int Content::ERRC_EM_SEC_PARAM_INDEX = 217;
const int Content::ERRC_EM_ERRC_STATE_INDEX = 222;
const int Content::EMM_L4C_EMM_INFO_INDEX = 244;
constexpr int Content::EL1TX_EM_TX_INFO_INDEX;
const int Content::SLCE_VOICE_INDEX = NEW_VALUE ? (IS_MOLY ? 250 : 141) : 80;
const int Content::SECURITY_CONFIGURATION_INDEX = NEW_VALUE ? (IS_MOLY ? 158 : 157) : 81;

/* Item data size */
const int Content::CELL_SEL_SIZE = 6;
const int Content::CH_DSCR_SIZE = 340;
const int Content::CTRL_CHAN_SIZE = 14;
const int Content::RACH_CTRL_SIZE = 14;
const int Content::LAI_INFO_SIZE = 28;
const int Content::RADIO_LINK_SIZE = 16;
const int Content::MEAS_REP_SIZE = 1384;
const int Content::CAL_LIST_SIZE = 260;
const int Content::CONTROL_MSG_SIZE = 4;
const int Content::SI2Q_INFO_SIZE = 10;
const int Content::MI_INFO_SIZE = 8;
const int Content::BLK_INFO_SIZE = 80;
const int Content::TBF_INFO_SIZE = 56;
const int Content::GPRS_GEN_SIZE = 32;
const int Content::URR_3G_GENERAL_SIZE = 12;

// add for LGE
const int Content::SLCE_VOICE_SIZE = 1 * 2;
const int Content::SECURITY_CONFIGURATION_SIZE = 2 * 2;

// LXO, stupid code..
const int Content::SM_EM_INFO_SIZE = 2204 * 2;
const int Content::M3G_MM_EMINFO_SIZE = 30 * 2;
const int Content::GMM_EM_INFO_SIZE = 20 * 2;
const int Content::M_3G_TCMMMI_INFO_SIZE = 7 * 2;
const int Content::CSCE_SERV_CELL_STATUS_SIZE = 52 * 2;
const int Content::CSCE_MULTI_PLMN_SIZE = 37 * 2;
const int Content::UMTS_CELL_STATUS_SIZE = 772 * 2;
const int Content::PERIOD_IC_BLER_REPORT_SIZE = 100 * 2;
const int Content::URR_UMTS_SRNC_SIZE = 2 * 2;
const int Content::SLCE_PS_DATA_RATE_STATUS_SIZE = 100 * 2;
const int Content::MEME_HSERV_CELL_SIZE = 8 * 2;

const int Content::HANDOVER_SEQUENCE_SIZE = 16 * 2; // alignment enabled
const int Content::ADM_POOL_STATUS_SIZE = 32 * 2;
const int Content::UL2_PSDATA_RATE_STATUS_SIZE = 8 * 2;
const int Content::UL_HSDSCH_RECONFIG_STATUS_SIZE = 8 * 2;
const int Content::URLC_EVENT_STATUS_SIZE = 18 * 2;
const int Content::UL_PERIOD_IC_BLER_REPORT_SIZE = 100 * 2;

const int Content::XGCSCE_NEIGH_CELL_STATUS_SIZE = 520 * 2;
Content::Content() {
    // TODO Auto-generated constructor stub

}

Content::~Content() {
    // TODO Auto-generated destructor stub
}

