/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef LYNQ_CALL_H
#define LYNQ_CALL_H 1
#include "lib_tele.h"
#ifdef __cplusplus
extern "C" {
#endif
#define LYNQ_PHONE_NUMBER_MAX 32
#define INDEX_IS_NUMBER( alpha_char )   \
   ( ( (alpha_char >= '0') && (alpha_char <= '9') ) ? 1 : 0 )
 typedef enum {
     LYNQ_CALL_ACTIVE = 0,
     LYNQ_CALL_HOLDING = 1,
     LYNQ_CALL_DIALING = 2,    /* MO call only */
     LYNQ_CALL_ALERTING = 3,   /* MO call only */
     LYNQ_CALL_INCOMING = 4,   /* MT call only */
     LYNQ_CALL_WAITING = 5       ,/* MT call only */
     LYNQ_CALL_DACTIVE=6
 } lynqCallState;

 typedef struct
{
    lynqBase base;
    int call_id;
    lynqCallState call_state;
    int toa;
    char * addr;
}lynqCallList;
typedef struct
{
    lynqBase base;
    RIL_LastCallFailCause cause_code;
    char * vendor_cause;
}lynqLastCallFailCause;
typedef int (*lynq_incoming_call_cb)(RIL_SOCKET_ID soc_id,int index, char addr[], int callState, int toa);
int lynq_init_call(lynq_incoming_call_cb call_cb);
int lynq_call(const char *addr,lynqCallList *msg);
int lynq_call_answer(lynqCallList* msg);
int lynq_call_hang_up(const int callId,lynqBase *base);
int lynq_reject_call(lynqBase *base);
int lynq_set_auto_answercall(int mode,int *status);
int lynq_get_mute_status(int *status);
int lynq_set_mute_mic(const int enable,int *status);
int lynq_set_DTMF(const char callnum,lynqBase *base);
int lynq_set_DTMF_volume(const int volume);
int lynq_do_multi_conference(lynqCallList *msg);
int lynq_othercall_hold(const int callindex,lynqBase *base);
int lynq_hangup_wating_for_call(lynqCallList *msg);
int lynq_hangup_foreground_resume_background(lynqCallList *msg);
int lynq_switch_hold_and_active_call(lynqCallList *msg);
int lynq_get_last_call_fail_cause(lynqLastCallFailCause *msg);
#ifdef __cplusplus
}
#endif
#endif
