/*
*  Copyright (C) 2014 MediaTek Inc.
*
*  Modification based on code covered by the below mentioned copyright
*  and/or permission notice(s).
*/

/* 
**
** Copyright 2006 The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <vendor-ril/telephony/ril.h>
#include <log/log.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/types.h>
/*Warren add for plantform 2021_08_11 start*/
#include "stateManager/stateManager.h"
/*Warren add for plantform 2021_08_11 end*/
#include "common.h"
/*Warren add for plantform 2021_08_11 start*/
#include <lib_tele.h>
#include <lynq_call.h>
#include <lynq_sms.h>
/*Warren add for plantform 2021_08_11 end*/
extern "C" void RIL_register (const RIL_RadioFunctions *callbacks);

extern "C" void RIL_onRequestComplete(RIL_Token t, RIL_Errno e,
                           void *response, size_t responselen);


#if defined(ANDROID_MULTI_SIM)
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen, RIL_SOCKET_ID socket_id);
#else
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen);
#endif

#undef LOG_TAG
#define LOG_TAG "DEMO_MAIN"
static struct RIL_Env s_rilEnv = {
    RIL_onRequestComplete,
    RIL_onUnsolicitedResponse,
    NULL
};
static void lynqOnUnsolicitedResponseCallback(int unsolResponse,char *response,int responselen) 
{
}
int main(int argc, char **argv)
{
    int lock_file = open("/tmp/tel_demo_single_proc.lock", O_CREAT|O_RDWR, 0666);
    int rc = flock(lock_file,LOCK_EX|LOCK_NB);
    if(rc) {
        if(EWOULDBLOCK == errno) {
            printf("Error: cannot restart the telephony app repeatedly\n");
            RLOGD("Error: cannot restart the telephony app repeatedly");
            exit(0);
        }
    }
#ifdef BASELIB_DIR_LIB64
    const char *rilLibPath = "/lib64/libvendor-ril.so";
#else
    const char *rilLibPath = "/lib/libvendor-ril.so";
#endif
    void *dlHandle;
    const RIL_RadioFunctions *(*rilInit)(const struct RIL_Env *, int, char **);

    const RIL_RadioFunctions *funcs;

    RLOGD("**RIL Daemon Started**");
    dlHandle = dlopen(rilLibPath, RTLD_NOW);

    if (dlHandle == NULL) {
        RLOGE("dlopen failed: %s", dlerror());
        exit(EXIT_FAILURE);
    }

    android::RIL_startEventLoop();
    //android::startATCILoop();
    //android::startPMLoop();
    //android::startWakupLoop();

    rilInit =
        (const RIL_RadioFunctions *(*)(const struct RIL_Env *, int, char **))
        dlsym(dlHandle, "RIL_Init");

    if (rilInit == NULL) {
        RLOGE("RIL_Init not defined or exported in %s", rilLibPath);
        exit(EXIT_FAILURE);
    }

    dlerror(); // Clear any previous dlerror
    RLOGD("start rilInit");
    funcs = rilInit(&s_rilEnv, 0, NULL);;
    RLOGD("start RIL_register");
    RIL_register(funcs);
/*Warren add for plantform 2021_08_11 start*/
    if(lynqApiInit()!=0)
    {
        RLOGD("lynq api init fail");
        exit(0);
    }
/*Warren add for plantform 2021_08_11 end*/
    android::startGdbusLoop();
    RLOGD("RIL_Init RIL_register completed");
    printf("lynq ril init  launch done!\n");
    while (true) {
        sleep(UINT32_MAX);
    }
    close(lock_file);
}
int lynq_waitToRcvCmd(char **data, int lenth)
{
    printf("--------->[%s,%d] \n",__FUNCTION__,__LINE__);
    android::getRequestData(data,lenth);
    
    return 0;
}
