#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ "$1" == "-h" ]
then
    echo -E "Usage1:$0 <type> <data> :Set test number / test URI"
    echo -E "Usage2:$0 <type> : Clear set number /set URI"
    echo -E "Usage3:$0 : clear set number and set URI"
    echo -E "type: 0 or 1, indicate number or URI"
    echo -E "data: number or uri string"
    exit 0
fi

if [ "$#" -gt 2 ]
then
    echo -E "parameter is invaild!"
    echo -E "Usage1:$0 <type> <data> :Set test number / test URI"
    echo -E "Usage2:$0 <type> : Clear set number /set URI"
    echo -E "Usage3:$0 : clear set number and set URI"
    echo -E "type: 0 or 1, indicate number or URI"
    echo -E "data: number or uri string"
    exit 0
fi

if [ "$#" -eq 2 ]
then
    type=$1
    data=$2
    echo -E "RIL_REQUEST_ECALL_SET_TEST_NUM ${type} ${data}"
elif [ "$#" -eq 1 ]
then
    type=$1
    echo -E "RIL_REQUEST_ECALL_SET_TEST_NUM ${type}"
elif [ "$#" -eq 0 ]
then
    echo -E "RIL_REQUEST_ECALL_SET_TEST_NUM"
else
    echo -E "wrong parameters"
fi



#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

if [ "$#" -eq 2 ]
then
    echo "RIL_REQUEST_ECALL_SET_TEST_NUM ${type} ${data}"  >&9
elif [ "$#" -eq 1 ]
then
    echo "RIL_REQUEST_ECALL_SET_TEST_NUM ${type}"  >&9
elif [ "$#" -eq 0 ]
then
    echo "RIL_REQUEST_ECALL_SET_TEST_NUM"  >&9
else
    exit 0
fi

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
