/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_UTIL_PROXYCONTROLLER_H_
#define SRC_UTIL_PROXYCONTROLLER_H_

#include <vector>
#include <atomic>
#include <mutex>
#include <string>

#include <utils/Looper.h>
#include <utils/Thread.h>
#include <utils/RefBase.h>
#include <vendor-ril/telephony/ril.h>

using ::android::Looper;
using ::android::Thread;
using ::android::MessageHandler;
using ::android::Message;
using ::android::sp;
using ::android::RefBase;

class Proxy_controller: public RefBase {
public:
    static constexpr int EVENT_NOTIFICATION_RC_CHANGED = 1;
    static constexpr int EVENT_START_RC_RESPONSE = 2;
    static constexpr int EVENT_APPLY_RC_RESPONSE = 3;
    static constexpr int EVENT_FINISH_RC_RESPONSE = 4;
    static constexpr int EVENT_TIMEOUT = 5;

    static const int SET_RC_STATUS_IDLE;
    static const int SET_RC_STATUS_STARTING;
    static const int SET_RC_STATUS_STARTED;
    static const int SET_RC_STATUS_APPLYING;
    static const int SET_RC_STATUS_SUCCESS;
    static const int SET_RC_STATUS_FAIL;

    // The entire transaction must complete within this amount of time
    // or a FINISH will be issued to each Logical Modem with the old
    // Radio Access Family.
    static const int SET_RC_TIMEOUT_WAITING_MSEC;
    static const std::string PROPERTY_CAPABILITY_SWITCH;
    static const std::string PROPERTY_CAPABILITY_SWITCH_STATE;

// event 1-5 is defined in ProxyController
    static const int EVENT_RADIO_AVAILABLE;
    static const int EVENT_RIL_CONNECTED;

// marker for retry cause
    static const int RC_RETRY_CAUSE_NONE;
    static const int RC_RETRY_CAUSE_WORLD_MODE_SWITCHING;
    static const int RC_RETRY_CAUSE_CAPABILITY_SWITCHING;
    static const int RC_RETRY_CAUSE_IN_CALL;
    static const int RC_RETRY_CAUSE_RADIO_UNAVAILABLE;
    static const int RC_RETRY_CAUSE_AIRPLANE_MODE;
    static const int RC_RETRY_CAUSE_RESULT_ERROR;

// marker for switch conditions pre-checking
    static const int RC_DO_SWITCH;
    static const int RC_NO_NEED_SWITCH;
    static const int RC_CANNOT_SWITCH;
//***** Class Variables
private:
    bool mIsCapSwitching;
    bool mHasRegisterWorldModeReceiver;
    bool mHasRegisterPhoneStateReceiver;
    bool mHasRegisterEccStateReceiver;
    bool mIsRildReconnected;
    std::vector<RIL_RadioAccessFamily> mNextRafs;
    int mSetRafRetryCause;
// Exception counter
    int onExceptionCount;
public:
    static Proxy_controller* sInstance;
    static Proxy_controller *getInstance();

    Proxy_controller();
    virtual ~Proxy_controller();
    int checkRadioCapabilitySwitchConditions(std::vector<RIL_RadioAccessFamily> rafs);
    bool isNeedSimSwitch(int majorPhoneId, int phoneNum);
    bool isEccInProgress();
    class Handle_thread: public Thread {
    public:
        Handle_thread();
        virtual ~Handle_thread();
        sp<Looper> getLooper();

    protected:
        virtual bool threadLoop();
    private:
        sp<Looper> m_looper;
    };

    class Request_message: public RefBase {
    public:
        Request_message();
        virtual ~Request_message() {};

    public:
        int what;
        int slot;
        int id;
        RIL_Errno e;
        RIL_RadioCapability cap;
        bool is_rc_set;
    };

    class Request_handler: public MessageHandler {
    public:
        Request_handler(Proxy_controller* proxy): proxy_controller(proxy){}
        virtual ~Request_handler() {}

    public:
        void sendMessage(sp<Request_message> msg, int delayms);
        void handleMessage(const Message& message);
        sp<Request_message> msg;
        // dummy message that makes handler happy
        Message m_dummyMsg;
    private:
        Proxy_controller* proxy_controller;
    };
public:
    // send message to request handler
    sp<Request_handler> sendMessage(sp<Request_message> msg, int delayms);
    void handle_request_resp(RIL_RadioCapability* cap, RIL_Errno e, int slot);
    void handle_message_notify(RIL_RadioCapability* cap,int slot);
    bool doSetRadioCapabilities(std::vector<RIL_RadioAccessFamily> rafs);
    bool set_Radio_Capability(std::vector<RIL_RadioAccessFamily> rafs);
private:
    sp<Request_handler> timeout_handle;
    sp<Handle_thread> handle_thread;
    void init();
    void clearTransaction();
    void resetRadioAccessFamilyStatusCounter();
    std::string getLogicalModemIdFromRaf(int raf);
    void sendRadioCapabilityRequest(int phoneId, int sessionId, int rcPhase,
                int radioFamily, std::string logicalModemId, int status, int eventId);
    void onStartRadioCapabilityResponse(sp<Request_message> msg);
    void onApplyRadioCapabilityResponse(sp<Request_message> msg);
    void onApplyRadioCapabilityErrorHandler(sp<Request_message> msg);
    void onFinishRadioCapabilityResponse(sp<Request_message> msg);
    void onTimeoutRadioCapability(sp<Request_message> msg);
    void onApplyExceptionHandler(sp<Request_message> msg);
    void onNotificationRadioCapabilityChanged(sp<Request_message> msg);
    void completeRadioCapabilityTransaction();
    void issueFinish(int sessionId);
private:
    std::atomic_int mRadioCapabilitySessionId;
    std::mutex m_mutex;
    // record each phone's set radio capability status
    std::vector<int> mSetRadioAccessFamilyStatus;
    int mRadioAccessFamilyStatusCounter;
    bool mTransactionFailed;

    std::vector<std::string> mCurrentLogicalModemIds;
    std::vector<std::string> mNewLogicalModemIds;

     // Record new and old Radio Access Family (raf) configuration.
     // The old raf configuration is used to restore each logical modem raf when FINISH is
     // issued if any requests fail.
    std::vector<int> mNewRadioAccessFamily;
    std::vector<int> mOldRadioAccessFamily;
    std::vector<int> m_eventId;
};


#endif /* SRC_UTIL_PROXYCONTROLLER_H_ */
