/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <bitset>

#include "IndividualRecord.h"
#include "../utils/GostEcallUtils.h"

using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_IndividualRecord"

std::atomic_uint16_t IndividualRecord::initRecNum (0);

IndividualRecord::IndividualRecord() {
    RL = 0; //little-endian = 0;
    RN = 0; //little-endian = 0;

    RFL = 0;
    SSOD = UINT8_MAX;
    RSOD = UINT8_MAX;
    RPP = UINT8_MAX;
    TMFE = 0;
    EVFE = 0;
    OBFE = 0;

    OID = UINT32_MAX; //O, depends: OBFE
    EVID = UINT32_MAX; //O,depends: EVFE
    TM = UINT32_MAX; //O, depends: TMFE
    SST = UINT8_MAX;
    RST = UINT8_MAX;
    RD="";
}

IndividualRecord::~IndividualRecord() {
}

std::uint8_t IndividualRecord::getEvfe() const {
    return EVFE;
}

void IndividualRecord::setEvfe(std::uint8_t evfe) {
    EVFE = evfe;
}

std::uint32_t IndividualRecord::getEvid() const {
    return EVID;
}

void IndividualRecord::setEvid(std::uint32_t evid) {
    EVID = evid;
}

std::uint8_t IndividualRecord::getObfe() const {
    return OBFE;
}

void IndividualRecord::setObfe(std::uint8_t obfe) {
    OBFE = obfe;
}

std::uint32_t IndividualRecord::getOid() const {
    return OID;
}

void IndividualRecord::setOid(std::uint32_t oid) {
    OID = oid;
}

//const std::vector<std::uint8_t>& IndividualRecord::getRd() const {
//    return RD;
//}
//
//void IndividualRecord::setRd(const std::vector<std::uint8_t> &rd) {
//    RD = rd;
//}

std::uint8_t IndividualRecord::getRfl() const {
    return RFL;
}

void IndividualRecord::setRfl(std::uint8_t rfl) {
    RFL = rfl;
}

std::uint16_t IndividualRecord::getRl() const {
    return RL;
}

void IndividualRecord::setRl(std::uint16_t rl) {
    RL = rl;
}

std::uint16_t IndividualRecord::getRn() const {
    return RN;
}

void IndividualRecord::setRn(std::uint16_t rn) {
    RN = rn;
}

std::uint8_t IndividualRecord::getRpp() const {
    return RPP;
}

void IndividualRecord::setRpp(std::uint8_t rpp) {
    RPP = rpp;
}

std::uint8_t IndividualRecord::getRsod() const {
    return RSOD;
}

void IndividualRecord::setRsod(std::uint8_t rsod) {
    RSOD = rsod;
}

std::uint8_t IndividualRecord::getSsod() const {
    return SSOD;
}

void IndividualRecord::setSsod(std::uint8_t ssod) {
    SSOD = ssod;
}

std::uint32_t IndividualRecord::getTm() const {
    return TM;
}

void IndividualRecord::setTm(std::uint32_t tm) {
    TM = tm;
}

std::uint8_t IndividualRecord::getTmfe() const {
    return TMFE;
}

void IndividualRecord::setTmfe(std::uint8_t tmfe) {
    TMFE = tmfe;
}

const std::string& IndividualRecord::getRd() const {
    return RD;
}

void IndividualRecord::setRd(const std::string rd) {
    RD = rd;
}

std::uint8_t IndividualRecord::getRst() const {
    return RST;
}

void IndividualRecord::setRst(std::uint8_t rst) {
    RST = rst;
}

std::uint8_t IndividualRecord::getSst() const {
    return SST;
}

std::string IndividualRecord::encodeAllSubRecords(std::uint8_t sst, std::uint8_t rst,std::uint8_t srt, std::string msd) {
    std::shared_ptr<IndividualSubRecord> enSubRecords = std::make_shared<IndividualSubRecord>(sst, rst);
    enSubRecords->setSrt(srt);

    //encode RD;
    std::string rd = enSubRecords->encodeAllService(msd);
    MTK_RLOGD("RD encode result is: %s", rd.c_str());
    if(rd.empty()) {
        MTK_RLOGW("encode RD fail");
        return "";
    }

    //encode RL
    std::string rl = encodeValue((rd.size()/2), 4, "RL");
    MTK_RLOGD("RL encode result is: %s", rl.c_str());
    if(rl.empty()) {
        MTK_RLOGW("encode RL fail");
        return "";
    }

    //encode RN
    std::string rn = encodeValue(generalRecodeNum(), 4, "RN");
    MTK_RLOGD("RN encode result is: %s", rn.c_str());
    if(rn.empty()) {
        MTK_RLOGW("encode RN fail");
        return "";
    }

    //encode RFL
    bitset<8> rfl;
    rfl[7] = 1; //SSOD
    std::string rflStr = encodeValue(rfl.to_ulong(), 2, "RFL");
    MTK_RLOGD("RFL encode result is: %s", rflStr.c_str());
    if(rflStr.empty()) {
        MTK_RLOGW("encode RFL fail");
        return "";
    }

    //encode SST
    std::string sstStr = encodeValue(sst, 2, "SST");
    if(sstStr.empty()) {
        MTK_RLOGW("encode SST fail");
        return "";
    }

    //encode RST
    std::string rstStr = encodeValue(rst, 2, "RST");
    if(rstStr.empty()) {
        MTK_RLOGW("encode RST fail");
        return "";
    }

    return rl + rn + rflStr + sstStr + rstStr + rd;
}

void IndividualRecord::setSst(std::uint8_t sst) {
    SST = sst;
}

int IndividualRecord::decodeAllSubRecords() {
    if(RD.empty()) {
        MTK_RLOGW("record data is null , just return");
        return -1;
    }
    MTK_RLOGD("RD: %s", RD.c_str());
    uint32_t index = 0;
    int64_t ret = 0;
    while(index < RD.length()) {
        std::shared_ptr<IndividualSubRecord> subRec = make_shared<IndividualSubRecord>(SST, RST);
        //decode SRT(Subrecord type)
        ret = decodeValue(RD, index, 2, "SRT(Subrecord type)");
        if(ret == -1) {
            MTK_RLOGW("decode SRT fail");
            return -1;
        }
        MTK_RLOGD("index: %d, SRT: 0X%02x",index, (uint8_t)ret);
        subRec->setSrt((uint8_t)ret);

        //SRL(subrecord length)
        ret = decodeValue(RD, index, 4, "SRL(subrecord length)");
        if(ret == -1) {
            MTK_RLOGW("decode SRL fail");
            return -1;
        }
        MTK_RLOGD("index: %d, SRL: 0X%04x",index, (uint16_t)ret);
        subRec->setSrl((uint16_t)ret);

        //decode SRD(subrecord Data);
        if(subRec->getSrl() > 0) {
            std::string sub = decodeData(RD, subRec->getSrl(), "SRD(subrecord Data)", index);
            if(sub.empty()) {
                MTK_RLOGW("decode RD fail");
                return -1;
            }
            MTK_RLOGD("index: %d, SRD: %s",index, sub.c_str());
            subRec->setSrd(sub);
            ret = subRec->decodeAllService();
            if(ret == -1) {
                MTK_RLOGW("decodeAllService() fail");
                return -1;
            }
            deSubRecords.push_back(subRec);
        }
    }
    return 0;
}

bool IndividualRecord::isIncludedCmdCode(std::uint16_t cmd) {
    MTK_RLOGD("cmd=0X%04X", cmd);
    if(deSubRecords.size() == 0) {
        MTK_RLOGW("no decode sub records");
        return false;
    }
    bool ret = false;
    for(auto &rec : deSubRecords) {
        ret = rec->isIncludedCmdCode(cmd);
        if(ret)
        {
            MTK_RLOGD("cmd=0X%04X is included",cmd);
            break;
        }
    }
    return ret;
}

std::string IndividualRecord::encodeAck(std::uint8_t sst_value, std::uint8_t rst_value, std::uint8_t subType, std::uint16_t cmd, bool ack) {

    //encode RD;
    std::string rd("");
    for(auto &rec : deSubRecords) {
        if(rec->isIncludedCmdCode(cmd)) {
            rd += rec->encodeAck(subType, cmd, ack);
        }
    }

    //encode RL
    std::string rl = encodeValue((rd.size()/2), 4, "RL");
    MTK_RLOGD("encode RL(0X%04X) result: %s",rd.size()/2, rl.c_str());

    //encode RN
    std::uint16_t value = generalRecodeNum();
    std::string rn = encodeValue(value, 4, "RL");
    MTK_RLOGD("encode RN(0X%04X) result: %s",value, rn.c_str());

    bitset<8> rfl;
    rfl[7] = 1;
    std::string rflStr = encodeValue(rfl.to_ulong(), 2, "RFL");
    MTK_RLOGD("encode RFL(0X%02X) result: %s",rfl.to_ulong(), rflStr.c_str());

    //encode SST
    std::string sst = encodeValue(sst_value, 2, "SST");
    MTK_RLOGD("encode SST(%d) result: %s",sst_value, sst.c_str());

    //encode RST
    std::string rst = encodeValue(rst_value, 2, "RST");
    MTK_RLOGD("encode RST(%d) result: %s",rst_value, rst.c_str());
    return rl + rn + rflStr + sst + rst + rd;
}

bool IndividualRecord::isNeedNewSms() {
    if(deSubRecords.size() == 0) {
        MTK_RLOGW("no decode sub records");
        return false;
    }
    bool ret = false;
    for(auto &rec : deSubRecords) {
        ret = rec->isIncludedCmdCode(EcallUtils::EGTS_ECALL_MSD_REQ);
        if(ret)
        {
            MTK_RLOGD("EGTS_ECALL_MSD_REQ is included");
            ret = rec->isNeedNewSms();
            break;
        }
    }
    return ret;
}

int IndividualRecord::getEcallReqPara() {
    if(deSubRecords.size() == 0) {
        MTK_RLOGW("no decode sub records");
        return 0;
    }
    int ret = 0;
    for(auto &rec : deSubRecords) {
        bool isExsit = rec->isIncludedCmdCode(EcallUtils::EGTS_ECALL_REQ);
        if(isExsit)
        {
            MTK_RLOGD("EGTS_ECALL_REQ is included");
            ret = rec->getEcallReqPara();
            break;
        }
    }
    return ret;
}

std::uint16_t IndividualRecord::generalRecodeNum() {
    return initRecNum++;
}
