/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <cstdlib>
#include <cstring>
#include <bitset>

#include "SslpManager.h"
#include "../utils/GostEcallUtils.h"
#include "./ecall/EcallUtils.h"

using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_SslpManager"

SslpManager::SslpManager() {
    // TODO Auto-generated constructor stub

}

SslpManager::~SslpManager() {
    // TODO Auto-generated destructor stub
}

int SslpManager::decodeAllRecords(const char* sfrd , std::uint16_t len) {
    if(sfrd == NULL || len == 0) {
        MTK_RLOGW("srfd, service frame data is invalid");
        return -1;
    }

    std::string str(sfrd);
    if(str.size() != len * 2) {
        MTK_RLOGW("srfd size(%llu) != len(%d)*2, service frame data is invalid, just return", str.size(), (len*2));
        return -1;
    }

    // must be even
    if ((str.size()) & 1) {
        MTK_RLOGW("srfd size(%llu) isn't even, service len is invalid, just return", str.size());
        return -1;
    }

    MTK_RLOGD("sfrd(%d): %s",len*2, (sfrd == NULL ? "":sfrd));
    uint32_t index = 0;
    int64_t ret = 0;
    while(index < str.length()) {
        std::shared_ptr<IndividualRecord> rec = make_shared<IndividualRecord>();
        //decode RL
        ret = decodeValue(str, index, 4, "RL(Record Length)");
        if(ret == -1) {
            MTK_RLOGW("decode RL fail");
            return -1;
        }
        MTK_RLOGD("index: %d, RL: 0X%04x",index, (uint16_t)ret);
        rec->setRl((uint16_t)ret);

        //decode RN
        ret = decodeValue(str, index, 4, "RN(Record Number)");
        if(ret == -1) {
            MTK_RLOGW("decode RN fail");
            return -1;
        }
        MTK_RLOGD("index: %d, RN: 0X%04x",index, (uint16_t)ret);
        rec->setRn((uint16_t)ret);

        //decode RFL(record flags)
        ret = decodeValue(str, index, 2, "RFL(record flags)");
        if(ret == -1) {
            MTK_RLOGW("decode RFL fail");
            return -1;
        }
        MTK_RLOGD("index: %d, RFL: 0X%02x",index, (uint8_t)ret);
        rec->setRfl((uint8_t)ret);
        bitset<8> rfl(rec->getRfl());
        rec->setSsod(rfl[7]);
        rec->setRsod(rfl[6]);
        rec->setRpp((rfl[5]<<2)|(rfl[4]<<1)|(rfl[3]));
        rec->setTmfe(rfl[2]);
        rec->setEvfe(rfl[1]);
        rec->setObfe(rfl[0]);
        MTK_RLOGD("ssod=%d, rsod=%d, rpp=%d, tmfe=%d, evfe=%d, obfe=%d",
                rec->getSsod(),
                rec->getRsod(),
                rec->getRpp(),
                rec->getTmfe(),
                rec->getEvfe(),
                rec->getObfe());

        //decode OID(object Identifier)
        if(rec->getObfe()) {
            ret = decodeValue(str, index, 8, "OID(object Identifier)");
            if(ret == -1) {
                MTK_RLOGW("decode OID fail");
                return -1;
            }
            MTK_RLOGD("index: %d, OID: 0X%08x",index, (uint32_t)ret);
            rec->setOid((uint32_t)ret);
        }

        //decode EVID(Event Identifier)
        if(rec->getEvfe()) {
            ret = decodeValue(str, index, 8, "EVID(Event Identifier)");
            if(ret == -1) {
                MTK_RLOGW("decode EVID fail");
                return -1;
            }
            MTK_RLOGD("index: %d, EVID: 0X%08x",index, (uint32_t)ret);
            rec->setEvid((uint32_t)ret);
        }

        //decode TM(Time)
        if(rec->getTmfe()) {
            ret = decodeValue(str, index, 8, "TM(Time)");
            if(ret == -1) {
                MTK_RLOGW("decode TM fail");
                return -1;
            }
            MTK_RLOGD("index: %d, TM: 0X%08x",index, (uint32_t)ret);
            rec->setTm((uint32_t)ret);
        }

        //decode SST(source service type)
        ret = decodeValue(str, index, 2, "SST(source service type)");
        if(ret == -1) {
            MTK_RLOGW("decode SST fail");
            return -1;
        }
        MTK_RLOGD("index: %d, SST: 0X%02x",index, (uint8_t)ret);
        rec->setSst((uint8_t)ret);

        //decode RST(recipient service type)
        ret = decodeValue(str, index, 2, "RST(recipient service type)");
        if(ret == -1) {
            MTK_RLOGW("decode RST fail");
            return -1;
        }
        MTK_RLOGD("index: %d, RST: 0X%02x",index, (uint8_t)ret);
        rec->setRst((uint8_t)ret);

        //decode RD(record Data);
        std::string sub = decodeData(str, rec->getRl(), "RD(record Data)", index);
        if(sub.empty()) {
            MTK_RLOGW("decode RD fail");
            return -1;
        }
        MTK_RLOGD("index: %d, RD: %s",index, sub.c_str());
        rec->setRd(sub);
        ret = rec->decodeAllSubRecords();
        if(ret == -1) {
            MTK_RLOGW("decodeAllSubRecords() fail");
            return -1;
        }
        deRecords.push_back(rec);
    }
    return 0;
}

bool SslpManager::isIncludedCmdCode(std::uint16_t cmd) {
    MTK_RLOGD("cmd=0X%04X", cmd);
    if(deRecords.size() == 0) {
        MTK_RLOGW("no decode records");
        return false;
    }
    bool ret = false;
    for(auto &rec : deRecords) {
        ret = rec->isIncludedCmdCode(cmd);
        if(ret)
        {
            MTK_RLOGD("cmd=0X%04X is included",cmd);
            break;
        }
    }
    return ret;
}

std::vector<std::shared_ptr<IndividualRecord> >& SslpManager::getDeRecords() {
    return deRecords;
}

std::string SslpManager::encodeAllRecords(std::uint8_t sst, std::uint8_t rst,std::uint8_t srt, std::string msd) {
    std::shared_ptr<IndividualRecord> enRecords = std::make_shared<IndividualRecord>();
    std::string sslp = enRecords->encodeAllSubRecords(sst,rst, srt, msd);
    MTK_RLOGD("sslp: %s", sslp.c_str());
    return sslp;
}

std::string SslpManager::encodeAck(std::uint8_t sst_value, std::uint8_t rst_value, std::uint8_t subType,
        std::uint16_t cmd, bool ack) {
    std::string sslp("");
    for(auto &rec : deRecords) {
        if(rec->isIncludedCmdCode(cmd)) {
            sslp += rec->encodeAck(sst_value, rst_value, subType, cmd, ack);
        }
    }
    MTK_RLOGD("sslp: %s", sslp.c_str());
    return sslp;
}

bool SslpManager::isNeedNewSms() {
    if(deRecords.size() == 0) {
        MTK_RLOGW("no decode records");
        return false;
    }
    bool ret = false;
    for(auto &rec : deRecords) {
        ret = rec->isIncludedCmdCode(EcallUtils::EGTS_ECALL_MSD_REQ);
        if(ret)
        {
            MTK_RLOGD("EGTS_ECALL_MSD_REQ is included");
            ret = rec->isNeedNewSms();
            break;
        }
    }
    return ret;
}

int SslpManager::getEcallReqPara() {
    if(deRecords.size() == 0) {
        MTK_RLOGW("no decode records");
        return 0;
    }
    int ret = 0;
    for(auto &rec : deRecords) {
        bool isExsit = rec->isIncludedCmdCode(EcallUtils::EGTS_ECALL_REQ);
        if(isExsit)
        {
            MTK_RLOGD("EGTS_ECALL_REQ is included");
            ret = rec->getEcallReqPara();
            break;
        }
    }
    return ret;
}
