#ifndef __LYNQ_INTERFACE_H__
#define __LYNQ_INTERFACE_H__


#define LYNQ_REQUEST_VENDOR_BASE 8000
#define LYNQ_URC_VENDOR_BASE 9000
#define LYNQ_AT_SNED (LYNQ_REQUEST_VENDOR_BASE +1)
#define LYNQ_URC_CALL_STATUS_IND (LYNQ_URC_VENDOR_BASE+1)
#define LYNQ_URC_DATA_STATUS_IND (LYNQ_URC_VENDOR_BASE+2)
#define LYNQ_URC_DATA_CALL_STATUS_IND (LYNQ_URC_VENDOR_BASE+3)
#define LYNQ_AUTO_ANSWER_CALL (LYNQ_REQUEST_VENDOR_BASE +2)
#define LYNQ_REQUEST_SET_DTMF_VOLUME (LYNQ_REQUEST_VENDOR_BASE +3)
#define LYNQ_URC_MODIFY_APNDB (LYNQ_URC_VENDOR_BASE+4)
#define LYNQ_URC_RESET_APNDB (LYNQ_URC_VENDOR_BASE+5)

#define LYNQ_URC_ALLOW_DATA (LYNQ_URC_VENDOR_BASE + 10)

#define LYNQ_REQUEST_WRITE_SMS_TO_MEMORY (LYNQ_REQUEST_VENDOR_BASE +4)
#define LYNQ_REQUEST_READ_SMS_FROM_MEMORY (LYNQ_REQUEST_VENDOR_BASE + 5)
#define LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY (LYNQ_REQUEST_VENDOR_BASE + 6)
#define LYNQ_REQUEST_LIST_SMS_FROM_MEMORY (LYNQ_REQUEST_VENDOR_BASE + 7)
#define LYNQ_REQUEST_SET_DEFAULT_SIM_ALL (LYNQ_REQUEST_VENDOR_BASE + 8)

#define LYNQ_REQUEST_SET_SPEECH_VOLUME (LYNQ_REQUEST_VENDOR_BASE +9)
#define LYNQ_REQUEST_GET_SPEECH_VOLUME (LYNQ_REQUEST_VENDOR_BASE +10)
#define LYNQ_REQUEST_RECORD  (LYNQ_REQUEST_VENDOR_BASE +11)
#define LYNQ_REQUEST_OOS_RECOVER_TIMER_INTERVAL (LYNQ_REQUEST_VENDOR_BASE +12)
#define LYNQ_REQUEST_OOS_DEEP_SLEEP_RECOVER_TIMER_INTERVAL (LYNQ_REQUEST_VENDOR_BASE +13)
#define LYNQ_REQUEST_CHANGE_SCREEN_STATE (LYNQ_REQUEST_VENDOR_BASE + 14)/*jb.qi add for two sim suspend 2022/9/19*/
#define LYNQ_REQUEST_CHANGE_RADIO (LYNQ_REQUEST_VENDOR_BASE + 15)
#define LYNQ_REQUEST_SET_VOICE_AUDIO_MODE (LYNQ_REQUEST_VENDOR_BASE + 16)
#define LYNQ_REQUEST_SET_REMOTE_RTP_IP (LYNQ_REQUEST_VENDOR_BASE + 17)
#define LYNQ_REQUEST_SET_VLAN_INFO (LYNQ_REQUEST_VENDOR_BASE + 18)
#define LYNQ_REQUEST_SET_RTP_PORT (LYNQ_REQUEST_VENDOR_BASE + 19)
#define LYNQ_REQUEST_SET_RTP_PARAM (LYNQ_REQUEST_VENDOR_BASE + 20)
#define LYNQ_REQUEST_GET_VOICE_AUDIO_MODE (LYNQ_REQUEST_VENDOR_BASE + 21)
#define LYNQ_REQUEST_GET_REMOTE_RTP_IP (LYNQ_REQUEST_VENDOR_BASE + 22)
#define LYNQ_REQUEST_GET_VLAN_INFO (LYNQ_REQUEST_VENDOR_BASE + 23)
#define LYNQ_REQUEST_GET_RTP_PORT (LYNQ_REQUEST_VENDOR_BASE + 24)
#define LYNQ_REQUEST_GET_RTP_PARAM (LYNQ_REQUEST_VENDOR_BASE + 25)
#define LYNQ_REQUEST_SET_CALL_RTP_SSRC (LYNQ_REQUEST_VENDOR_BASE + 26)
#define LYNQ_REQUEST_GET_CALL_RTP_SSRC (LYNQ_REQUEST_VENDOR_BASE + 27)
#define LYNQ_REQUEST_GET_DEFAULT_SIM_ALL (LYNQ_REQUEST_VENDOR_BASE + 28)
#define LYNQ_REQUEST_SET_DEFAULT_SIM_ALL_EXCEPT_DATA (LYNQ_REQUEST_VENDOR_BASE + 29)

#ifdef ECALL_SUPPORT
#define RIL_UNSOL_ECALL_T2_TIMER_OUT  9000
#define RIL_UNSOL_ECALL_T5_TIMER_OUT  9001
#define RIL_UNSOL_ECALL_T6_TIMER_OUT  9002
#define RIL_UNSOL_ECALL_T7_TIMER_OUT  9003
#define RIL_UNSOL_ECALL_REDIAL_TIMER_OUT 9004
#define RIL_UNSOL_ECALL_AUTO_ANS_TIMER_OUT 9005
#define RIL_UNSOL_ECALL_AUTO_ANS_IMS_TIMER_OUT 9006
#endif
//Warren add for plantform 2024_04_11 start
/* 
**The range of error values unique to LYNQ is 7000 to 10000.
**The sim card state is error.
*/
typedef enum{
    /*base abnormal*/
    LYNQ_E_PARAMETER_ANONALY=7000,
    LYNQ_E_SEND_REQUEST_FAIL=7001,
    LYNQ_E_GET_HEAD_ERROR=7002,
    LYNQ_E_INNER_ERROR=7100,
    LYNQ_E_MALLOC_ERROR=7101,
    /**/
    LYNQ_E_CARDSTATE_ERROR=8000,
    /* The voice service state is out of service*/
    LYNQ_E_STATE_OUT_OF_SERVICE=8001,
    /* The voice service state is EMERGENCY_ONLY*/
    LYNQ_E_STATE_EMERGENCY_ONLY=8002,
    /* The radio power is power off*/
    LYNQ_E_STATE_POWER_OFF=8003,
    LYNQ_E_TIME_OUT=8004,
    /*create or open sms DB fail */
    LYNQ_E_SMS_DB_FAIL=8005,
    /*Failed to execute sql statement*/
    LYNQ_E_SMS_SQL_FAIL = 8006,
    LYNQ_E_SMS_NOT_FIND = 8007,
    /* The logic conflict*/
    LYNQ_E_CONFLICT=9000,
    /*Null anomaly*/
    LYNQ_E_NULL_ANONALY=9001,
    /*Invalid id anomaly*/
    LYNQ_E_INVALID_ID_ANONALY=9002,
#ifdef ECALL_SUPPORT
    LYNQ_E_ECALL_BEING_RUNNING =9003,
    LYNQ_E_ECALL_MSD_LENGTH_ERROR =9004,
    LYNQ_E_ECALL_DAILING_NO_ANSWER =9005,
#endif
}LYNQ_E;

typedef struct{
    int request;
    int waitTime;
    char * name;
}lynq_sp_command_t;

#endif  //__LYNQ_INTERFACE_H__

