#ifndef CALL_RTP_INNER_H
#define CALL_RTP_INNER_H 1

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_IP_LENGTH 128
#define MAX_VLAN_INFO_LENGTH 32
#define MAX_SSRC_INFO_LENGTH 10   /*2^32=4294967296, 10 digit*/

typedef enum{
    RTP_CLIENT = 0,     
    RTP_SERVER =1,
    RTP_MODE_MAX
}LYNQ_Rtp_Mode;

#define RTP_FROM_CMD "gst-launch-1.0 -v udpsrc port=%d caps=\'application/x-rtp, media=(string)audio, clock-rate=(int)%d, channels=(int)%d\' ! rtpjitterbuffer latency=%d ! rtpL16depay ! audioconvert ! alsasink device=\'hw:0,2\'"
#define RTP_TO_CMD   "gst-launch-1.0 -v alsasrc device=\'hw:0,6\' ! audioconvert ! audio/x-raw,format=S16BE, channels=%d ! audioresample  ! audio/x-raw, rate=%d ! rtpL16pay ! %s udpsink host=%s %s auto-multicast=true port=%d"                        
#define RTP_VLAN_INFO_FORMAT "multicast-iface=\"%s\""
#define RTP_SSRC_INFO_FORMAT " rtpmux name=mux ssrc=%u !"

#define USER_LOG_TAG "LYNQ_CALL"

#define RESULT_OK (0)
#define RESULT_ERROR (-1)

typedef enum{
    Rtp_Ssrc_random = 0,     
    Rtp_Ssrc_specific =1,   
}LYNQ_Rtp_Ssrc_Mode;

typedef struct
{   
    char ip[MAX_IP_LENGTH];
    int port;   
    int ssrc_mode;
    unsigned int ssrc;
    char vlan_info[MAX_VLAN_INFO_LENGTH];
}lynq_rtp_server_info;

typedef struct
{       
    int port;
    int clockrate;  
    int latency;
    int channels;
}lynq_rtp_client_info;

/*set*/
int exe_set_remote_rtp_ip(const char* ip, const int ip_length);
int exe_set_vlan_info(const char* vlan_info, const int vlan_info_length);
int exe_set_rtp_port(const LYNQ_Rtp_Mode rtp_mode, const int port);
int exe_set_rtp_param(const int clock_rate,const int channels,const int latency); //only for client
int exe_set_call_rtp_ssrc(const int ssrc_mode, const unsigned int ssrc);
/*get*/
LYNQ_Audio_Mode exe_get_voice_audio_mode();
int exe_get_remote_rtp_ip(char* ip, const int ip_length);
int exe_get_vlan_info(char* vlan_info, const int vlan_info_length);
int exe_get_rtp_port(const LYNQ_Rtp_Mode rtp_mode, int* port);
int exe_get_rtp_param(int* clock_rate,int* channels, int* latency);//only for client
int exe_get_call_rtp_ssrc(int* ssrc_mod, unsigned int* ssrc);
/*Audio Path setting end*/

#ifdef __cplusplus
}
#endif
#endif
