#include <log/log.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
extern "C" {
#include <gio/gio.h>
#include "liblog/lynq_deflog.h"
#include <glib.h>
}
#include "broadcast/broadcast_service.h"
#define LOG_TAG "BROABCAST_SERVICE"

#define BROADCAST_SERVICE "broadcast.lynq" /*well-known bus name */
#define BROADCAST_DATA_INTERFACE "broadcast.lynq.Data" /*interface name*/
#define BROADCAST_DATA_PATH "/broadcast/lynq/data" /*object name*/
static pthread_t s_tid_dispatch;
static GDBusNodeInfo *introspection_data = NULL;
static GHashTable *hashTable = NULL;
static GAsyncQueue *queue;	
static int fp = -1;
static int switch_status = -1;
//void init_trigger_file();
static const gchar introspection_xml[] =
        "<node>"
        "  <interface name='broadcast.lynq.Data'>"
        "    <method name='send_broadcast_by_name'>"
        "      <arg name='broadcast_name' type='s' direction='in'/>"
        "      <arg name='broadcast_length' type='i' direction='in'/>"
        "      <arg name='broadcast_prame' type='s' direction='in'/>"
        "    </method>"
        "    <method name='send_broadcast_by_id'>"
        "      <arg name='broadcast_id' type='i' direction='in'/>"
        "      <arg name='broadcast_length' type='i' direction='in'/>"
        "      <arg name='broadcast_prame' type='s' direction='in'/>"
        "    </method>"
        "    <method name='send_broadcast_param_unfixed'>"
        "      <arg name='broadcast_id' type='s' direction='in'/>"
        "      <arg name='broadcast_prame' type='*' direction='in'/>"
        "    </method>"
        "    <signal name='broadcast_to_name'>"
        "      <arg name='broadcast_name' type='s'/>"
        "      <arg name='broadcast_length' type='i'/>"
        "      <arg name='broadcast_prame' type='s'/>"
        "    </signal>"
        "    <signal name='broadcast_to_id'>"
        "      <arg name='broadcast_name' type='i'/>"
        "      <arg name='broadcast_length' type='i'/>"
        "      <arg name='broadcast_prame' type='s'/>"
        "    </signal>"
        "    <signal name='broadcast_parme_unfixed'>"
        "      <arg name='broadcast_name' type='s'/>"
        "      <arg name='broadcast_prame' type='*'/>"
        "    </signal>"
        "  </interface>"
        "</node>";


static void
broadcast_interface (GDBusConnection       *connection,
                    const gchar           *sender,
                    const gchar           *object_path,
                    const gchar           *interface_name,
                    const gchar           *method_name,
                    GVariant              *parameters,
                    GDBusMethodInvocation *invocation,
                    gpointer               user_data)
{
    LYDBGLOG("method_name:%s,%s, %s, %d",method_name, __FILE__, __FUNCTION__, __LINE__);
    if (g_strcmp0 (method_name, "send_broadcast_by_name") == 0)
    {
       GError *error = NULL;
       g_dbus_connection_emit_signal(connection,
                                    NULL,
                                    BROADCAST_DATA_PATH,
                                    BROADCAST_DATA_INTERFACE,
                                    "broadcast_to_name",
                                    parameters,
                                    &error);
        if (error) {
            LYDBGLOG("g_dbus_connection_emit_signal error");
             g_error_free(error);
        }
        g_dbus_method_invocation_return_value (invocation, NULL);
    } 
    else if(g_strcmp0 (method_name, "send_broadcast_by_id") == 0)
    { 
       GError *error = NULL;
        //g_variant_get (parameters, "(&s&s)", &name,&param);
       // sleep(5);
       g_dbus_connection_emit_signal(connection,
                                    NULL,
                                    BROADCAST_DATA_PATH,
                                    BROADCAST_DATA_INTERFACE,
                                    "broadcast_to_id",
                                    parameters,
                                    &error);
       if (error) {
           LYDBGLOG("send_broadcast_by_id error");
           g_error_free(error);
       }
       g_dbus_method_invocation_return_value (invocation, NULL);
    }
    else if(g_strcmp0 (method_name, "send_broadcast_param_unfixed") == 0)
    { 
       GError *error = NULL;
       g_dbus_connection_emit_signal(connection,
                                    NULL,
                                    BROADCAST_DATA_PATH,
                                    BROADCAST_DATA_INTERFACE,
                                    "broadcast_parme_unfixed",
                                    parameters,
                                    &error);
    if (error) {
         LYDBGLOG("send_broadcast_param_unfixed error");
         g_error_free(error);
     }
     g_dbus_method_invocation_return_value (invocation, NULL);
    }
    else{
        RLOGE("Places that can't be reached");
        g_assert_not_reached ();
    }
}
static const GDBusInterfaceVTable interface_vtable =
{
  broadcast_interface,
  NULL,
  NULL
};	
static void
on_bus_acquired (GDBusConnection *connection,
                 const gchar     *name,
                 gpointer         user_data)
{
    LYDBGLOG("Acquired a message bus connection");
    guint registration_id;
    registration_id = g_dbus_connection_register_object (connection,
                                                         BROADCAST_DATA_PATH,
                                                         introspection_data->interfaces[0],
                                                         &interface_vtable,
                                                         NULL,  /* user_data */
                                                         NULL,  /* user_data_free_func */
                                                         NULL); /* GError** */
    g_assert (registration_id > 0);
}

static void
on_name_acquired (GDBusConnection *connection,
                  const gchar     *name,
                  gpointer         user_data)
{
  LYDBGLOG("on_name_acquired");
 // g_print ("Acquired the name %s on the session bus\n", name);
}

static void
on_name_lost(GDBusConnection *connection,
                                         const gchar     *name,
                                         gpointer user_data)
{
    LYDBGLOG("Lost the name %s", name);
}
static gpointer
broadcast_service_cb (gpointer data){
    GMainLoop *loop;
    guint id;
    introspection_data = g_dbus_node_info_new_for_xml (introspection_xml, NULL);
    g_assert (introspection_data != NULL);
    hashTable = g_hash_table_new_full(g_int_hash, g_int_equal, NULL, g_free);
    queue = g_async_queue_new();
    loop = g_main_loop_new(NULL, FALSE);
    id = g_bus_own_name(G_BUS_TYPE_SYSTEM,
                           BROADCAST_SERVICE,
                          GBusNameOwnerFlags(G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT |
                           G_BUS_NAME_OWNER_FLAGS_REPLACE),
                           on_bus_acquired,
                           on_name_acquired,
                           on_name_lost,
                           loop,
                           NULL);
    g_main_loop_run(loop);
    g_bus_unown_name(id);
    g_main_loop_unref(loop);
    g_async_queue_unref(queue);
    g_dbus_node_info_unref (introspection_data);
    return NULL;
}
void
register_broadcast_service(){
    LYDBGLOG("register_broadcast_service\n");
    GError *error = NULL;
    sleep(5);
    GThread *thead = g_thread_try_new("broadcast_service", broadcast_service_cb, NULL, &error);
    g_assert_no_error(error);
    if(error!=NULL)
    {
        LYDBGLOG("initTiggerService free error pointer %P", error);
        g_error_free(error);
    }
}
