#include <string.h>
#include <stdlib.h>
#include <log/log.h>
#include "atci_at_util.h"

#undef LOG_TAG
#define LOG_TAG "AT_COMMON"

int atci_at_skip_space(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  while (**p_cur == ATCI_SPACE) {
    (*p_cur)++;
  }
  return SYS_SUCC;
}
int atci_at_hasmore(char **p_cur) {
  if (*p_cur == NULL || **p_cur == ATCI_END_CHAR) {
    return SYS_FAIL;
  }
  return SYS_SUCC;
}

int atci_at_to_equal(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  *p_cur = strchr(*p_cur, ATCI_EQUAL);
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  (*p_cur)++;
  return SYS_SUCC;
}
int atci_at_to_colon(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  *p_cur = strchr(*p_cur, ATCI_COLON);
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  (*p_cur)++;
  return SYS_SUCC;
}
int atci_at_skip_next_comma(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  *p_cur = strchr(*p_cur, ATCI_COMMA);
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  (*p_cur)++;
  return SYS_SUCC;
}
int atci_at_get_next_key(char **p_cur, char **p_out) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  atci_at_skip_space(p_cur);
  if (**p_cur == ATCI_DOUBLE_QUOTE) {
    (*p_cur)++;
    *p_out = strsep(p_cur, "\"");
    atci_at_skip_next_comma(p_cur);
  } else {
    *p_out = strsep(p_cur, ",");
  }
  return SYS_SUCC;
}

/**
 * Parses the next integer in the  line and places it in *p_out
 * "uns" is indicate in unsigned or not
 * returns SYS_SUCC on success
 * returns SYS_FAIL  on fail
 * updates *p_cur
 * "base" is the same as the base param in strtol
 */
int atci_at_get_nextint_base(char **p_cur, int *p_out, int base, int uns) {
  char *ret;
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  if (SYS_FAIL == atci_at_get_next_key(p_cur, &ret)) {
    return SYS_FAIL;
  } else {
    long l;
    char *end;
    if (uns) {
      l = strtoul(ret, &end, base);
    } else {
      l = strtol(ret, &end, base);
    }
    *p_out = (int) l;
    if (end == ret) {
      return SYS_FAIL;
    }
  }
  return SYS_SUCC;
}
int atci_at_get_nextint(char **p_cur, int *p_out) {
  return atci_at_get_nextint_base(p_cur, p_out, 10, 0);
}
int atci_at_get_nexthexint(char **p_cur, int *p_out) {
  return atci_at_get_nextint_base(p_cur, p_out, 16, 1);
}
int atci_get_cmd_mode(char *line) {
  int reasult = AT_WRONG_MODE;
  char *p_cur = NULL;
  if (NULL == line) {
    reasult = AT_WRONG_MODE;
    RLOGD("atci_get_cmd_mode error, input is NULL");
    return reasult;
  }
  p_cur = strchr(line, ATCI_EQUAL);
  if (NULL == p_cur) {
    p_cur = strchr(line, ATCI_QUESTION_MARK);
    if (NULL == p_cur) {
      reasult = AT_ACTIVE_MODE;
    } else {
      reasult = AT_READ_MODE;
    }
  } else {
    p_cur++;
    atci_at_skip_space(&p_cur);
    if (ATCI_QUESTION_MARK == *p_cur) {
      reasult = AT_TEST_MODE;
    } else {
      reasult = AT_SET_MODE;
    }
  }
  RLOGD("atci_get_cmd_mode success[%d]", reasult);
  return reasult;
}

char* atci_get_cmd_prefix(char *line) {
  int buf_len;
  char *prefix;
  char *end_ptr;
  if (NULL == line) {
    RLOGD("input is null");
    return NULL;
  }
  end_ptr = line;
  while (!ATCI_IS_CAHR(*end_ptr, ATCI_EQUAL)
      && !ATCI_IS_CAHR(*end_ptr, ATCI_QUESTION_MARK)
      && !ATCI_IS_CAHR(*end_ptr, ATCI_END_CHAR)
      && !ATCI_IS_CAHR(*end_ptr, ATCI_CR) && !ATCI_IS_CAHR(*end_ptr, ATCI_LF)) {
    end_ptr++;
  }
  buf_len = end_ptr - line + 1;
  prefix = (char *) calloc(buf_len, 1);
  if (prefix) {
    int i;
    char *in_ptr = line;
    char *out_ptr = prefix;
    for (i = 0; i < buf_len - 1; i++) {
      if (!ATCI_IS_CAHR(*in_ptr, ATCI_SPACE)) {
        *out_ptr = ATCI_UPPER_TO_LOWER(*in_ptr);
        out_ptr++;
      }
      in_ptr++;
    }
    *out_ptr = ATCI_END_CHAR;
  }
  RLOGD("get cmd prefix [%d][%s]", buf_len, prefix);
  return prefix;
}

