#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <error.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/if_ether.h>
#include <netpacket/packet.h>
#include <errno.h>
#include <log/log.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdint.h>
#include <sys/ioctl.h>
#include <linux/spi/spidev.h>
#include <liblog/lynq_deflog.h>
#include "include/libat/lynq_at_factory.h"

#define FACTORY_STRING "AT+LYNQFACTORY="
#define USER_LOG_TAG "AT_FACTORY"

#undef LOG_TAG
#define LOG_TAG "AT_FACTORY"

static const char *usb3_speed = "super-speed";
static const char *usb2_speed = "high-speed";

lynq_atsvc_outcb handle_output;

typedef struct
{
    char *cmd;
    void (*func)(char *input);
}Command;

enum
{
    Response = 0,
    Urc
};

void lynq_response_ok()
{
    char *str = "OK";
    handle_output(str, strlen(str), Response);
}

void lynq_response_error(int error_code)
{
    char str[32] = {0};
    sprintf(str, "+CME ERROR: %d", error_code);
    handle_output(str, strlen(str), Response);
}

void lynq_handle_adc(char *input)
{
    FILE *fp;
    char lynq_adc_dev[126] = {0};
    char lynq_adc_buf[32] = {0};
    int lynq_adc_num = atoi(input+4);
    char flag[64] = {0};
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input  2>&1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input  2>&1");
    }
    else if(lynq_adc_num == 2)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input  2>&1");
    }
    else if(lynq_adc_num == 3)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage3_input  2>&1");
    }
    fp=popen(lynq_adc_dev, "r");
    fgets(lynq_adc_buf,sizeof(lynq_adc_buf),fp);
    sprintf(flag,"%s %s", "+ADC:", lynq_adc_buf);
    if(handle_output != NULL)
    {
        handle_output(flag, strlen(flag), Response);
    }
    lynq_response_ok();
    pclose(fp);
}

int set_campare(char dev_buf[][40],char *buf_str[3])
{
    FILE *fp;
    int k = 15;
    int j;
    char lynq_usb_buf[256] = {0};
    char buf[256] = {0};
    for(j=0;j++;j<3)
    {
        sprintf(lynq_usb_buf,"cat /sys/class/leds/led95%d:%s",k++, dev_buf[j]);
        fp=popen(lynq_usb_buf, "r");
        fgets(buf, sizeof(buf), fp);
        if(strcmp(buf,buf_str[j]))
        {
            pclose(fp);
            return -1;
        }
        pclose(fp);
    }
    return 0;
}
void lynq_handle_sink(char *input)
{
    FILE *fp;
    time_t start,end;
    char lynq_usb_dev[256] = {0};
    char lynq[256] = {0};
    char char_buf[16] = {0};
    char flag_buf[64] = {0};
    int sink[3][3] = {{255,0,0},{0,255,0},{0,0,255}};
    char dev_buf[][40] = {{"green:cellular-radio/brightness"},{"green:cellular-quality/brightness"},{"red:system/brightness"}};
    char *str_buf[3] = {"0","0","0"};
    int i,j,ret;
    int state = 0;
    int k = 15;

    for(i = 0;i < 3;i++)
    {
        bzero(flag_buf, 64);
        k = 15;

        switch(i)
        {
        case 0:
        {
            str_buf[0]="255";
            str_buf[1]="0";
            str_buf[2]="0";
            break;
        }

        case 1:
        {
            str_buf[0]="0";
            str_buf[1]="255";
            str_buf[2]="0";
            break;
        }

        case 2:
        {
            str_buf[0]="0";
            str_buf[1]="0";
            str_buf[2]="255";
            break;
        }
        }
        for(int h=0;h<20;h++)
        {
            for(j = 0;j < 3;j++)
            {
                bzero(lynq_usb_dev, 256);
                sprintf(lynq_usb_dev,"echo %d >  /sys/class/leds/led95%d:%s  2>&1", sink[i][j], k++, dev_buf[j]);
                fp=popen(lynq_usb_dev, "r");
                pclose(fp);
            }
            bzero(char_buf,16);
            if(set_campare(dev_buf,str_buf))
            {
                RLOGD("pre_campare fail %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                continue;
            }
            sprintf(lynq,"cat /sys/bus/iio/devices/iio:device1/in_voltage4_input  2>&1");
            fp=popen(lynq, "r");
            fgets(char_buf, sizeof(char_buf), fp);

            if(set_campare(dev_buf,str_buf))
            {
                RLOGD("behand_campare fail %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                continue;
            }
            sprintf(flag_buf, "%s%d%s%s%s", "SINK[", i+1, "]: ", char_buf, "\n");
            handle_output(flag_buf, strlen(flag_buf), Response);
            state =1;
            break;
        }
        if(state == 0)
        {
            sprintf(flag_buf, "%s%d%s%s%s", "SINK[", i+1, "]: ", char_buf, "\n");
            handle_output(flag_buf, strlen(flag_buf), Response);
        }
    }
    pclose(fp);
    lynq_response_ok();
    return;
}

void lynq_handle_emmc(char *input)
{
    FILE *fp;
    char emmc_buf[100] = {0};
    char buf[100] = {0};
    sprintf(emmc_buf, "ls /dev | grep mmcblk0  2>&1");
    fp=popen(emmc_buf, "r");
    if(!fp){
        lynq_response_error(100);
        return;
    }
    while(fgets(buf, sizeof(buf), fp) != NULL){
        lynq_response_ok();
        pclose(fp);
        return;
    }
    lynq_response_error(100);
    pclose(fp);
}

static int gpio_set_commond(int gpio, const char *commond, int value)
{
    char lynq_set_gpio_commond[128] = {0};
    sprintf(lynq_set_gpio_commond,"echo %s %d %d > /sys/devices/platform/10005000.pinctrl/mt_gpio", commond, gpio, value);
    system(lynq_set_gpio_commond);
    return 0;
}
int gpio_init(int gpio, int mode, int value)
{
    gpio_set_commond(gpio, "mode", mode);
    gpio_set_commond(gpio, "out", value);
    RLOGE("gpio:%d,mode:%d,value:%d\n",gpio,mode,value);
    return 0;
}

static int gpio_status_get()
{
    FILE *fp;
    char lynq_get_gpio_commond[128] = {0};
    char lynq_get_gpio_state[64] = {0};
    sprintf(lynq_get_gpio_commond,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 006");
    fp=popen(lynq_get_gpio_commond, "r");
    if(!fp){
        RLOGE("get gpio state error\n");
        return -1;
    }
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    int state = lynq_get_gpio_state[7] - '0';
    return state;
}

int lynq_gpio_analysis(char *input,int *lynq_gpio_arr,int lynq_gpio_total_arr[],int total_length)
{
    int j = 0;
    int k = 0;
    int size = 0;
    char res[64] = {0};
    int greep = input[0] - '0';
    sprintf(res,"+GPIO:the greep:%d\n",greep);//The first digit represents grouping
    handle_output(res, strlen(res), Response);

    for (int i = 1; i < strlen(input); i++)
    {
        int num = 0;
        for (; input[i] != ',' && input[i] != '\0'; i++)
        {
            if (input[i] >= '0' && input[i] <= '9')
            {
                num = num * 10 + (input[i] - '0');
            }
            else
            {
                handle_output("+GPIO:input error\r\n", strlen("input error\r\n"), Response);
                return -1;
            }
        }
        for (k = 0; k < total_length && num != 0;k++)
        {
            if(num == lynq_gpio_total_arr[k])
            {
                lynq_gpio_arr[size] = num;
                size++;
                break;
            }
        }
        if(k >= total_length)
        {
            bzero(res,64);
            sprintf(res,"+GPIO:GPIO%d input error\r\n",num);
            handle_output(res, strlen(res), Response);
        }
    }
    if (lynq_gpio_arr[0] == 0)
    {
        handle_output("+GPIO:input all gpio not exist\r\n", strlen("input all gpio not exist\r\n"), Response);
        return -1;
    }
    return size;
}

#define GPIO_FILE "/data/factory/gpio_L805.conf"
int load_gpio(int *lynq_gpio_total_arr)
{
    FILE *fp;
    char StrLine[512];
    char StrGpio[512];
    char platform[10] = {0};
    char total[10] = {0};
    int count = 0;
    if((fp = fopen(GPIO_FILE, "r")) == NULL)
    {
        RLOGE("open %s error!\n", GPIO_FILE);
        return -1;
    }
    while (!feof(fp))
    {
        memset(StrLine, 0, 512);
        fgets(StrLine, 512, fp);
        if(strstr(StrLine, "platform:") != NULL)
        {
            strcpy(platform, strstr(StrLine, "platform:") + sizeof("platform:") - 1);
            if(!strcmp(platform,"L805"))
            {
                RLOGE("platform:error\n");
                fclose(fp);
                return -1;
            }
            RLOGE("platform:%s\n",platform);
        }
        
        else if(strstr(StrLine, "total:") != NULL)
        {
            strcpy(total, strstr(StrLine, "total:") + sizeof("total:") - 1);
            RLOGE("total:%s\n",total);
        }
        
        else if((strstr(StrLine, "gpio:") != NULL))
        {
            strcpy(StrGpio, strstr(StrLine, "gpio:") + sizeof("gpio:") - 1);
            for(int i=0; StrGpio[i] != '\0'; i++)
            {
                int num = 0;
                for (; StrGpio[i] != ',' && StrGpio[i] != '\0' && StrGpio[i] != '\n'; i++)
                {
                    num = num * 10 + (StrGpio[i] - '0');
                }
                lynq_gpio_total_arr[count] = num;
                count++;
            }
            break;

        }
    }
    fclose(fp);
    return count;
}

/*GPIO 6 is Used for comparison*/
static int set_all_gpio_status_and_check(int lynq_gpio_arr[], int status, int total_length)
{
    int ret;
    
    for(int m = 0; m < total_length; m++)
    {
        gpio_init(lynq_gpio_arr[m], 0, status);
    }
    usleep(10000);
    ret = gpio_status_get();
    if(ret!= status)
    {
        RLOGE("gpio status error\n");
        return 1;
    }
    return 0;
}

void lynq_handle_gpio(char *input)
{
    int lynq_gpio_total_arr[256];
    int lynq_gpio_arr[256] = {0};
    char lynq_show_gpio_state[64] = {0};
    int lynq_gpio_low = 0;
    int lynq_gpio_high = 0;
    int total_length = 0;
    int valid_length = 0;
    int value;
    int ret;
    int lynq_gpio_test_env_error = 1;
    int i = 0,m = 0,j = 0;
    int need_int = 1;
    int lynq_gpio_beta_state = 1;

    if((total_length = load_gpio(lynq_gpio_total_arr)) < 0)
    {
        RLOGE("Don't have this platform gpio configure\n");
        return;
    }
    gpio_set_commond(6, "mode", 0);
    gpio_set_commond(6, "dir", 0);
    RLOGE("start function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    input = input + strlen("gpio");
    if((valid_length = lynq_gpio_analysis(input, lynq_gpio_arr, lynq_gpio_total_arr, total_length)) < 0)
    {
        lynq_response_error(100);
        return;
    }
    RLOGE("The Valid count:%d\n",valid_length);
    for(i=0; i < valid_length; i++)
    {
        for(j=0;j<3;j++)
        {
            if  (j > 0) // reset gpio when retry
            {
                need_int = 1;
            }

            if (need_int == 1)
            {
                ret = set_all_gpio_status_and_check(lynq_gpio_arr, 0, valid_length);
                if (ret == 1)
                {
                    RLOGE("can't pull up or pull down gpio-6\n");
                    continue;
                }
                else if(ret == 0)
                {
                    RLOGE("all gpio can pull up or pull dpwn\n");
                    need_int = 0;
                }
                else if(ret == -1)
                {
                    RLOGE("gpio init or uninit fail\n");
                    lynq_response_error(100);
                    return;
                }
                RLOGE("finsh configure function\n");  
            }

            lynq_gpio_low = 0;
            lynq_gpio_high = 0;

            for(int n=0;n<3;n++)
            {
                gpio_set_commond(lynq_gpio_arr[i], "out", 1);
                usleep(10000);
                value = gpio_status_get();
                if(value == 1)
                {
                    RLOGE("high function is OK,input %d\n",lynq_gpio_arr[i]);
                    lynq_gpio_high = 1;
                    lynq_gpio_test_env_error = 0;
                    break;
                }
                else
                {
                    RLOGE("high function is Fail, input %d\n",lynq_gpio_arr[i]);
                    if(i == 0 && j == 0)
                    {
                        lynq_gpio_test_env_error = set_all_gpio_status_and_check(lynq_gpio_arr, 1, valid_length) == 0 ? 0 : 1;
                    }
                }
            }
            if (lynq_gpio_test_env_error == 1)
                break;
            gpio_set_commond(lynq_gpio_arr[i], "out", 0);
            usleep(10000);
            value = gpio_status_get();
            if(value == 0)
            {
                RLOGE("low function is OK,input %d\n",lynq_gpio_arr[i]);
                lynq_gpio_low = 1;
            }
            else
            {
                RLOGE("low function is fail,input %d\n",lynq_gpio_arr[i]);
            }
            bzero(lynq_show_gpio_state, 64);
            if((lynq_gpio_low != 1) || (lynq_gpio_high != 1))
            {
                RLOGE("total fail function,input %d\n",lynq_gpio_arr[i]);
            }
            else
            {
                RLOGE("success function,input:%d\n",lynq_gpio_arr[i]);
                sprintf(lynq_show_gpio_state,"+GPIO:%d\r\n",lynq_gpio_arr[i]);
                handle_output(lynq_show_gpio_state, strlen(lynq_show_gpio_state), Response);
                break; // do not retry when pass
            }
        } // for(j=0;j<3;j++)
        if (lynq_gpio_test_env_error == 1)
        {
            lynq_gpio_beta_state = 0;
            break;
        }
        if (j >= 3 )
        {
            lynq_gpio_beta_state = 0;
            sprintf(lynq_show_gpio_state,"+GPIO:%d FAIL\r\n",lynq_gpio_arr[i]);
            handle_output(lynq_show_gpio_state, strlen(lynq_show_gpio_state), Response);
        }
    } // for(i=0; i < sizeof(lynq_gpio_arr)/sizeof(lynq_gpio_arr[0]); i++)

    if(lynq_gpio_test_env_error == 1)
    {
        RLOGE("tool error\n");
        handle_output("+GPIO:tool error\r\n", strlen("+GPIO:tool error\r\n"), Response);
        lynq_response_error(100);
        return;
    }

    if(lynq_gpio_beta_state == 1)
    {
        RLOGE("total success function\n");
        lynq_response_ok();
    }
    else
    {
        RLOGE("total fail function\n");
        lynq_response_error(100);
    }
}

void lynq_handle_pcie(char *input)
{
    FILE *fp;
    char lynq_usb_dev[128] = {0};
    char lynq_get_gpio_state[512] = {0};
    sprintf(lynq_usb_dev,"cat sys/devices/platform/10005000.pinctrl/mt_gpio |grep 097  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    if(lynq_get_gpio_state[6] == '1')
    {
        lynq_response_ok();
    }
    else
    {
        lynq_response_error(100);
    }
}

int receive_data(int fd,char *buf_send,char *buf_recv, int send_len)
{
    time_t time_start;
    time_t time_end;
    int ret = 0;
    time_start=time(NULL);
    for(int recv =0;recv <50;recv++)
    {
        bzero(buf_recv, send_len);
        ret = recvfrom(fd,buf_recv,1024,0,NULL,NULL);
        if(ret<0)
        {
            handle_output("time_out", strlen("time_out"), Response);
            return -1;
        }
        else if (ret != send_len)
        {
            continue;
        }

        if(memcmp(buf_send,buf_recv, send_len))
        {
            time_end=time(NULL);
            if(difftime(time_end,time_start)>2)
            {
                handle_output("time_out", strlen("time_out"), Response);
                break;
            }
        }
        else
        {
            return 0;
        }
    }
    handle_output("can't receive correct data", strlen("can't receive correct data"), Response);
    return -1;
}

int rsgmii_init()
{
    char lynq_set_rgmii_arr[256] = {0};

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep \"RUNNING\"");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("Please checkout network_line", strlen("Please checkout network_line"), Response);
        return -1;
    }
    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 | grep \"RUNNING\"");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("Please checkout network_line", strlen("Please checkout network_line"), Response);
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 192.168.11.1");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 192.168.22.2");
    system(lynq_set_rgmii_arr);

    
    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep HWaddr | awk '{print \"ip n add 192.168.11.1 lladdr \"$5\" dev eth2\"}' | sh");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 | grep HWaddr | awk '{print \"ip n add 192.168.22.2 lladdr \"$5\" dev eth1\"}' | sh");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"iptables -t nat -A POSTROUTING -s 192.168.22.2 -d 192.168.11.1 -j SNAT --to-source 192.168.22.44");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"iptables -t nat -A POSTROUTING -s 192.168.11.1 -d 192.168.22.2 -j SNAT --to-source 192.168.11.33");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep \"inet addr\" | grep \"192.168.11.1\"");
    if(system(lynq_set_rgmii_arr))
    {
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 | grep \"inet addr\" | grep \"192.168.22.2\"");
    if(system(lynq_set_rgmii_arr))
    {
        return -1;
    }
    return 0;
}


int rsgmii_socket_init(struct sockaddr_in* server_addr, const char * eth_name, const char * ip_addr)
{
    int ser_socket = -1;
    struct ifreq ser;
    memset(&ser,0x00,sizeof(ser));
    strncpy(ser.ifr_name,eth_name,strlen(eth_name));

    server_addr->sin_family=AF_INET;
    server_addr->sin_port = htons(100);
    server_addr->sin_addr.s_addr = inet_addr(ip_addr);


    ser_socket = socket(AF_INET,SOCK_DGRAM,0);
    if (ser_socket<0)
    {
        return -1;
    }
    
    struct timeval timeout={1,0};
    int ret;
    ret = bind(ser_socket,(struct sockaddr*)server_addr,sizeof(*server_addr));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    
    ret = setsockopt(ser_socket,SOL_SOCKET,SO_BINDTODEVICE,(char *)&ser,sizeof(ser));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    ret = setsockopt(ser_socket,SOL_SOCKET,SO_RCVTIMEO,&timeout,sizeof(timeout));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }

    return ser_socket;
}

void lynq_handle_rsgmii()
{
    
    int ret;
    int check_count = 0;
    int check_ok_count = 0;
    int ser_socket = -1;
    int cli_socket = -1;
    char buf_init[1024];
    char buf_tran[1024];
    char buf_recv[1024];
    char flag[256]={0};
    struct sockaddr_in ser_addr;
    struct sockaddr_in cli_addr;
    time_t start,end;
    bzero(buf_init,sizeof(buf_init));
    bzero(buf_tran,sizeof(buf_tran));
    bzero(buf_recv,sizeof(buf_recv));
    
    const char *ser_ip = "192.168.22.2";
    const char *cli_ip = "192.168.11.1";
    const char * ser_name = "eth2";
    const char * cli_name = "eth1";
    int count = 0;
    ret = rsgmii_init();
    if(ret<0)
    {
        lynq_response_error(1);
        return;
    }

    ser_socket =rsgmii_socket_init(&ser_addr, ser_name, ser_ip);
    if(ser_socket < 0)
    {
        handle_output("init_failed", strlen("init_failed"), Response);
        lynq_response_error(2);
        return;
    }

    cli_socket =rsgmii_socket_init(&cli_addr, cli_name, cli_ip);
    if(cli_socket < 0)
    {
        close(ser_socket);
        handle_output("init_failed", strlen("init_failed"), Response);
        lynq_response_error(3);
        return;
    }
    //data content
    for(int j =0;j<4;j++)
    {
        for(int i =0;i<255;i++)
        {
            count += sprintf(buf_init + count,"%c",i);
            if (count >= 1024)
            {
                buf_init[1023] = '\0';
                break;
            }
        }
        
        if (count >= 1024)
        {
            break;
        }
    }

    start = time(NULL);
    for(int i=0;i<128;i++)
    {
        check_count++;
        end = time(NULL);
        if(difftime(end,start)>10)
        {
            break;
        }
        ret = sendto(cli_socket,buf_init,sizeof(buf_init),0,(struct sockaddr*)&ser_addr,sizeof(ser_addr));
        if(ret < 0 )
        {
            continue;
        }

        ret = receive_data(ser_socket,buf_init,buf_tran, sizeof(buf_init));
        if(ret < 0)
        {
            continue;
        }

        //ser receive data and send back the same of data to cli
        ret = sendto(ser_socket,buf_tran,sizeof(buf_init),0,(struct sockaddr*)&cli_addr,sizeof(cli_addr));
        if(ret <0)
        {
            continue;
        }

        ret = receive_data(cli_socket,buf_init,buf_recv, sizeof(buf_init));
        if(ret < 0)
        {
            continue;
        }

        check_ok_count ++;
    }

    if(check_ok_count >= 120)
    {
        lynq_response_ok();
    }
    else
    {
        sprintf(flag,"sent %d, success %d\n", check_count, check_ok_count);
        handle_output(flag, strlen(flag), Response);
        lynq_response_error(100);
    }

    close(ser_socket);
    close(cli_socket);
    return;
}

int sgmii_receive_data(int fd,char *buf_send,char *buf_recv, int send_len)
{
    time_t time_start;
    time_t time_end;
    int ret = 0;
    time_start=time(NULL);
    for(int recv =0;recv <50;recv++)
    {
        bzero(buf_recv, send_len);
        ret = recvfrom(fd,buf_recv,1024,0,NULL,NULL);
        if(ret<0)
        {
            RLOGE("time_out\n");
            return -1;
        }
        else if (ret != send_len)
        {
            continue;
        }

        if(memcmp(buf_send,buf_recv, send_len))
        {
            time_end=time(NULL);
            if(difftime(time_end,time_start)>2)
            {
                RLOGE("time_out\n");
                break;
            }
        }
        else
        {
            return 0;
        }
    }
    handle_output("+SGMII:can't receive correct data\r\n", strlen("+SGMII:can't receive correct data\r\n"), Response);
    return -1;
}

int sgmii_init()
{
    char lynq_set_rgmii_arr[256] = {0};

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth0 | grep \"RUNNING\"");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("+SGMII:Please checkout network_line", strlen("+SGMII:Please checkout network_line"), Response);
        return -1;
    }
    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep \"RUNNING\"");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("+SGMII:Please checkout network_line", strlen("+SGMII:Please checkout network_line"), Response);
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth0 192.168.11.1");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 192.168.22.2");
    system(lynq_set_rgmii_arr);

    
    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth0 | grep HWaddr | awk '{print \"ip n add 192.168.11.1 lladdr \"$5\" dev eth1\"}' | sh");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep HWaddr | awk '{print \"ip n add 192.168.22.2 lladdr \"$5\" dev eth0\"}' | sh");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"iptables -t nat -A POSTROUTING -s 192.168.22.2 -d 192.168.11.1 -j SNAT --to-source 192.168.22.44");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"iptables -t nat -A POSTROUTING -s 192.168.11.1 -d 192.168.22.2 -j SNAT --to-source 192.168.11.33");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth0 | grep \"inet addr\" | grep \"192.168.11.1\"");
    if(system(lynq_set_rgmii_arr))
    {
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep \"inet addr\" | grep \"192.168.22.2\"");
    if(system(lynq_set_rgmii_arr))
    {
        return -1;
    }
    return 0;
}


int sgmii_socket_init(struct sockaddr_in* server_addr, const char * eth_name, const char * ip_addr)
{
    int ser_socket = -1;
    struct ifreq ser;
    memset(&ser,0x00,sizeof(ser));
    strncpy(ser.ifr_name,eth_name,strlen(eth_name));

    server_addr->sin_family=AF_INET;
    server_addr->sin_port = htons(100);
    server_addr->sin_addr.s_addr = inet_addr(ip_addr);


    ser_socket = socket(AF_INET,SOCK_DGRAM,0);
    if (ser_socket<0)
    {
        return -1;
    }
    
    struct timeval timeout={1,0};
    int ret;
    ret = bind(ser_socket,(struct sockaddr*)server_addr,sizeof(*server_addr));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    
    ret = setsockopt(ser_socket,SOL_SOCKET,SO_BINDTODEVICE,(char *)&ser,sizeof(ser));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    ret = setsockopt(ser_socket,SOL_SOCKET,SO_RCVTIMEO,&timeout,sizeof(timeout));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }

    return ser_socket;
}

void lynq_handle_sgmii()
{
    
    int ret;
    int check_count = 0;
    int check_ok_count = 0;
    int ser_socket = -1;
    int cli_socket = -1;
    char buf_init[1024];
    char buf_tran[1024];
    char buf_recv[1024];
    char flag[256]={0};
    struct sockaddr_in ser_addr;
    struct sockaddr_in cli_addr;
    time_t start,end;
    bzero(buf_init,sizeof(buf_init));
    bzero(buf_tran,sizeof(buf_tran));
    bzero(buf_recv,sizeof(buf_recv));
    
    const char *ser_ip = "192.168.22.2";
    const char *cli_ip = "192.168.11.1";
    const char * ser_name = "eth1";
    const char * cli_name = "eth0";
    int count = 0;

    ser_socket =sgmii_socket_init(&ser_addr, ser_name, ser_ip);
    if(ser_socket < 0)
    {
        handle_output("+SGMII:init_failed\r\n", strlen("+SGMII:init_failed\r\n"), Response);
        lynq_response_error(2);
        return;
    }

    cli_socket =sgmii_socket_init(&cli_addr, cli_name, cli_ip);
    if(cli_socket < 0)
    {
        close(ser_socket);
        handle_output("+SGMII:init_failed\r\n", strlen("+SGMII:init_failed\r\n"), Response);
        lynq_response_error(3);
        return;
    }
    //data content
    for(int j =0;j<4;j++)
    {
        for(int i =0;i<255;i++)
        {
            count += sprintf(buf_init + count,"%c",i);
            if (count >= 1024)
            {
                buf_init[1023] = '\0';
                break;
            }
        }
        
        if (count >= 1024)
        {
            break;
        }
    }

    start = time(NULL);
    for(int i=0;i<128;i++)
    {
        check_count++;
        end = time(NULL);
        if(difftime(end,start)>10)
        {
            break;
        }
        ret = sendto(cli_socket,buf_init,sizeof(buf_init),0,(struct sockaddr*)&ser_addr,sizeof(ser_addr));
        if(ret < 0 )
        {
            continue;
        }

        ret = sgmii_receive_data(ser_socket,buf_init,buf_tran, sizeof(buf_init));
        if(ret < 0)
        {
            continue;
        }

        //ser receive data and send back the same of data to cli
        ret = sendto(ser_socket,buf_tran,sizeof(buf_init),0,(struct sockaddr*)&cli_addr,sizeof(cli_addr));
        if(ret <0)
        {
            continue;
        }

        ret = sgmii_receive_data(cli_socket,buf_init,buf_recv, sizeof(buf_init));
        if(ret < 0)
        {
            continue;
        }

        check_ok_count ++;
    }

    if(check_ok_count >= 120)
    {
        lynq_response_ok();
    }
    else
    {
        sprintf(flag,"+SGMII:sent %d, success %d\r\n", check_count, check_ok_count);
        handle_output(flag, strlen(flag), Response);
        lynq_response_error(100);
    }

    close(ser_socket);
    close(cli_socket);
    return;
}

int rgmii_receive_data(int fd,char *buf_send,char *buf_recv, int send_len, int count)
{
    ssize_t ret;
    char *buf_cmp = NULL;
    int corrent_cont = 0;
    char reason_buf[32] = {0};

    /*To prevent packet loss,Setting 50 opportunities*/
    for(int cont = 0; cont < 50; cont++)
    {
        bzero(reason_buf,sizeof(reason_buf));
        bzero(buf_recv, sizeof(buf_recv));
        ret = recv(fd,buf_recv,1472,0);
        if(ret<0)
        {
            sprintf(reason_buf,"%d:recv_fail\n",count);
            RLOGE(reason_buf);
            return -1;
        }

        else if (ret < send_len)
        {
            continue;
        }
        // Analyzing Ethernet frame headers
        struct ethhdr *eth_header = (struct ethhdr *)buf_recv;
        RLOGD("Source MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", eth_header->h_source[0], eth_header->h_source[1], eth_header->h_source[2], eth_header->h_source[3], eth_header->h_source[4], eth_header->h_source[5]);
        RLOGD("Destination MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", eth_header->h_dest[0], eth_header->h_dest[1], eth_header->h_dest[2], eth_header->h_dest[3], eth_header->h_dest[4], eth_header->h_dest[5]);
        RLOGD("Ethernet Type: %04X\n", ntohs(eth_header->h_proto));
        // Analyzing IP headers
        struct iphdr *ip_header = (struct iphdr *)(buf_recv + sizeof(struct ethhdr));
        RLOGD("Source IP: %s\n", inet_ntoa(*(struct in_addr *)&ip_header->saddr));
        RLOGD("Destination IP: %s\n", inet_ntoa(*(struct in_addr *)&ip_header->daddr));
        RLOGD("Protocol: %d\n", ip_header->protocol);
        // Analyzing UDP headers
        struct udphdr *udp_header = (struct udphdr *)(buf_recv + sizeof(struct iphdr) + sizeof(struct ethhdr));
        RLOGD("Source Port: %d\n", ntohs(udp_header->source));
        RLOGD("Destination Port: %d\n", ntohs(udp_header->dest));
        RLOGD("UDP Length: %d\n", ntohs(udp_header->len));
        // Compare data
        buf_cmp = buf_recv + sizeof(struct ethhdr) + sizeof(struct iphdr) + sizeof(struct udphdr);
        if(memcmp(buf_send, buf_cmp, send_len))
        {
            RLOGE("rec data fail and retry!!\n");
            continue;
        }
        // raw_socket will received data twice
        else
        {
            corrent_cont++;
            RLOGD("rec data success and again!!\n");
            if(corrent_cont == 2)
            {
                RLOGD("cammpare OK!!\n");
                return 0;
            }
            continue;
        }
        
    }
    handle_output("+RGMII:can't receive correct data\r\n", strlen("+RGMII:can't receive correct data\r\n"), Response);
    return -1;
}

int rgmii_init()
{
    char lynq_set_rgmii_arr[128] = {0};

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"echo cl22w 0x00 0x5040 > /sys/devices/platform/11021000.ethernet/stmmac");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("+RGMII:Please checkout network_line\r\n", strlen("+RGMII:Please checkout network_line\r\n"), Response);
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 192.168.33.1");
    system(lynq_set_rgmii_arr);

    
    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ip n replace 192.168.33.2 lladdr ec:1d:7f:b0:2f:32 dev eth2");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 promisc");
    system(lynq_set_rgmii_arr);

    return 0;
}

int rgmii_socket_init(struct sockaddr_in* server_addr, const char * ip_addr)
{
    int ser_socket = -1;
    struct timeval timeout={1,0};
    int ret;
    server_addr->sin_family=AF_INET;
    server_addr->sin_port = htons(100);
    server_addr->sin_addr.s_addr = inet_addr(ip_addr);

    ser_socket = socket(AF_INET,SOCK_DGRAM,0);
    
    if (ser_socket<0)
    {
        return -1;
    }

    ret = setsockopt(ser_socket, SOL_SOCKET, SO_RCVTIMEO, &timeout, sizeof(struct timeval));
    if(ret < 0)
    {
        close(ser_socket);
        RLOGE("set socket timeout init_failed\n");
        return -1;
    }
    ret = bind(ser_socket,(struct sockaddr*)server_addr,sizeof(*server_addr));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    return ser_socket;
}

void lynq_handle_rgmii(char *input)
{
    int ret;
    int check_count = 0;
    int check_ok_count = 0;
    int socketfd = -1;
    int raw_socket = -1;
    char buf_init[1024];
    char buf_recv[1472];
    struct sockaddr_in ser_addr;
    struct sockaddr_in cli_addr;
    struct sockaddr_ll raw_addr;
    struct timeval raw_timeout={2,0};
    struct ifreq ser;
    time_t start,end;
    bzero(buf_init,sizeof(buf_init));
    bzero(buf_recv,sizeof(buf_recv));
    
    const char *ser_ip = "192.168.33.1";
    const char *cli_ip = "192.168.33.2";

    int count = 0;

    cli_addr.sin_family=AF_INET;
    cli_addr.sin_port = htons(100);
    cli_addr.sin_addr.s_addr = inet_addr(cli_ip);

    socketfd = rgmii_socket_init(&ser_addr,ser_ip);
    if(socketfd < 0)
    {
        RLOGE("init_failed\n");
        lynq_response_error(2);
        return;
    }
    //Use raw_socket receive data at the link layer
    raw_socket = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    if(raw_socket < 0)
    {
        RLOGE("raw_socket init_failed\n");
        lynq_response_error(2);
        return;
    }
    memset(&raw_addr, 0, sizeof(raw_addr));
    raw_addr.sll_family=AF_PACKET;
    raw_addr.sll_protocol = htons(ETH_P_ALL);
    raw_addr.sll_ifindex = if_nametoindex("eth2");

    ret = setsockopt(raw_socket, SOL_SOCKET, SO_RCVTIMEO, &raw_timeout, sizeof(struct timeval));
    if(ret < 0)
    {
        RLOGE("set raw_socket timeout init_failed\n");
        lynq_response_error(3);
        return -1;
    }

    ret = bind(raw_socket, (struct sockaddr*)&raw_addr, sizeof(raw_addr));//bind network interface card
    if(ret < 0)
    {
        RLOGE("bind raw_socket init_failed\n");
        lynq_response_error(3);
        return;
    }

    for(int j =0;j<4;j++)
    {
        for(int i =0;i<255;i++)
        {
            count += sprintf(buf_init + count,"%c",i);
            if (count >= 1024)
            {
                buf_init[1023] = '\0';
                break;
            }
        }
        
        if (count >= 1024)
        {
            break;
        }
    }

    start = time(NULL);
    for(int i=0;i<128;i++)
    {
        check_count++;
        end = time(NULL);
        if(difftime(end,start)>20)
        {
            break;
        }
        ret = sendto(socketfd,buf_init,sizeof(buf_init),0,(struct sockaddr*)&cli_addr,sizeof(cli_addr));
        if(ret < 0 )
        {
            continue;
        }
        ret = rgmii_receive_data(raw_socket,buf_init,buf_recv, sizeof(buf_init),check_count);
        if(ret < 0)
        {
            continue;
        }
        check_ok_count ++;
    }
    //  Received correctly 120 times
    if(check_ok_count >= 120)
    {
        RLOGD("rgmii OK!!\n");
        lynq_response_ok();
    }
    else
    {
        RLOGD("sent %d, success %d\r\n", check_count, check_ok_count);
        lynq_response_error(100);
    }

    close(socketfd);
    close(raw_socket);
    return;
}

void lynq_handle_allprepare(char *input)
{
    int ret;

    /*RGMII-test is conducted through GPIO,so initialization is not required*/
    // ret = rgmii_init();
    // if(ret<0)
    // {
    //     lynq_response_error(1);
    //     return;
    // }

    ret = sgmii_init();
    if(ret<0)
    {
        lynq_response_error(2);
        return;
    }
    lynq_response_ok();
}

void lynq_handle_inside_version(char *input)
{
    FILE *fp;
    char buf[64] = {0};
    fp=popen("uci get lynq_uci_ro.lynq_version.LYNQ_SW_INSIDE_VERSION 2>&1", "r");
    if(NULL == fp){
        char *str = "popen errorn\n";
        handle_output(str, strlen(str), Response);
    }
    fgets(buf, sizeof(buf), fp);
    handle_output(buf, strlen(buf), Response);
    lynq_response_ok();
    pclose(fp);
}

void lynq_handle_usb(char *input)
{
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512];
    bzero(lynq_usb_buf, 512);
    bzero(lynq_usb_dev,512);
    sprintf(lynq_usb_dev,"cat /sys/devices/platform/11201000.usb/udc/11201000.usb/current_speed  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp);
    if(!strncmp(lynq_usb_buf,usb3_speed,strlen(usb3_speed)))
    {
        char *res = "[usb][result],3.0";
        handle_output(res, strlen(res), Response);
        lynq_response_ok();
    }
    else if(!strncmp(lynq_usb_buf,usb2_speed,strlen(usb2_speed)))
    {
        char *res = "[usb][result],2.0";
        handle_output(res, strlen(res), Response);
        lynq_response_ok();
    }
    pclose(fp);
    return 1;
}


void lynq_handle_iccid_dual(char *input)
{
    RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    FILE *fp_sim1;
    FILE *fp_sim2;
    char buf_sim1[64] = {0};
    char buf_sim2[64] = {0};
    char sim1_iccid[64] = {0};
    char sim2_iccid[64] = {0};
    fp_sim1=popen("uci get radio_property.property.vendor_ril_iccid_sim1", "r");
    fp_sim2=popen("uci get radio_property.property.vendor_ril_iccid_sim2", "r");
    if(NULL == fp_sim1 || NULL == fp_sim2){
        char *str = "popen errorn\n";
        handle_output(str, strlen(str), Response);
    }
    fgets(buf_sim1, sizeof(buf_sim1), fp_sim1);
    fgets(buf_sim2, sizeof(buf_sim2), fp_sim2);
    if(strstr(buf_sim1,":empty") != NULL)
    {
        strcpy(buf_sim1,"empty");
    }
    if(strstr(buf_sim2,":empty") != NULL)
    {
        strcpy(buf_sim2,"empty");
    }
    sprintf(sim1_iccid,"+iccid1:%s\r\n",buf_sim1);
    sprintf(sim2_iccid,"+iccid2:%s\r\n",buf_sim2);
    handle_output(sim1_iccid, strlen(sim1_iccid), Response);
    handle_output(sim2_iccid, strlen(sim2_iccid), Response);
    lynq_response_ok();
    pclose(fp_sim1);
    pclose(fp_sim2);
}

/*dongyu@2024.7.23 Add SE XA2000 AT engineering test commands start*/
void lynq_handle_hsm_xa2000()
{
    char command[256] = {0};

    uint8_t tx[] = {0x5A, 0xCF, 0x00, 0x00, 0x3B, 0xB5};
    uint8_t rx[sizeof(tx)] = {0};
    uint8_t expected_cmd[] = {0xA5, 0xEF, 0x00, 0x00, 0xD2, 0x73};

    sprintf(command, "echo out 205 1 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
    system(command);
    usleep(100000);
    sprintf(command, "echo out 200 1 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
    system(command);
    usleep(100000);
    sprintf(command, "echo out 200 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
    system(command);
    usleep(100000);
    sprintf(command, "echo out 200 1 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
    system(command);

    struct spi_ioc_transfer tr = {
        .tx_buf = (unsigned long)tx,
        .rx_buf = (unsigned long)rx,
        .len = sizeof(tx),
        .speed_hz = 1000000,
        .delay_usecs = 0,
        .bits_per_word = 8,
    };
    int spi_fd = open("/dev/spidev1.0", O_RDWR);
    if (spi_fd < 0)
    {
        perror("Failed to open the SPI device");
        lynq_response_error(2);
        return;
    }

    int attempts = 0;
    const int max_attempts = 10;
    while (attempts < max_attempts)
    {
        if (ioctl(spi_fd, SPI_IOC_MESSAGE(1), &tr) < 1)
        {
            perror("Failed to send SPI message");
            close(spi_fd);
            lynq_response_error(2);
            return;
        }

        if (memcmp(rx, expected_cmd, sizeof(rx)) == 0) {
            char flag[256] = "Reset data: ";
            for (int i = 0; i < sizeof(rx); i++) {
                char temp[10];
                sprintf(temp, "0x%02X ", rx[i]);
                strcat(flag, temp);
            }
            if(handle_output != NULL)
            {
                handle_output(flag, strlen(flag), Response);
            }
            break;
        }
        attempts++;
    }
    close(spi_fd);

    if (attempts >= max_attempts)
    {
        lynq_response_error(100);
        return;
    }

    sprintf(command, "echo out 205 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
    system(command);
    usleep(100000);
    sprintf(command, "echo out 200 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio");
    system(command);

    lynq_response_ok();
}
/*dongyu@2024.7.23 Add SE XA2000 AT engineering test commands end*/

static Command commands[] = 
{
    {"adc",lynq_handle_adc},
    {"sink",lynq_handle_sink},
    {"emmc",lynq_handle_emmc},
    {"gpio",lynq_handle_gpio},
    {"pcie",lynq_handle_pcie},
    {"rsgmii",lynq_handle_rsgmii},
    {"rgmii",lynq_handle_rgmii},
    {"sgmii",lynq_handle_sgmii},
    {"allprepare",lynq_handle_allprepare},
    {"usb",lynq_handle_usb},
    {"iccid",lynq_handle_iccid_dual},
    {"XA2000",lynq_handle_hsm_xa2000},
    {NULL, NULL}
};

Command* find_command (char *input)
{
    RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    int i;
    int ret = -1;
    for (i = 0; commands[i].cmd; i++)
    {
        ret = strncmp(input, commands[i].cmd, strlen(commands[i].cmd));
        if(ret == 0)
        {
            RLOGD("function %s line %d find input %s commands[i].cmd %s  strlen %d ret %d\n", __FUNCTION__, __LINE__, input, commands[i].cmd, strlen(commands[i].cmd), ret);
            return (&commands[i]);
        }
    }
    RLOGD("function %s line %d not find ret %d \n", __FUNCTION__, __LINE__, ret);
    return ((Command *)NULL);
}

void lynq_at_factory_cb(char *input, int input_max_size)
{
    if(handle_output != NULL)
    {
        RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        if(input != NULL)
        {
            char *handle_string = input + strlen(FACTORY_STRING);
            if(!strlen(handle_string))
            {
                RLOGD("function %s line %d strlen %d\n", __FUNCTION__, __LINE__, strlen(handle_string));
                return;
            }
            RLOGD("function %s line %d  handle_string %s\n", __FUNCTION__, __LINE__, handle_string);
            Command *cmd = find_command(handle_string);
            if(cmd != NULL)
            {
                RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
                (*(cmd->func))(handle_string);
                return;
            }
        }
    }
}

lynq_atsvc_incb lynq_register_at_factory(lynq_atsvc_outcb out_cb)
{
    if(out_cb != NULL)
    {
        handle_output = out_cb;
        RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        return lynq_at_factory_cb;
    }
}
