#include <gio/gio.h>
#include <stdlib.h>
#include "broadcast_send.h"
#include <log/log.h>

#define BROADCAST_SERVICE "broadcast.lynq" /*well-known bus name */
#define BROADCAST_DATA_INTERFACE "broadcast.lynq.Data" /*interface name*/
#define BROADCAST_DATA_PATH "/broadcast/lynq/data" /*object name*/
#define LOG_TAG "BROADCAST_SEND"
static GMainLoop *loop = NULL;
static GDBusProxy *proxy = NULL;
void unregister_broadcast_send(void)
{
    if(proxy != NULL) 
    {
     g_object_unref (proxy);
    }
}

int send_broadcast_by_name (char * broadcast_name,int data_length ,char *param)
{
  
    GDBusConnection *c1;
    GVariant *result;
    GError *error;
    GMainLoop *loop;
    gint32  set_result = -1;
    g_type_init();
    loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
    error = NULL;
    c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
    result = g_dbus_connection_call_sync (c1,
                                        BROADCAST_SERVICE,  /* bus name */
                                        BROADCAST_DATA_PATH, /* object path */
                                        BROADCAST_DATA_INTERFACE,  /* interface name */
                                        "send_broadcast_by_name",                 /* method name */
                                        g_variant_new("(sis)", broadcast_name,data_length, param),
                                        NULL,                    /* return type */
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
    g_variant_unref (result);
    //g_main_loop_run (loop);
    g_main_loop_unref (loop);
    return set_result;
}
int send_broadcast_by_id (int broadcast_id,int data_length ,char *param)
{

    GDBusConnection *c1;
    GVariant *result;
    GError *error;
    GMainLoop *loop;
    gint32  set_result = -1;
    g_type_init();
    loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
    error = NULL;
    c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
    result = g_dbus_connection_call_sync (c1,
                                        BROADCAST_SERVICE,  /* bus name */
                                        BROADCAST_DATA_PATH, /* object path */
                                        BROADCAST_DATA_INTERFACE,  /* interface name */
                                        "send_broadcast_by_id",                 /* method name */
                                        g_variant_new("(iis)", broadcast_id,data_length, param),
                                        NULL,                    /* return type */
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
    g_variant_unref (result);
    g_main_loop_unref (loop);
}

int send_broadcast_param_unfixed (char * broadcast_name,GVariant *arg_InArg)
{

    GDBusConnection *c1;
    GVariant *result;
    GError *error;
    GMainLoop *loop;
    gint32  set_result = -1;
    g_type_init();
    loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
    error = NULL;
    c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
    result = g_dbus_connection_call_sync (c1,
                                        BROADCAST_SERVICE,  /* bus name */
                                        BROADCAST_DATA_PATH, /* object path */
                                        BROADCAST_DATA_INTERFACE,  /* interface name */
                                        "send_broadcast_param_unfixed",                 /* method name */
                                        g_variant_new("(s@*)",broadcast_name,arg_InArg),
                                        NULL,                    /* return type */
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
    g_variant_unref (result);
    g_main_loop_unref (loop);
}
void proxy_ready(GObject *source, GAsyncResult *result, gpointer user_data) {
    GError *error;

    error = NULL;
    proxy = g_dbus_proxy_new_for_bus_finish(result, &error);
    if (proxy == NULL) 
    {
        RLOGE("create proxy fail");
        unregister_broadcast_send();
        return ;
    }
    while(service_ready_send() != TRUE);
    RLOGD("proxy is ready");

}
void *run_send(void* arg)
{
    if(loop != NULL) {
        g_main_loop_run(loop);
    }else{
        RLOGD("loop null");
    }
    return ((void*)0);
}

gboolean service_ready_send(void)
{
    gchar *owner_name = NULL;
    owner_name = g_dbus_proxy_get_name_owner((GDBusProxy*)proxy);
    if(NULL != owner_name)
    {
        RLOGD("Owner Name: %s\n", owner_name);        
        g_free(owner_name);
        return TRUE;
    }
    else
    {   
        RLOGD("Owner Name is NULL.");  
        sleep(5);
        return FALSE;
    }
}

void register_broadcast_send ()
{
     GError *error = NULL;
    proxy = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SYSTEM,
                                         G_DBUS_PROXY_FLAGS_NONE,
                                         NULL, /* GDBusInterfaceInfo */
                                         BROADCAST_SERVICE,
                                         BROADCAST_DATA_PATH,
                                         BROADCAST_DATA_INTERFACE,
                                         NULL, /* GCancellable */
                                         &error);
    if (proxy == NULL)
    {
     RLOGD("broadcast proxy null");  
     return;
    }
    while(service_ready_send() != TRUE);
        
}
void register_broadcast_send_loop(void)
{
    register_broadcast_send();
}


