
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <string.h>
#include <vendor-ril/telephony/ril.h>
#include <vendor-ril/telephony/mtk_ril_sp.h>
#include <vendor-ril/telephony/mtk_ril_ivt.h>
#include "lynq_call.h"
#include "lynq_module_common.h"
#include "lynq_module_socket.h"
#include "lynq_call_common.h"

#define CALL_OFF (0)
#define CALL_ON  (1)
#define USER_LOG_TAG "LYNQ_CALL"

#define AP_SPEECH "/tmp/ap_speech"
#define AUDIO_CTRL_SER "/tmp/audio_ctrl_service"
#define LIBMODEM_AFE "/tmp/libmodem-afe-ctrl"
#define TELE_DEMO_LOCK "/tmp/tel_demo_single_proc.lock"
#define CALL_REBOOT_FLAG "/tmp/.call_reboot_flag"
#define SYSTEM_UPTIME 40
#define MAX_RING_INCOMING_INTERVAL 10

using ::android::Parcel;

/**
 * @brief mark call initialization state
 * 0: deinit state
 * 1: init state
 */
int g_module_init_flag = 0;

 typedef enum {
     LYNQ_CALL_ACTIVE = 0,
     LYNQ_CALL_HOLDING = 1,
     LYNQ_CALL_DIALING = 2,    /* MO call only */
     LYNQ_CALL_ALERTING = 3,   /* MO call only */
     LYNQ_CALL_INCOMING = 4,   /* MT call only */
     LYNQ_CALL_WAITING = 5,    /* MT call only */
     /*warren add for T800 platform 2022/04/26 start*/
     LYNQ_CALL_END = 6,         /*CALL END*/
     /*warren add for T800 platform 2022/04/26 end*/
}lynq_call_state_t;

typedef struct
{
    int used;
    int call_id;
    int call_state;
    int toa;
    int direction;/*0: MO call,1:MT call*/
    char addr[LYNQ_PHONE_NUMBER_MAX];
}lynq_call_list_e_t;
typedef struct
{
    int call_id;
    int call_state;
    int toa;
    int direction;/*0: MO call,1:MT call*/
    char addr[LYNQ_PHONE_NUMBER_MAX];
}lynq_call_list_t;

static lynq_call_list_e_t s_call_lists[LYNQ_CALL_MAX]={};
static bool s_call_list_loop = 0;
static pthread_t s_call_list_loop_tid = -1;
static pthread_mutex_t s_notice_get_call_list_mutex  = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_notice_get_call_list_cond = PTHREAD_COND_INITIALIZER;

static int s_module_isDial = 0;
static pthread_mutex_t call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t call_state_change_cond = PTHREAD_COND_INITIALIZER;
static int s_CallId = 0;
static pthread_mutex_t s_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_call_state_change_cond = PTHREAD_COND_INITIALIZER;

static int s_module_call_state =CALL_OFF;
static int s_call_auto_answer = 0;
static time_t s_rev_ring_time=0;

#ifdef MODE_DSDS
int global_slot = -1;
int urc_slot = -1;
#endif


typedef enum{
    LYNQ_E_VOLUMN_SET_DTMF,
    LYNQ_E_VOLUMN_SET_SPEECH
}LYNQ_E_VOLUMN_SET;  

#if 0
int JumpHeader(Parcel &p,int *resp_type,int* token,int *request,int *slot_id,int *error)
{
    if(p.dataAvail() > 0)
    {
        p.readInt32(resp_type);
        p.readInt32(token);
        p.readInt32(request);
        p.readInt32(slot_id);
        p.readInt32(error);
        return 0;
    }
    else
    {
        return -1;
    }
}
int send_request(int sockfd,lynq_client_t *client_tmp)
{
    int ret=0;
    ret = sendto(sockfd, client_tmp, client_size, 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(ret==-1)
    {
        LYERRLOG("sendto error");
        return -1;
    }
    return 0;
}

int get_response(int sockfd,Parcel &p)
{
    int len = 0;
    char recvline[LYNQ_REC_BUF];
    bzero(recvline,LYNQ_REC_BUF);
    /* receive data from server */
    len = recvfrom(sockfd,recvline,LYNQ_REC_BUF, 0, (struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(len == -1)
    {
        LYERRLOG("recvfrom error");
        return -1;
    }
    if (recvline != NULL) {
        p.setData((uint8_t *)recvline,len); // p.setData((uint8_t *) buffer, buflen);
        p.setDataPosition(0);
    }
    return 0;
}
#endif
static char *strdupReadString(Parcel* &p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

int lynq_get_current_call_list(lynq_call_list_t call_list[LYNQ_CALL_MAX])
{
    Parcel* p=NULL;    
    int ret=lynq_send_common_request(p,8,RIL_REQUEST_GET_CURRENT_CALLS,0,"");
    if(ret!=0)
    {
        return ret;    
    }        

    int call_num = 0;
    int temp = 0;
    char *remote_phoneNum;
    char *remote_name;
    char uusData[128];

    p->readInt32(&call_num);

    if(call_num<=0)
    {
        s_module_call_state = CALL_OFF;
        LYINFLOG("lynq_call_state:%d",s_module_call_state);
        delete p; 
        return RESULT_OK;
    }
    s_module_call_state = CALL_ON;
    LYINFLOG("lynq_call_state:%d, call num is %d ",s_module_call_state,call_num);
    for(int i = 0;i < call_num;i++)
    {
        p->readInt32(&temp);
        call_list[i].call_state = temp;
        p->readInt32(&call_list[i].call_id);
        p->readInt32(&call_list[i].toa);
        p->readInt32(&temp);
        p->readInt32(&temp);
        call_list[i].direction = temp;
        p->readInt32(&temp);
        p->readInt32(&temp);
        p->readInt32(&temp);
        remote_phoneNum = strdupReadString(p);
        memcpy(call_list[i].addr,remote_phoneNum,strlen(remote_phoneNum));
        if(remote_phoneNum !=NULL)
        {
            free(remote_phoneNum);
        }
        LYINFLOG("call_id=%d,call_state=%d,direction=%d,addr=%s,toa=%d",call_list[i].call_id,call_list[i].call_state,
        call_list[i].direction,call_list[i].addr,call_list[i].toa);
        p->readInt32(&temp);
        remote_name = strdupReadString(p);
        if(remote_name !=NULL)
        {
            free(remote_name);
        }
        p->readInt32(&temp);
        p->readInt32(&temp);
        if(temp==0)
        {
            continue;
        }
        p->readInt32(&temp); /* UUS Information is present */
        p->readInt32(&temp);
        p->readInt32(&temp);
        if(temp<=128)
        {
            p->read(uusData,temp);
        }
        else 
        {
            LYERRLOG("%s len %d is too great",__func__,temp);
            delete p; 
            return LYNQ_E_MALLOC_ERROR;
        }
    }

    delete p; 
    return RESULT_OK;   

#if 0
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int call_num = 0;
    int temp = 0;
    char *remote_phoneNum = NULL;
    char *remote_name= NULL;
    char *uusData = NULL;
    client.uToken = Global_uToken_call;
    client.request = 9;//RIL_REQUEST_GET_CURRENT_CALLS
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    JumpHeader(p,&resp_type,&token,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error == 0)
    {
        p.readInt32(&call_num);
        global_call_count = call_num;
        if(call_num<=0)
        {
            lynq_call_state = CALL_OFF;
            LYINFLOG("lynq_call_state:%d",lynq_call_state);
            return 0;
        }
        lynq_call_state = CALL_ON;
        LYINFLOG("lynq_call_state:%d, call num is %d ",lynq_call_state,call_num);
        for(int i = 0;i < call_num;i++)
        {
            p.readInt32(&temp);
            call_list[i].call_state = temp;
            p.readInt32(&call_list[i].call_id);
            p.readInt32(&call_list[i].toa);
            p.readInt32(&temp);
            p.readInt32(&temp);
            call_list[i].direction = temp;
            p.readInt32(&temp);
            p.readInt32(&temp);
            p.readInt32(&temp);
            remote_phoneNum = strdupReadString(p);
            memcpy(call_list[i].addr,remote_phoneNum,strlen(remote_phoneNum));
            LYINFLOG("call_id=%d,call_state=%d,direction=%d,addr=%s,toa=%d",call_list[i].call_id,call_list[i].call_state,
            call_list[i].direction,call_list[i].addr,call_list[i].toa);
            p.readInt32(&temp);
            remote_name = strdupReadString(p);
            p.readInt32(&temp);
            p.readInt32(&temp);
            if(temp==0)
            {
                continue;
            }
            p.readInt32(&temp); /* UUS Information is present */
            p.readInt32(&temp);
            p.readInt32(&temp);
            p.read(uusData,temp);
        }
    }
    return 0;
#endif
}

void cleanCallList(int lynq_call_id)
{
    LYINFLOG("cleanCall local idx is %d, id is %d",lynq_call_id,s_call_lists[lynq_call_id].call_id);
    s_call_lists[lynq_call_id].call_id = 0;
    s_call_lists[lynq_call_id].call_state = (int)LYNQ_CALL_END;
    s_call_lists[lynq_call_id].toa = 0;
    s_call_lists[lynq_call_id].direction = 0;
    s_call_lists[lynq_call_id].used = 0;
    memset(s_call_lists[lynq_call_id].addr,0,sizeof(s_call_lists[lynq_call_id].addr));
}


int getUnusedElement()
{
    for(int i=0;i < LYNQ_CALL_MAX; i++)
    {
        if(s_call_lists[i].used!=1)
        {
            return i;
        }
    }
    return INVALID_ID;
}
int addAddr(char addr[], int call_id)
{
    int ret = 0;
    ret = getUnusedElement();
    memcpy(s_call_lists[ret].addr,addr,strlen(addr)+1);
    s_call_lists[ret].call_id=call_id;
    s_call_lists[ret].used = 1;
    LYINFLOG("add local idx is %d addr is %s",ret,addr);
    return ret;
}
void updateCallList(lynq_call_list_e_t *callList,    int call_id,int call_state,int toa,int direction)
{
    LYINFLOG("Update original local id is %d, new local id is %d",callList->call_id,call_id);
    callList->call_id = call_id;
    callList->call_state = call_state;
    callList->toa = toa;
    callList->direction = direction;   
    return;
}

void wait_call_state()
{
    LYINFLOG("call state changed");
    pthread_mutex_lock(&s_call_state_change_mutex);
    pthread_cond_wait(&s_call_state_change_cond,&s_call_state_change_mutex);
    pthread_mutex_unlock(&s_call_state_change_mutex);
}

int checkHasCall(char addr[])
{
    for(int i = 0;i<LYNQ_CALL_MAX;i++)
    {
        if(strcmp(s_call_lists[i].addr,addr)==0)
        {
            LYINFLOG("checkHasCall addr is %s idx is %d id is %d",addr,i,s_call_lists[i].call_id);
            return true;
        }
    }
    LYINFLOG("checkHasCall addr is %s , no idx is found",addr);
    return false;
}
int find_call_id_with_addr(char *addr)
{
    for(int id = 0; id < LYNQ_CALL_MAX; id++)
    {
        if(s_call_lists[id].used && (strcmp(s_call_lists[id].addr,addr) == 0))
        {
            LYINFLOG("find addr  %s in local list, local idx is %d id is %d",addr,id,s_call_lists[id].call_id);
            return id;
        }
    }
    LYINFLOG("find addr  %s in local list , not found",addr);
    return INVALID_ID;
}
int find_call_id_with_call_id(int call_id)
{
    for(int id = 0; id < LYNQ_CALL_MAX; id++)
    {
        if(s_call_lists[id].used && (s_call_lists[id].call_id == call_id))
        {
            LYINFLOG("find id  %d in local list, local idx is %d, addr is %s",call_id,id,s_call_lists[id].addr);
            return id;
        }
    }
    LYINFLOG("find id  %d in local list , not found",call_id);
    return INVALID_ID;
}
void sendSignalToWaitCallStateChange()
{
    LYINFLOG("send Signal To Wait Call State Change");
    pthread_mutex_lock(&call_state_change_mutex);
    pthread_cond_signal(&call_state_change_cond);
    pthread_mutex_unlock(&call_state_change_mutex);
}
void send_call_state_change(int callid)
{
    LYINFLOG("send call state change");
    s_CallId = callid;
    pthread_mutex_lock(&s_call_state_change_mutex);
    pthread_cond_signal(&s_call_state_change_cond);
    pthread_mutex_unlock(&s_call_state_change_mutex);
}

void cleanup_call_list_mutex(void *arg)
{
    pthread_mutex_unlock(&s_notice_get_call_list_mutex);
}

void update_end_state(int lynq_call_id)
{
    LYINFLOG("update_end_state local idx is %d, id is %d",lynq_call_id,s_call_lists[lynq_call_id].call_id);
    s_call_lists[lynq_call_id].call_state = (int)LYNQ_CALL_END;
}

void *triggerGetCallList(void *parg)
{
    int ret=0;
    bool call_end;
    lynq_call_list_t call_list[LYNQ_CALL_MAX];
    int update=0;
    int cnt;
    int i,n;
#ifdef ECALL_SUPPORT
    int handupIncomingMT=0;
#endif
    unsigned long interval;
    time_t now;


    pthread_mutex_lock(&s_notice_get_call_list_mutex);
    pthread_cleanup_push(cleanup_call_list_mutex, NULL); // thread cleanup handler
    int tmp_call_id;
    while(s_call_list_loop)
    {
        update=0;       
        pthread_cond_wait(&s_notice_get_call_list_cond, &s_notice_get_call_list_mutex);
        LYINFLOG("triggerGetCallList event %p!!!", pthread_self());
        memset(call_list,0,sizeof(call_list));
        ret = lynq_get_current_call_list(call_list);
        if(ret != RESULT_OK)
        {
            LYERRLOG("get current call list failure!!!");
            continue;
        }
        LYINFLOG("++++++++++++++triggerGetCallList++++++++++++++");
        LYINFLOG("clear local index begin");
        cnt=0;
        for(i = 0;i < LYNQ_CALL_MAX;i++)
        {
            if(s_call_lists[i].used ==0)
            {
                continue;
            }
            cnt++;
            LYINFLOG("local idx is %d id is %d addr is %s state is %d direction is %d",i,s_call_lists[i].call_id,s_call_lists[i].addr,s_call_lists[i].call_state,s_call_lists[i].direction);
            
            if(s_call_lists[i].call_id > 0)
            {
                call_end = 0;
                for(n = 0; n < LYNQ_CALL_MAX; n++)
                {
                    if(call_list[n].call_id == s_call_lists[i].call_id)
                    {
                        call_end = 1;
                        LYINFLOG("find lynq call local idx %d, service idx %d  id is %d!!!",i,n,s_call_lists[i].call_id);
                        break;
                    }
                }
                if(call_end == 0)
                {
                    LYINFLOG("MT/MO hungup,then clean call info local idx is %d id is %d",i, s_call_lists[i].call_id);
                    //update_end_state(i);//lei modify for:update end state for this call
                    tmp_call_id = s_call_lists[i].call_id;
                    cleanCallList(i);
                    //Release the end handle
                    send_call_state_change(tmp_call_id);//means mt/mo call is end
                    //cleanCallList(i);
                }
            } //fix bug API-54
            else 
            {
                LYINFLOG("local id is 0");
            }
        }
        LYINFLOG("clear local index end, local used cnt is %d", cnt);

        LYINFLOG("add or update local index begin ");
        for (i = 0;i < LYNQ_CALL_MAX;i++)
        {    
            if(call_list[i].call_id==0)
            {
                break;
            }

            LYINFLOG("servie idx %d begin: call_id=%d, call_state=%d, direction=%d, addr=%s, toa=%d",i,call_list[i].call_id, call_list[i].call_state,
                call_list[i].direction,call_list[i].addr,call_list[i].toa);
        
            if(call_list[i].direction == 1)//MT call
            {
                 LYINFLOG("This is a MT CALL");
                 /*MT CALL state code
                 **LYNQ_CALL_INCOMING = 4,
                 **LYNQ_CALL_WAITING = 5,
                 */
#ifdef ECALL_SUPPORT
                if((call_list[i].call_state ==4) || (call_list[i].call_state ==5))
                {
                    handupIncomingMT=Is_handup_IncomingMT(call_list[i].call_id);                        
                    LYINFLOG("handupIncomingMT is %d",handupIncomingMT);
                    if(handupIncomingMT)
                    {
                        lynq_call_hungup(&(call_list[i].call_id));
                        continue;
                    }         
                }
#endif 
                /*you call me, and i call you,One party failed to dial*/
                n = find_call_id_with_addr(call_list[i].addr);
                if(n ==INVALID_ID)
                {
                    if(s_call_auto_answer==false && call_list[i].call_state==LYNQ_CALL_INCOMING)
                    {
                        time(&now);
                        interval = difftime(now,s_rev_ring_time);   
                        if(interval>MAX_RING_INCOMING_INTERVAL)
                        {
                            LYINFLOG("recv incoming, %d second no ril ring",interval);
                            continue;
                        }                        
                    }                    
                    
                    n = addAddr(call_list[i].addr,call_list[i].call_id);
                    updateCallList(&s_call_lists[n],call_list[i].call_id,call_list[i].call_state,call_list[i].toa,call_list[i].direction);
                    send_call_state_change(call_list[i].call_id);
                }
                else if(s_call_lists[n].call_state == call_list[i].call_state)
                {
                    LYINFLOG("state not changed, state is %d ",call_list[i].call_state);
                    if(call_list[i].call_state ==4 || call_list[i].call_state ==5)
                    {
                        /*if call state not change,Maybe this call was ignored, so we need to continue to inform the user of 
                        **an incoming call until the status changes.
                        **fix bug API-54
                        */
                        LYINFLOG("resend incoming call signal");
                        send_call_state_change(call_list[i].call_id);
                    }
                }
                else 
                {
                    LYINFLOG("state changed from %d to %d",s_call_lists[n].call_state,call_list[i].call_state);
                    
                    updateCallList(&s_call_lists[n],call_list[i].call_id,call_list[i].call_state,call_list[i].toa,call_list[i].direction);//update mt call
                    send_call_state_change(call_list[i].call_id);
                }                            
            }
            else
            {     
                LYINFLOG("This is a MO CALL");
                call_end = 0;
                for(n = 0 ; n < LYNQ_CALL_MAX; n++)
                {
                    if(s_call_lists[n].used && ((strcmp(call_list[i].addr,s_call_lists[n].addr)==0)||(call_list[i].call_id==s_call_lists[n].call_id)))
                    {
                        if(s_call_lists[n].call_id==0)
                        {
                            LYINFLOG("add a call id");
                            update=1;//for send sigal
                        }
                        LYINFLOG("local idx %d updated, original call id is %d origial addr is %s original state is %d",n,s_call_lists[n].call_id,s_call_lists[n].addr,s_call_lists[n].call_state);                    
                        updateCallList(&s_call_lists[n],call_list[i].call_id,call_list[i].call_state,call_list[i].toa,call_list[i].direction);
                        call_end = 1;
                        send_call_state_change(call_list[i].call_id);//means mo call is success
                        break;
                    }                    
                }
                if(call_end == 0)//1.there is no space to use 2.can't find addr in buffer 3.call_id not equal   eg:when call is error return 8004/handle <= 0 will into this
                {  
                    LYINFLOG("need to hangup id %d", call_list[i].call_id);
#ifdef ECALL_SUPPORT
                    if(IsECallDialing())
                    {
                        LYINFLOG("ecall is dialing, for the timebeing, don't huangup");
                        continue;
                    }
#endif
                    LYINFLOG("hang up service call id %d",call_list[i].call_id); 
                    lynq_call_hungup(&(call_list[i].call_id));
                }

            }
            LYDBGLOG("servie idx %d end",i);
        }
        LYINFLOG("add or update local index end ");       
        if(s_module_isDial==1)
        {
            LYINFLOG("now is dialing");
            if(update==1)
            {
                LYINFLOG("find added call");
                sendSignalToWaitCallStateChange();
                s_module_isDial = 0;
            }    
            else
            {
                LYINFLOG("not find added call");
            }                
        }
        else 
        {
            LYINFLOG("now is not dialing");
        }        
    }
    pthread_cleanup_pop(0);
    pthread_mutex_unlock(&s_notice_get_call_list_mutex);
    return NULL;
}

void lynqNoticeGetModuleCallList()
{
    LYINFLOG("RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED send start");
    pthread_mutex_lock(&s_notice_get_call_list_mutex);
    pthread_cond_signal(&s_notice_get_call_list_cond);
    pthread_mutex_unlock(&s_notice_get_call_list_mutex);
    LYINFLOG("RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED send end");
}

#if 0
/*Warren add for T800 platform 2021/11/19 start*/
int lynq_socket_client_start()
{   
    #if 0
    struct sockaddr_in lynq_socket_server_addr;
    /* init lynq_socket_server_addr */
    bzero(&lynq_socket_server_addr, sizeof(lynq_socket_server_addr));
    lynq_socket_server_addr.sin_family = AF_INET;
    lynq_socket_server_addr.sin_port = htons(LYNQ_SERVICE_PORT);
    lynq_socket_server_addr.sin_addr.s_addr = htons(INADDR_ANY);
    
    /*
    if(inet_pton(AF_INET,"127.0.0.1", &lynq_socket_server_addr.sin_addr) <= 0)
    {
        LYDBGLOG("[%s] is not a valid IPaddress", argv[1]);
        exit(1);
    }
*/
    lynq_call_client_sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if(connect(lynq_call_client_sockfd, (struct sockaddr *)&lynq_socket_server_addr, sizeof(lynq_socket_server_addr)) == -1)
    {
        LYERRLOG("connect error");
        return -1;
    }
    #endif
    lynq_call_client_sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (-1 == lynq_call_client_sockfd)
    {
        return lynq_call_client_sockfd;
    }
    struct timeval timeOut;
    timeOut.tv_sec = 60;
    timeOut.tv_usec = 0;
    if (setsockopt(lynq_call_client_sockfd, SOL_SOCKET, SO_RCVTIMEO, &timeOut, sizeof(timeOut)) < 0) 
    {
        RLOGD("time out setting failed\n"); 
        return -1;
    }
    /* 设置address */  
    memset(&addr_serv, 0, sizeof(addr_serv));  
    addr_serv.sin_family = AF_INET;  
    addr_serv.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);  
    addr_serv.sin_port = htons(LYNQ_SERVICE_PORT);  
    len_addr_serv = sizeof(addr_serv);  
    return 0;
}

int lynq_socket_urc_start()
{
    int socket_fd=0;
    int rt=0;
    int len=0;
    int on=1;
    struct sockaddr_in urc_local_addr;
    pthread_attr_t attr;
    socket_fd = socket(AF_INET,SOCK_DGRAM,0);
    if(socket_fd < 0)
    {
        LYERRLOG("creaet socket for udp fail");
        return -1;
    }
    urc_local_addr.sin_family = AF_INET;
    urc_local_addr.sin_port = htons(LYNQ_URC_SERVICE_PORT);
    urc_local_addr.sin_addr.s_addr = htons(INADDR_ANY);
    /* Set socket to allow reuse of address and port, SO_REUSEADDR value is 2*/
    rt = setsockopt(socket_fd,SOL_SOCKET,SO_REUSEADDR,&on,sizeof on);
    if(rt<0)
    {
        LYERRLOG("SO_REUSEADDR fail");
        return -1;
    }
    rt = bind(socket_fd ,(struct sockaddr*)&urc_local_addr, sizeof(urc_local_addr));
    if (rt == -1)
    {
        LYERRLOG("bind failed");
        return -1;
    }
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    rt = pthread_create(&lynq_call_urc_tid,&attr,thread_urc_recv,(void *)socket_fd);
    if(rt < 0)
    {
        LYERRLOG("urc loop failure!!!");
        return -1;
    }
    LYDBGLOG("urc loop success!!!");
    return 0;
}
#endif

void lynq_call_state_change_test(int soc_id)
{
    LYDBGLOG("call state change,sim:%d",soc_id);
}

int lynq_start_call_list_loop()
{
#if 0
    int ret = 0;
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    s_notice_get_call_list_mutex = new pthread_mutex_t;
    pthread_mutex_init(s_notice_get_call_list_mutex, NULL);
    s_notice_get_call_list_cond = new pthread_cond_t;
    LYINFLOG("liulei s_notice_get_call_list_mutex\n");
    pthread_cond_init(s_notice_get_call_list_cond, NULL);
    LYINFLOG("liulei s_notice_get_call_list_cond\n"); 
#endif

    s_call_list_loop = 1;  
    int ret = pthread_create(&s_call_list_loop_tid,/*&attr*/NULL,triggerGetCallList,NULL);
    if(ret < 0)
    {
        LYERRLOG("lynq_update_call_list_loop fail!!!");
        return -1;
    }
    LYINFLOG("lynq_update_call_list_loop success!!!");

    memset(s_call_lists,0,sizeof(s_call_lists));
    return 0;
}

int lynq_stop_call_list_loop()
{
    int ret;
    pthread_mutex_lock(&s_notice_get_call_list_mutex);
    s_call_list_loop = 0;
    ret = pthread_cancel(s_call_list_loop_tid);
    LYINFLOG("pthread cancel w_c_list ret = %d",ret);    
    pthread_mutex_unlock(&s_notice_get_call_list_mutex);    
    ret = pthread_join(s_call_list_loop_tid,NULL);
    LYINFLOG("pthread join w_c_list ret = %d",ret);  
    s_call_list_loop_tid=-1;
#if 0
    pthread_mutex_destroy(s_notice_get_call_list_mutex);
    pthread_cond_destroy(s_notice_get_call_list_cond);
    delete s_notice_get_call_list_mutex;
    //s_notice_get_call_list_mutex = NULL;
    delete s_notice_get_call_list_cond;
    //s_notice_get_call_list_cond = NULL;
#endif
    
    return 0;
}

int lynq_init_call(int utoken){

    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);   
    LYERRLOG("%s start, parameter is %d", __func__,utoken);

    if(g_module_init_flag != MODULE_CLOSED)
    {
        LYERRLOG("module state is %d",g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(utoken <0){
        LYERRLOG("utoken  is less than 0",utoken);      
        return LYNQ_E_PARAMETER_ANONALY;
    }
    g_module_init_flag = MODULE_SWITCHING;
  

    g_module_Global_uToken = utoken; 

    int ret = lynq_start_all_urc_socket_thread();
    if(ret != RESULT_OK)
    {
        LYERRLOG("init socket urc fail!!!");
        g_module_init_flag = MODULE_CLOSED;
        return LYNQ_E_INNER_ERROR;
    }

    ret = lynq_start_all_rc_socket_thread();
    if(ret !=RESULT_OK)
    {
        LYERRLOG("init socket client fail!!!");
        lynq_close_all_urc_socket_thread();
        g_module_init_flag = MODULE_CLOSED;
        return LYNQ_E_INNER_ERROR;
    }

     
    int result = lynq_start_call_list_loop();
    if(ret != RESULT_OK)
    {
        LYERRLOG("lynq_start_call_list_loop fail!!!");
        lynq_close_all_urc_socket_thread();
        lynq_close_all_rc_socket_thread();
        g_module_init_flag = MODULE_CLOSED;
        return LYNQ_E_INNER_ERROR;
    }      

    g_module_init_flag = MODULE_RUNNING;

    LYERRLOG("%s end suc", __func__);
    return 0;
}

int lynq_deinit_call(void){
    LYERRLOG("%s start", __func__);

    if (g_module_init_flag != MODULE_RUNNING)
    {
       LYERRLOG("module state is %d",g_module_init_flag);
       return LYNQ_E_CONFLICT;
    }      
    lynq_call_hungup_all();  
    g_module_init_flag = MODULE_SWITCHING;
    lynq_close_all_urc_socket_thread();
    lynq_close_all_rc_socket_thread();    
    lynq_stop_call_list_loop();
    g_module_init_flag = MODULE_CLOSED;

    LYERRLOG("%s end suc", __func__);
    return 0;
}

#if 0
int lynq_set_common_request(int request_id, int argc, const char* format,...)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;
    int slot_id = -1;
    int error = -1;

    Parcel* p=NULL;
    int ret=lynq_send_common_request(request_id,5,p,argc,format,...);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;

    client.uToken = Global_uToken_call;
    client.request = request_id;
    client.paramLen = argc;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    if(argc!=0)
    {
        va_list args;
        va_start(args, format);
        vsnprintf(client.param, LYNQ_REQUEST_PARAM_BUF, format, args);
        va_end(args);    
    }
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    if(get_response(lynq_call_client_sockfd,p)==0)
    {    
        JumpHeader(p,&resp_type,&token,&request,&slot_id,&error);
        LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    }
    return error;

    
}
#endif

int lynq_get_common_request(int request_id, int* status)
{
    if(status==NULL)
    {
        LYERRLOG("status is null");
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,request_id,0,"");
    if(ret==RESULT_OK)
    {
        p->readInt32(status);
        delete p;        
    }
    return ret;   
}

int waitCallstateChange(int mtime)
{
    LYINFLOG("wait Call state Change");
    int ret = 0;
    int sec = 0;
    int ms  = 0;
    struct timeval now;
    struct timespec timeout;
    gettimeofday(&now,NULL);
    sec = mtime/1000;
    ms  = mtime%1000;
    timeout.tv_sec = now.tv_sec+sec;
    unsigned long long ns;
    ns = now.tv_usec*1000ull + ms*1000000ull;
    timeout.tv_sec += ns/1000000000;
    timeout.tv_nsec = ns % 1000000000;
    pthread_mutex_lock(&call_state_change_mutex);
    ret = pthread_cond_timedwait(&call_state_change_cond,&call_state_change_mutex,&timeout);
    pthread_mutex_unlock(&call_state_change_mutex);
    return ret;
}

int IsNormalCallDailing()
{
    return s_module_isDial;
}


int check_file_access(const char *fileName)
{
    if(0 == access(fileName,F_OK))
    {
        LYINFLOG("find file %s success",fileName);
        return 0;
    }
    LYERRLOG("find file %s fail",fileName);
    return 1;
}
int try_reset_audio_service()
{
    //check files:audio-ctrl-service,libmodem-afe-service,speech_daemon
    int ap_speech = 0;
    int audio_ctrl_ser = 0;
    int md_afe = 0;
    int tele_demo_lock = 0;
    LYINFLOG("try_reset_audio_service start");
    ap_speech = check_file_access(AP_SPEECH);
    audio_ctrl_ser = check_file_access(AUDIO_CTRL_SER);
    md_afe = check_file_access(LIBMODEM_AFE);
    tele_demo_lock = check_file_access(TELE_DEMO_LOCK);
    if((ap_speech + audio_ctrl_ser + md_afe) > 0)
    {
        system("systemctl stop audio-ctrl-service");
        system("systemctl stop speech_daemon");
        system("systemctl stop libmodem_afe_service");
        usleep(200000);//200ms
        system("rm /tmp/audio_ctrl_service -rf");
        system("rm /tmp/ap_speech -rf");
        system("rm /tmp/libmodem-afe-ctrl -rf");
        usleep(100000);//100ms
        system("systemctl start libmodem_afe_service");
        usleep(200000);//200ms
        system("systemctl start speech_daemon");
        usleep(200000);//200ms
        system("systemctl start audio-ctrl-service");
        sleep(1);//1s
        LYERRLOG("reset audio relation service");
    }
    if(tele_demo_lock)
    {
        LYERRLOG("%s lose,why?",TELE_DEMO_LOCK);
    }
    return 0;
}

int call_boot_check()
{
    FILE *file = NULL;
    int uptime = 0;

    file = fopen("/proc/uptime", "r");
    if(file == NULL) 
    {
        LYERRLOG("Error opening /proc/uptime");
        return -1;
    }
    
    if(fscanf(file, "%d ", &uptime) != 1) 
    {
        LYERRLOG("Error reading uptime value");
    }
    
    fclose(file);

    if(uptime > SYSTEM_UPTIME) 
    {
        LYINFLOG("System uptime is greater than 40 seconds.");
    } 
    else 
    {
        LYINFLOG("System uptime is less than 40 seconds.");
        FILE *fp = NULL;
        if(check_file_access(CALL_REBOOT_FLAG) != 0)
        {
            usleep(3000000);
            fp = fopen(CALL_REBOOT_FLAG,"w");
            if(fp == NULL)
            {
                LYERRLOG("Creat call reboot flag file failed !!!!");
                return -1;
            }
            LYINFLOG("Creat flag file success");
            fclose(fp);
        }
    }
    return 0;

}
int lynq_call(int* handle,char addr[])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
#ifdef MODE_DSDS
    urc_slot = -1;
#endif
    try_reset_audio_service();

#ifdef GSW_RIL_CFG
    call_boot_check();
#endif

    int lynq_call_id = -1;

    LYINFLOG("lynq_call begin addr %s",addr);
    if(addr==NULL)
    {
        LYERRLOG("Phone num is null!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }

    if(find_call_id_with_addr(addr)!=INVALID_ID)
    {
        LYERRLOG("addr %s exists",addr);
        return LYNQ_E_CONFLICT;
    }

#ifdef ECALL_SUPPORT
    if(lynq_ecall_is_running())
    {
        LYERRLOG("lynq_fast_ecall ecall is running");
        return LYNQ_E_ECALL_BEING_RUNNING;
    }
#endif   
    Parcel* p=NULL;
    lynq_call_id = addAddr(addr,0);
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_DIAL,2,"%s %d",addr, 0);
    if(ret!=0)
    {
        cleanCallList(lynq_call_id);  
        return ret;      
    }       
    delete p;
    s_module_isDial = 1;
    if(waitCallstateChange(6000)==ETIMEDOUT)//6000ms
    {
        //if timeout,this call need destroy.
        s_module_isDial = 0;      
        LYERRLOG("lynq_call timeout:wait Call state fail!!! clear local idx %d",lynq_call_id);
        cleanCallList(lynq_call_id);
        send_call_state_change(lynq_call_id);
        return LYNQ_E_TIME_OUT;
    }
    s_module_isDial = 0;
    *handle = s_call_lists[lynq_call_id].call_id;
    if(*handle > 0)
    {
        LYINFLOG("lynq_call dial addr %s suc, id is %d",addr,*handle);
        return RESULT_OK;   
    }
    else 
    {   
        LYERRLOG("lynq_call dial addr %s fail, invalid id",addr);
        cleanCallList(lynq_call_id);
        send_call_state_change(lynq_call_id);
        return LYNQ_E_INVALID_ID_ANONALY;
    }        
}

int lynq_call_answer()
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }   

    Parcel* p=NULL;    
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_ANSWER,0,"");
    if(ret==RESULT_OK)
    {
        delete p;      
    }        
    return ret;
}

int lynq_call_hungup(int* handle)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        return LYNQ_E_CONFLICT;
    }  
    
    if(handle==NULL||!((*handle>=0)&&(*handle<10)))
    {
        LYERRLOG("%s illegal input!!!!",__func__);
        return LYNQ_E_PARAMETER_ANONALY;
    }

    int call_id = *handle;
    Parcel* p=NULL;    
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_HANGUP,1,"%d",call_id);
    if(ret!=0)
    {
        return ret; 
    }
    delete p; 

    int lynq_call_id=find_call_id_with_call_id(call_id);
    if(lynq_call_id!=INVALID_ID)
    {
        //lei  modify for API-857
        cleanCallList(lynq_call_id);
        send_call_state_change(call_id);
    }
    return RESULT_OK;
}
int lynq_call_hungup_all()
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    Parcel* p=NULL;    
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_UDUB,0,"");
    if(ret==RESULT_OK)
    {
         delete p;      
    }        
    return ret;   
}

int lynq_wait_call_state_change(int *handle)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    wait_call_state();
    *handle = s_CallId;
    LYINFLOG("lynq mo/mt call id:%d",s_CallId);
    return RESULT_OK;
}

int lynq_set_auto_answercall(const int mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    s_call_auto_answer = mode;
    LYINFLOG("auto answer call mode =%d",mode);
    return RESULT_OK;   
}

int lynq_find_already_end()
{
    for(int i=0;i < LYNQ_CALL_MAX; i++)
    {
        if(s_call_lists[i].call_state == 6)
        {
            return 0;
        }
    }
    return INVALID_ID;
}

#ifdef MODE_DSDS
int lynq_get_current_call_state_ext(int *handle,    int *slot,int *call_state,int *toa,int *direction,char addr[])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    int lynq_call_id = 0;
    LYINFLOG("lynq_get_current_call_state begin ");
    if(handle==NULL)
    {
        LYERRLOG("handle is NULL");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if((*handle) <= 0)
    {
        LYINFLOG("lynq_get_current_call_state input error %d\n ", *handle);
        return LYNQ_E_INVALID_ID_ANONALY;
    }
    LYINFLOG("lynq_get_current_call_state %d\n ", *handle);
    lynq_call_id = find_call_id_with_call_id(*handle);
    if(lynq_call_id==INVALID_ID)
    {
        //find end state
        if((*handle) >= 0)
        {
            *call_state = (int)LYNQ_CALL_END;
            *slot = global_slot;
            return RESULT_OK; 
        }
        else
        {
            return LYNQ_E_INVALID_ID_ANONALY;
        }
    }
    *slot = global_slot;
    *call_state = s_call_lists[lynq_call_id].call_state;
    *toa = s_call_lists[lynq_call_id].toa;
    *direction = s_call_lists[lynq_call_id].direction;
    memcpy(addr,s_call_lists[lynq_call_id].addr,strlen(s_call_lists[lynq_call_id].addr)+1);
    return RESULT_OK;
}
#endif

int lynq_get_current_call_state(int *handle,    int *call_state,int *toa,int *direction,char addr[])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    int lynq_call_id = 0;
    LYINFLOG("lynq_get_current_call_state begin ");
    if(handle==NULL)
    {
        LYERRLOG("handle is NULL");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if((*handle) <= 0)
    {
        LYINFLOG("lynq_get_current_call_state input error %d\n ", *handle);
        return LYNQ_E_INVALID_ID_ANONALY;
    }
    LYINFLOG("lynq_get_current_call_state %d\n ", *handle);
    lynq_call_id = find_call_id_with_call_id(*handle);
    if(lynq_call_id==INVALID_ID)
    {
        //find end state
        if((*handle) >= 0)
        {
            *call_state = (int)LYNQ_CALL_END;
            return RESULT_OK; 
        }
        else
        {
            return LYNQ_E_INVALID_ID_ANONALY;
        }
    }
    *call_state = s_call_lists[lynq_call_id].call_state;
    *toa = s_call_lists[lynq_call_id].toa;
    *direction = s_call_lists[lynq_call_id].direction;
    memcpy(addr,s_call_lists[lynq_call_id].addr,strlen(s_call_lists[lynq_call_id].addr)+1);
    return RESULT_OK;
}

int lynq_get_current_call_number()
{
    int cnt=0;
    int i;
    for(i = 0;i < LYNQ_CALL_MAX;i++)
    {
        if(s_call_lists[i].used !=0)
        {
            cnt++;           
        }
    }

    return cnt;
}

/*audio begin*/
static int judge_mic(const int enable){
    switch(enable){
        case 0:
            return true;
        case 1:
            return true;
        default:
            return false;
    }
}

int lynq_set_mute_mic(const int enable)
{   
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(!judge_mic(enable)){
        return LYNQ_E_PARAMETER_ANONALY;
    }
 // return lynq_set_common_request(53,1,"%d",enable); //RIL_REQUEST_SET_MUTE  

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SET_MUTE,1,"%d",enable);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
}
int lynq_get_mute_mic(int *status)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    return lynq_get_common_request(RIL_REQUEST_GET_MUTE,status);//54
}

/**
 * @brief Check whether DTMF is valid
 * 
 * @param callnum dtmf eg:0-9 * #
 * @return int 
 */
static int judge_dtmf(const char callnum)
{
    if(callnum == '#')
    {
        return true;
    }
    if(callnum == '*')
    {
        return true;
    }
    if(callnum >= '0'&& callnum <= '9')
    {
        return true;
    }
    return false;
}

int lynq_switch_waiting_or_holding_and_active(void)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE,0,"");
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;

#if 0
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    client.uToken = Global_uToken_call;
    client.request = RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE;
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_call_sendto_mutex);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_call_sendto_mutex);
    JumpHeader(p,&resp_type,&token,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
#endif
}

int lynq_hangup_waiting_or_background(void)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND,0,"");
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
#if 0
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    client.uToken = Global_uToken_call;
    client.request = RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND;
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_call_sendto_mutex);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_call_sendto_mutex);
    JumpHeader(p,&resp_type,&token,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
#endif
}

int lynq_hangup_foreground_resume_background(void)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND,0,"");
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
#if 0    
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    client.uToken = Global_uToken_call;
    client.request = RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND;
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_call_sendto_mutex);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_call_sendto_mutex);
    JumpHeader(p,&resp_type,&token,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
#endif
}

int lynq_set_DTMF(const char callnum)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(!judge_dtmf(callnum))
    {
        return LYNQ_E_CONFLICT;
    }
    if(s_module_call_state!=CALL_ON)
    {
        LYERRLOG("LYNQ_E_CONFLICT");
        return LYNQ_E_CONFLICT;
    }
    
//  return lynq_set_common_request(24,1,"%c",callnum); //RIL_REQUEST_DTMF  

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_DTMF,1,"%c",callnum);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
}
static int judge_volume(LYNQ_E_VOLUMN_SET set,const int volume){
    if(set==LYNQ_E_VOLUMN_SET_DTMF){
        if(volume < 0 ||volume >36){
            return 0;
        }
    }
    else if (set==LYNQ_E_VOLUMN_SET_SPEECH)
    {
        if(volume < 1 ||volume >7){
            return 0;
        }
    }
    return 1;
}
int lynq_set_DTMF_volume(const int volume)
{   
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(!judge_volume(LYNQ_E_VOLUMN_SET_DTMF,volume)){
        return LYNQ_E_PARAMETER_ANONALY;
    }
//  return lynq_set_common_request(8003,1,"%d",volume);//LYNQ_REQUEST_SET_DTMF_VOLUME
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_SET_DTMF_VOLUME,1,"%d",volume);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
}
int lynq_set_speech_volume(const int volume)//mixer_set_volume
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(!judge_volume(LYNQ_E_VOLUMN_SET_SPEECH,volume))
    {
        return LYNQ_E_PARAMETER_ANONALY;
    }
//  return lynq_set_common_request(8009,1,"%d",volume); //LYNQ_REQUEST_SET_SPEECH_VOLUME
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_SET_SPEECH_VOLUME,1,"%d",volume);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
}
int lynq_get_speech_volume(int* volumn)//mixer_get_volume
{
    return lynq_get_common_request(LYNQ_REQUEST_GET_SPEECH_VOLUME,volumn);//8010  
} 
int lynq_incall_record_start(const char* file_path)
{
//    return lynq_set_common_request(8011,2,"%s %s","1",file_path); //LYNQ_REQUEST_RECORD
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_RECORD,2,"%s %s","1",file_path);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;    
}
int lynq_incall_record_stop()
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    const char* unused_file="just_ocuupy_paramter_postion";
//    return lynq_set_common_request(8011,2,"%s %s","0",unused_file); //LYNQ_REQUEST_RECORD
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_RECORD,2,"%s %s","0",unused_file);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;        
}
/*audio end*/



bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED:
        case RIL_UNSOL_CALL_RING:
        case RIL_UNSOL_RINGBACK_TONE:
        case RIL_UNSOL_CALL_INFO_INDICATION:
#ifdef ECALL_SUPPORT
        case RIL_UNSOL_ECALL_INDICATIONS://9502        
#endif
            return true;                
        default:
            return false;
    }    
}

void urc_msg_process(Parcel *p)
{ 
    int resp_type;
    int urcid;
    int slot_id;

    int size=p->dataSize();
    p->readInt32(&resp_type);
    p->readInt32(&urcid);
    p->readInt32(&slot_id);
#ifdef MODE_DSDS
    urc_slot = slot_id;
#endif
    LYINFLOG("%s urc id = %d, slot_id = %d, size is %d, msg is %s",__func__, urcid,slot_id,size,requestToString(urcid));
    switch (urcid)
    {
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED://1001
        {
            LYINFLOG("**************:resp_type=%d,urcid=%d,slot_id=%d",resp_type,urcid,slot_id);
            lynqNoticeGetModuleCallList();
            break;
        }
        case RIL_UNSOL_CALL_RING: //1018
        {
            time(&s_rev_ring_time);
            if(s_call_auto_answer==1)
            {
                lynq_call_answer();
            }
            break;
        }
        case RIL_UNSOL_RINGBACK_TONE: //1029
        case RIL_UNSOL_CALL_INFO_INDICATION://3049
        {
            LYINFLOG("**************:resp_type=%d,urcid=%d,slot_id=%d",resp_type,urcid,slot_id);
            break;
        }
#ifdef ECALL_SUPPORT
        case RIL_UNSOL_ECALL_INDICATIONS://9502
        {
            urc_ecall_msg_process(p);
        }
#endif
        default:
            break;
    }
}

#if 0
int main(int argc,char **argv)
{
    int n = 0;
    n = lynq_init_call(lynq_call_state_change_test,2222);
    if(n<0)
    {
        LYDBGLOG("lynq init call fail!!!");
        return -1;
    }
    LYDBGLOG("lynq call init success!!!");
    char phoneNum[LYNQ_PHONE_NUMBER_MAX];
    sprintf(phoneNum,"18180053406 0",strlen("18180053406 0")+1);
    lynq_call(phoneNum);
    while(1)
    {
        sleep(1);
    }
    return 0;
}
#endif
/*Warren add for T800 platform 2021/11/19 end*/
