#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include "lynq_dev_control.h"
#include <cutils/properties.h>
#include <sys/time.h>
#include <time.h>
#include <sys/ioctl.h>
#include <log/log.h>
#define DEVICE_NAME    "ro.product.device"
#define SW_VERSION    "ro.lynq.sw.version"
#define OEM_VERSION    "ro.product.oem"
#define MANUFACTURE    "ro.product.manufacture"
#define HW_VERSION    "ro.lynq.sw.version"
#define LOG_TAG "DEV_API"
struct linux_rtc_time {
  	int tm_sec;
  	int tm_min;
  	int tm_hour;
  	int tm_mday;
  	int tm_mon;
  	int tm_year;
  	int tm_wday;
  	int tm_yday;
  	int tm_isdst;
  };
  
  /* RTC_RD_TIME etc have this definition since 1.99.9 (pre2.0-9) */
  #ifndef RTC_RD_TIME
  # define RTC_RD_TIME	_IOR('p', 0x09, struct linux_rtc_time)
  #define RTC_AIE_OFF	_IO('p', 0x02)	/* ... off	
  # define RTC_SET_TIME	_IOW('p', 0x0a, struct linux_rtc_time)
  # define RTC_UIE_ON	_IO('p', 0x03)	/* Update int. enable on */
  # define RTC_UIE_OFF	_IO('p', 0x04)	/* Update int. enable off */
  #endif
  #ifndef RTC_EPOCH_READ
  # define RTC_EPOCH_READ	_IOR('p', 0x0d, unsigned long)	/* Read epoch */
  # define RTC_EPOCH_SET	_IOW('p', 0x0e, unsigned long)	/* Set epoch */
  #endif
void gsdk_device_get_devicename(char *devicename)
{
    int i = property_get(DEVICE_NAME, devicename, "11111");
    RLOGD("property_Get DEVICE_NAME,i:%d,devicename:%s",i,devicename);
    return ;
}
void gsdk_device_get_swversion(char *swversion)
{
	
    int i=property_get(SW_VERSION, swversion, "2222");
    RLOGD("property_Get DEVICE_NAME,i:%d,swversion:%s",i,swversion);
    return ;
}
void gsdk_device_get_oemversion(char *oemversion)
{
	property_get(OEM_VERSION, oemversion, "");
	
	return ;
}
void gsdk_device_get_manufacturer(char *manufacturer)
{
	property_get(MANUFACTURE, manufacturer, "");
	return ;
}
void gsdk_device_get_hwversion(char *swversion)
{
	property_get(SW_VERSION, swversion, "");
	return ;
	
}
void gsdk_device_get_oemapp_path()
{
	
	
}
void gsdk_device_get_oemdata_path()
{
	
}
void gsdk_device_shutdown_system()
{
	system("/sbin/poweroff");
	return ;
	
}
void gsdk_device_reboot_system()
{
	 system("/sbin/reboot");
	return ;
}
void gsdk_device_set_autosleep()
{
	system("echo mem > /sys/power/autosleep");
	
}
int gsdk_device_set_rtc_timer()
{
	static const char *fls = {"/dev/rtc0"};
	int fp = open(fls, O_RDONLY);
	return fp;
}
int gsdk_device_get_rtc_timer(int rtc_fd, struct tm *tm)
{
	int rc = -1;
	//struct tm timer_time;
	rc = ioctl(rtc_fd, RTC_RD_TIME, &tm);
	
	
	if (rc == -1) {
		RLOGD("read the time failed");
		return -1;
	}

	return 0;
}

int gsdk_device_cancel_rtc_timer(int rtc_fd)
{
	int rc = -1;
	rc = ioctl(rtc_fd, RTC_AIE_OFF, 0);
	if (rc == -1) {
	    RLOGD("cancel the time failed");
	    return -1;
	}
	return 0;
}
int gsdk_device_get_adc()
{
	static const char *adc_path = {"/sys/bus/iio/devices/iio\:device0/in_voltage0_BATADC_input"};
	char str[100]= {0};
	int adc;
	int fp = open(adc_path, O_RDONLY);
	int err_r = read(fp,str,sizeof(str));
	adc = atoi(str);
	return adc;
	
}

void gsdk_device_wake_lock()
{
	system("echo lock_name > /sys/power/wake_lock");
	return ;
}
void gsdk_device_wake_unlock()
{
	system("echo lock_name > /sys/power/wake_unlock");
	return ;
	
}

void gsdk_device_set_usb_state()
{
	return ;
}
int gsdk_device_get_usb_state()
{
	static const char *usb_state_path = {"/sys/devices/platform/11201000.usb/udc/11201000.usb/state"};
    const char *usb_no_connect = {"not attached"};
	const char *usb_connect = {"configured"};
	char str[100]= {0};
	int fp = open(usb_state_path, O_RDONLY);
	printf("open usb state:%d\n",fp);
	read(fp,str,sizeof(str));
	printf("str:%s\n",str);
	if(strcmp(str,usb_no_connect))
	{ 
	    return 0;
	}
	else if (strcmp(str,usb_connect))
	{
	    return 1;
	}
	else
	{
	    return -1;
	}

	
}
/*
int write_gpio_file(){
	int err = -1;
	gchar argv[50];
	char *s;
	param_process(mode,gpio_numb,param,argv);
	s = argv;
	RLOGD("s:%s",s);
	int fp = open("/proc/n5600", O_RDWR);
	if (fp < 0) {	
	  RLOGD("open /proc/n5600 error\n");
	  return -1;
	}
	else { 
	  RLOGD("open /proc/n5600 success!\n");
	}	
	err = write(fp, s, sizeof(argv));
	close(fp);
	if(err == -1)	{
	  RLOGE("read faild!!!\n");
	  return -1;
	}else{
      return 1;
	}
	
}*/

