#ifndef LYNQ_MODULE_COMMON_H
#define LYNQ_MODULE_COMMON_H 

#define RESULT_OK (0)
#define RESULT_ERROR (-1)

/*the same with lynq_interface.h begin*/
#define LYNQ_REQUEST_VENDOR_BASE 8000
#define LYNQ_URC_VENDOR_BASE 9000
#define LYNQ_AT_SNED (LYNQ_REQUEST_VENDOR_BASE +1)
#define LYNQ_URC_CALL_STATUS_IND (LYNQ_URC_VENDOR_BASE+1)
#define LYNQ_URC_DATA_STATUS_IND (LYNQ_URC_VENDOR_BASE+2)
#define LYNQ_URC_DATA_CALL_STATUS_IND (LYNQ_URC_VENDOR_BASE+3)
#define LYNQ_AUTO_ANSWER_CALL (LYNQ_REQUEST_VENDOR_BASE +2)
#define LYNQ_REQUEST_SET_DTMF_VOLUME (LYNQ_REQUEST_VENDOR_BASE +3)
#define LYNQ_URC_MODIFY_APNDB (LYNQ_URC_VENDOR_BASE+4)
#define LYNQ_URC_RESET_APNDB (LYNQ_URC_VENDOR_BASE+5)


#define LYNQ_REQUEST_WRITE_SMS_TO_MEMORY (LYNQ_REQUEST_VENDOR_BASE +4)
#define LYNQ_REQUEST_READ_SMS_FROM_MEMORY (LYNQ_REQUEST_VENDOR_BASE + 5)
#define LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY (LYNQ_REQUEST_VENDOR_BASE + 6)
#define LYNQ_REQUEST_LIST_SMS_FROM_MEMORY (LYNQ_REQUEST_VENDOR_BASE + 7)
#define LYNQ_REQUEST_SET_DEFAULT_SIM_ALL (LYNQ_REQUEST_VENDOR_BASE + 8)

#define LYNQ_REQUEST_SET_SPEECH_VOLUME (LYNQ_REQUEST_VENDOR_BASE +9)
#define LYNQ_REQUEST_GET_SPEECH_VOLUME (LYNQ_REQUEST_VENDOR_BASE +10)
#define LYNQ_REQUEST_RECORD  (LYNQ_REQUEST_VENDOR_BASE +11)
#define LYNQ_REQUEST_OOS_RECOVER_TIMER_INTERVAL (LYNQ_REQUEST_VENDOR_BASE +12)
#define LYNQ_REQUEST_OOS_DEEP_SLEEP_RECOVER_TIMER_INTERVAL (LYNQ_REQUEST_VENDOR_BASE +13)
#define LYNQ_REQUEST_CHANGE_SCREEN_STATE (LYNQ_REQUEST_VENDOR_BASE + 14)/*jb.qi add for two sim suspend 2022/9/19*/
#define LYNQ_REQUEST_CHANGE_RADIO (LYNQ_REQUEST_VENDOR_BASE + 15)
/*the same with lynq_interface.h end*/

typedef enum{
    /*base abnormal*/
    LYNQ_E_PARAMETER_ANONALY=7000,
    LYNQ_E_SEND_REQUEST_FAIL=7001,
    LYNQ_E_GET_HEAD_ERROR=7002,
    LYNQ_E_INNER_ERROR=7100,
    LYNQ_E_MALLOC_ERROR=7101,
    /**/
    LYNQ_E_CARDSTATE_ERROR=8000,
    /* The voice service state is out of service*/
    LYNQ_E_STATE_OUT_OF_SERVICE=8001,
    /* The voice service state is EMERGENCY_ONLY*/
    LYNQ_E_STATE_EMERGENCY_ONLY=8002,
    /* The radio power is power off*/
    LYNQ_E_STATE_POWER_OFF=8003,
    LYNQ_E_TIME_OUT=8004,
    /*create or open sms DB fail */
    LYNQ_E_SMS_DB_FAIL=8005,
    /*Failed to execute sql statement*/
    LYNQ_E_SMS_SQL_FAIL = 8006,
    LYNQ_E_SMS_NOT_FIND = 8007,
    /* The logic conflict*/
    LYNQ_E_CONFLICT=9000,
    /*Null anomaly*/
    LYNQ_E_NULL_ANONALY=9001,   
}LYNQ_E;

#define MODULE_CLOSED (0)
#define MODULE_SWITCHING  (1)
#define MODULE_RUNNING (2)

extern int g_module_init_flag;

#endif
