#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "ftp/lynq_ftp.h"

int lynq_ftpshm_create( void )
{
  key_t key;
  int shm_id;
  
  key = ftok(FTPSHMPATH,FTPSHMID);
  shm_id = shmget(key,sizeof(struct ftp_socket_info),0664 | IPC_CREAT | IPC_EXCL); 
  
 	if(shm_id < 0)
	{
		if(errno == EEXIST)
		shm_id = shmget(key,sizeof(struct ftp_socket_info),0664 | IPC_CREAT );
	
		else 
		{
			LYDBGLOG("[%s-%d] ftp,shm_create_fail", __FUNCTION__, __LINE__);
			return -1;
		}
	}
	return shm_id;
}

lynq_ftp_socker_info *ftpshm_act(int shmid)
{
	lynq_ftp_socker_info *p = NULL;

	p = shmat(shmid,NULL,0);

	if(p == NULL)
	{
		LYDBGLOG("[%s-%d] ftp,shm_act_fail", __FUNCTION__, __LINE__);
		return NULL;
	}

	return p;
}

void lynq_ftpshm_deact(lynq_ftp_socker_info *shm)
{
	int ret;
	
	ret = shmdt(shm);

	if(ret < 0)
	{
		LYDBGLOG("[%s-%d] ftp,shm_deact_fail", __FUNCTION__, __LINE__);
		return ;
	}

	return;
}

void lynq_ftpshm_del(int shmid)
{
	int ret;

	ret = shmctl(shmid, IPC_RMID, 0);

	if(ret == -1)
	{
		LYDBGLOG("[%s-%d] ftp,shm_del_fail", __FUNCTION__, __LINE__);
		return ;
	}

	return;
}
