#include <stdio.h>
#include <stdlib.h>
#include <liblog/lynq_deflog.h>
#include "include/liblynq-qser-adc.h"
#define USER_LOG_TAG "LIBLYNQ_QSER_ADC"
#undef LOG_TAG
#define LOG_TAG "LIBLYNQ_QSER_ADC"
int qser_adc_show(ADC_CHANNEL_E qadc)
{
    int adc_value;
    char cmd[1024];
    char cmd_ret[1024];
    FILE *fp;
    switch(qadc)
    {
    case QADC_NONE:
    {
        LYERRLOG("function %s line %d\n", __FUNCTION__, __LINE__);
        return 0;
    }
    case ADC0:
    {
        LYDBGLOG("function %s line %d\n", __FUNCTION__, __LINE__);
        sprintf(cmd,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input");
        break;
    }
    case ADC1:
    {
        LYDBGLOG("function %s line %d\n", __FUNCTION__, __LINE__);
        sprintf(cmd,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input");
        break;
    }
    case ADC2:
    {
        LYDBGLOG("function %s line %d\n", __FUNCTION__, __LINE__);
        sprintf(cmd,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input");
        break;
    }
    default:
    {
        LYERRLOG("input error\n");
        return -1;
    }
    }
    if((fp = popen(cmd,"r")) == NULL)
    {
        LYERRLOG("popen error!");
        return -1;
    }
    if((fread(cmd_ret,sizeof(cmd_ret),1,fp))<0)
    {
        LYERRLOG("fread fail!");
        fclose(fp);
        return -1;
    }
    fclose(fp);

    adc_value = atoi(cmd_ret);
    if (adc_value < 0 || adc_value > 12000)
    {
        LYERRLOG("bad adc value %s!", cmd_ret);
        return -1;
    }

    return adc_value;
}
