
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <string.h>
#include <vendor-ril/telephony/ril.h>
#include <vendor-ril/telephony/mtk_ril_sp.h>
#include <vendor-ril/telephony/mtk_ril_ivt.h>
#include "lynq_sms.h"
#include "lynq_module_common.h"
#include "lynq_module_socket.h"

#define CALL_OFF (0)
#define CALL_ON  (1)
#define USER_LOG_TAG "LYNQ_SMS"

using ::android::Parcel;


int sms_storage_index = 0;

/**
 * @brief mark call initialization state
 * 0: deinit state
 * 1: init state
 */
int g_module_init_flag = 0;

//static lynq_call_list_e_t s_call_lists[LYNQ_CALL_MAX]={};
//static bool s_call_list_loop = 0;
//static pthread_t s_call_list_loop_tid = -1;
static pthread_mutex_t s_notice_new_sms_mutex  = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_notice_new_sms_cond = PTHREAD_COND_INITIALIZER;

//static int s_module_isDial = 0;
//static pthread_mutex_t call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
//static pthread_cond_t call_state_change_cond = PTHREAD_COND_INITIALIZER;
//static int s_CallId = 0;
//static pthread_mutex_t s_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
//static pthread_cond_t s_call_state_change_cond = PTHREAD_COND_INITIALIZER;


static char *strdupReadString(Parcel* &p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

void lynqNoticeGetModuleNewSms()
{
    pthread_mutex_lock(&s_notice_new_sms_mutex);
    pthread_cond_signal(&s_notice_new_sms_cond);
    pthread_mutex_unlock(&s_notice_new_sms_mutex);
    
}

void lynqNoticeWaitModuleNewSms()
{
    pthread_mutex_lock(&s_notice_new_sms_mutex);
    pthread_cond_wait(&s_notice_new_sms_cond, &s_notice_new_sms_mutex);
    pthread_mutex_unlock(&s_notice_new_sms_mutex);
}

int lynq_sms_init(int uToken)
{
    LYLOGSET(LOG_DEBUG);
    LYLOGEINIT(USER_LOG_TAG);  	
    LYERRLOG("%s start, parameter is %d", __func__,uToken);
	
    if(g_module_init_flag != MODULE_CLOSED)
    {
        LYERRLOG("module state is %d",g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(uToken <0){
        LYERRLOG("uToken  is less than 0",uToken);      
        return LYNQ_E_PARAMETER_ANONALY;
    }
    g_module_init_flag = MODULE_SWITCHING;



    g_module_Global_uToken = uToken;

    int ret = lynq_start_all_urc_socket_thread();
    if(ret != RESULT_OK)
    {
        LYERRLOG("init socket urc fail!!!");
        g_module_init_flag = MODULE_CLOSED;
        return LYNQ_E_INNER_ERROR;
    }

    ret = lynq_start_all_rc_socket_thread();
    if(ret !=RESULT_OK)
    {
        LYERRLOG("init socket client fail!!!");
        lynq_close_all_urc_socket_thread();
        g_module_init_flag = MODULE_CLOSED;
        return LYNQ_E_INNER_ERROR;
    }
    g_module_init_flag = MODULE_RUNNING;
    LYERRLOG("%s end suc", __func__);
    return RESULT_OK;
}

/*
Converts an array to a hexadecimal string
*/
void ArrayToStr(unsigned char *Buff, unsigned int BuffLen, char *OutputStr)
{
    int i = 0;
    char TempBuff[MSG_MAX_LEN * 2 +1] = {0};
    char strBuff[MSG_MAX_LEN * 2 +1] = {0};

    for(i = 0; i<BuffLen;i++)
    {
        sprintf(TempBuff,"%02x",(unsigned char)Buff[i]);
        strncat(strBuff,TempBuff,BuffLen*2);
    }
    strncpy(OutputStr, strBuff, BuffLen*2);
    return;
}

int lynq_send_sms(char telephony_num[TELEPHONE_NUM_LEN], int charset, char *msg, int msglen)
{
    LYINFLOG("charset is %d, msglen %d\n", charset, msglen);
    if(msglen > MSG_MAX_LEN || msglen <= 0)
    {
        LYERRLOG("msglen out of the range");
        return LYNQ_E_SMS_MSGLEN_OUT_OF_RANGE;
    }
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;
    if(charset == 1)//means 8 bit
    {
        char msg_e_b[msglen*2+1] = {0};// +1 for end of string.*2:A char array contains two elements of a string for each value
        ArrayToStr(msg, msglen, msg_e_b);
        LYINFLOG("tel, charset, msg_e_b: %s, %d, %s", telephony_num, charset, msg_e_b);
        int ret=lynq_send_common_request(p,20,RIL_REQUEST_SEND_SMS,3,"%s %d %s",telephony_num, charset, msg_e_b);
        if(ret!=RESULT_OK)
        {
            LYERRLOG("%s  8bit send error %d",__func__,__LINE__);
            return ret;
        }
        delete p;
        return RESULT_OK;
    }
    else//other bit
    {
        int ret=lynq_send_common_request(p,20,RIL_REQUEST_SEND_SMS,3,"%s %d %s",telephony_num, charset, msg);
        if(ret!=RESULT_OK)
        {
            LYERRLOG("%s  7bit send error %d",__func__,__LINE__);
            return ret;
        }
        delete p;
        return RESULT_OK;
    }
}

int lynq_read_sms(int index,int *status,int *charset,char smsc[SMSC_MAX_LEN],int *smscLen,int *smslen,char message[MSG_MAX_LEN],char teleNum[TELEPHONE_NUM_LEN],int *numLen,int *current,int *total)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_READ_SMS_FROM_MEMORY,1,"%d",index);
    if(ret!=0)
    {
        return ret;
    }
    LYDBGLOG("LYNQ_REQUEST_READ_SMS_FROM_MEMORY SUCCESS!");
    p->readInt32(&index);
    p->readInt32(status);
    p->readInt32(charset);
    /*lei add for gws 2022/5/12*/
    p->readInt32(current);
    p->readInt32(total);
    /*lei add for gws 2022/5/12*/
    char *phone_num = NULL;
    phone_num = strdupReadString(p);
    *numLen = strlen(phone_num);
    strcpy(teleNum, phone_num);
    char *smscenter = NULL;
    smscenter = strdupReadString(p);
    *smscLen = strlen(smscenter);
    strcpy(smsc,smscenter);
    char *msg = NULL;
    msg = strdupReadString(p);
    *smslen = strlen(msg);
    strcpy(message,msg);
    free(phone_num);
    free(smscenter);
    free(msg);
    delete p;
    return RESULT_OK;
}

int lynq_get_smsc_address(char service_num[SMSC_MAX_LEN])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_GET_SMSC_ADDRESS,0,"");
    if(ret!=0)
    {
        return ret;
    }
    LYDBGLOG("lynq_get_smsc_address SUCCESS!");
    char *temp = strdupReadString(p);
    strcpy(service_num, temp);
    free(temp);
    delete p;
    return RESULT_OK;
}

int lynq_wait_receive_new_sms(int *handle)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(handle==NULL)
    {
        LYERRLOG("handle is null!!!");
        return LYNQ_E_NULL_ANONALY;
    }
    lynqNoticeWaitModuleNewSms();
    *handle = sms_storage_index;
    return RESULT_OK;
}

int lynq_set_smsc_address(const char* service_num)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SET_SMSC_ADDRESS,1,"%s", service_num);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s  8bit send error %d",__func__,__LINE__);
        return ret;
    }
    LYDBGLOG("lynq_set_smsc_address SUCCESS!");
    delete p;
    return RESULT_OK;
}

int lynq_list_sms(char index_list[SMS_NUM_MAX])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_LIST_SMS_FROM_MEMORY,0,"");
    if(ret!=0)
    {
        return ret;
    }
    LYDBGLOG("lynq_list_sms SUCCESS!");
    char *temp = strdupReadString(p);
    strcpy(index_list, temp);
    free(temp);
    delete p;
    return RESULT_OK;
}

int lynq_delete_sms(int index)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY,1,"%d", index);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s  8bit send error %d",__func__,__LINE__);
        return ret;
    }
    LYDBGLOG("lynq_delete_sms SUCCESS!");
    delete p;
    return RESULT_OK;
}

bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case RIL_UNSOL_RESPONSE_NEW_SMS:
            return true;
        default:
            return false;
    }
}

int lynq_sms_deinit(void)
{
    LYERRLOG("%s start", __func__);

    if (g_module_init_flag != MODULE_RUNNING)
    {
       LYERRLOG("module state is %d",g_module_init_flag);
       return LYNQ_E_CONFLICT;
    }
    g_module_init_flag = MODULE_SWITCHING;
    lynq_close_all_urc_socket_thread();
    lynq_close_all_rc_socket_thread(); 
    g_module_init_flag = MODULE_CLOSED;
    
    LYERRLOG("%s end suc", __func__);
    return RESULT_OK;
}

void urc_msg_process(Parcel *p)
{ 
    int resp_type;
    int urcid;
    int slot_id;

    int size=p->dataSize();
    p->readInt32(&resp_type);
    p->readInt32(&urcid);
    p->readInt32(&slot_id);
    LYINFLOG("%s urc id = %d, slot_id = %d, size is %d, msg is %s",__func__, urcid,slot_id,size,requestToString(urcid));
    switch (urcid)
    {
        case RIL_UNSOL_RESPONSE_NEW_SMS://new sms received
        {
            LYINFLOG("**************:resp_type=%d,urcid=%d,slot_id=%d",resp_type,urcid,slot_id);
            char *msg = NULL;
            int index = 0;
            msg = strdupReadString(p);
            p->readInt32(&index);
            sms_storage_index = index;
            lynqNoticeGetModuleNewSms();
            free(msg);
            break;
        }
        default:
            break;
    }
}

