/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include <string>
#include <vector>
#include <thread>
#include <chrono>

#include "Phone_utils.h"
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_MODEMTEST"

int mCurrentEmmodemtestFlag = -1; // at cmd handle flag

const int MODEM_NONE = 0;
const int MODEM_CTA = 1;
const int MODEM_FTA = 2;
const int MODEM_IOT = 3;
const int MODEM_QUERY = 4;
const int MODEM_OPERATOR = 5;
const int MODEM_FACTORY = 6;
const int MODEM_QUERY_CDMA = 7;
const int MODEM_CDMA = 8;
const int MODEM_QUERY_CLSC = 9;
const int MODEM_CLSC = 10;

int mCtaOption = 0;
int mIotOption = 0;
int mFtaOption = 0;
int mOperatorOption = 0;
int mFactoryOption = 0;
int mCdmaOption = 0;

int modem_id = -1;
int modem_option_cnt = -1;
int modem_option[8] = {0};

static const int EVENT_QUERY_PREFERRED_TYPE_DONE = 1000;
static const int EVENT_SET_PREFERRED_TYPE_DONE = 1001;
static const int REBOOT_DIALOG = 2000;
static const int NETWORK_TYPE = 3; //type 3 means GSM/WCDMA (auto mode) 0 means GSM/WCDMA (WCDMA preferred)

static const int CMD_LENGTH = 6;
static const int MODE_LENGTH = 3;

//static const String PREFERENCE_GPRS = "com.mtk.GPRS";
//static const String PREF_ATTACH_MODE = "ATTACH_MODE";
//static const String PREF_ATTACH_MODE_SIM = "ATTACH_MODE_SIM";
static const int ATTACH_MODE_ALWAYS = 1;
static const int ATTACH_MODE_NOT_SPECIFY = -1;
static const int DOCOMO_OPTION = 1 << 7;
static const int SOFTBANK_OPTION = 1 << 8;
//static const String PROP_TEST_CARD = "persist.sys.forcttestcard";
//static const String PROP_TDD_TEST = "persist.sys.forcttddtest";

static const int IPO_ENABLE = 1;
static const int IPO_DISABLE = 0;

static const int PCH_DATA_PREFER = 0;
static const int PCH_CALL_PREFER = 1;

static const int INDEX_SPIRENT = 1;
static const int FLAG_UNLOCK = 0x200000;
static const int FLAG_NOT_DETECT_CDMA_CARD = 0x100000;

bool mModemFlag = false;
int mCurrentMode = 0;
int mCurrentCmdFlag = 0;

void setCurrentTestFlag(int msg){
    mCurrentEmmodemtestFlag = msg;
    return ;
}

void  sendATCommand_modemtest(const char *cmd,int msg)
{
    setCurrentTestFlag(msg);
    emSendATCommand(cmd, Radio_capability_switch_util::get_main_capability_phone_id());
    return ;
}

static void sendATCommandCdma(std::string str, int message) {
    std::vector<std::string> cmdOri(3);
    cmdOri[0] = "AT+ECTM=" + str;
    cmdOri[1] = "";
    cmdOri[2] = "DESTRILD:C2K";
    std::vector<std::string> cmds = getCdmaCmdArr(cmdOri);
    std::string cmd;
    for (auto s : cmds) {
        cmd += s;
    }
    sendATCommand_modemtest(cmd.c_str(), message);
    sendATCommand_modemtest("AT+RFSSYNC", -1);
}

void setCdmaOption() {
    if (modem_option[0] == INDEX_SPIRENT) {
        sendATCommandCdma("\"SPIRENT\"", MODEM_CDMA);
    } else {
        sendATCommandCdma("\"NONE\"", MODEM_CDMA);
    }
}
void  sendATCommand_modemtest(const char *str,int flag,int msg)
{
    char cmd[32] = {0};
    mCurrentCmdFlag = (mCurrentCmdFlag & 0xFF0000) | flag;
    sprintf(cmd,"AT+EPCT=%s,%d",str,mCurrentCmdFlag);
    setCurrentTestFlag(msg);
    emSendATCommand(cmd,Radio_capability_switch_util::get_main_capability_phone_id());
    return ;
}

int setPreferredNetworkType_modemtest(int type)
{
    RequestInfo *pRI_preferredNetType = creatRILInfoAndInit(RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE, OTHER,
            (RIL_SOCKET_ID)Radio_capability_switch_util::get_main_capability_phone_id());
    android::Parcel p;
    size_t pos =  p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(type);
    p.setDataPosition(pos);
    pRI_preferredNetType->pCI->dispatchFunction(p, pRI_preferredNetType);
    return 1;
}
void checkNetworkType() {
    RLOGD("checkNetworkType");
    RequestInfo *pRI_preferredNetType = creatRILInfoAndInit(RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE, OTHER,
            (RIL_SOCKET_ID)Radio_capability_switch_util::get_main_capability_phone_id());
    android::Parcel p;
    pRI_preferredNetType->pCI->dispatchFunction(p, pRI_preferredNetType);
}

void handleQuery(char* data)
{
    if(strstr(data,"+EPCT:") != NULL){
        char *p = strstr(data,",");
        if(p != NULL){
            char mode[3] = {0};
            char flag[12] = {0};
            strncpy(mode,p-1,1);
            char *end = strstr(data,"OK");
            if(end != NULL){
                RLOGD("end %s ", end);
                RLOGD("end len %d ", end - p -1);
                strncpy(flag,p+1,end - p -1);
                mCurrentCmdFlag = atoi(flag);
            }
            mCurrentMode = atoi(mode);
            RLOGD("mCurrentMode %d mCurrentCmdFlag %d",mCurrentMode,mCurrentCmdFlag);
        }
    }
    return;
}
const char *modem_test_cta_options[] = {
    "Integrity Check",
    "RLC TL1",
    "K1297",
    "SN Conflict",
    "CF query",
    "DLMN lock",
    "Measurement open",
    "Disable DPA",
    "Intra CMR",
};

const char *modem_test_fta_options[] = {
    "ANITE",
    "CRTUG",
    "CRTUW",
    "ANRITSU",
    "CMW500"
};

void setGprsTransferType(int type) {
    RLOGD("setGprsTransferType %d" ,type);
    int property = (type == PCH_DATA_PREFER ? 1 : 0);
    RLOGD("Change persist.radio.gprs.prefer to %d" ,property);
    //SystemProperties.set("persist.radio.gprs.prefer", property);
    char cmd[32];
    sprintf(cmd,"AT+EGTP=%d",type);
    sendATCommand_modemtest(cmd,-1);
    sprintf(cmd,"AT+EMPPCH=%d",type);
    sendATCommand_modemtest(cmd,-1);
    //sendATCMD
}
void attachOrDetachGprs() {
    if ((mOperatorOption & DOCOMO_OPTION) != 0 || (mOperatorOption & SOFTBANK_OPTION) != 0) {
        RLOGD("Attach GPRS for DoCoMo/Softband");
        //SystemProperties.set("persist.radio.gprs.attach.type", "1");
        char cmdStr[] = {"AT+EGTYPE=1,1"};
        sendATCommand_modemtest(cmdStr,-1);
    } else {
        RLOGD("Dettach GPRS for DoCoMo/Softband");
        //SystemProperties.set("persist.radio.gprs.attach.type", "0");
        char cmdStr[] = {"AT+EGTYPE=0,1"};
        sendATCommand_modemtest(cmdStr,-1);
    }
}
void turnoffWCMAPreferred(){
    if(mModemFlag){
        setCurrentTestFlag(EVENT_SET_PREFERRED_TYPE_DONE);
        setPreferredNetworkType_modemtest(NETWORK_TYPE);
    }
}
int modemTestProcess(int id,int *whichButton, int ButtonCount)//from onCreate & onCreateDialog
{
    RLOGD("modemTestProcess id: %d, mCurrentMode: %d", id, mCurrentMode);
    switch(id){
        case MODEM_NONE:
        {
            RLOGD("modemTestProcess MODEM_NONE");
            sendATCommand_modemtest("0", 0, MODEM_NONE);
            if (mCurrentMode == MODEM_FTA) {
                setGprsTransferType(PCH_CALL_PREFER);
            }
            break;
        }
        case MODEM_CTA:
        {
            RLOGD("modemTestProcess MODEM_CTA");
            mCtaOption = 0;
#ifndef TARGET_PLATFORM_MT2735
            for(int i = 0; i < ButtonCount; i++){
                mCtaOption += (1 << whichButton[i]);
            }
#endif
            sendATCommand_modemtest("1", mCtaOption, MODEM_CTA);
#ifndef TARGET_PLATFORM_MT2735
            turnoffWCMAPreferred();
#endif
            if (mCurrentMode == MODEM_FTA) {
                setGprsTransferType(PCH_CALL_PREFER);
            }
            break;
        }
        case MODEM_FTA:
        {
            RLOGD("modemTestProcess MODEM_FTA");
            mFtaOption = 0;
            for(int i = 0; i < ButtonCount; i++){
                RLOGD("which button %d",whichButton[i]);
                mFtaOption += (1 << whichButton[i]);
            }
            RLOGD("mFtaOption %x", mFtaOption);
#ifndef TARGET_PLATFORM_MT2735
            turnoffWCMAPreferred();
#endif
            sendATCommand_modemtest("2", mFtaOption, MODEM_FTA);
            //enableIPO(false);
            setGprsTransferType(PCH_DATA_PREFER);
            break;
        }
        case MODEM_IOT:
        {
            RLOGD("modemTestProcess MODEM_IOT");
            mIotOption = 0;
            for(int i = 0; i < ButtonCount; i++){
                mIotOption += (1 << whichButton[i]);
            }
            sendATCommand_modemtest("3", mIotOption, MODEM_IOT);
            if (mCurrentMode == MODEM_FTA) {
                setGprsTransferType(PCH_CALL_PREFER);
            }
            break;
        }
        case MODEM_OPERATOR:
        {
            RLOGD("modemTestProcess MODEM_OPERATOR");
            mOperatorOption = 0;
            for(int i = 0; i < ButtonCount; i++){
                mOperatorOption += (1 << whichButton[i]);
            }
#ifndef TARGET_PLATFORM_MT2735
            turnoffWCMAPreferred();
#endif
            attachOrDetachGprs();
            sendATCommand_modemtest("4", mOperatorOption, MODEM_OPERATOR);
            if (mCurrentMode == MODEM_FTA) {
                setGprsTransferType(PCH_CALL_PREFER);
            }
            break;
        }
        case MODEM_CDMA:
        {
            RLOGD("modemTestProcess MODEM_CDMA");
            setCdmaOption();
            break;
        }
        case MODEM_FACTORY:
        {
            RLOGD("modemTestProcess MODEM_FACTORY");
#ifndef TARGET_PLATFORM_MT2735
            turnoffWCMAPreferred();
#endif
            sendATCommand_modemtest("5", 0, MODEM_FACTORY);
            if (mCurrentMode == MODEM_FTA) {
                setGprsTransferType(PCH_CALL_PREFER);
            }
            break;
        }
        default:
            RLOGD("modemTestProcess default");
            break;
    }
    return 0;
}

const char * getToastString(int what) {
    switch (what) {
    case MODEM_NONE:
        return "MODEM_NONE";
    case MODEM_CTA:
        return "MODEM_CTA";
    case MODEM_FTA:
        return "MODEM_FTA";
    case MODEM_IOT:
        return "MODEM_IOT";
    case MODEM_OPERATOR:
        return "MODEM_OPERATOR";
    case MODEM_FACTORY:
        return "MODEM_FACTORY";
    case MODEM_CDMA:
        return "MODEM_CDMA";
    default:
        return "";
    }
}

void emModemtestAtCmdHandle(char*response, int responselen) {
    RLOGD("emModemtestAtCmdHandle mCurrentEmmodemtestFlag : %d",mCurrentEmmodemtestFlag);
    switch (mCurrentEmmodemtestFlag) {
        case MODEM_NONE:
        case MODEM_CTA:
        case MODEM_FTA:
        case MODEM_IOT:
        case MODEM_OPERATOR:
        case MODEM_FACTORY:
        case MODEM_CDMA:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("%s  AT cmd success. %s\n",getToastString(mCurrentEmmodemtestFlag),response);
            }
            else {
                RLOGD("%s  AT cmd failed.\n",getToastString(mCurrentEmmodemtestFlag));
            }
            break;
        }
        case MODEM_QUERY:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("Query success. %s\n",response);
                handleQuery(response);
            }
            else {
                RLOGD("Query fail. ");
            }
            break;
        }
        case EVENT_QUERY_PREFERRED_TYPE_DONE:
        {
            if ((responselen > 0) && (response != NULL)) {
                int type = -1;
                //parse currect preferred type
                type = atoi(response);
                RLOGD("Get Preferred Type: %d ",type);
                if (type == 0) {
                    mModemFlag = true;
                } else {
                    mModemFlag = false;
                }
            }
            else {
                RLOGD("Query preferred type fail ");
            }
            break;
        }
        case EVENT_SET_PREFERRED_TYPE_DONE:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("Turn off WCDMA Preferred success\n");
            }
            else {
                RLOGD("Turn off WCDMA Preferred Fail");
            }
            break;
        }
        default:
            break;
    }
}

void emModemtestThread(int n)
{
    RLOGD("Modem Test wait 2s");
    std::this_thread::sleep_for(std::chrono::seconds(2));
    RLOGD("Modem Test: %s, ",getToastString(modem_id));
    modemTestProcess(modem_id,modem_option,modem_option_cnt);
    RLOGD("Modem Test: unregisterNetwork() ");
    android::unregisterNetwork();
    android::emResultNotify(RET_STRING_MODEMTEST_SUCCESS);
    RLOGD("Modem Test done");
}

int emModemtestStart(int argc, int multicnt,int *item)
{
    //item[0]: fta/cta/... item[1] count  item[2]..item[count+1] which part
    RLOGD("emModemtestStart called");
    if(argc < 1)
    {
        RLOGD("emModemtestStart: please select id to test: \
            ");
        android::emResultNotify(RET_STRING_MODEMTEST_FAIL);
        return -1;
    }
    int idmapping[7] = {MODEM_NONE,MODEM_CTA,MODEM_FTA,MODEM_IOT,MODEM_FACTORY,MODEM_FACTORY, MODEM_CDMA};
    RLOGD("emModemtestStart called item[0]: %d", item[0]);
    modem_id = idmapping[item[0]];
    modem_option_cnt = multicnt;
    modem_option[0] = item[1];
    RLOGD("emModemtestStart modem_option[0]: %d", item[1]);

    for(int i = 0; i < modem_option_cnt ; i++){
        modem_option[i+1] = item[2+i];
        RLOGD("emModemtestStart modem_option[%d]: %d", i+1, item[2+i]);
    }
    modem_option_cnt+=1;

    RLOGD("emModemtestStart modem_option_cnt %d",modem_option_cnt);
    mCtaOption = 0;
    mIotOption = 0;
    mFtaOption = 0;
    mOperatorOption = 0;
    mFactoryOption = 0;
    mCdmaOption = 0;
    mCurrentEmmodemtestFlag = 0;
    android::registerForATcmdResponse(emModemtestAtCmdHandle);

    if(modem_id != MODEM_CDMA) {
#ifndef TARGET_PLATFORM_MT2735
        setCurrentTestFlag(EVENT_QUERY_PREFERRED_TYPE_DONE);
        checkNetworkType();
#endif
        std::this_thread::sleep_for(std::chrono::seconds(2));
        sendATCommand_modemtest("AT+EPCT?",MODEM_QUERY);
    }

    std::thread em_modem_test(emModemtestThread, 0);
    em_modem_test.join();
    return (0);
}
#endif

