/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <string>
using namespace std;

#include "rfdesense/RfDesenseRatInfo.h"
#include "rfdesense/RfDesenseTxTest.h"

RfDesenseRatInfo::RfDesenseRatInfo() {
    // TODO Auto-generated constructor stub

}

RfDesenseRatInfo::~RfDesenseRatInfo() {
    // TODO Auto-generated destructor stub
}

std::string RfDesenseRatInfo::getRatName() {
    return RatName;
}

void RfDesenseRatInfo::setRatName(std::string mRatname) {
    if (!mRatname.empty()) {
        RatName = mRatname;
    }
}

bool RfDesenseRatInfo::getRatCheckState() {
    return RatCheckState;
}

void RfDesenseRatInfo::setRatCheckState(bool mRatCheckState) {
    RatCheckState = mRatCheckState;
}

bool RfDesenseRatInfo::getRatSendState() {
    return RatSendState;
}

void RfDesenseRatInfo::setRatSendState(bool mRatSendState) {
    RatSendState = mRatSendState;
}

std::string RfDesenseRatInfo::getRatCmdStart() {
    return RatCmdStart;
}

void RfDesenseRatInfo::setRatCmdStart(std::string mRatCmdStart) {
    if (!mRatCmdStart.empty()) {
        RatCmdStart = mRatCmdStart;
    }
}

std::string RfDesenseRatInfo::getRatCmdStop() {
    return RatCmdStop;
}

void RfDesenseRatInfo::setRatCmdStop(std::string mRatCmdStop) {
    if (!mRatCmdStop.empty()) {
        RatCmdStop = mRatCmdStop;
    }
}

std::string RfDesenseRatInfo::getRatCmdSwitch() {
    return RatCmdSwitch;
}

void RfDesenseRatInfo::setRatCmdSwitch(std::string mRatCmdSwitch) {
    RatCmdSwitch = mRatCmdSwitch;
}

std::string RfDesenseRatInfo::getRatCmdPowerRead() {
    return RatCmdPowerRead;
}

void RfDesenseRatInfo::setRatCmdLteBwRb(int ratCmdLteBw, int ratCmdLteRb) {
    if (ratCmdLteBw == -1) {
        RatCmdLteBw = DEFAULT_BAND_WIDTH;
    } else {
        RatCmdLteBw = ratCmdLteBw;
    }
    if (ratCmdLteRb == -1) {
        RatCmdLteRb = DEFAULT_VRB_LENGTH;
    } else {
        RatCmdLteRb = ratCmdLteRb;
    }
}

void RfDesenseRatInfo::setRatCmdStart(std::string rat, int channel, int power,
        int band) {
    std::string command = "";
    if (0 == rat.compare(RfDesenseTxTest::mRatName[0])) {  //GSM
        command = std::string("AT+ERFTX=2,1,") + std::to_string(channel) + ","
                + std::to_string(4100) + "," + std::to_string(band) + ","
                + std::to_string(0) + "," + std::to_string(power) + ","
                + std::to_string(0);
    } else if (0 == rat.compare(RfDesenseTxTest::mRatName[1])) {    //TDSCDMA
        command = std::string("AT+ERFTX=0,0,") + std::to_string(band) + ","
                + std::to_string(channel) + "," + std::to_string(power);
    } else if (0 == rat.compare(RfDesenseTxTest::mRatName[2])) {    //WCDMA
        command = std::string("AT+ERFTX=0,0,") + std::to_string(band) + ","
                + std::to_string(channel) + "," + std::to_string(power);
    } else if (0 == rat.compare(RfDesenseTxTest::mRatName[3])) {    //LTE(FDD)
        command = std::string("AT+ERFTX=6,0,2,") + std::to_string(band) + ","
                + std::to_string(RatCmdLteBw) + "," + std::to_string(channel)
                + ",1,0,0,0," + std::to_string(RatCmdLteRb) + "," + "0,"
                + std::to_string(power);
    } else if (0 == rat.compare(RfDesenseTxTest::mRatName[4])) {    //LTE(TDD)
        command = std::string("AT+ERFTX=6,0,2,") + std::to_string(band) + ","
                + std::to_string(RatCmdLteBw) + "," + std::to_string(channel)
                + ",0,0,0,0," + std::to_string(RatCmdLteRb) + "," + "0,"
                + std::to_string(power);
    } else if (0 == rat.compare(RfDesenseTxTest::mRatName[5])) {    //CDMA(EVDO)
        command = std::string("AT+ERFTX=13,4,") + std::to_string(channel) + ","
                + std::to_string(band) + "," + std::to_string(power);
    } else if (0 == rat.compare(RfDesenseTxTest::mRatName[6])) {    //CDMA(1x)
        command = std::string("AT+ECRFTX=1,") + std::to_string(channel) + ","
                + std::to_string(band) + "," + std::to_string(power) + ",0";
    }
    RatCmdStart = command;
}

void RfDesenseRatInfo::setRatPowerRead(std::string mRatCmdPowerRead) {
    RatCmdPowerRead = mRatCmdPowerRead;
}

std::string RfDesenseRatInfo::getRatband() {
    return Ratband;
}

void RfDesenseRatInfo::setRatband(std::string ratband) {
    Ratband = ratband;
}

std::string RfDesenseRatInfo::getRatPowerSet() {
    return RatPowerSet;
}

void RfDesenseRatInfo::setRatPowerSet(std::string ratPowerSet) {
    RatPowerSet = ratPowerSet;
}

int RfDesenseRatInfo::getRatTxtimes() {
    return RatTxtimes;
}

void RfDesenseRatInfo::setRatTxtimes(int ratTxtimes) {
    RatTxtimes = ratTxtimes;
}
