/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef RFDESENSETXTESTGSM_H_
#define RFDESENSETXTESTGSM_H_

#include <string>
#include <vector>
#include <memory>
#include <mutex>

class RfDesenseTxTestGsm {
public:
    std::string get_command();
    std::string get_band();
    std::string get_power();
    bool set_band(int value);
    bool set_pattern(int value);
    bool set_channel(std::string value);
    bool set_power(std::string value);
    bool set_afc(std::string value);
    bool set_tsc(std::string value);
    void show_default();
    void show_channel();
    void show_power();
    void show_afc();
    void show_tsc();
    RfDesenseTxTestGsm();
    virtual ~RfDesenseTxTestGsm();
    static std::shared_ptr<RfDesenseTxTestGsm> get_instance();
private:
    static std::shared_ptr<RfDesenseTxTestGsm> m_instance;
    static std::mutex mutex;
    int min = -1;
    int max = -1;
    int min2 = -1;
    int max2 = -1;
    int step = 1;
    static const int INDEX_BAND;
    static const int INDEX_CHANNEL;
    static const int INDEX_POWER;
    static const int INDEX_AFC;
    static const int INDEX_TSC;
    static const int INDEX_PATTERN;
    static std::string band;
    static std::string channel;
    static std::string power;
    static std::string afc;
    static std::string tsc;
    static std::string pattern;
    std::string command;
    bool check_channel(int index, std::string channel);
    bool check_power(int index, std::string power);
    bool check_afc(std::string afc);
    bool check_tsc(std::string tsc);
    bool check_pattern(std::string pattern);
    static const std::vector<std::string> band_values;
    static const std::vector<std::vector<std::string>> gsm_gmsk_limits;
};

#endif /* RFDESENSETXTESTGSM_H_ */
