/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SMSMESSAGE_H_
#define SMSMESSAGE_H_
#include <cstdint>
#include <memory>
#include <string>
#include <vector>

#include "SmsMessageBase.h"
#include "SmsEnvelope.h"
#include "BearerData.h"

class SmsMessage: public SmsMessageBase {
public:
  SmsMessage();
  SmsMessage(std::shared_ptr<SmsAddress> addr,
      std::shared_ptr<SmsEnvelope> env);
  virtual ~SmsMessage();
  class SubmitPdu: SubmitPduBase {
  };
  static std::shared_ptr<SmsMessage> createFromPdu(std::vector<uint8_t> pdu);
  virtual SmsConstants::MessageClass getMessageClass() override;
  virtual int getProtocolIdentifier() override;
  virtual bool isReplace() override;
  virtual bool isCphsMwiMessage() override;
  virtual bool isMWIClearMessage() override;
  virtual bool isMWISetMessage() override;
  virtual bool isMwiDontStore() override;
  virtual int getStatus() override;
  virtual bool isStatusReportMessage() override;
  virtual bool isReplyPathPresent() override;
  //static std::shared_ptr<SmsMessage> createFromEfRecord(int index, uint8_t* data, int length);
  int getTeleService() {
    return mEnvelope->teleService;
  }
  int getMessageType();
  void parseSms();
  void createPdu();
  std::vector<std::uint8_t> getIncomingSmsFingerprint();
  static uint8_t convertDtmfToAscii(uint8_t dtmfDigit);
private:

  //void parsePduFromEfRecord(uint8_t* pdu, int length);
  constexpr static uint8_t TELESERVICE_IDENTIFIER = 0x00;
  constexpr static uint8_t SERVICE_CATEGORY = 0x01;
  constexpr static uint8_t ORIGINATING_ADDRESS = 0x02;
  constexpr static uint8_t ORIGINATING_SUB_ADDRESS = 0x03;
  constexpr static uint8_t DESTINATION_ADDRESS = 0x04;
  constexpr static uint8_t DESTINATION_SUB_ADDRESS = 0x05;
  constexpr static uint8_t BEARER_REPLY_OPTION = 0x06;
  constexpr static uint8_t CAUSE_CODES = 0x07;
  constexpr static uint8_t BEARER_DATA = 0x08;

  /**
   *  Status of a previously submitted SMS.
   *  This field applies to SMS Delivery Acknowledge messages. 0 indicates success;
   *  Here, the error class is defined by the bits from 9-8, the status code by the bits from 7-0.
   *  See C.S0015-B, v2.0, 4.5.21 for a detailed description of possible values.
   */
  int status = 0;

  /** Specifies if a return of an acknowledgment is requested for send SMS */
  static constexpr int RETURN_NO_ACK = 0;
  static constexpr int RETURN_ACK = 1;

  /**
   * Supported priority modes for CDMA SMS messages
   * (See 3GPP2 C.S0015-B, v2.0, table 4.5.9-1)
   */
  static constexpr int PRIORITY_NORMAL = 0x0;
  static constexpr int PRIORITY_INTERACTIVE = 0x1;
  static constexpr int PRIORITY_URGENT = 0x2;
  static constexpr int PRIORITY_EMERGENCY = 0x3;

  std::shared_ptr<SmsEnvelope> mEnvelope = nullptr;
  std::shared_ptr<BearerData> mBearerData = nullptr;
  static uint32_t mPos;
  void writeInt(uint32_t data);
  uint32_t readInt(std::vector<uint8_t> pdu);
  void writeVector(std::vector<uint8_t> v);
  std::vector<uint8_t> readVector(std::vector<uint8_t> v, int length);
  void writeByte(uint8_t data);
  uint8_t readByte(std::vector<uint8_t> pdu);
  void parsePdu(std::vector<uint8_t> pdu);
};

#endif /* SMSMESSAGE_H_ */
