#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include<stdlib.h>
#include <netinet/in.h>
#include <strings.h>
#include "liblog/liblog.h"
#include "liblog/lynq_deflog.h"


#define USER_LOG_TAG "UDPCLI"
#define BUF_LEN 128
#define ERR_CMDVALID  2	
#define ERR_SOCK  3
#define SA struct sockaddr

int main(int argc, const char *argv[])
{
	int sockfd;
	char buf[BUF_LEN];


	LYLOGEINIT(USER_LOG_TAG);    
	if(argc!=3)
	{
		LYDBGLOG("argv is wrong, please input ip and port\n");
		LYVERBLOG("+[udpcli]: error num = %d\n", ERR_CMDVALID);
		return ERR_CMDVALID;
	}

	sockfd=socket(AF_INET,SOCK_DGRAM,0);

	if(sockfd<0)
	{
		LYDBGLOG("fail to sockfd\n");
		return ERR_SOCK;
	}

	struct sockaddr_in seraddr;
	seraddr.sin_family=AF_INET;
	seraddr.sin_port=htons(atoi(argv[2]));
	seraddr.sin_addr.s_addr=inet_addr(argv[1]);

	int len=sizeof(seraddr);

	while(1)
	{
		bzero(buf,sizeof(buf));

		fgets(buf,sizeof(buf),stdin);

		sendto(sockfd,buf,sizeof(buf),0,(SA *)&seraddr,len);

		recvfrom(sockfd,buf,sizeof(buf),0,NULL,NULL);

		LYVERBLOG("+[udpcli]: cli_rcv = %s\n",buf);
	}
	return 0;
}
