#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <gio/gio.h>
#include <log/log.h>
#include <glib.h>

#define TEST_SERVICE "test.lynq" /*well-known bus name */
#define TEST_DATA_INTERFACE "test.lynq.Data" /*interface name*/
#define TEST_DATA_PATH "/test/lynq/data" /*object name*/
GMainLoop *loop = NULL;
GDBusProxy *proxy = NULL;
#define LOG_TAG "TEST_CONTROL"
int test_decrease (int a,int b,int select_argvi){
	GDBusConnection *c1;
	GVariant *result;
	GError *error;
	GMainLoop *loop;
	gint32  set_result = -1;
	RLOGD("%dzqcstart%s, %s, %d",select_argvi, __FILE__, __FUNCTION__, __LINE__);
	g_type_init();
	loop = g_main_loop_new(NULL, FALSE);   
	error = NULL;
	c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
	g_assert_no_error (error);
	error = NULL;
	g_assert (c1 != NULL);
	g_assert (!g_dbus_connection_is_closed (c1));
	result = g_dbus_connection_call_sync (c1,
                                        TEST_SERVICE,  //bus name
                                        TEST_DATA_PATH, //object path 
                                        TEST_DATA_INTERFACE,  // interface name 
                                        "reduce",                 // method name 
                                        g_variant_new ("(ii)", a,select_argvi),   //parameters 
                                         G_VARIANT_TYPE ("(i)"),                    // return type 
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
										
										

	g_assert_no_error (error);
	g_assert (result != NULL);
	g_variant_get(result, "(i)", &(set_result));
	g_variant_unref (result);
	RLOGD("%s, %s, %d,hgh %dzqcend:%d", __FILE__, __FUNCTION__, __LINE__,select_argvi,set_result);
	//g_main_loop_run (loop);
	g_main_loop_unref (loop);
	
    return set_result;
}

int test_add (int a,int b,int select_argvi){
	GDBusConnection *c1;
	GVariant *result;
	GError *error;
	GMainLoop *loop;
	gint32  set_result = -1;
	RLOGD("%dzqcstart%s, %s, %d",select_argvi, __FILE__, __FUNCTION__, __LINE__);
	g_type_init();
	loop = g_main_loop_new(NULL, FALSE);   
	error = NULL;
	c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
	g_assert_no_error (error);
	error = NULL;
	g_assert (c1 != NULL);
	g_assert (!g_dbus_connection_is_closed (c1));
	result = g_dbus_connection_call_sync (c1,
                                        TEST_SERVICE,  //bus name
                                        TEST_DATA_PATH, //object path 
                                        TEST_DATA_INTERFACE,  // interface name 
                                        "add",                 // method name 
                                        g_variant_new ("(ii)", a,select_argvi),   //parameters 
                                         G_VARIANT_TYPE ("(i)"),                    // return type 
                                        G_DBUS_CALL_FLAGS_NONE,
                                        30000,
                                        NULL,
                                        &error);
										
										

	g_assert_no_error (error);
	g_assert (result != NULL);
	g_variant_get(result, "(i)", &(set_result));
	g_variant_unref (result);
	RLOGD("%s, %s, %d,hgh %dzqcend:%d", __FILE__, __FUNCTION__, __LINE__,select_argvi,set_result);
	//g_main_loop_run (loop);
	g_main_loop_unref (loop);
	
    return set_result;
}
int test_call (int state,int select_argvi){
	GDBusConnection *c1;
	GVariant *result;
	GError *error;
	GMainLoop *loop;
	gint32  set_result = -1;
	RLOGD("select_argvi %d,start %s, %s, %d",select_argvi, __FILE__, __FUNCTION__, __LINE__);
	g_type_init();
	loop = g_main_loop_new(NULL, FALSE);   
	error = NULL;
	c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
	g_assert_no_error (error);
	error = NULL;
	g_assert (c1 != NULL);
	g_assert (!g_dbus_connection_is_closed (c1));
	result = g_dbus_connection_call_sync (c1,
                                        TEST_SERVICE,       //bus name
                                        TEST_DATA_PATH,     //object path 
                                        TEST_DATA_INTERFACE,  // interface name 
                                                                        "callstate",// method name 
                                        g_variant_new ("(i)", state,select_argvi),//parameters 
                                        G_VARIANT_TYPE ("(i)"),             // return type 
                                        G_DBUS_CALL_FLAGS_NONE,
                                        30000,
                                        NULL,
                                        &error);
										
										

	g_assert_no_error (error);
	g_assert (result != NULL);
	g_variant_get(result, "(i)", &(set_result));
	g_variant_unref (result);
	RLOGD("%s, %s, %d,hgh %d,state:%d", __FILE__, __FUNCTION__, __LINE__,select_argvi,set_result);
	//g_main_loop_run (loop);
	g_main_loop_unref (loop);
	
    return set_result;
}

/*
static GVariantBuilder * 
get_platform_data (void){
GVariantBuilder builder;
GVariant *value;
RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
 g_variant_builder_init (&builder, G_VARIANT_TYPE_STRING_ARRAY);
 RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
g_variant_builder_add (&builder, "s", "when");
g_variant_builder_add (&builder, "s", "in");
g_variant_builder_add (&builder, "s", "the");
g_variant_builder_add (&builder, "s", "course");
RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
//value = g_variant_builder_end (&builder);
return g_variant_builder_end (&builder);
}
    
void gvariant_test(){
	GVariant *value;
	GVariantIter *iter;
	gchar *str;
	g_variant_get (get_platform_data(), "as", &iter);
        while (g_variant_iter_loop (iter, "s", &str))
		RLOGD("%s, %s, %d,%s\n", __FILE__, __FUNCTION__, __LINE__,str);
		g_variant_iter_free (iter);
}
void gvariant_test2(int a,int b,int select_argvi,GVariant*parameters){
  test_add (a, b, select_argvi,parameters);
}
int test_add (int a,int b,int select_argvi){
	//,GVariant*parameters){
	GDBusConnection *c1;
	GVariant *result;
	GVariantBuilder builder;
	GError *error;
	GMainLoop *loop;
	gint32  set_result = -1;
	RLOGD("%dzqcstart%s, %s, %d",select_argvi, __FILE__, __FUNCTION__, __LINE__);
	//if(parameters == NULL)
	//RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
	
	g_type_init();
	loop = g_main_loop_new(NULL, FALSE);   
	error = NULL;
	c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
	g_assert_no_error (error);
	error = NULL;
	g_assert (c1 != NULL);
	g_assert (!g_dbus_connection_is_closed (c1));
    RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
    g_variant_builder_init (&builder, G_VARIANT_TYPE_STRING_ARRAY);
    RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
    g_variant_builder_add (&builder, "s", "when");
    g_variant_builder_add (&builder, "s", "in");
    g_variant_builder_add (&builder, "s", "the");
    g_variant_builder_add (&builder, "s", "course");
	result = g_dbus_connection_call_sync (c1,
                                        TEST_SERVICE,  //bus name
                                        TEST_DATA_PATH, //object path 
                                        TEST_DATA_INTERFACE,  // interface name 
                                        "add",                 // method name 
                                        g_variant_new ("(as)", builder),   //parameters 
                                         G_VARIANT_TYPE ("(i)"),                    // return type 
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
										
										

	g_assert_no_error (error);
	g_assert (result != NULL);
	g_variant_get(result, "(i)", &(set_result));
	g_variant_unref (result);
	RLOGD("%s, %s, %d,hgh %dzqcend:%d", __FILE__, __FUNCTION__, __LINE__,select_argvi,set_result);
	//g_main_loop_run (loop);
	g_main_loop_unref (loop);
	
    return set_result;
}
*/
int main(int agrc, char** argv)
{
    int select_argvi = 99;
    if(argv[1] != NULL)
    {
        select_argvi = atoi(argv[1]);
    }
    for(int i=1;i<agrc;i++)
    {
        printf("initGDBus:%d\n",atoi(argv[i]));
    }
    if(select_argvi == 1)
    {
        for(int i=0;i<10000;i++)
        {
             //gvariant_test2(i,5,select_argvi,get_platform_data());
             test_add(i,5,select_argvi);
             //gvariant_test();
        }
    }
    else if(select_argvi == 0)
    {
        for(int i=0;i<10000;i++)
        {
             //gvariant_test2(i,5,select_argvi,get_platform_data());
             test_decrease(i,5,select_argvi);
             //gvariant_test();
        }
    }
    else if(select_argvi == 2)
    {
        for(int i=0;i<10;i++)
        {
             //gvariant_test2(i,5,select_argvi,get_platform_data());
             test_call(i,select_argvi);
             //gvariant_test();
        }
    }
    else
    {
        RLOGD("other test");
    }
    while(1){sleep(10);}
    return 0;
}

