/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "CmdUtils.h"
#include "../../utils/GostEcallUtils.h"
using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_CmdUtils"
CmdUtils::CmdUtils() {
    // TODO Auto-generated constructor stub

}

CmdUtils::~CmdUtils() {
    // TODO Auto-generated destructor stub
}

int CmdUtils::decodeCmdCommand(std::uint16_t cmd, const std::string &data) {
    MTK_RLOGD("cmd=0X%02X, data: %s", cmd, (data.empty() ? "": data.c_str()));
    MTK_RLOGW("don't support, just return");
    return 0;
}

bool CmdUtils::isCmdCommands(std::uint16_t cmd) {
    MTK_RLOGD("cmd=0X%02X", cmd);
    switch (cmd) {
    case EGTS_RAW_DATA:
    case EGTS_TEST_MODE:
    case EGTS_CONFIG_RESET:
    case EGTS_SET_AUTH_CODE:
    case EGTS_RESTART:
        //radio mute
    case EGTS_RADIO_MUTE_DELAY:
    case EGTS_RADIO_UNMUTE_DELAY:
        //GEneral-purpose settings
    case EGTS_GPRS_APN:
    case EGTS_SERVER_ADDRESS:
    case EGTS_SIM_PIN:
    case EGTS_INT_MEM_TRANSMIT_INTERVAL:
    case EGTS_INT_MEM_TRANSMIt_ATTEMPTS:
        //test mode
    case EGTS_TEST_REGISTRATION_PERIOD:
    case EGTS_MODE_END_DISTANCE:
        //service station mode
    case EGTS_GARAGE_MODE_END_DISTANCE:
    case EGTS_GARAGE_MODE_PIN:
        //Miscellaneous parameters
    case EGTS_GNSS_POWER_OFF_TIME:
    case EGTS_GNSS_DATA_RATE:
    case EGTS_GNSS_MIN_ELEVATION:
        //Device parameters
    case EGTS_UNIT_ID:
    case EGTS_UNIT_IMEI:
    case EGTS_UNIT_RS485_BAUD_RATE:
    case EGTS_UNIT_RS485_STOP_BITS:
    case EGTS_UNIT_RS485_PARITY:
    case EGTS_UNIT_HOME_DISPATCHER_ID:
    case EGTS_SERVICE_AUTH_METHOD:
    case EGTS_SERVER_CHECK_IN_PERIOD:
    case EGTS_SERVER_CHECK_IN_ATTEMPTS:
    case EGTS_SERVER_PACKET_TOUT:
    case EGTS_SERVER_PACKET_RETRANSMIT_ATTEMPTS:
    case EGTS_UINT_MIC_LEVEL:
    case EGTS_UINT_SPK_LEVEL: {
        return true;
    }
    }
    return false;
}
