/**********************************************************************************************
* @file atci_lynq_data_cmd.cpp
* @brief.Implementation of lynq data AT commands function 
* @details None
* @author   Hong Liu。
* @date     2022-12-07
* @version  V1.0
* @copyright   Copyright (c) MobileTek 
***********************************************************************************************/
#include <vendor-ril/telephony/ril.h>
#include <string.h>
#include <log/log.h>

#include "ATCI.h"
#include "atci_util.h"
#include "atci_at_util.h"
#include "atci_lynq_data_cmd.h"
#include "atci_common.h"
#include "lynq_common.h"
#include "common.h"
#include "sim.h"

#undef LOG_TAG
#define LOG_TAG "DEMO_ATCI_DATA"
#define LINE __LINE__
#define FUNC __FUNCTION__
#define SET_DEFAULT_SIM_ALL -1

int g_flag_apn = 0;

atci_cmd_type_t atci_data_cmd_table[] = {
//cmd_name      target_type        handler
    { "AT+LAPNACT", TARGET_TELEPHONY, atci_data_enable_pdp_hdlr },            //AT command to enable defult PDP
    { "AT+ELAPNACT", TARGET_TELEPHONY, atci_data_enable_pdp_with_apn_hdlr },  //AT command to enable PDP with APN
    { "AT+LEAPNMOD", TARGET_TELEPHONY, atci_data_modify_apn_hdlr },           //AT command to modify APN
    { "AT+LCSUS", TARGET_TELEPHONY, atci_switch_card_halr },
    { NULL, TARGET_UNKNOWN, NULL }
};
int atci_lynq_data_init(void *arg) {
    int ret;
    ret = atci_cmd_register(atci_data_cmd_table);
    return ret;
}

int atci_switch_card_halr(char *cmd, int op_mode, int target, char *response)
{
    char buf[16];
    switch (op_mode)
    {
        case AT_SET_MODE:
        {
            //paser parameter
            //send to target handle
            //ex: at+lapnact=int
            RLOGD("input cmd[%s]", cmd);
            if (SYS_FAIL == atci_at_to_equal(&cmd))
            {
                //input error
                ATCIResponseNoToken(100,NULL,SET_DEFAULT_SIM_ALL);
                return SYS_FAIL;
            }
            RLOGD("[%d][%s] data is[%s]",LINE,FUNC,cmd);
            int state;
            if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &state))
            {
                ATCIResponseNoToken(100,NULL,SET_DEFAULT_SIM_ALL);
                return SYS_FAIL;
            }
            RLOGD("state value is %d", state);
            if(state==1)
            {
                char* argv[2] = { 0 };
                argv[0] = "SET_DEFAULT_SIM_ALL";
                //sprintf(argv[1], "%d", state);
                argv[1] = "1";
                
                int argc = 2;
                android::lynqSendToRil(2,argv,1024);
                RLOGD("%s g_switch_card_error %d %d", __FUNCTION__, g_switch_card_error, __LINE__);
                if(!g_switch_card_error)
                {
                    ATCIResponseNoToken(0,NULL,-1);
                }
                else
                {
                    ATCIResponseNoToken(g_switch_card_error,NULL,-1);
                }
                
            }
            else if(state == 0)
            {
                char* argv[2] = { 0 };
                argv[0] = "SET_DEFAULT_SIM_ALL";
                //sprintf(argv[1], "%d", state);
                argv[1] = "0";
                
                int argc = 2;
                android::lynqSendToRil(2,argv,1024);
                RLOGD("%s g_switch_card_error %d %d", __FUNCTION__, g_switch_card_error, __LINE__);
                if(!g_switch_card_error)
                {
                    ATCIResponseNoToken(0,NULL,-1);
                }
                else
                {
                    ATCIResponseNoToken(g_switch_card_error,NULL,-1);
                }
            }
            else
            {
                
                ATCIResponseNoToken(100,NULL,SET_DEFAULT_SIM_ALL);
                return SYS_FAIL;
            }
            break;
        }
        case AT_TEST_MODE:
        {
            memset(buf,0,sizeof(buf));
            sprintf(buf,"%s","+LCSUS: (0,1)");
            ATCIResponseNoToken(0,buf,SET_DEFAULT_SIM_ALL);
            break;
        }
        case AT_READ_MODE:
        {
            
            int id = get_default_sim_all();
            memset(buf,0,sizeof(buf));
            sprintf(buf,"+LCSUS: %d", id);
            ATCIResponseNoToken(0,buf,SET_DEFAULT_SIM_ALL);
            break;
        }
        default:
        {
            RLOGD("set mute error");
            break;
        }
    }
    return SYS_SUCC;
}

int atci_data_enable_pdp_hdlr(char *cmd, int op_mode, int target, char *response)
{
    int ret;
    char buf[16];
    switch (op_mode)
    {
        case AT_SET_MODE:
        {
            //paser parameter
            //send to target handle
            //ex: at+lapnact=int
            RLOGD("input cmd[%s]", cmd);

            if (SYS_FAIL == atci_at_to_equal(&cmd))
            {
                //input error
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_FAIL;
            }
            RLOGD("[%d][%s] data is[%s]",LINE,FUNC,cmd);
            int state;

            if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &state))
            {
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_FAIL;
            }

            RLOGD("state value is %d", state);

            //wrire data to target
            atci_data_req_t req;

            if(state==1)
            {
                req.request_id = RIL_REQUEST_SETUP_DATA_CALL;
            }
            else if(state == 0)
            {
                req.request_id = RIL_REQUEST_DEACTIVATE_DATA_CALL;
            }
            else
            {
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_FAIL;
            }
            

            char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
            memcpy(reqStr, request2RILStr(req.request_id),strlen(request2RILStr(req.request_id)) + 1);
            RLOGD("request is %s", reqStr);
            char* argv[2] = { 0 };
            argv[0] = reqStr;
            int argc = 1;
            sendAtciRequest(req.request_id, reqStr, argc, argv);
            ATCIResponseNoToken(0,NULL,req.request_id);
            break;
        }
        case AT_TEST_MODE:
        {
            memset(buf,0,sizeof(buf));
            sprintf(buf,"%s","+LAPNACT: (0,1)");
            ATCIResponseNoToken(0,buf,RIL_REQUEST_SETUP_DATA_CALL);
            break;
        }
        default:
        {
            RLOGD("set mute error");
            break;
        }
    }
    return SYS_SUCC;
}

int atci_data_enable_pdp_with_apn_hdlr(char *cmd, int op_mode, int target,char *response)
{
    int ret;
    int argc = 0;
    char* argv[8] = { 0 };
    char buf[512];
    char authTypebuf[16] = {0};
    int state = 0;
    int authType = 0;
    char *apn = NULL;
    char *apnTpye = NULL;
    char *user = NULL;
    char *password =NULL;
    char *apnprotocol = NULL;
    char *apnRoamProtocol = NULL;
    switch (op_mode)
    {
        case AT_SET_MODE:
        {
            //paser parameter
            //send to target handle
            //ex: at+lapnact=int
            RLOGD("input cmd[%s]", cmd);

            if (SYS_FAIL == atci_at_to_equal(&cmd))
            {
              //input error
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_FAIL;
            }
            RLOGD("[%d][%s] data is[%s]",LINE,FUNC,cmd);

            if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &state))
            {
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_FAIL;
            }
            RLOGD("state value is %d", state);
            if(state == 1)
            {
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apn))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("apn value is %s", apn);
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apnTpye))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("apnTpye value is %s", apnTpye);
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &user))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("user value is %s", user);
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &password))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("pwd value is %s", password);
                if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &authType))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("authType value is %d", authType);
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apnprotocol))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("apnprotocol value is %s", apnprotocol);
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apnRoamProtocol))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("apnRoamProtocol value is %s", apnRoamProtocol);
                argv[1] = apn;
                argv[2] = apnTpye;
                argv[3] = user;
                argv[4] = password;
                sprintf(authTypebuf,"%d",authType);
                argv[5] = authTypebuf;
                argv[6] = apnprotocol;
                argv[7] = apnRoamProtocol;
                argc = 8;
            }
            else if(state == 0)
            {
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apnTpye))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                    return SYS_FAIL;
                }
                RLOGD("apnTpye value is %s", apnTpye);
                argv[1] = apnTpye;
                argc = 2;
            }
            //wrire data to target
            atci_data_req_t req;
            if(state==1)
            {
                req.request_id = RIL_REQUEST_SETUP_DATA_CALL;
            }
            else if(state == 0)
            {
                req.request_id = RIL_REQUEST_DEACTIVATE_DATA_CALL;
            }
            else
            {
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_FAIL;
            }
            

            char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
            memcpy(reqStr, request2RILStr(req.request_id),strlen(request2RILStr(req.request_id)) + 1);
            RLOGD("request is %s", reqStr);
            argv[0] = reqStr;
            sendAtciRequest(req.request_id, reqStr, argc, argv);
            ATCIResponseNoToken(0,NULL,req.request_id);
            break;
        }
        case AT_TEST_MODE:
        {
            memset(buf,0,sizeof(buf));
            sprintf(buf,"%s","+ELAPNACT: (0,1),"","","","",(0-3),(\"null\",\"IPV4\",\"IPV6\",\"IPV4V6\"),(\"null\",\"IPV4\",\"IPV6\",\"IPV4V6\")");
            ATCIResponseNoToken(0,buf,RIL_REQUEST_SETUP_DATA_CALL);
            break;
        }
        case AT_READ_MODE:
        {
            for(int i = 0;i < LYNQ_APN_CHANNEL_MAX; i ++)
            {
                if(!apn_table[i].used)
                {
                    continue;
                }
                memset(buf,0,sizeof(buf));
                sprintf(buf,"+ELAPNACT:%s,%s,%d,%s,%s\n", apn_table[i].apn, apn_table[i].apntype ,apn_table[i].pdpstate, apn_table[i].ifaceName, apn_table[i].address);
                if(atci_send_data(buf)!=0)
                {
                    RLOGD("send data fail");
                    return SYS_FAIL;
                }
            }
            if(apn_count == 0)
            {
                memset(buf,0,sizeof(buf));
                ATCIResponseNoToken(0,buf,RIL_REQUEST_SETUP_DATA_CALL);
                return SYS_SUCC;
            }
            atci_send_result(0);
            break;
        }
        default:
        {
            RLOGD("set mute error");
            break;
        }
    }
    return SYS_SUCC;
}

static int insert_apn_char(char *agc, char *id,char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][64];
    if (!strcmp(id,"null"))
    {
        sprintf(strtmp[0], "id=;");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (!strcmp(mcc,"null"))
    {
        char mcc[8] = {0};
        if(strlen(mccmnc))
        {
            strncpy(mcc, mccmnc, 3);
            sprintf(strtmp[1], "mcc=%s;", mcc);
        }
        else
        {
            sprintf(strtmp[2], "mcc=;");
        }
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (!strcmp(mnc,"null"))
    {
        if(strlen(mccmnc))
        {
            sprintf(strtmp[2], "mnc=%s;", mccmnc+3);
        }
        else
        {
            sprintf(strtmp[2], "mnc=;");
        }
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (!strcmp(apn,"null"))
    {
        sprintf(strtmp[3], "apn=;");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (!strcmp(apntype,"null"))
    {
        sprintf(strtmp[4], "apntype=;");
    }
    else
    {
        sprintf(strtmp[4], "type=%s;", apntype);
    }
    if (!strcmp(user,"null"))
    {
        sprintf(strtmp[5], "user=;");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (!strcmp(password,"null"))
    {
        sprintf(strtmp[6], "password=;");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (!strcmp(normalprotocol,"null"))
    {
        sprintf(strtmp[7], "protocol=;");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (!strcmp(roamingprotocol,"null"))
    {
        sprintf(strtmp[8], "roamingprotocol=;");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (!strcmp(carrier,"null"))
    {
        sprintf(strtmp[9], "carrier=;");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s",strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);
    return 0;
}

int atci_data_modify_apn_hdlr(char *cmd, int op_mode, int target, char *response)
{
    char *id  = NULL;
    char *mcc = NULL;
    char *mnc = NULL;
    char *apn = NULL;
    char *apntype = NULL;
    char *user = NULL;
    char *password = NULL;
    char *normalprotocol = NULL;
    char *roamingprotocol = NULL;
    char *carrier = NULL;
    int state = -1;
    char apn_info[512];
    char* argv[3] = { 0 };
    int argc = 0;
    g_flag_apn = 1;
    switch (op_mode)
    {
        case AT_SET_MODE:
        {
            RLOGD("input cmd[%s]", cmd);
            if (SYS_FAIL == atci_at_to_equal(&cmd))
            {
                //input error
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                return SYS_FAIL;
            }
            RLOGD("[%d][%s] data is[%s]",LINE,FUNC,cmd);
            if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &state))
            {
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                return SYS_FAIL;
            }
            RLOGD("state value is %d", state);
            if (SYS_FAIL == atci_at_get_next_key(&cmd, &id))
            {
                ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                return SYS_FAIL;
            }
            if(state == 0)
            {
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &mcc))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &mnc))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apn))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apntype))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &user))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &password))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &normalprotocol))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &roamingprotocol))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &carrier))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                /*get mccmnc*/
                lynq_req_mccmnc(666);
                lynq_wait_result_comeback(100);//wait 100ms
                /*get mccmnc*/
                insert_apn_char(apn_info, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);
                argv[1] = "0";
                argv[2] = apn_info;
                RLOGD("apn_info %s\n", apn_info);
                atci_data_req_t req;
                req.request_id = RIL_REQUEST_MODIFY_APN;
                char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
                memcpy(reqStr, request2RILStr(req.request_id),strlen(request2RILStr(req.request_id)) + 1);
                RLOGD("request is %s", reqStr);
                argv[0] = reqStr;
                argc = 3;
                sendAtciRequest(req.request_id, reqStr, argc, argv);
            }
            else if (state == 1)
            {
                sprintf(apn_info, "id=%s", id);
                argv[1] = "1";
                argv[2] = apn_info;
                atci_data_req_t req;
                req.request_id = RIL_REQUEST_MODIFY_APN;
                char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
                memcpy(reqStr, request2RILStr(req.request_id),strlen(request2RILStr(req.request_id)) + 1);
                RLOGD("request is %s", reqStr);
                argv[0] = reqStr;
                argc = 3;
                sendAtciRequest(req.request_id, reqStr, argc, argv);
            }
            else if (state == 2)
            {
                sprintf(apn_info, "id=%s", id);
                argv[1] = "2";
                argv[2] = apn_info;
                atci_data_req_t req;
                req.request_id = RIL_REQUEST_MODIFY_APN;
                char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
                memcpy(reqStr, request2RILStr(req.request_id),strlen(request2RILStr(req.request_id)) + 1);
                RLOGD("request is %s", reqStr);
                argv[0] = reqStr;
                argc = 3;
                sendAtciRequest(req.request_id, reqStr, argc, argv);
            }
            else if (state == 3)
            {
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &mcc))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &mnc))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apn))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &apntype))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &user))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &password))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &normalprotocol))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &roamingprotocol))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                if (SYS_FAIL == atci_at_get_next_key(&cmd, &carrier))
                {
                    ATCIResponseNoToken(100,NULL,RIL_REQUEST_MODIFY_APN);
                    return SYS_FAIL;
                }
                insert_apn_char(apn_info, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);
                argv[1] = "3";
                argv[2] = apn_info;
                atci_data_req_t req;
                req.request_id = RIL_REQUEST_MODIFY_APN;
                char reqStr[RIL_REQUEST_STRING_LENGTH] = {0};
                memcpy(reqStr, request2RILStr(req.request_id),strlen(request2RILStr(req.request_id)) + 1);
                RLOGD("request is %s", reqStr);
                argv[0] = reqStr;
                argc = 3;
                sendAtciRequest(req.request_id, reqStr, argc, argv);
            }
            else
            {
                RLOGD("function %s line %d unknow command", __FUNCTION__, __LINE__);
            }
            break;
        }
        default:
        {
            break;
        }
       
    }
    return SYS_SUCC;
}


