#include<sys/types.h>
#include<sys/socket.h>
#include<unistd.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<netdb.h>
#include<signal.h>
#include <log/log.h>
#include <hardware_legacy/power.h>
#include <vendor-ril/telephony/ril.h>
#include <telephony/ril_cdma_sms.h>

#include <telephony/record_stream.h>
#include <utils/SystemClock.h>
#include <binder/Parcel.h>
#include <cutils/jstring.h>
#include <sys/types.h>
#include <limits.h>
#include <pwd.h>

#include <stdlib.h>
#include <stdarg.h>

#include <unistd.h>

#include <errno.h>
#include <ctype.h>
#include <alloca.h>
#include <sys/un.h>
#include <assert.h>
#include <netinet/in.h>
#include <atomic>

#include "utils/String8.h"
#include "ss.h"

#include "cc.h"
#include "network.h"
#include "stk.h"


#include "atci/ATCI.h"
#include "data/data.h"
#include "data/data_gdbus.h"
#include "ecall/eCall.h"
#include "em/em.h"
#include "sms/sms.h"
#include "sms/cdma/sms_pdu_cdma.h"
#include "stateManager/stateManager.h"


#include "Radio_capability_switch_util.h"

#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "common.h"
#include "utils.h"
#include "Phone_utils.h"
#include <time.h>
#include "sim.h"
#include <string.h>
#include<pthread.h>
#include <cutils/properties.h>
#include "lynq_at.h"
#ifdef __cplusplus
extern "C" {
#endif
#include <pthread.h>
#define SIM_COUNT 2
#define RIL_REQUEST_GET_SIM_STATUS 1
int already_gps = 0;
int enable_nema = 0;
char rgmii[32] = {0};
char sgmii[32] = {0};
int gps_set = 2;
int g_set_output = 0;
int ttyGS0_fd;
pthread_t lynq_gps_tid;
// static pthread_mutex_t s_gps_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
// static pthread_cond_t s_gps_change_cond = PTHREAD_COND_INITIALIZER;
typedef enum {
    sim1,
#if (SIM_COUNT >= 2)
    sim2,
#if (SIM_COUNT >= 3)
    RIL_SOCKET_3,
#endif
#if (SIM_COUNT >= 4)
    RIL_SOCKET_4,
#endif
#endif
    //RIL_SOCKET_NUM
} RIL_SIM_COUNT;

#include "lynq_factory.h"

static const char *usb3_speed = "super-speed";
static const char *usb2_speed = "high-speed";
pthread_mutex_t lynq_audio_mutex = PTHREAD_MUTEX_INITIALIZER;


static void lynq_factory_response_ttyGS3(char *buf){
    write(ttyGS3_fd,buf,strlen(buf));
    return;
}

void *thread_test(void *arg){
    char gnss_buf[128] = {0};
    lynq_factory_response_ttyGS3("+GPS OPEN:OK\n");
    sprintf(gnss_buf, "%s%d%s", "echo \"GNSS_MODE=", gps_set, "\">>/etc/gnss/mnl.prop");
    system(gnss_buf);
    sleep(1);
    FILE *fp;
    char test[100] = {0};
    sprintf(test, "lynq-gnss-test cold %s", "2>&1");
    char lynq_factory_buf[1024] = {0};
    fp=popen(test, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return 0;
    }
    /*open vcom port*/
    ttyGS0_fd = open("/dev/ttyGS0",O_RDWR);
    if(ttyGS0_fd == -1)
    {
        lynq_factory_response_ttyGS3("\n+open /dev/ttyGS0:ERROR\n");
        return NULL;
    }
    /*open vcom port*/
    while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
    {
        if(enable_nema == 1){
            if(g_set_output == 0)
            {
                lynq_factory_response_ttyGS3(lynq_factory_buf);
            }
            /*output nema into vcom port*/
            if(g_set_output == 1)
            {
                write(ttyGS0_fd,lynq_factory_buf,strlen(lynq_factory_buf));
            }
            /*output nema into vcom port*/
        }
    }
    close(ttyGS0_fd);
    pclose(fp);
    return 0;
}

/**
 * @brief parse ipv4 eg:192.168.131.222 ->192.168.131.1
 * @param  buf              My Param doc
 */
static void parse_ipv4(char *buf)
{
    char *p = buf;
    int cnt = 0;
    while(*p != '\0')
    {
        if(*p == '.')
        {
            cnt++;
            if(cnt == 3)
            {
                *p++;
                *p = '1';
                *p++;
                *p = '\0';
            }
        }
        *p++;
    }

}

void *thread_test_RGMII(void *arg){
    char cmd[128] = {0};
    FILE *fp;
    sprintf(cmd, "%s %s %s %s", "ping -I eth2", rgmii, "-c4", "2>&1");
    fp=popen(cmd, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return NULL;
    }
    char lynq_factory_buf[1024] = {0};
    while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
    {
        if(strstr(lynq_factory_buf, "Usage"))
        {
            lynq_factory_response_ttyGS3("RGMII cannot recognize IP addresses\n");
            lynq_factory_response_ttyGS3("ERROR\n");
            pclose(fp);
            return NULL;
        }
        lynq_factory_response_ttyGS3(lynq_factory_buf);
    }
    lynq_factory_response_ttyGS3("OK\n");
    pclose(fp);
    return NULL;
}

static void lynq_test_RGMII(char *argv){
    if(argv == NULL)
    {
        lynq_factory_response_ttyGS3("\nERROR\n");
        return;
    }
    strcpy(rgmii, argv);
    pthread_t thid;
    pthread_attr_t a;
    pthread_attr_init(&a);
    pthread_attr_setdetachstate(&a, PTHREAD_CREATE_DETACHED);
    if(pthread_create(&thid, &a, thread_test_RGMII, NULL) != 0) {
        return;
    }
    //pthread_join(thid, NULL);
    return;
}

/**
 * @brief factory test for sgmii
 * 
 */
void *thread_test_SGMII_wtf(void *arg){
    FILE *fp;
    char cmd[128] = {0};
    sprintf(cmd, "%s %s %s %s", "ping -I eth1", sgmii, "-c4", "2>&1");
    fp=popen(cmd, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return NULL;
    }
    char lynq_factory_buf[1024] = {0};
    while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
    {
        if(strstr(lynq_factory_buf, "Usage"))
        {
            lynq_factory_response_ttyGS3("SGMII cannot recognize IP addresses\n");
            lynq_factory_response_ttyGS3("ERROR\n");
            pclose(fp);
            return NULL;
        }
        lynq_factory_response_ttyGS3(lynq_factory_buf);
    }
    lynq_factory_response_ttyGS3("OK\n");
    pclose(fp);
    return NULL;
}

/**
 * @brief factory test for sgmii
 * 
 */
static void lynq_test_SGMII(char *argv){
    if(argv == NULL)
    {
        lynq_factory_response_ttyGS3("\nERROR\n");
        return;
    }
    strcpy(sgmii, argv);
    pthread_t thid;
    pthread_attr_t a;
    pthread_attr_init(&a);
    pthread_attr_setdetachstate(&a, PTHREAD_CREATE_DETACHED);
    if(pthread_create(&thid, &a, thread_test_SGMII_wtf, NULL) != 0) {
        return;
    }
    //pthread_join(thid, NULL);
    return;
}


static void lynq_gps_open(char *num){
    if(already_gps == 1){
        lynq_factory_response_ttyGS3("gps already open\n");
        return;
    }
    if(num == NULL)
    {
        return;
    }
    gps_set = atoi(num);
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    int ret = pthread_create(&lynq_gps_tid, NULL, thread_test, NULL);
    if(ret < 0)
    {
        lynq_factory_response_ttyGS3("gps thread create failure!!!\n");
        return;
    }
    already_gps = 1;
    return;
}

static void lynq_gps_enable(void){
   
    enable_nema = 1;
    lynq_factory_response_ttyGS3("+GPS ENABLE:OK\n");
    return;
}

static void lynq_gps_disable(void)
{
    enable_nema = 0;
    lynq_factory_response_ttyGS3("+GPS DISABLE:OK\n");
    return;
}

static void lynq_gps_close(void)
{
    already_gps = 0;
    enable_nema = 0;
    system("killall lynq-gnss-test");
    lynq_factory_response_ttyGS3("+GPS CLOSE:OK\n");
    return;
}

int lynq_dispose_factory_adc(int num,char *argv[MAX_ARGS])
{
    if(num != 5)
    {
        lynq_factory_response_ttyGS3("+ADC ERROR: 100");
        return -1;
    }
    FILE *fp;
    char lynq_adc_dev[126] = {0};
    char lynq_adc_buf[32] = {0};
    int lynq_adc_num = atoi(argv[4]);
    char flag[64] = {0};
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input  2>&1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input  2>&1");
    }
    else if(lynq_adc_num == 2)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input  2>&1");
    }
    else if(lynq_adc_num == 3)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage3_input  2>&1");
    }
    fp=popen(lynq_adc_dev, "r");
    fgets(lynq_adc_buf,sizeof(lynq_adc_buf),fp);
    sprintf(flag,"%s %s", "ADC:", lynq_adc_buf);
    lynq_factory_response_ttyGS3(flag);
    lynq_factory_response_ttyGS3("OK\n");
    pclose(fp);
    return 1;
}

int lynq_dispose_factory_usb(int num,char *argv[MAX_ARGS])
{
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512];
    bzero(lynq_usb_buf, 512);
    bzero(lynq_usb_dev,512);
    sprintf(lynq_usb_dev,"cat /sys/devices/platform/11201000.usb/udc/11201000.usb/current_speed  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp);
    if(!strncmp(lynq_usb_buf,usb3_speed,strlen(usb3_speed)))
    {   
        lynq_factory_response_ttyGS3("[usb][result],3.0 \n");
        lynq_factory_response_ttyGS3("OK\n");
    }
    else if(!strncmp(lynq_usb_buf,usb2_speed,strlen(usb2_speed)))
    {
        lynq_factory_response_ttyGS3("[usb][result],2.0 \n");
        lynq_factory_response_ttyGS3("OK\n");
    }
    pclose(fp);
    return 1;
}

void *lynq_deal_witch_audio(void *arg)
{
    char lynq_adudio_time_arr[128] = {0};
    char *lynq_argv  = (char *)arg;
    pthread_mutex_lock(&lynq_audio_mutex);
    lynq_factory_response_ttyGS3("OK\n");
    system("echo write_reg,0x002c,0x0008 > /sys/kernel/debug/mtksocaudio");
    system("echo write_reg,0x0030,0x0010 > /sys/kernel/debug/mtksocaudio");
    sprintf(lynq_adudio_time_arr,"arecord -D plughw:0,1 --buffer-size=1024 -r 16000 -d %s -f S16_LE -c1 | aplay -D plughw:0,7 --buffer-size=1024 -r 16000 -d %s -f S16_LE -c1",lynq_argv,lynq_argv);
//    system("arecord -D plughw:0,1 --buffer-size=1024 -r 16000 -d 2 -f S16_LE -c1 | aplay -D plughw:0,7 --buffer-size=1024 -r 16000 -d 2 -f S16_LE -c1 ");
    system(lynq_adudio_time_arr);
    free(lynq_argv);
    lynq_argv = NULL;
    pthread_mutex_unlock(&lynq_audio_mutex);
    pthread_exit(0);
}

int lynq_dispose_factory_audio(int num,char *argv[MAX_ARGS])
{
    pthread_t id;
    int i,ret;
    char *lynq_audio_time = (char *)malloc(16);
    bzero(lynq_audio_time, 16);
    if(lynq_audio_time != NULL)
    {
        memcpy(lynq_audio_time,argv[4],strlen(argv[4]));
    } 
    ret=pthread_create(&id,NULL,lynq_deal_witch_audio,(char *)lynq_audio_time); 
    if(ret!=0)
    {
        return ret;
    }
    //pthread_join(id,NULL);
    return 0;
}

int lynq_check_emmc()
{
    FILE *fp;
    char emmc_buf[100] = {0};
    char buf[100] = {0};
    sprintf(emmc_buf, "ls /dev | grep mmcblk0  2>&1");
    fp=popen(emmc_buf, "r");
    if(!fp){
        lynq_factory_response_ttyGS3("\n+CME: POPEN ERROR\n");
        return -1;
    }
    while(fgets(buf, sizeof(buf), fp) != NULL){
        lynq_factory_response_ttyGS3("+EMMC: OK \n"); 
        pclose(fp);
        return 0;   
    }
    lynq_factory_response_ttyGS3("\033[47;31m+EMMC: ERROR\033[0m\n");
    pclose(fp);
    return 0;
}

int lynq_check_gpio()
{
    #if 1
    FILE *fp;
    
    int lynq_gpio_arr[85] = {230,231,232,233,234,102,104,103,101,186 ,188 ,187 ,185 ,194 ,196 ,195 ,193 ,205 ,204 ,203 ,202, 201 ,190 ,192 ,191 ,189 ,173 ,174 ,175 ,176 ,170 ,169 ,184 ,183 ,182 ,181 ,24 ,25 ,157 ,158 ,155 ,156 ,143 ,144 ,140 ,141 ,153 ,154 ,180 ,179 ,29 ,30 ,178, 177, 7 ,5 ,4 ,113 ,112, 116 ,115 ,114, 107, 108, 105, 106, 100 ,99 ,98, 97, 94, 93, 92, 91, 1 ,130 ,41 ,67 ,69, 68, 63, 22, 23, 199, 200};
    char lynq_set_gpio_arr[256] = {0};
    char lynq_get_gpio_state[512] = {0};
    char lynq_show_gpio_state[64] = {0};
    int lynq_gpio_low = 0;
    int lynq_gpio_hig = 0;
    int i = 0,m = 0;
    int lynq_gpio_beta_state = 1;

    for(m = 0; m < 85; m++)
    {
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[m]);
        system(lynq_set_gpio_arr);
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo out %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[m]);
        system(lynq_set_gpio_arr);
    }

    for(i = 0; i < 85; i++)
    {
        lynq_gpio_low = 0;
        lynq_gpio_hig = 0;

        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);

        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo out %d 1 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);

        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 006");
        fp=popen(lynq_set_gpio_arr, "r");
        bzero(lynq_get_gpio_state, 512);
        fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
/*     
        if(strlen(lynq_get_gpio_state) > 0)
        {
            lynq_factory_response_ttyGS3(lynq_get_gpio_state);
            lynq_factory_response_ttyGS3("\n");
        }
*/
        pclose(fp);
        if(lynq_get_gpio_state[7] == '1')
        {
            lynq_gpio_hig = 1;
        }

        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo out %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);
        
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 006");
        fp=popen(lynq_set_gpio_arr, "r");
        bzero(lynq_get_gpio_state, 512);
        fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
        pclose(fp);
        if(lynq_get_gpio_state[7] == '0')
        {
            lynq_gpio_low = 1;
        }
        bzero(lynq_show_gpio_state, 64);
        if((lynq_gpio_low != 1) || (lynq_gpio_hig != 1))
        {
            lynq_gpio_beta_state = 0;
            sprintf(lynq_show_gpio_state,"[gpio%d][result]:FAIL \n",(char *)lynq_gpio_arr[i]);
            lynq_factory_response_ttyGS3(lynq_show_gpio_state);
        }
        else
        {
            sprintf(lynq_show_gpio_state,"gpio%d\n",(char *)lynq_gpio_arr[i]);
            lynq_factory_response_ttyGS3(lynq_show_gpio_state);
        }
    }
    if(lynq_gpio_beta_state == 1)
    {
        sprintf(lynq_show_gpio_state,"[gpio][result]:PASS \n");
        lynq_factory_response_ttyGS3(lynq_show_gpio_state);
    }
    return 0;
    #endif
}

int lynq_test_sink(){
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512] = {0};
    char buf[512] = {0};
    int sink[3][3] = {{255,0,0},{0,255,0},{0,0,255}};
    char dev_buf[][40]={{"green:cellular-radio/brightness"},{"green:cellular-quality/brightness"},{"red:system/brightness"}};
    int i;
    int j;
    int k = 15;
    char flag_buf[64] = {0};
    for(i = 0;i < 3;i++){
        bzero(flag_buf, 64);
        bzero(lynq_usb_buf, 512);
        bzero(buf, 512);
        k = 15;
        for(j = 0;j < 3;j++){
            bzero(lynq_usb_dev, 512);
            sprintf(lynq_usb_dev,"echo %d >  /sys/class/leds/led95%d:%s  2>&1", sink[i][j], k++, dev_buf[j]);
            fp=popen(lynq_usb_dev, "r");
        }
        usleep(10000);
        sprintf(lynq_usb_buf,"cat /sys/bus/iio/devices/iio:device1/in_voltage4_input  2>&1");
        fp=popen(lynq_usb_buf, "r");
        
        fgets(buf, sizeof(buf), fp);
        sprintf(flag_buf, "%s%d%s%s%s", "SINK[", i+1, "]: ", buf, "\n");
        lynq_factory_response_ttyGS3(flag_buf);
    }
    lynq_factory_response_ttyGS3("OK\n");
    pclose(fp);
    return 1;
}

int lynq_check_pcie(void){
    FILE *fp;
    char lynq_usb_dev[128] = {0};
    char lynq_get_gpio_state[512] = {0};
    sprintf(lynq_usb_dev,"cat sys/devices/platform/10005000.pinctrl/mt_gpio |grep 097  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    if(lynq_get_gpio_state[6] == '1')
    {
        lynq_factory_response_ttyGS3("+PCIE: OK\n");
    }
    else
    {
        lynq_factory_response_ttyGS3("+PCIE: ERROR\n");
    }
    return 0;
}

void lynq_switch_card(char *card)
{
    char *sim_argv[3] = {};
    sim_argv[0] = "SET_DEFAULT_SIM_ALL";
    sim_argv[1] = card;
    sim_argv[2] = "sleep";
    android::lynqSendToRil(2,sim_argv,8888);
    sleep(1);
    return;
}

static void lynq_get_imei(int argc, char *argv[MAX_ARGS])
{
    lynqSendAt(argc,argv,1010);
    /*switch card 1*/
    lynq_switch_card("1");
    lynqSendAt(argc,argv,1010);
    /*switch card 0*/
    lynq_switch_card("0");
    return;
}

void lynq_nema_set(char *choice)
{
    if(choice == NULL)
    {
        lynq_factory_response_ttyGS3("INPUT ERROR\n");
    }
    g_set_output = atoi(choice);
    lynq_factory_response_ttyGS3("+SET NEMA:OK\n");
    return;
}

void lynq_sendRequestToMd(int request, int id) {
    RequestInfo* info = creatRILInfoAndInit(request, INIT, (RIL_SOCKET_ID) ((id)));
    info->lynqEvent = 1;
    switch(request){
        case RIL_REQUEST_DEVICE_IDENTITY:
        {
            getDeviceIdentity(1, NULL, (RIL_SOCKET_ID) ((id)), info);
            break;
        }
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE:
        {
            getPreferredNetworkType(1, NULL, (RIL_SOCKET_ID) ((id)), info);
            break;
        }
        case RIL_REQUEST_GET_SIM_STATUS:
        {
            getIccCardStatus(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_DATA_REGISTRATION_STATE:
        {
            getDataRegistrationState(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        {
            getVoiceRegistrationState(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_VOICE_RADIO_TECH:
        {
            getVoiceRadioTechnology(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_OEM_HOOK_RAW:
        {
            char* tmp[2] = {"RIL_REQUEST_OEM_HOOK_RAW", "AT+ECAL"};
            sendATCMD(2, tmp, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_GET_RADIO_CAPABILITY:
        {
            getRadioCapability(1, NULL, (RIL_SOCKET_ID) ((id)), info);
            break;
        }
        default:
            RLOGE("don't support  %d in init", id);
            if(info) {
                free(info);
            }
    }
}

int lynq_get_factory_data(int num,char *argv[MAX_ARGS]){
    if(!strcmp(argv[1],"AT+CGSN"))
    {
        for(int i = 0; i < 2; i++)
        {
            lynq_sendRequestToMd(RIL_REQUEST_DEVICE_IDENTITY,i);
        }
    }
    if(num < 4)
        return -1;
    else if(!strcmp(argv[3], "gps_open")){
        lynq_gps_open(argv[4]);
    }
    else if(!strcmp(argv[3], "gps_enable")){
        lynq_gps_enable();
    }
    else if(!strcmp(argv[3], "gps_disable")){
        lynq_gps_disable();
    }
    else if(!strcmp(argv[3], "gps_close")){
        lynq_gps_close();
    }
    else if(!strcmp(argv[3], "sink")){
        lynq_test_sink();
    }
    else if(!strcmp(argv[3], "rgmii")){
        lynq_test_RGMII(argv[4]);
    }
    else if(!strcmp(argv[3], "sgmii")){
        lynq_test_SGMII(argv[4]);
    }
    else if((!strcmp(argv[3],"adc")))
    {
        lynq_dispose_factory_adc(num,argv);
    }
    else if((!strcmp(argv[3],"usb")))
    {
         lynq_dispose_factory_usb(num,argv);
    }
    else if((!strcmp(argv[3], "emmc")))
    {
        lynq_check_emmc();
    }
    else if((!strcmp(argv[3],"gpio")))
    {
        lynq_check_gpio();
    }
    else if((!strcmp(argv[3],"pcie")))
    {
        lynq_check_pcie();
    }
    else if((!strcmp(argv[3],"nema_set")))
    {
        lynq_nema_set(argv[4]);
    }
    else{
        lynq_factory_response_ttyGS3("invalid command\n"); 
    }
    return 0;
}

#ifdef __cplusplus
}
#endif