/*============================================================================= 
**     FileName: lynq_send_log_data
**     Desc: send log data
**     Author: victor
**     Version: V1.0
**     LastChange: 2021-12-23
**     History: 
=============================================================================*/

#include "common.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <log/log.h>
#include "lynq_fota.h"
#include "ftp/lynq_ftp.h"
#include "mtk_device_wrap.h"
#include "include/iot_rock.h"

static lynq_ftp_socker_info ftp_atfota_info;

#define UPDATA_ADDR "/tmp/fota.delta"
#define READ_BLOCK_SIZE 0x40000

int lynq_fota_md5_flag = -1;

#define FLASH_DEV_DELTA       "/dev/mtd41"	
#define EMMC_DEV_DELTA        "/media/fota.delta"

void lynq_response_ttyGS3(char *log_buf)
{
    if((ttyGS3_fd > 0) && (NULL != log_buf))
    {
	    if(-1 == write(ttyGS3_fd,log_buf,strlen(log_buf)))
	    {
            printf("write ttyGS3_fd fail \n");
        }
    }
    return ;
}

/**
 * @brief get fota patch
 * 
 * @param string:ftp log message,Refer to the fota documentation
 */
int lynq_ftp_download_atfota_package(char *string[])
{
    int ret = 0;

    for(int i = 0; i < 9; i++)
    {
        if(string[i] == NULL)
        {
            lynq_response_ttyGS3("+LYNQFOTA: Download Data NULL\n");
            return 1;
        }
    }
    
    sprintf(ftp_atfota_info.sevname,"%s",string[0]);

    ftp_atfota_info.portnum = atoi(string[1]);

    sprintf(ftp_atfota_info.username,"%s",string[2]);
    sprintf(ftp_atfota_info.pw,"%s",string[3]);


    sprintf(ftp_atfota_info.is_pasv_mode,"%s",string[4]);
    sprintf(ftp_atfota_info.file_type,"%s",string[5]);
    sprintf(ftp_atfota_info.put_opt,"%s",string[6]);

    sprintf(ftp_atfota_info.getfilename_path,"%s",string[7]);
    sprintf(ftp_atfota_info.getfilename,"%s",string[8]);
    chdir("/tmp/");
    if(1 == lynq_ftp_login(&ftp_atfota_info))
    {
        if(0 == lynq_ftp_download(&ftp_atfota_info))
        {
            lynq_response_ttyGS3("+LYNQFOTA: GET FOTA FILE OK\n");
            ret = 0;
        }
        else
        {
            lynq_response_ttyGS3("+CME: GET FOTA FILE FAIL\n");
            ret = 1;
        }
    }
    else
    {
        lynq_response_ttyGS3("+CME: FOTA LOGIN FAIL\n");
        ret = 1;
    }
    return ret;
}

/**
 * @brief Differential subcontracting MD5 check
 * 
 * @param string:MD5 value,Subcontracting address,Refer to the fota documentation
 */
int lynq_md5_atfota_package(char *string[])
{
    int fd_down,size,fd_target;
    char delta_data[READ_BLOCK_SIZE];
    char input_md5_data[64] = {0};
    char buf_buf[128] = {0};

    for(int i = 0; i < 2; i++)
    {
        if(string[i] == NULL)
        {
            lynq_response_ttyGS3("+LYNQFOTA: Md5 Value NULL\n");
            return 1;
        }
    }

    sprintf(input_md5_data,"%s",string[0]);
    lynq_fota_md5_flag = lynq_md5_file_verfy(UPDATA_ADDR, input_md5_data);
    if(lynq_fota_md5_flag == 0)
    {
        lynq_response_ttyGS3("+LYNQFOTA: MD5 OK\n");
    }
    else
    {
        lynq_response_ttyGS3("+LYNQFOTA: MD5 FAIL\n");
        return 1;
    }

    if((atoi(string[1])) == 0)
    {
        fd_down = open(UPDATA_ADDR,O_RDONLY);
        if (fd_down < 0) {
            lynq_response_ttyGS3("+LYNQFOTA: open source  error\n");
            lynq_fota_md5_flag = -1;
            return 1;
        }
        if(lynq_fota_set_addr_value(FLASH_DEV_DELTA,strlen(FLASH_DEV_DELTA)))
        {
            lynq_response_ttyGS3("+LYNQFOTA: SET FOTA NAND ADDR FAIL\n");
            close(fd_down);
            lynq_fota_md5_flag = -1;
            return 1;
        }
        fd_target = open(FLASH_DEV_DELTA,O_RDWR);
        if (fd_target < 0) {
            close(fd_down);
            lynq_response_ttyGS3("+LYNQFOTA: open target  error\n");
            lynq_fota_md5_flag = -1;
            return 1;
        } 
		system("flash_eraseall /dev/mtd41");
        while(( size = read(fd_down,delta_data,READ_BLOCK_SIZE))>0) {
            write(fd_target,delta_data,READ_BLOCK_SIZE);
            memset(delta_data,0,READ_BLOCK_SIZE);
        }
        close(fd_target);
        close(fd_down);
    }
    else if((atoi(string[1])) == 1)
    {
        if(lynq_fota_set_addr_value(EMMC_DEV_DELTA,strlen(EMMC_DEV_DELTA)))
        {
            lynq_response_ttyGS3("+LYNQFOTA: SET FOTA EMMC ADDR FAIL\n");
            lynq_fota_md5_flag = -1;
            return 1;
        }
        system("cp -rf /tmp/fota.delta /media/");
    }
    else
    {
        lynq_response_ttyGS3("+LYNQFOTA: NO SET FOTA ADDR ERROR\n");
        lynq_fota_md5_flag = -1;
        return 1;
    }

    lynq_response_ttyGS3("+LYNQFOTA: Saving the upgrade Package Success\n");
//    lynq_response_ttyGS3("Store upgrade data to delta success\n");

    return 0;
}

/**
 * @brief fota
 * 
 * @param void
 */
int lynq_atfota_func_test(void)
{
    if(lynq_fota_md5_flag == 0) //upgrade success ,device reboot ,lynq_fota_md5_flag no need to reset
    {
        lynq_response_ttyGS3("+LYNQFOTA: Recive upgrade Command OK\n");
        if(0 != lynq_rock_main(1))
        {
            lynq_response_ttyGS3("+LYNQFOTA: Upgrade Fail\n");
            lynq_fota_md5_flag = -1;
        }
    }
    else
    {
        lynq_response_ttyGS3("+LYNQFOTA: MD5 verify fail\n");
        return 1;
    }
    return 0;
}

void lynq_atfota_test(char *argv[]) 
{
    if((argv[0] == NULL) || (argv[1] == NULL) || (argv[2] == NULL)|| (argv[3] == NULL))
    {
        printf("argv NULL\n");
        return ;
    }
    if(!strcmp(argv[3], "download"))
    {
        if(!(strcmp(argv[4], "ftp")))
        {
            if(lynq_ftp_download_atfota_package(&argv[5]))
            {
                printf("lynq_ftp_download_atfota_package fail\n");
            }
        }
        else
        {
            lynq_response_ttyGS3("+LYNQFOTA: No FTP Download\n");
        }
    }
    else if(!(strcmp(argv[3], "md5")))
    {
        if(lynq_md5_atfota_package(&argv[4]))
        {
            printf("lynq_md5_atfota_package fail\n");
        }
    }
    else if(!(strcmp(argv[3], "upgrade")))
    {
        if(lynq_atfota_func_test())
        {
            printf("lynq_atfota_func_test fail\n");
        }
    }
    else
    {
        lynq_response_ttyGS3("+LYNQFOTA: fota api error!!!\n");
    }
    return ;
}


#ifdef __cplusplus
}
#endif
