/*============================================================================= 
**     FileName: lynq_at_temp
**     Desc: lynq at temp
**     Author: rita
**     Version: V1.0
**     LastChange: 2022-06-13
**     History: 
=============================================================================*/

#include "common.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

//#include <log/log.h>
#include "liblynq-thermal/lynq_get_thermal.h"

static void lynq_response_ttyGS3(char *log_buf)
{
//    sprintf(log_buf,"LYNQ_GOTO_LOGS_REQ\n");
    write(ttyGS3_fd,log_buf,strlen(log_buf));
    return;  
}

int lynq_at_get_temp(int argc, char *argv[])
{
    int temp = 0;
    char buf[20] = "";


    
    if(NULL == argv[3] || argc<4){
        lynq_response_ttyGS3("+CME ERROR: no such device,please reinput!!\n");
        return -1;
    }
    
    int ret = lynq_get_zone_tmp(ZONE_NUM(atoi(argv[3])), &temp);
       
    
    if(ret!=0){
        lynq_response_ttyGS3("+CME ERROR: no such device,please reinput!!\n");
    }
    else{
       //lynq_response_ttyGS3("+temp:%d\n");
       sprintf(buf,"+LYNQMTSM: %d\n", temp);
       lynq_response_ttyGS3(buf);
    }

    return ret;
}


#ifdef __cplusplus
}
#endif
